/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.RuleOwlSymmetricProperty;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.rule.IRule;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;

public class TestRuleOwlSymmetricProperty
extends AbstractRuleTestCase {
    public TestRuleOwlSymmetricProperty() {
    }

    public TestRuleOwlSymmetricProperty(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_Rule() throws Exception {
        AbstractTripleStore store = this.getStore();
        try {
            URIImpl A = new URIImpl("http://www.foo.org/A");
            URIImpl B = new URIImpl("http://www.foo.org/B");
            URIImpl X = new URIImpl("http://www.foo.org/X");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)X, RDF.TYPE, (Value)OWL.SYMMETRICPROPERTY);
            buffer.add((Resource)A, (URI)X, (Value)B);
            buffer.flush();
            TestRuleOwlSymmetricProperty.assertTrue((boolean)store.hasStatement((Resource)X, RDF.TYPE, (Value)OWL.SYMMETRICPROPERTY));
            TestRuleOwlSymmetricProperty.assertTrue((boolean)store.hasStatement((Resource)A, (URI)X, (Value)B));
            long nbefore = store.getStatementCount();
            Vocabulary vocab = store.getVocabulary();
            RuleOwlSymmetricProperty r = new RuleOwlSymmetricProperty(store.getSPORelation().getNamespace(), vocab);
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleOwlSymmetricProperty.assertTrue((boolean)store.hasStatement((Resource)X, RDF.TYPE, (Value)OWL.SYMMETRICPROPERTY));
            TestRuleOwlSymmetricProperty.assertTrue((boolean)store.hasStatement((Resource)A, (URI)X, (Value)B));
            TestRuleOwlSymmetricProperty.assertTrue((boolean)store.hasStatement((Resource)B, (URI)X, (Value)A));
            TestRuleOwlSymmetricProperty.assertEquals((long)(nbefore + 1L), (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

