/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.RuleOwlTransitiveProperty1;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.rule.IRule;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;

public class TestRuleOwlTransitiveProperty
extends AbstractRuleTestCase {
    public TestRuleOwlTransitiveProperty() {
    }

    public TestRuleOwlTransitiveProperty(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_OwlTranstitiveProperty1() throws Exception {
        AbstractTripleStore store = this.getStore();
        try {
            URIImpl A = new URIImpl("http://www.foo.org/A");
            URIImpl X = new URIImpl("http://www.foo.org/X");
            URIImpl Y = new URIImpl("http://www.foo.org/Y");
            URIImpl Z = new URIImpl("http://www.foo.org/Z");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)A, RDF.TYPE, (Value)OWL.TRANSITIVEPROPERTY);
            buffer.add((Resource)X, (URI)A, (Value)Y);
            buffer.add((Resource)Y, (URI)A, (Value)Z);
            buffer.flush();
            TestRuleOwlTransitiveProperty.assertTrue((boolean)store.hasStatement((Resource)A, RDF.TYPE, (Value)OWL.TRANSITIVEPROPERTY));
            TestRuleOwlTransitiveProperty.assertTrue((boolean)store.hasStatement((Resource)X, (URI)A, (Value)Y));
            TestRuleOwlTransitiveProperty.assertTrue((boolean)store.hasStatement((Resource)Y, (URI)A, (Value)Z));
            long nbefore = store.getStatementCount();
            Vocabulary vocab = store.getVocabulary();
            RuleOwlTransitiveProperty1 r = new RuleOwlTransitiveProperty1(store.getSPORelation().getNamespace(), vocab);
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleOwlTransitiveProperty.assertTrue((boolean)store.hasStatement((Resource)A, RDF.TYPE, (Value)OWL.TRANSITIVEPROPERTY));
            TestRuleOwlTransitiveProperty.assertTrue((boolean)store.hasStatement((Resource)X, (URI)A, (Value)Y));
            TestRuleOwlTransitiveProperty.assertTrue((boolean)store.hasStatement((Resource)Y, (URI)A, (Value)Z));
            TestRuleOwlTransitiveProperty.assertTrue((boolean)store.hasStatement((Resource)X, (URI)A, (Value)Z));
            TestRuleOwlTransitiveProperty.assertEquals((long)(nbefore + 1L), (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

