/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.RuleRdf01;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.rule.IRule;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class TestRuleRdf01
extends AbstractRuleTestCase {
    public TestRuleRdf01() {
    }

    public TestRuleRdf01(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_rdf01() throws Exception {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI A = f.createURI("http://www.foo.org/A");
            BigdataURI B = f.createURI("http://www.foo.org/B");
            BigdataURI C2 = f.createURI("http://www.foo.org/C");
            URI rdfType = RDF.TYPE;
            URI rdfProperty = RDF.PROPERTY;
            store.addStatement((Resource)A, (URI)B, (Value)C2);
            TestRuleRdf01.assertTrue((boolean)store.hasStatement((Resource)A, (URI)B, (Value)C2));
            TestRuleRdf01.assertFalse((boolean)store.hasStatement((Resource)B, rdfType, (Value)rdfProperty));
            TestRuleRdf01.assertEquals((long)1L, (long)store.getStatementCount());
            RuleRdf01 r = new RuleRdf01(store.getSPORelation().getNamespace(), store.getVocabulary());
            this.applyRule(store, (IRule)r, 1L, 1L);
            TestRuleRdf01.assertTrue((boolean)store.hasStatement((Resource)A, (URI)B, (Value)C2));
            TestRuleRdf01.assertTrue((boolean)store.hasStatement((Resource)B, rdfType, (Value)rdfProperty));
            TestRuleRdf01.assertEquals((long)2L, (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_rdf01_distinctPrefixScan() throws Exception {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI A = f.createURI("http://www.foo.org/A");
            BigdataURI B = f.createURI("http://www.foo.org/B");
            BigdataURI C2 = f.createURI("http://www.foo.org/C");
            BigdataURI D = f.createURI("http://www.foo.org/D");
            BigdataURI E = f.createURI("http://www.foo.org/E");
            URI rdfType = RDF.TYPE;
            URI rdfProperty = RDF.PROPERTY;
            store.addStatement((Resource)A, (URI)B, (Value)C2);
            store.addStatement((Resource)C2, (URI)B, (Value)D);
            store.addStatement((Resource)A, (URI)E, (Value)C2);
            TestRuleRdf01.assertTrue((boolean)store.hasStatement((Resource)A, (URI)B, (Value)C2));
            TestRuleRdf01.assertTrue((boolean)store.hasStatement((Resource)C2, (URI)B, (Value)D));
            TestRuleRdf01.assertTrue((boolean)store.hasStatement((Resource)A, (URI)E, (Value)C2));
            TestRuleRdf01.assertFalse((boolean)store.hasStatement((Resource)B, rdfType, (Value)rdfProperty));
            TestRuleRdf01.assertFalse((boolean)store.hasStatement((Resource)E, rdfType, (Value)rdfProperty));
            TestRuleRdf01.assertEquals((long)3L, (long)store.getStatementCount());
            RuleRdf01 r = new RuleRdf01(store.getSPORelation().getNamespace(), store.getVocabulary());
            this.applyRule(store, (IRule)r, 2L, 2L);
            TestRuleRdf01.assertTrue((boolean)store.hasStatement((Resource)A, (URI)B, (Value)C2));
            TestRuleRdf01.assertTrue((boolean)store.hasStatement((Resource)C2, (URI)B, (Value)D));
            TestRuleRdf01.assertTrue((boolean)store.hasStatement((Resource)A, (URI)E, (Value)C2));
            TestRuleRdf01.assertTrue((boolean)store.hasStatement((Resource)B, rdfType, (Value)rdfProperty));
            TestRuleRdf01.assertTrue((boolean)store.hasStatement((Resource)E, rdfType, (Value)rdfProperty));
            TestRuleRdf01.assertEquals((long)5L, (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

