/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.DoNotAddFilter;
import com.bigdata.rdf.rules.RuleRdfs03;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.relation.rule.IRule;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestRuleRdfs03
extends AbstractRuleTestCase {
    public TestRuleRdfs03() {
    }

    public TestRuleRdfs03(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_rdfs3_filterLiterals() throws Exception {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            URIImpl A = new URIImpl("http://www.foo.org/A");
            URIImpl X = new URIImpl("http://www.foo.org/X");
            URIImpl U = new URIImpl("http://www.foo.org/U");
            LiteralImpl V12 = new LiteralImpl("V1");
            URIImpl V2 = new URIImpl("http://www.foo.org/V2");
            URI rdfRange = RDFS.RANGE;
            URI rdfType = RDF.TYPE;
            store.addStatement((Resource)A, rdfRange, (Value)X);
            store.addStatement((Resource)U, (URI)A, (Value)V12);
            store.addStatement((Resource)U, (URI)A, (Value)V2);
            TestRuleRdfs03.assertTrue((boolean)store.hasStatement((Resource)A, rdfRange, (Value)X));
            TestRuleRdfs03.assertTrue((boolean)store.hasStatement((Resource)U, (URI)A, (Value)V12));
            TestRuleRdfs03.assertTrue((boolean)store.hasStatement((Resource)U, (URI)A, (Value)V2));
            TestRuleRdfs03.assertEquals((long)3L, (long)store.getStatementCount());
            Vocabulary vocab = store.getVocabulary();
            RuleRdfs03 r = new RuleRdfs03(store.getSPORelation().getNamespace(), vocab);
            DoNotAddFilter filter = new DoNotAddFilter(vocab, store.getAxioms(), true);
            this.applyRule(store, (IRule)r, (IElementFilter<ISPO>)filter, -1L, 1L);
            TestRuleRdfs03.assertTrue((boolean)store.hasStatement((Resource)A, rdfRange, (Value)X));
            TestRuleRdfs03.assertTrue((boolean)store.hasStatement((Resource)U, (URI)A, (Value)V12));
            TestRuleRdfs03.assertTrue((boolean)store.hasStatement((Resource)U, (URI)A, (Value)V2));
            TestRuleRdfs03.assertTrue((boolean)store.hasStatement((Resource)V2, rdfType, (Value)X));
            TestRuleRdfs03.assertEquals((long)4L, (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_rdfs3_01() throws Exception {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            URIImpl A = new URIImpl("http://www.foo.org/A");
            URIImpl B = new URIImpl("http://www.foo.org/B");
            URI rdfsRange = RDFS.RANGE;
            URI rdfsClass = RDFS.CLASS;
            URI rdfType = RDF.TYPE;
            store.addStatement((Resource)A, rdfType, (Value)B);
            store.addStatement((Resource)rdfType, rdfsRange, (Value)rdfsClass);
            TestRuleRdfs03.assertTrue((boolean)store.hasStatement((Resource)A, rdfType, (Value)B));
            TestRuleRdfs03.assertTrue((boolean)store.hasStatement((Resource)rdfType, rdfsRange, (Value)rdfsClass));
            TestRuleRdfs03.assertEquals((long)2L, (long)store.getStatementCount());
            Vocabulary vocab = store.getVocabulary();
            RuleRdfs03 r = new RuleRdfs03(store.getSPORelation().getNamespace(), vocab);
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleRdfs03.assertTrue((boolean)store.hasStatement((Resource)A, rdfType, (Value)B));
            TestRuleRdfs03.assertTrue((boolean)store.hasStatement((Resource)rdfType, rdfsRange, (Value)rdfsClass));
            TestRuleRdfs03.assertTrue((boolean)store.hasStatement((Resource)B, rdfType, (Value)rdfsClass));
            TestRuleRdfs03.assertEquals((long)3L, (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

