/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.DoNotAddFilter;
import com.bigdata.rdf.rules.InferenceEngine;
import com.bigdata.rdf.rules.RuleRdfs04a;
import com.bigdata.rdf.rules.RuleRdfs04b;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.relation.rule.IRule;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestRuleRdfs04
extends AbstractRuleTestCase {
    public TestRuleRdfs04() {
    }

    public TestRuleRdfs04(String name) {
        super(name);
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties(super.getProperties());
        properties.setProperty(InferenceEngine.Options.FORWARD_CHAIN_RDF_TYPE_RDFS_RESOURCE, "true");
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_rdfs4a() throws Exception {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            URIImpl U = new URIImpl("http://www.foo.org/U");
            URIImpl A = new URIImpl("http://www.foo.org/A");
            URIImpl X = new URIImpl("http://www.foo.org/X");
            URI rdfType = RDF.TYPE;
            URI rdfsResource = RDFS.RESOURCE;
            store.addStatement((Resource)U, (URI)A, (Value)X);
            TestRuleRdfs04.assertTrue((boolean)store.hasStatement((Resource)U, (URI)A, (Value)X));
            TestRuleRdfs04.assertEquals((long)1L, (long)store.getStatementCount());
            Vocabulary vocab = store.getVocabulary();
            RuleRdfs04a r = new RuleRdfs04a(store.getSPORelation().getNamespace(), vocab);
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleRdfs04.assertTrue((boolean)store.hasStatement((Resource)U, (URI)A, (Value)X));
            TestRuleRdfs04.assertTrue((boolean)store.hasStatement((Resource)U, rdfType, (Value)rdfsResource));
            TestRuleRdfs04.assertFalse((boolean)store.hasStatement((Resource)X, rdfType, (Value)rdfsResource));
            TestRuleRdfs04.assertEquals((long)2L, (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_rdfs4b() throws Exception {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            URIImpl U = new URIImpl("http://www.foo.org/U");
            URIImpl A = new URIImpl("http://www.foo.org/A");
            URIImpl V = new URIImpl("http://www.foo.org/V");
            URI rdfType = RDF.TYPE;
            URI rdfsResource = RDFS.RESOURCE;
            store.addStatement((Resource)U, (URI)A, (Value)V);
            TestRuleRdfs04.assertTrue((boolean)store.hasStatement((Resource)U, (URI)A, (Value)V));
            TestRuleRdfs04.assertEquals((long)1L, (long)store.getStatementCount());
            RuleRdfs04b r = new RuleRdfs04b(store.getSPORelation().getNamespace(), store.getVocabulary());
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleRdfs04.assertTrue((boolean)store.hasStatement((Resource)U, (URI)A, (Value)V));
            TestRuleRdfs04.assertFalse((boolean)store.hasStatement((Resource)U, rdfType, (Value)rdfsResource));
            TestRuleRdfs04.assertTrue((boolean)store.hasStatement((Resource)V, rdfType, (Value)rdfsResource));
            TestRuleRdfs04.assertEquals((long)2L, (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_rdfs4b_filterLiterals() throws Exception {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            URIImpl A = new URIImpl("http://www.foo.org/A");
            LiteralImpl C2 = new LiteralImpl("C");
            URI rdfType = RDF.TYPE;
            URI rdfsResource = RDFS.RESOURCE;
            store.addStatement((Resource)A, rdfType, (Value)C2);
            TestRuleRdfs04.assertTrue((boolean)store.hasStatement((Resource)A, rdfType, (Value)C2));
            TestRuleRdfs04.assertEquals((long)1L, (long)store.getStatementCount());
            Vocabulary vocab = store.getVocabulary();
            RuleRdfs04b r = new RuleRdfs04b(store.getSPORelation().getNamespace(), vocab);
            DoNotAddFilter filter = new DoNotAddFilter(vocab, store.getAxioms(), true);
            this.applyRule(store, (IRule)r, (IElementFilter<ISPO>)filter, 0L, 0L);
            TestRuleRdfs04.assertTrue((boolean)store.hasStatement((Resource)A, rdfType, (Value)C2));
            TestRuleRdfs04.assertFalse((boolean)store.hasStatement((Resource)A, rdfType, (Value)rdfsResource));
            TestRuleRdfs04.assertEquals((long)1L, (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

