/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.RuleRdfs07;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.rule.IRule;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDFS;

public class TestRuleRdfs07
extends AbstractRuleTestCase {
    public TestRuleRdfs07() {
    }

    public TestRuleRdfs07(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_rdfs07_01() throws Exception {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI A = f.createURI("http://www.foo.org/A");
            BigdataURI B = f.createURI("http://www.foo.org/B");
            BigdataURI U = f.createURI("http://www.foo.org/U");
            BigdataURI Y = f.createURI("http://www.foo.org/Y");
            URI rdfsSubPropertyOf = RDFS.SUBPROPERTYOF;
            store.addStatement((Resource)A, rdfsSubPropertyOf, (Value)B);
            store.addStatement((Resource)U, (URI)A, (Value)Y);
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)A, rdfsSubPropertyOf, (Value)B));
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)U, (URI)A, (Value)Y));
            TestRuleRdfs07.assertFalse((boolean)store.hasStatement((Resource)U, (URI)B, (Value)Y));
            TestRuleRdfs07.assertEquals((long)2L, (long)store.getStatementCount());
            RuleRdfs07 r = new RuleRdfs07(store.getSPORelation().getNamespace(), store.getVocabulary());
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)A, rdfsSubPropertyOf, (Value)B));
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)U, (URI)A, (Value)Y));
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)U, (URI)B, (Value)Y));
            TestRuleRdfs07.assertEquals((long)3L, (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_rdfs07_02() throws Exception {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI A = f.createURI("http://www.foo.org/A");
            BigdataURI B = f.createURI("http://www.foo.org/B");
            BigdataURI U1 = f.createURI("http://www.foo.org/U1");
            BigdataURI Y1 = f.createURI("http://www.foo.org/Y1");
            BigdataURI U2 = f.createURI("http://www.foo.org/U2");
            BigdataURI Y2 = f.createURI("http://www.foo.org/Y2");
            URI rdfsSubPropertyOf = RDFS.SUBPROPERTYOF;
            store.addStatement((Resource)A, rdfsSubPropertyOf, (Value)B);
            store.addStatement((Resource)U1, (URI)A, (Value)Y1);
            store.addStatement((Resource)U2, (URI)A, (Value)Y2);
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)A, rdfsSubPropertyOf, (Value)B));
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)U1, (URI)A, (Value)Y1));
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)U2, (URI)A, (Value)Y2));
            TestRuleRdfs07.assertFalse((boolean)store.hasStatement((Resource)U1, (URI)B, (Value)Y1));
            TestRuleRdfs07.assertFalse((boolean)store.hasStatement((Resource)U2, (URI)B, (Value)Y2));
            TestRuleRdfs07.assertEquals((long)3L, (long)store.getStatementCount());
            RuleRdfs07 r = new RuleRdfs07(store.getSPORelation().getNamespace(), store.getVocabulary());
            this.applyRule(store, (IRule)r, -1L, 2L);
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)A, rdfsSubPropertyOf, (Value)B));
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)U1, (URI)A, (Value)Y1));
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)U2, (URI)A, (Value)Y2));
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)U1, (URI)B, (Value)Y1));
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)U2, (URI)B, (Value)Y2));
            TestRuleRdfs07.assertEquals((long)5L, (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_rdfs07_03() throws Exception {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI A = f.createURI("http://www.foo.org/A");
            BigdataURI B1 = f.createURI("http://www.foo.org/B1");
            BigdataURI B2 = f.createURI("http://www.foo.org/B2");
            BigdataURI U = f.createURI("http://www.foo.org/U");
            BigdataURI Y = f.createURI("http://www.foo.org/Y");
            URI rdfsSubPropertyOf = RDFS.SUBPROPERTYOF;
            store.addStatement((Resource)A, rdfsSubPropertyOf, (Value)B1);
            store.addStatement((Resource)A, rdfsSubPropertyOf, (Value)B2);
            store.addStatement((Resource)U, (URI)A, (Value)Y);
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)A, rdfsSubPropertyOf, (Value)B1));
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)A, rdfsSubPropertyOf, (Value)B2));
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)U, (URI)A, (Value)Y));
            TestRuleRdfs07.assertEquals((long)3L, (long)store.getStatementCount());
            RuleRdfs07 r = new RuleRdfs07(store.getSPORelation().getNamespace(), store.getVocabulary());
            this.applyRule(store, (IRule)r, -1L, 2L);
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)A, rdfsSubPropertyOf, (Value)B1));
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)A, rdfsSubPropertyOf, (Value)B2));
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)U, (URI)A, (Value)Y));
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)U, (URI)B1, (Value)Y));
            TestRuleRdfs07.assertTrue((boolean)store.hasStatement((Resource)U, (URI)B2, (Value)Y));
            TestRuleRdfs07.assertEquals((long)5L, (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

