/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.RuleRdfs10;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.rule.IRule;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestRuleRdfs10
extends AbstractRuleTestCase {
    public TestRuleRdfs10() {
    }

    public TestRuleRdfs10(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_rdfs10_01() throws Exception {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            URIImpl U = new URIImpl("http://www.foo.org/U");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)U, RDF.TYPE, (Value)RDFS.CLASS);
            buffer.flush();
            TestRuleRdfs10.assertTrue((boolean)store.hasStatement((Resource)U, RDF.TYPE, (Value)RDFS.CLASS));
            TestRuleRdfs10.assertEquals((long)1L, (long)store.getStatementCount());
            RuleRdfs10 r = new RuleRdfs10(store.getSPORelation().getNamespace(), store.getVocabulary());
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleRdfs10.assertTrue((boolean)store.hasStatement((Resource)U, RDF.TYPE, (Value)RDFS.CLASS));
            TestRuleRdfs10.assertTrue((boolean)store.hasStatement((Resource)U, RDFS.SUBCLASSOF, (Value)U));
            TestRuleRdfs10.assertEquals((long)2L, (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_rdfs10_02() throws Exception {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            URIImpl U1 = new URIImpl("http://www.foo.org/U1");
            URIImpl U2 = new URIImpl("http://www.foo.org/U2");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)U1, RDF.TYPE, (Value)RDFS.CLASS);
            buffer.add((Resource)U2, RDF.TYPE, (Value)RDFS.CLASS);
            buffer.flush();
            TestRuleRdfs10.assertTrue((boolean)store.hasStatement((Resource)U1, RDF.TYPE, (Value)RDFS.CLASS));
            TestRuleRdfs10.assertTrue((boolean)store.hasStatement((Resource)U1, RDF.TYPE, (Value)RDFS.CLASS));
            TestRuleRdfs10.assertEquals((long)2L, (long)store.getStatementCount());
            RuleRdfs10 r = new RuleRdfs10(store.getSPORelation().getNamespace(), store.getVocabulary());
            this.applyRule(store, (IRule)r, -1L, 2L);
            TestRuleRdfs10.assertTrue((boolean)store.hasStatement((Resource)U1, RDF.TYPE, (Value)RDFS.CLASS));
            TestRuleRdfs10.assertTrue((boolean)store.hasStatement((Resource)U2, RDF.TYPE, (Value)RDFS.CLASS));
            TestRuleRdfs10.assertTrue((boolean)store.hasStatement((Resource)U1, RDFS.SUBCLASSOF, (Value)U1));
            TestRuleRdfs10.assertTrue((boolean)store.hasStatement((Resource)U2, RDFS.SUBCLASSOF, (Value)U2));
            TestRuleRdfs10.assertEquals((long)4L, (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

