/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.RuleRdfs11;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.rule.IRule;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDFS;

public class TestRuleRdfs11
extends AbstractRuleTestCase {
    public TestRuleRdfs11() {
    }

    public TestRuleRdfs11(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_rdfs11() throws Exception {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI A = f.createURI("http://www.foo.org/A");
            BigdataURI B = f.createURI("http://www.foo.org/B");
            BigdataURI C2 = f.createURI("http://www.foo.org/C");
            URI rdfsSubClassOf = RDFS.SUBCLASSOF;
            store.addStatement((Resource)A, rdfsSubClassOf, (Value)B);
            store.addStatement((Resource)B, rdfsSubClassOf, (Value)C2);
            TestRuleRdfs11.assertTrue((boolean)store.hasStatement((Resource)A, rdfsSubClassOf, (Value)B));
            TestRuleRdfs11.assertTrue((boolean)store.hasStatement((Resource)B, rdfsSubClassOf, (Value)C2));
            TestRuleRdfs11.assertFalse((boolean)store.hasStatement((Resource)A, rdfsSubClassOf, (Value)C2));
            TestRuleRdfs11.assertEquals((long)2L, (long)store.getStatementCount());
            RuleRdfs11 r = new RuleRdfs11(store.getSPORelation().getNamespace(), store.getVocabulary());
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleRdfs11.assertTrue((boolean)store.hasStatement((Resource)A, rdfsSubClassOf, (Value)B));
            TestRuleRdfs11.assertTrue((boolean)store.hasStatement((Resource)B, rdfsSubClassOf, (Value)C2));
            TestRuleRdfs11.assertTrue((boolean)store.hasStatement((Resource)A, rdfsSubClassOf, (Value)C2));
            TestRuleRdfs11.assertEquals((long)3L, (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

