/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.RuleContextEnum;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.rule.IQueryOptions;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.ISlice;
import com.bigdata.relation.rule.IStep;
import com.bigdata.relation.rule.QueryOptions;
import com.bigdata.relation.rule.Rule;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.IJoinNexusFactory;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class TestSlice
extends AbstractRuleTestCase {
    public TestSlice() {
    }

    public TestSlice(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_slice() throws Exception {
        Properties properties = new Properties(this.getProperties());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI foo = f.createURI("http://www.bigdata.com/foo");
            BigdataURI bar = f.createURI("http://www.bigdata.com/bar");
            BigdataURI x0 = f.createURI("http://www.bigdata.com/x0");
            BigdataURI x1 = f.createURI("http://www.bigdata.com/x1");
            BigdataURI x2 = f.createURI("http://www.bigdata.com/x2");
            BigdataURI y0 = f.createURI("http://www.bigdata.com/y0");
            BigdataURI y1 = f.createURI("http://www.bigdata.com/y1");
            BigdataURI y2 = f.createURI("http://www.bigdata.com/y2");
            BigdataURI z0 = f.createURI("http://www.bigdata.com/z0");
            BigdataURI z1 = f.createURI("http://www.bigdata.com/z1");
            BigdataURI z2 = f.createURI("http://www.bigdata.com/z2");
            store.addTerms(new BigdataValue[]{foo, bar, x0, x1, x2, y0, y1, y2, z0, z1, z2});
            StatementBuffer buf = new StatementBuffer(store, 100);
            buf.add((Statement)f.createStatement((Resource)x0, (URI)foo, (Value)y0, null, StatementEnum.Explicit));
            buf.add((Statement)f.createStatement((Resource)x1, (URI)foo, (Value)y1, null, StatementEnum.Explicit));
            buf.add((Statement)f.createStatement((Resource)x2, (URI)foo, (Value)y2, null, StatementEnum.Explicit));
            buf.add((Statement)f.createStatement((Resource)y0, (URI)bar, (Value)z0, null, StatementEnum.Explicit));
            buf.add((Statement)f.createStatement((Resource)y1, (URI)bar, (Value)z1, null, StatementEnum.Explicit));
            buf.add((Statement)f.createStatement((Resource)y2, (URI)bar, (Value)z2, null, StatementEnum.Explicit));
            buf.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore()));
            }
            IJoinNexusFactory joinNexusFactory = store.newJoinNexusFactory(RuleContextEnum.HighLevelQuery, ActionEnum.Query, 2, null);
            IVariable[] vars = new IVariable[]{Var.var((String)"x"), Var.var((String)"y"), Var.var((String)"z")};
            ListBindingSet bs0 = new ListBindingSet(vars, new IConstant[]{new Constant((Object)x0.getIV()), new Constant((Object)y0.getIV()), new Constant((Object)z0.getIV())});
            ListBindingSet bs1 = new ListBindingSet(vars, new IConstant[]{new Constant((Object)x1.getIV()), new Constant((Object)y1.getIV()), new Constant((Object)z1.getIV())});
            ListBindingSet bs2 = new ListBindingSet(vars, new IConstant[]{new Constant((Object)x2.getIV()), new Constant((Object)y2.getIV()), new Constant((Object)z2.getIV())});
            this.assertSameSolutions((IChunkedOrderedIterator<ISolution>)joinNexusFactory.newInstance(store.getIndexManager()).runQuery((IStep)this.newRule(store, null, (BigdataValue)foo, (BigdataValue)bar)), new IBindingSet[]{bs0, bs1, bs2});
            log.error((Object)"Ignoring known issue.");
            return;
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    protected IRule newRule(AbstractTripleStore store, ISlice slice, BigdataValue foo, BigdataValue bar) {
        assert (foo.getIV() != this.NULL);
        assert (bar.getIV() != this.NULL);
        return new Rule(this.getName(), null, (IPredicate[])new SPOPredicate[]{new SPOPredicate(store.getSPORelation().getNamespace(), (IVariableOrConstant)Var.var((String)"x"), (IVariableOrConstant)new Constant((Object)foo.getIV()), (IVariableOrConstant)Var.var((String)"y")), new SPOPredicate(store.getSPORelation().getNamespace(), (IVariableOrConstant)Var.var((String)"y"), (IVariableOrConstant)new Constant((Object)bar.getIV()), (IVariableOrConstant)Var.var((String)"z"))}, (IQueryOptions)new QueryOptions(false, true, null, slice), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertSameSolutions(IChunkedOrderedIterator<ISolution> itr, IBindingSet[] expected) {
        if (itr == null) {
            throw new IllegalArgumentException();
        }
        if (expected == null) {
            throw new IllegalArgumentException();
        }
        try {
            int n = 0;
            while (itr.hasNext()) {
                if (n >= expected.length) {
                    TestSlice.fail((String)("Too many solutions were produced: #of expected solutions=" + expected.length));
                }
                IBindingSet actual = ((ISolution)itr.next()).getBindingSet();
                TestSlice.assertNotNull((String)"bindings not requested?", (Object)actual);
                if (!actual.equals((Object)expected[n])) {
                    TestSlice.fail((String)("Wrong bindings: index=" + n + ", actual=" + actual + ", expected=" + expected[n]));
                }
                ++n;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Matched " + n + " binding sets"));
            }
            TestSlice.assertEquals((String)"#of solutions", (int)n, (int)expected.length);
        }
        finally {
            itr.close();
        }
    }
}

