/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.inf.TruthMaintenance;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractInferenceEngineTestCase;
import com.bigdata.rdf.rules.InferenceEngine;
import com.bigdata.rdf.spo.ExplicitSPOFilter;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOComparator;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.DataLoader;
import com.bigdata.rdf.store.IRawTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.IChunkedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import org.apache.log4j.MDC;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.rio.RDFFormat;

public class TestTruthMaintenance
extends AbstractInferenceEngineTestCase {
    private final Random r = new Random();

    public TestTruthMaintenance() {
    }

    public TestTruthMaintenance(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_filter_01() {
        TempTripleStore focusStore = null;
        AbstractTripleStore store = this.getStore();
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI x = f.createURI("http://www.foo.org/x1");
            BigdataURI y = f.createURI("http://www.foo.org/y2");
            BigdataURI z = f.createURI("http://www.foo.org/z3");
            store.addTerms(new BigdataValue[]{x, y, z});
            IV x1 = x.getIV();
            IV y2 = y.getIV();
            IV z3 = z.getIV();
            SPO[] a = new SPO[]{new SPO(x1, y2, z3, StatementEnum.Inferred), new SPO(y2, y2, z3, StatementEnum.Explicit)};
            store.addStatements((ISPO[])a, a.length);
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement(x1, y2, z3));
            TestTruthMaintenance.assertTrue((boolean)store.getStatement(x1, y2, z3).isInferred());
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement(y2, y2, z3));
            TestTruthMaintenance.assertTrue((boolean)store.getStatement(y2, y2, z3).isExplicit());
            Properties properties = store.getProperties();
            properties.setProperty(AbstractTripleStore.Options.LEXICON, "false");
            focusStore = new TempTripleStore(properties);
            Object[] a2 = new SPO[]{new SPO(x1, y2, z3, StatementEnum.Explicit), new SPO(y2, y2, z3, StatementEnum.Explicit), new SPO(z3, y2, z3, StatementEnum.Explicit)};
            store.addStatements((AbstractTripleStore)focusStore, true, (IChunkedOrderedIterator)new ChunkedArrayIterator(a2.length, a2, null), null);
            TestTruthMaintenance.assertTrue((boolean)focusStore.hasStatement(x1, y2, z3));
            TestTruthMaintenance.assertTrue((boolean)focusStore.getStatement(x1, y2, z3).isExplicit());
            TestTruthMaintenance.assertTrue((boolean)focusStore.hasStatement(y2, y2, z3));
            TestTruthMaintenance.assertTrue((boolean)focusStore.getStatement(y2, y2, z3).isExplicit());
            TestTruthMaintenance.assertTrue((boolean)focusStore.hasStatement(z3, y2, z3));
            TestTruthMaintenance.assertTrue((boolean)focusStore.getStatement(z3, y2, z3).isExplicit());
            int nremoved = TruthMaintenance.applyExistingStatements((AbstractTripleStore)focusStore, (AbstractTripleStore)store, null);
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement(x1, y2, z3));
            TestTruthMaintenance.assertTrue((boolean)store.getStatement(x1, y2, z3).isExplicit());
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement(y2, y2, z3));
            TestTruthMaintenance.assertTrue((boolean)store.getStatement(y2, y2, z3).isExplicit());
            TestTruthMaintenance.assertEquals((String)"#removed", (int)1, (int)nremoved);
        }
        finally {
            if (focusStore != null) {
                focusStore.__tearDownUnitTest();
            }
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_assertAll_01() {
        TempTripleStore tempStore = null;
        AbstractTripleStore store = this.getStore();
        try {
            TruthMaintenance tm = new TruthMaintenance(store.getInferenceEngine());
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI U = f.createURI("http://www.bigdata.com/U");
            BigdataURI V = f.createURI("http://www.bigdata.com/V");
            BigdataURI X = f.createURI("http://www.bigdata.com/X");
            BigdataURI rdfsSubClassOf = f.asValue(RDFS.SUBCLASSOF);
            tempStore = tm.newTempTripleStore();
            StatementBuffer assertionBuffer = new StatementBuffer(tempStore, store, 10, 10);
            TestTruthMaintenance.assertTrue((tempStore == assertionBuffer.getStatementStore() ? 1 : 0) != 0);
            assertionBuffer.add((Resource)U, (URI)rdfsSubClassOf, (Value)V);
            assertionBuffer.add((Resource)V, (URI)rdfsSubClassOf, (Value)X);
            assertionBuffer.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)("\n\ntempStore:\n" + tempStore.dumpStore(store, true, true, false, true)));
            }
            tm.assertAll(tempStore);
            if (log.isInfoEnabled()) {
                log.info((Object)("\n\ndatabase:\n" + store.dumpStore(store, true, true, false, true)));
            }
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)U, (URI)rdfsSubClassOf, (Value)V));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)V, (URI)rdfsSubClassOf, (Value)X));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)U, (URI)rdfsSubClassOf, (Value)X));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_retractAll_01() {
        AbstractTripleStore store = this.getStore();
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI U = f.createURI("http://www.bigdata.com/U");
            BigdataURI V = f.createURI("http://www.bigdata.com/V");
            BigdataURI X = f.createURI("http://www.bigdata.com/X");
            BigdataURI rdfsSubClassOf = f.asValue(RDFS.SUBCLASSOF);
            InferenceEngine inf = store.getInferenceEngine();
            TruthMaintenance tm = new TruthMaintenance(inf);
            StatementBuffer assertionBuffer = new StatementBuffer(tm.newTempTripleStore(), store, 100, 10);
            assertionBuffer.add((Resource)U, (URI)rdfsSubClassOf, (Value)V);
            assertionBuffer.add((Resource)V, (URI)rdfsSubClassOf, (Value)X);
            assertionBuffer.flush();
            tm.assertAll((TempTripleStore)assertionBuffer.getStatementStore());
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)U, (URI)rdfsSubClassOf, (Value)V));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)V, (URI)rdfsSubClassOf, (Value)X));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)U, (URI)rdfsSubClassOf, (Value)X));
            StatementBuffer retractionBuffer = new StatementBuffer(tm.newTempTripleStore(), store, 100, 10);
            retractionBuffer.add((Resource)V, (URI)rdfsSubClassOf, (Value)X);
            retractionBuffer.flush();
            tm.retractAll((TempTripleStore)retractionBuffer.getStatementStore());
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)U, (URI)rdfsSubClassOf, (Value)V));
            TestTruthMaintenance.assertFalse((boolean)store.hasStatement((Resource)V, (URI)rdfsSubClassOf, (Value)X));
            TestTruthMaintenance.assertFalse((boolean)store.hasStatement((Resource)U, (URI)rdfsSubClassOf, (Value)X));
            assertionBuffer = new StatementBuffer(tm.newTempTripleStore(), store, 100, 10);
            assertionBuffer.add((Resource)V, (URI)rdfsSubClassOf, (Value)X);
            assertionBuffer.flush();
            tm.assertAll((TempTripleStore)assertionBuffer.getStatementStore());
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)U, (URI)rdfsSubClassOf, (Value)V));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)V, (URI)rdfsSubClassOf, (Value)X));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)U, (URI)rdfsSubClassOf, (Value)X));
            retractionBuffer = new StatementBuffer(tm.newTempTripleStore(), store, 100, 10);
            retractionBuffer.add((Resource)U, (URI)rdfsSubClassOf, (Value)X);
            retractionBuffer.flush();
            tm.retractAll((TempTripleStore)retractionBuffer.getStatementStore());
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)U, (URI)rdfsSubClassOf, (Value)V));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)V, (URI)rdfsSubClassOf, (Value)X));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)U, (URI)rdfsSubClassOf, (Value)X));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_downgradeExplicitToInference() {
        AbstractTripleStore store = this.getStore();
        try {
            TruthMaintenance tm = new TruthMaintenance(store.getInferenceEngine());
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI U = f.createURI("http://www.bigdata.com/U");
            BigdataURI V = f.createURI("http://www.bigdata.com/V");
            BigdataURI X = f.createURI("http://www.bigdata.com/X");
            BigdataURI rdfsSubClassOf = f.asValue(RDFS.SUBCLASSOF);
            TempTripleStore tempStore = tm.newTempTripleStore();
            StatementBuffer assertionBuffer = new StatementBuffer(tempStore, store, 10, 10);
            TestTruthMaintenance.assertTrue((tempStore == assertionBuffer.getStatementStore() ? 1 : 0) != 0);
            assertionBuffer.add((Resource)U, (URI)rdfsSubClassOf, (Value)V);
            assertionBuffer.add((Resource)V, (URI)rdfsSubClassOf, (Value)X);
            assertionBuffer.add((Resource)U, (URI)rdfsSubClassOf, (Value)X);
            assertionBuffer.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)("\n\ntempStore:\n" + tempStore.dumpStore(store, true, true, false, true)));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"Doing asserts.");
            }
            tm.assertAll(tempStore);
            if (log.isInfoEnabled()) {
                log.info((Object)("\n\ndatabase:\n" + store.dumpStore(store, true, true, false, true)));
            }
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)U, (URI)rdfsSubClassOf, (Value)V));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)V, (URI)rdfsSubClassOf, (Value)X));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)U, (URI)rdfsSubClassOf, (Value)X));
            TestTruthMaintenance.assertEquals((Object)StatementEnum.Explicit, (Object)store.getStatement((Resource)U, (URI)rdfsSubClassOf, (Value)V).getStatementType());
            TestTruthMaintenance.assertEquals((Object)StatementEnum.Explicit, (Object)store.getStatement((Resource)V, (URI)rdfsSubClassOf, (Value)X).getStatementType());
            TestTruthMaintenance.assertEquals((Object)StatementEnum.Explicit, (Object)store.getStatement((Resource)U, (URI)rdfsSubClassOf, (Value)X).getStatementType());
            tempStore = tm.newTempTripleStore();
            StatementBuffer retractionBuffer = new StatementBuffer(tempStore, store, 10, 10);
            TestTruthMaintenance.assertTrue((tempStore == retractionBuffer.getStatementStore() ? 1 : 0) != 0);
            retractionBuffer.add((Resource)U, (URI)rdfsSubClassOf, (Value)X);
            retractionBuffer.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)("\n\ntempStore:\n" + tempStore.dumpStore(store, true, true, false, true)));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"Doing retraction.");
            }
            tm.retractAll(tempStore);
            if (log.isInfoEnabled()) {
                log.info((Object)("\n\ndatabase:\n" + store.dumpStore(store, true, true, false, true)));
            }
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)U, (URI)rdfsSubClassOf, (Value)V));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)V, (URI)rdfsSubClassOf, (Value)X));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)U, (URI)rdfsSubClassOf, (Value)X));
            TestTruthMaintenance.assertEquals((Object)StatementEnum.Explicit, (Object)store.getStatement((Resource)U, (URI)rdfsSubClassOf, (Value)V).getStatementType());
            TestTruthMaintenance.assertEquals((Object)StatementEnum.Explicit, (Object)store.getStatement((Resource)V, (URI)rdfsSubClassOf, (Value)X).getStatementType());
            TestTruthMaintenance.assertEquals((Object)StatementEnum.Inferred, (Object)store.getStatement((Resource)U, (URI)rdfsSubClassOf, (Value)X).getStatementType());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_retractWhenStatementSupportsExplicitStatement() {
        URIImpl user = new URIImpl("http://www.bigdata.com/user");
        URIImpl currentGraph = new URIImpl("http://www.bigdata.com/currentGraph");
        URIImpl foo = new URIImpl("http://www.bigdata.com/foo");
        URIImpl graph = new URIImpl("http://www.bigdata.com/Graph");
        URI rdftype = RDF.TYPE;
        URI rdfsRange = RDFS.RANGE;
        AbstractTripleStore store = this.getStore();
        try {
            InferenceEngine inf = store.getInferenceEngine();
            TruthMaintenance tm = new TruthMaintenance(inf);
            StatementBuffer assertionBuffer = new StatementBuffer(tm.newTempTripleStore(), store, 100, 10);
            assertionBuffer.add((Resource)user, (URI)currentGraph, (Value)foo);
            assertionBuffer.add((Resource)currentGraph, rdfsRange, (Value)graph);
            assertionBuffer.add((Resource)foo, rdftype, (Value)graph);
            assertionBuffer.flush();
            tm.assertAll((TempTripleStore)assertionBuffer.getStatementStore());
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore(true, true, false)));
            }
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)user, (URI)currentGraph, (Value)foo));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)currentGraph, rdfsRange, (Value)graph));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)foo, rdftype, (Value)graph));
            BigdataStatement stmtC = store.getStatement((Resource)foo, rdftype, (Value)graph);
            TestTruthMaintenance.assertNotNull((Object)stmtC);
            TestTruthMaintenance.assertEquals((Object)StatementEnum.Explicit, (Object)stmtC.getStatementType());
            StatementBuffer retractionBuffer = new StatementBuffer(tm.newTempTripleStore(), store, 100, 10);
            retractionBuffer.add((Resource)user, (URI)currentGraph, (Value)foo);
            retractionBuffer.flush();
            tm.retractAll((TempTripleStore)retractionBuffer.getStatementStore());
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore(true, true, false)));
            }
            TestTruthMaintenance.assertFalse((boolean)store.hasStatement((Resource)user, (URI)currentGraph, (Value)foo));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)currentGraph, rdfsRange, (Value)graph));
            TestTruthMaintenance.assertTrue((boolean)store.hasStatement((Resource)foo, rdftype, (Value)graph));
            stmtC = store.getStatement((Resource)foo, rdftype, (Value)graph);
            TestTruthMaintenance.assertNotNull((Object)stmtC);
            TestTruthMaintenance.assertEquals((Object)StatementEnum.Explicit, (Object)stmtC.getStatementType());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_closurecorrectness() {
        URIImpl a = new URIImpl("http://www.bigdata.com/a");
        URIImpl b = new URIImpl("http://www.bigdata.com/b");
        URIImpl c = new URIImpl("http://www.bigdata.com/c");
        URI sco = RDFS.SUBCLASSOF;
        AbstractTripleStore store = this.getStore();
        try {
            TruthMaintenance tm = new TruthMaintenance(store.getInferenceEngine());
            StatementBuffer assertionBuffer = new StatementBuffer(tm.newTempTripleStore(), store, 100, 10);
            assertionBuffer.add((Resource)a, sco, (Value)b);
            assertionBuffer.add((Resource)b, sco, (Value)c);
            assertionBuffer.flush();
            tm.assertAll((TempTripleStore)assertionBuffer.getStatementStore());
            if (log.isInfoEnabled()) {
                log.info((Object)("\ndump after closure:\n" + store.dumpStore(store, true, true, false, true)));
            }
            StatementBuffer retractionBuffer = new StatementBuffer(tm.newTempTripleStore(), store, 100, 10);
            retractionBuffer.add((Resource)b, sco, (Value)c);
            retractionBuffer.flush();
            tm.retractAll((TempTripleStore)retractionBuffer.getStatementStore());
            if (log.isInfoEnabled()) {
                log.info((Object)("\ndump after retraction and re-closure:\n" + store.dumpStore(true, true, false)));
            }
            TempTripleStore controlStore = new TempTripleStore(store.getProperties());
            try {
                TruthMaintenance tmControlStore = new TruthMaintenance(controlStore.getInferenceEngine());
                StatementBuffer assertionBuffer2 = new StatementBuffer(tmControlStore.newTempTripleStore(), (AbstractTripleStore)controlStore, 100, 10);
                assertionBuffer2.add((Resource)a, sco, (Value)b);
                assertionBuffer2.flush();
                tmControlStore.assertAll((TempTripleStore)assertionBuffer2.getStatementStore());
                if (log.isInfoEnabled()) {
                    log.info((Object)("\ndump controlStore after closure:\n" + controlStore.dumpStore(true, true, false)));
                }
                this.assertSameGraphs(controlStore, store);
            }
            finally {
                controlStore.__tearDownUnitTest();
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_infiniteloop() {
        URIImpl a = new URIImpl("http://www.bigdata.com/a");
        URIImpl b = new URIImpl("http://www.bigdata.com/b");
        URIImpl entity = new URIImpl("http://www.bigdata.com/Entity");
        URI sameAs = OWL.SAMEAS;
        URI rdfType = RDF.TYPE;
        AbstractTripleStore store = this.getStore();
        try {
            InferenceEngine inf = store.getInferenceEngine();
            TruthMaintenance tm = new TruthMaintenance(inf);
            StatementBuffer assertionBuffer = new StatementBuffer(tm.newTempTripleStore(), store, 100, 10);
            assertionBuffer.add((Resource)a, rdfType, (Value)entity);
            assertionBuffer.add((Resource)b, rdfType, (Value)entity);
            assertionBuffer.add((Resource)a, sameAs, (Value)b);
            assertionBuffer.flush();
            tm.assertAll((TempTripleStore)assertionBuffer.getStatementStore());
            if (log.isInfoEnabled()) {
                log.info((Object)("\ndump after closure:\n" + store.dumpStore(store, true, true, false, true)));
            }
            StatementBuffer retractionBuffer = new StatementBuffer(tm.newTempTripleStore(), store, 100, 10);
            retractionBuffer.add((Resource)a, sameAs, (Value)b);
            retractionBuffer.flush();
            tm.retractAll((TempTripleStore)retractionBuffer.getStatementStore());
            if (log.isInfoEnabled()) {
                log.info((Object)("\ndump after re-closure:\n" + store.dumpStore(store, true, true, false, true)));
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_stress() {
        String ontology = "src/test/resources/data/lehigh/univ-bench.owl";
        String resource = "src/test/resources/data/lehigh/U1";
        Properties properties = this.getProperties();
        properties.setProperty(DataLoader.Options.CLOSURE, DataLoader.ClosureEnum.None.toString());
        TempTripleStore tmp = null;
        AbstractTripleStore store = this.getStore(properties);
        try {
            DataLoader dataLoader = store.getDataLoader();
            String baseURI = new File("src/test/resources/data/lehigh/U1").toURI().toString();
            dataLoader.loadData("src/test/resources/data/lehigh/univ-bench.owl", baseURI, RDFFormat.RDFXML);
            dataLoader.loadData("src/test/resources/data/lehigh/U1", baseURI, RDFFormat.RDFXML);
            InferenceEngine inf = store.getInferenceEngine();
            inf.computeClosure(null);
            Properties p = new Properties(properties);
            p.setProperty(AbstractTripleStore.Options.LEXICON, "false");
            tmp = new TempTripleStore(p);
            store.copyStatements((AbstractTripleStore)tmp, null, false);
            this.doStressTest(tmp, inf, 10, 1, 1);
            this.doStressTest(tmp, inf, 7, 1, 5);
            this.doStressTest(tmp, inf, 5, 5, 1);
            this.doStressTest(tmp, inf, 3, 5, 5);
        }
        catch (Exception ex) {
            TestTruthMaintenance.fail((String)("Not expecting: " + ex), (Throwable)ex);
        }
        finally {
            if (tmp != null) {
                tmp.__tearDownUnitTest();
            }
            store.__tearDownUnitTest();
        }
    }

    public void doStressTest(TempTripleStore tmp, InferenceEngine inf, int ntrials, int D, int N) {
        AbstractTripleStore store = inf.database;
        this.assertSameGraphs(tmp, store);
        for (int trial = 0; trial < ntrials; ++trial) {
            MDC.put((String)"trial", (Object)("trial=" + trial));
            this.retractAndAssert(inf, store, 0, D, N);
            this.assertSameGraphs(tmp, store);
            MDC.remove((String)"trial");
        }
    }

    private void retractAndAssert(InferenceEngine inf, AbstractTripleStore db, int depth, int D, int N) {
        assert (depth >= 0);
        assert (depth < D);
        Object[] stmts = this.selectRandomExplicitStatements(db, N);
        log.info((Object)("Selected " + stmts.length + " statements at random: depth=" + depth));
        TruthMaintenance tm = new TruthMaintenance(inf);
        for (SPO sPO : stmts) {
            log.info((Object)("Retracting: " + sPO.toString((IRawTripleStore)db)));
        }
        TempTripleStore tempStore = tm.newTempTripleStore();
        db.addStatements((AbstractTripleStore)tempStore, true, (IChunkedOrderedIterator)new ChunkedArrayIterator(stmts.length, stmts, null), null);
        log.info((Object)("Retracting: n=" + stmts.length + ", depth=" + depth));
        long before = db.getStatementCount();
        tm.retractAll(tempStore);
        long l = db.getStatementCount();
        long delta = l - before;
        log.info((Object)("Retraction: before=" + before + ", after=" + l + ", delta=" + delta));
        if (depth + 1 < D) {
            this.retractAndAssert(inf, db, depth + 1, D, N);
        }
        for (Object object : stmts) {
            log.info((Object)("Asserting: " + object.toString((IRawTripleStore)db)));
        }
        tempStore = tm.newTempTripleStore();
        db.addStatements((AbstractTripleStore)tempStore, true, (IChunkedOrderedIterator)new ChunkedArrayIterator(stmts.length, stmts, null), null);
        log.info((Object)("Asserting: n=" + stmts.length + ", depth=" + depth));
        before = db.getStatementCount();
        tm.assertAll(tempStore);
        long l2 = db.getStatementCount();
        delta = l2 - before;
        log.info((Object)("Assertion: before=" + before + ", after=" + l2 + ", delta=" + delta));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPO[] selectRandomExplicitStatements(AbstractTripleStore db, int N) {
        int nsubjects;
        try (IChunkedIterator termIds = db.getSPORelation().distinctTermScan((IKeyOrder)SPOKeyOrder.SPO);){
            int n = 0;
            while (termIds.hasNext()) {
                termIds.next();
                ++n;
            }
            nsubjects = n;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("There are " + nsubjects + " distinct subjects"));
        }
        HashSet<IV> subjects = new HashSet<IV>(N);
        for (int i = 0; i < nsubjects && subjects.size() < N; ++i) {
            try (IChunkedIterator termIds = db.getSPORelation().distinctTermScan((IKeyOrder)SPOKeyOrder.SPO);){
                int index = this.r.nextInt(nsubjects);
                IV s = this.NULL;
                for (int j = 0; termIds.hasNext() && j < index; ++j) {
                    s = (IV)termIds.next();
                }
                subjects.add(s);
                continue;
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected " + subjects.size() + " distinct subjects: " + subjects));
        }
        ArrayList<ISPO> stmts = new ArrayList<ISPO>(N);
        for (IV s : subjects) {
            IAccessPath accessPath = db.getAccessPath(s, this.NULL, this.NULL, ExplicitSPOFilter.INSTANCE);
            try (IChunkedOrderedIterator itr = accessPath.iterator();){
                if (!itr.hasNext()) continue;
                ISPO[] chunk = (ISPO[])itr.nextChunk();
                ISPO tmp = chunk[this.r.nextInt(chunk.length)];
                if (log.isInfoEnabled()) {
                    log.info((Object)("Selected at random: " + tmp.toString((IRawTripleStore)db)));
                }
                stmts.add(tmp);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected " + stmts.size() + " distinct statements: " + stmts));
        }
        return stmts.toArray(new SPO[stmts.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertSameGraphs(TempTripleStore expected, AbstractTripleStore actual) {
        IChunkedOrderedIterator itre = expected.getAccessPath((IKeyOrder)SPOKeyOrder.SPO).iterator();
        IChunkedOrderedIterator itra = actual.getAccessPath((IKeyOrder)SPOKeyOrder.SPO).iterator();
        int nerrs = 0;
        int maxerrs = 10;
        int nexpected = 0;
        int nactual = 0;
        try {
            block3: while (itre.hasNext()) {
                if (!itra.hasNext()) {
                    TestTruthMaintenance.fail((String)("Actual iterator exhausted before expected: nexpected=" + nexpected + ", nactual=" + nactual + ", remaining=" + this.toString((IChunkedOrderedIterator<ISPO>)itre, 10, (AbstractTripleStore)expected)));
                }
                SPO expectedSPO = (SPO)itre.next();
                ++nexpected;
                SPO actualSPO = (SPO)itra.next();
                ++nactual;
                if (expectedSPO.equals((ISPO)actualSPO)) continue;
                while (SPOComparator.INSTANCE.compare(actualSPO, expectedSPO) < 0) {
                    log.warn((Object)("Not expecting: " + actualSPO.toString((IRawTripleStore)actual)));
                    if (!itra.hasNext()) break;
                    actualSPO = (SPO)itra.next();
                    ++nactual;
                    if (nerrs++ != maxerrs) continue;
                    TestTruthMaintenance.fail((String)"Too many errors");
                }
                while (SPOComparator.INSTANCE.compare(expectedSPO, actualSPO) < 0) {
                    log.warn((Object)("Expecting: " + expectedSPO.toString((IRawTripleStore)actual)));
                    if (!itre.hasNext()) continue block3;
                    expectedSPO = (SPO)itre.next();
                    ++nexpected;
                    if (nerrs++ != maxerrs) continue;
                    TestTruthMaintenance.fail((String)"Too many errors");
                }
            }
            TestTruthMaintenance.assertFalse((String)"Actual iterator will visit more than expected", (boolean)itra.hasNext());
        }
        finally {
            itre.close();
            itra.close();
        }
        TestTruthMaintenance.assertEquals((String)"statementCount", (int)nexpected, (int)nactual);
    }

    private String toString(IChunkedOrderedIterator<ISPO> itr, int max, AbstractTripleStore db) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        while (itr.hasNext() && n < max) {
            if (n > 0) {
                sb.append(", ");
            }
            sb.append(((ISPO)itr.next()).toString((IRawTripleStore)db));
        }
        return "{" + sb.toString() + "}";
    }
}

