/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.engine.AbstractQueryEngineTestCase;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sail.sparql.ast.SimpleNode;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.UpdateRoot;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.ASTDeferredIVResolution;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.LocalTripleStore;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.openrdf.model.Value;
import org.openrdf.query.MalformedQueryException;

public class AbstractBigdataExprBuilderTestCase
extends TestCase {
    private static final Logger log = Logger.getLogger(AbstractBigdataExprBuilderTestCase.class);
    protected String baseURI = null;
    protected AbstractTripleStore tripleStore = null;
    protected String lex = null;
    protected BigdataValueFactory valueFactory = null;

    public AbstractBigdataExprBuilderTestCase() {
    }

    public AbstractBigdataExprBuilderTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.tripleStore = this.getStore(this.getProperties());
        this.lex = this.tripleStore.getLexiconRelation().getNamespace();
        this.valueFactory = this.tripleStore.getValueFactory();
    }

    protected void tearDown() throws Exception {
        this.baseURI = null;
        if (this.tripleStore != null) {
            this.tripleStore.__tearDownUnitTest();
            this.tripleStore = null;
        }
        this.lex = null;
        this.valueFactory = null;
    }

    protected VarNode mockAnonVar(String varname) {
        VarNode var = new VarNode(varname);
        var.setAnonymous(true);
        return var;
    }

    protected IV<BigdataValue, ?> makeIV(BigdataValue value) {
        IV iv = this.tripleStore.getLexiconRelation().getInlineIV((Value)value);
        if (iv == null) {
            iv = TermId.mockIV((VTE)VTE.valueOf((Value)value));
            iv.setValue(value);
        }
        return iv;
    }

    protected VarNode makeAnon(VarNode v) {
        v.setAnonymous(true);
        return v;
    }

    protected Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty(AbstractTripleStore.Options.QUADS, "true");
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(Options.BUFFER_MODE, BufferMode.Transient.toString());
        return properties;
    }

    protected AbstractTripleStore getStore(Properties properties) {
        String namespace = "kb";
        Journal journal = new Journal(properties);
        LocalTripleStore lts = new LocalTripleStore((IIndexManager)journal, "kb", Long.valueOf(0L), properties);
        lts.create();
        return lts;
    }

    public QueryRoot parse(String queryStr, String baseURI) throws MalformedQueryException {
        Bigdata2ASTSPARQLParser parser = new Bigdata2ASTSPARQLParser();
        ASTContainer astContainer = parser.parseQuery2(queryStr, baseURI);
        ASTDeferredIVResolution.resolveQuery((AbstractTripleStore)this.tripleStore, (ASTContainer)astContainer);
        QueryRoot ast = astContainer.getOriginalAST();
        LinkedList<ValueExpressionNode> nodes = new LinkedList<ValueExpressionNode>();
        Iterator itr = BOpUtility.visitAll((BOp)ast, ValueExpressionNode.class);
        while (itr.hasNext()) {
            ValueExpressionNode node = (ValueExpressionNode)itr.next();
            nodes.add(node);
        }
        for (ValueExpressionNode node : nodes) {
            node.invalidate();
        }
        return ast;
    }

    protected UpdateRoot parseUpdate(String updateStr, String baseURI) throws MalformedQueryException {
        Bigdata2ASTSPARQLParser parser = new Bigdata2ASTSPARQLParser();
        ASTContainer ast = parser.parseUpdate2(updateStr, baseURI);
        ASTDeferredIVResolution.resolveUpdate((AbstractTripleStore)this.tripleStore, (ASTContainer)ast);
        return ast.getOriginalUpdateAST();
    }

    protected static void assertSameAST(String queryStr, IQueryNode expected, IQueryNode actual) {
        Object parseTree = null;
        if (expected instanceof QueryRoot) {
            if (((QueryRoot)expected).getQueryHints() == null) {
                ((QueryRoot)actual).setQueryHints(null);
            }
            if (((QueryRoot)expected).getDataset() == null) {
                ((QueryRoot)actual).setDataset(null);
            }
        }
        if (actual instanceof UpdateRoot) {
            for (BOp x : ((UpdateRoot)actual).args()) {
                x.setProperty("datasetClauses", null);
            }
        }
        if (expected instanceof UpdateRoot) {
            for (BOp x : ((UpdateRoot)expected).args()) {
                x.setProperty("datasetClauses", null);
            }
        }
        if (!expected.equals(actual)) {
            log.error((Object)("\nqueryStr:\n" + queryStr));
            log.error((Object)("\nparseTree:\n" + (parseTree == null ? null : ((SimpleNode)parseTree).dump(""))));
            log.error((Object)("\nexpected:\n" + expected));
            log.error((Object)("\nactual:\n" + actual));
            AbstractQueryEngineTestCase.diff((BOp)expected, (BOp)actual);
            throw new AssertionError();
        }
    }
}

