/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.bop.engine.AbstractQueryEngineTestCase;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Options;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.spo.SPORelation;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.LocalTripleStore;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.Value;

public class AbstractASTEvaluationTestCase
extends AbstractQueryEngineTestCase {
    private static final Logger log = Logger.getLogger(AbstractASTEvaluationTestCase.class);
    protected AbstractTripleStore store = null;
    protected BigdataValueFactory valueFactory = null;
    protected String baseURI = null;
    private BOpContextBase context = null;

    public AbstractASTEvaluationTestCase() {
    }

    public AbstractASTEvaluationTestCase(String name) {
        super(name);
    }

    public BOpContextBase getBOpContext() {
        return this.context;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.store = this.getStore(this.getProperties());
        this.context = new BOpContextBase(null, this.store.getIndexManager());
        this.valueFactory = this.store.getValueFactory();
        this.baseURI = "http://www.bigdata.com";
    }

    protected void tearDown() throws Exception {
        if (this.store != null) {
            this.store.__tearDownUnitTest();
            this.store = null;
        }
        this.context = null;
        this.valueFactory = null;
        this.baseURI = null;
        super.tearDown();
    }

    protected void enableDeleteMarkersInIndes() {
        SPORelation rel = this.store.getSPORelation();
        rel.getPrimaryIndex().getIndexMetadata().setDeleteMarkers(true);
    }

    public Properties getProperties() {
        Properties properties = (Properties)super.getProperties().clone();
        properties.setProperty(AbstractTripleStore.Options.QUADS, "true");
        properties.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(Options.BUFFER_MODE, BufferMode.Transient.toString());
        return properties;
    }

    protected AbstractTripleStore getStore(Properties properties) {
        String namespace = "kb";
        Journal journal = new Journal(properties);
        LocalTripleStore lts = new LocalTripleStore((IIndexManager)journal, "kb", Long.valueOf(0L), properties);
        lts.create();
        return lts;
    }

    protected static void assertSameAST(IQueryNode expected, IQueryNode actual) {
        if (!expected.equals(actual)) {
            log.error((Object)("expected: " + BOpUtility.toString((BOp)expected)));
            log.error((Object)("actual  : " + BOpUtility.toString((BOp)actual)));
            AbstractQueryEngineTestCase.diff((BOp)expected, (BOp)actual);
            throw new AssertionError();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)BOpUtility.toString((BOp)expected));
        }
    }

    protected static Set<IVariable<?>> asSet(String[] vars) {
        LinkedHashSet set = new LinkedHashSet();
        for (String s : vars) {
            set.add((IVariable<?>)Var.var((String)s));
        }
        return set;
    }

    protected static Set<IVariable<?>> asSet(IVariable<?>[] vars) {
        LinkedHashSet set = new LinkedHashSet();
        for (IVariable<?> var : vars) {
            set.add(var);
        }
        return set;
    }

    protected static final Set<VarNode> asSet(VarNode[] a) {
        return new LinkedHashSet<VarNode>(Arrays.asList(a));
    }

    protected static final Set<FilterNode> asSet(FilterNode[] a) {
        return new LinkedHashSet<FilterNode>(Arrays.asList(a));
    }

    protected static final Set<Integer> asSet(Integer[] a) {
        return new LinkedHashSet<Integer>(Arrays.asList(a));
    }

    protected IV makeIV(Value v) {
        BigdataValue bv = this.store.getValueFactory().asValue(v);
        TermId iv = TermId.mockIV((VTE)VTE.valueOf((Value)v));
        iv.setValue(bv);
        return iv;
    }
}

