/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.sparql.ast.ISolutionSetStats;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase2;

public abstract class AbstractSolutionSetStatsTestCase
extends TestCase2 {
    protected static final Set<IVariable> emptySet = Collections.emptySet();
    protected static final Map<IVariable, IConstant> emptyMap = Collections.emptyMap();
    protected String namespace;
    protected BigdataValueFactory f;

    public AbstractSolutionSetStatsTestCase() {
    }

    public AbstractSolutionSetStatsTestCase(String name) {
        super(name);
    }

    protected abstract ISolutionSetStats newFixture(IBindingSet[] var1);

    protected <T> IConstant<T> asConst(T val) {
        return new Constant(val);
    }

    protected Set<IVariable> asSet(IVariable ... vars) {
        HashSet<IVariable> set = new HashSet<IVariable>();
        for (IVariable v : vars) {
            if (set.add(v)) continue;
            AbstractSolutionSetStatsTestCase.fail((String)("Duplicate: " + v));
        }
        return set;
    }

    protected <T> T[] asArray(T ... vals) {
        return vals;
    }

    protected Map<IVariable, IConstant> asMap(IVariable[] vars, IConstant[] vals) {
        assert (vars.length == vals.length);
        LinkedHashMap<IVariable, IConstant> map = new LinkedHashMap<IVariable, IConstant>();
        for (int i = 0; i < vars.length; ++i) {
            map.put(vars[i], vals[i]);
        }
        return map;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.namespace = this.getName();
        this.f = BigdataValueFactoryImpl.getInstance((String)this.namespace);
    }

    protected void tearDown() throws Exception {
        if (this.f != null) {
            this.f.remove();
            this.f = null;
        }
        this.namespace = null;
        super.tearDown();
    }

    public void test_002() {
        IBindingSet[] bsets = new IBindingSet[]{};
        MySolutionStats expected = new MySolutionStats(0L, emptySet, emptySet, emptySet, emptySet, this.asMap(new IVariable[0], new IConstant[0]));
        ISolutionSetStats actual = this.newFixture(bsets);
        AbstractSolutionSetStatsTestCase.assertSameStats(expected, actual);
    }

    public void test_003() {
        Var x = Var.var((String)"x");
        XSDNumericIV one = new XSDNumericIV(1);
        LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(one));
        bsets.add(bset);
        MySolutionStats expected = new MySolutionStats(1L, this.asSet(new IVariable[]{x}), emptySet, this.asSet(new IVariable[]{x}), emptySet, this.asMap(this.asArray(x), this.asArray(this.asConst(one))));
        ISolutionSetStats actual = this.newFixture(bsets.toArray(new IBindingSet[0]));
        AbstractSolutionSetStatsTestCase.assertSameStats(expected, actual);
    }

    public void test_003a() {
        Var x = Var.var((String)"x");
        XSDNumericIV one = new XSDNumericIV(1);
        one.setValue((BigdataValue)this.f.createLiteral(1));
        LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(one));
        bsets.add(bset);
        MySolutionStats expected = new MySolutionStats(1L, this.asSet(new IVariable[]{x}), emptySet, this.asSet(new IVariable[]{x}), this.asSet(new IVariable[]{x}), this.asMap(this.asArray(x), this.asArray(this.asConst(one))));
        ISolutionSetStats actual = this.newFixture(bsets.toArray(new IBindingSet[0]));
        AbstractSolutionSetStatsTestCase.assertSameStats(expected, actual);
    }

    public void test_004() {
        Var x = Var.var((String)"x");
        Var y = Var.var((String)"y");
        XSDNumericIV one = new XSDNumericIV(1);
        XSDNumericIV two = new XSDNumericIV(1);
        two.setValue((BigdataValue)this.f.createLiteral(2));
        LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(one));
        bset.set((IVariable)y, this.asConst(two));
        bsets.add(bset);
        MySolutionStats expected = new MySolutionStats(1L, this.asSet(new IVariable[]{x, y}), emptySet, this.asSet(new IVariable[]{x, y}), this.asSet(new IVariable[]{y}), this.asMap(new IVariable[]{x, y}, new IConstant[]{this.asConst(one), this.asConst(two)}));
        ISolutionSetStats actual = this.newFixture(bsets.toArray(new IBindingSet[0]));
        AbstractSolutionSetStatsTestCase.assertSameStats(expected, actual);
    }

    public void test_005() {
        Var x = Var.var((String)"x");
        Var y = Var.var((String)"y");
        XSDNumericIV one = new XSDNumericIV(1);
        one.setValue((BigdataValue)this.f.createLiteral(1));
        XSDNumericIV two = new XSDNumericIV(2);
        two.setValue((BigdataValue)this.f.createLiteral(2));
        XSDNumericIV three = new XSDNumericIV(3);
        three.setValue((BigdataValue)this.f.createLiteral(3));
        XSDNumericIV four = new XSDNumericIV(4);
        four.setValue((BigdataValue)this.f.createLiteral(4));
        LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(one));
        bset.set((IVariable)y, this.asConst(two));
        bsets.add(bset);
        bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(three));
        bset.set((IVariable)y, this.asConst(four));
        bsets.add(bset);
        MySolutionStats expected = new MySolutionStats(2L, this.asSet(new IVariable[]{x, y}), emptySet, this.asSet(new IVariable[]{x, y}), this.asSet(new IVariable[]{x, y}), emptyMap);
        ISolutionSetStats actual = this.newFixture(bsets.toArray(new IBindingSet[0]));
        AbstractSolutionSetStatsTestCase.assertSameStats(expected, actual);
    }

    public void test_005a() {
        Var x = Var.var((String)"x");
        Var y = Var.var((String)"y");
        XSDNumericIV one = new XSDNumericIV(1);
        one.setValue((BigdataValue)this.f.createLiteral(1));
        XSDNumericIV two = new XSDNumericIV(2);
        two.setValue((BigdataValue)this.f.createLiteral(2));
        XSDNumericIV three = new XSDNumericIV(3);
        three.setValue((BigdataValue)this.f.createLiteral(3));
        XSDNumericIV four = new XSDNumericIV(4);
        LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(one));
        bset.set((IVariable)y, this.asConst(two));
        bsets.add(bset);
        bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(three));
        bset.set((IVariable)y, this.asConst(four));
        bsets.add(bset);
        MySolutionStats expected = new MySolutionStats(2L, this.asSet(new IVariable[]{x, y}), emptySet, this.asSet(new IVariable[]{x, y}), this.asSet(new IVariable[]{x}), emptyMap);
        ISolutionSetStats actual = this.newFixture(bsets.toArray(new IBindingSet[0]));
        AbstractSolutionSetStatsTestCase.assertSameStats(expected, actual);
    }

    public void test_006() {
        Var x = Var.var((String)"x");
        Var y = Var.var((String)"y");
        Var z = Var.var((String)"z");
        XSDNumericIV one = new XSDNumericIV(1);
        one.setValue((BigdataValue)this.f.createLiteral(1));
        XSDNumericIV two = new XSDNumericIV(2);
        two.setValue((BigdataValue)this.f.createLiteral(2));
        XSDNumericIV three = new XSDNumericIV(3);
        three.setValue((BigdataValue)this.f.createLiteral(3));
        XSDNumericIV four = new XSDNumericIV(4);
        four.setValue((BigdataValue)this.f.createLiteral(4));
        XSDNumericIV five = new XSDNumericIV(5);
        five.setValue((BigdataValue)this.f.createLiteral(5));
        LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(one));
        bset.set((IVariable)y, this.asConst(two));
        bsets.add(bset);
        bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(three));
        bset.set((IVariable)y, this.asConst(four));
        bset.set((IVariable)z, this.asConst(five));
        bsets.add(bset);
        MySolutionStats expected = new MySolutionStats(2L, this.asSet(new IVariable[]{x, y, z}), this.asSet(new IVariable[]{z}), this.asSet(new IVariable[]{x, y}), this.asSet(new IVariable[]{x, y, z}), emptyMap);
        ISolutionSetStats actual = this.newFixture(bsets.toArray(new IBindingSet[0]));
        AbstractSolutionSetStatsTestCase.assertSameStats(expected, actual);
    }

    public void test_006a() {
        Var x = Var.var((String)"x");
        Var y = Var.var((String)"y");
        Var z = Var.var((String)"z");
        XSDNumericIV one = new XSDNumericIV(1);
        one.setValue((BigdataValue)this.f.createLiteral(1));
        XSDNumericIV two = new XSDNumericIV(2);
        XSDNumericIV three = new XSDNumericIV(3);
        XSDNumericIV four = new XSDNumericIV(4);
        four.setValue((BigdataValue)this.f.createLiteral(4));
        XSDNumericIV five = new XSDNumericIV(5);
        five.setValue((BigdataValue)this.f.createLiteral(5));
        LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(one));
        bset.set((IVariable)y, this.asConst(two));
        bsets.add(bset);
        bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(three));
        bset.set((IVariable)y, this.asConst(four));
        bset.set((IVariable)z, this.asConst(five));
        bsets.add(bset);
        MySolutionStats expected = new MySolutionStats(2L, this.asSet(new IVariable[]{x, y, z}), this.asSet(new IVariable[]{z}), this.asSet(new IVariable[]{x, y}), this.asSet(new IVariable[]{z}), emptyMap);
        ISolutionSetStats actual = this.newFixture(bsets.toArray(new IBindingSet[0]));
        AbstractSolutionSetStatsTestCase.assertSameStats(expected, actual);
    }

    public void test_007() {
        Var x = Var.var((String)"x");
        Var y = Var.var((String)"y");
        Var z = Var.var((String)"z");
        XSDNumericIV one = new XSDNumericIV(1);
        one.setValue((BigdataValue)this.f.createLiteral(1));
        XSDNumericIV two = new XSDNumericIV(2);
        two.setValue((BigdataValue)this.f.createLiteral(2));
        XSDNumericIV three = new XSDNumericIV(3);
        three.setValue((BigdataValue)this.f.createLiteral(3));
        XSDNumericIV four = new XSDNumericIV(4);
        four.setValue((BigdataValue)this.f.createLiteral(4));
        XSDNumericIV five = new XSDNumericIV(5);
        five.setValue((BigdataValue)this.f.createLiteral(5));
        LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(three));
        bset.set((IVariable)y, this.asConst(four));
        bset.set((IVariable)z, this.asConst(five));
        bsets.add(bset);
        bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(one));
        bset.set((IVariable)y, this.asConst(two));
        bsets.add(bset);
        MySolutionStats expected = new MySolutionStats(2L, this.asSet(new IVariable[]{x, y, z}), this.asSet(new IVariable[]{z}), this.asSet(new IVariable[]{x, y}), this.asSet(new IVariable[]{x, y, z}), emptyMap);
        ISolutionSetStats actual = this.newFixture(bsets.toArray(new IBindingSet[0]));
        AbstractSolutionSetStatsTestCase.assertSameStats(expected, actual);
    }

    public void test_007a() {
        Var x = Var.var((String)"x");
        Var y = Var.var((String)"y");
        Var z = Var.var((String)"z");
        XSDNumericIV one = new XSDNumericIV(1);
        one.setValue((BigdataValue)this.f.createLiteral(1));
        XSDNumericIV two = new XSDNumericIV(2);
        two.setValue((BigdataValue)this.f.createLiteral(2));
        XSDNumericIV three = new XSDNumericIV(3);
        three.setValue((BigdataValue)this.f.createLiteral(3));
        XSDNumericIV four = new XSDNumericIV(4);
        four.setValue((BigdataValue)this.f.createLiteral(4));
        XSDNumericIV five = new XSDNumericIV(5);
        LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(three));
        bset.set((IVariable)y, this.asConst(four));
        bset.set((IVariable)z, this.asConst(five));
        bsets.add(bset);
        bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(one));
        bset.set((IVariable)y, this.asConst(two));
        bsets.add(bset);
        MySolutionStats expected = new MySolutionStats(2L, this.asSet(new IVariable[]{x, y, z}), this.asSet(new IVariable[]{z}), this.asSet(new IVariable[]{x, y}), this.asSet(new IVariable[]{x, y}), emptyMap);
        ISolutionSetStats actual = this.newFixture(bsets.toArray(new IBindingSet[0]));
        AbstractSolutionSetStatsTestCase.assertSameStats(expected, actual);
    }

    public void test_008() {
        Var x = Var.var((String)"x");
        Var y = Var.var((String)"y");
        Var z = Var.var((String)"z");
        XSDNumericIV one = new XSDNumericIV(1);
        one.setValue((BigdataValue)this.f.createLiteral(1));
        XSDNumericIV two = new XSDNumericIV(2);
        two.setValue((BigdataValue)this.f.createLiteral(2));
        XSDNumericIV three = new XSDNumericIV(3);
        three.setValue((BigdataValue)this.f.createLiteral(3));
        XSDNumericIV four = new XSDNumericIV(4);
        four.setValue((BigdataValue)this.f.createLiteral(4));
        XSDNumericIV five = new XSDNumericIV(5);
        five.setValue((BigdataValue)this.f.createLiteral(5));
        LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(three));
        bset.set((IVariable)y, this.asConst(four));
        bset.set((IVariable)z, this.asConst(five));
        bsets.add(bset);
        bset = new ListBindingSet();
        bsets.add(bset);
        bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(one));
        bset.set((IVariable)y, this.asConst(two));
        bsets.add(bset);
        MySolutionStats expected = new MySolutionStats(3L, this.asSet(new IVariable[]{x, y, z}), this.asSet(new IVariable[]{x, y, z}), this.asSet(new IVariable[0]), this.asSet(new IVariable[]{x, y, z}), emptyMap);
        ISolutionSetStats actual = this.newFixture(bsets.toArray(new IBindingSet[0]));
        AbstractSolutionSetStatsTestCase.assertSameStats(expected, actual);
    }

    public void test_009() {
        Var x = Var.var((String)"x");
        Var y = Var.var((String)"y");
        Var z = Var.var((String)"z");
        XSDNumericIV one = new XSDNumericIV(1);
        one.setValue((BigdataValue)this.f.createLiteral(1));
        XSDNumericIV two = new XSDNumericIV(2);
        two.setValue((BigdataValue)this.f.createLiteral(2));
        XSDNumericIV three = new XSDNumericIV(3);
        three.setValue((BigdataValue)this.f.createLiteral(3));
        XSDNumericIV four = new XSDNumericIV(4);
        four.setValue((BigdataValue)this.f.createLiteral(4));
        XSDNumericIV five = new XSDNumericIV(5);
        five.setValue((BigdataValue)this.f.createLiteral(5));
        XSDNumericIV six = new XSDNumericIV(6);
        six.setValue((BigdataValue)this.f.createLiteral(6));
        XSDNumericIV seven = new XSDNumericIV(7);
        seven.setValue((BigdataValue)this.f.createLiteral(7));
        LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(one));
        bset.set((IVariable)y, this.asConst(two));
        bset.set((IVariable)z, this.asConst(five));
        bsets.add(bset);
        bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(one));
        bset.set((IVariable)y, this.asConst(two));
        bset.set((IVariable)z, this.asConst(six));
        bsets.add(bset);
        bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(one));
        bset.set((IVariable)y, this.asConst(two));
        bset.set((IVariable)z, this.asConst(seven));
        bsets.add(bset);
        MySolutionStats expected = new MySolutionStats(3L, this.asSet(new IVariable[]{x, y, z}), this.asSet(new IVariable[0]), this.asSet(new IVariable[]{x, y, z}), this.asSet(new IVariable[]{x, y, z}), this.asMap(this.asArray(x, y), this.asArray(this.asConst(one), this.asConst(two))));
        ISolutionSetStats actual = this.newFixture(bsets.toArray(new IBindingSet[0]));
        AbstractSolutionSetStatsTestCase.assertSameStats(expected, actual);
    }

    protected static void assertSameStats(ISolutionSetStats expected, ISolutionSetStats actual) {
        AbstractSolutionSetStatsTestCase.assertEquals((String)"solutionSetSize", (long)expected.getSolutionSetSize(), (long)actual.getSolutionSetSize());
        AbstractSolutionSetStatsTestCase.assertEquals((String)"usedVars", (Object)expected.getUsedVars(), (Object)actual.getUsedVars());
        AbstractSolutionSetStatsTestCase.assertEquals((String)"alwaysBound", (Object)expected.getAlwaysBound(), (Object)actual.getAlwaysBound());
        AbstractSolutionSetStatsTestCase.assertEquals((String)"notAlwaysBound", (Object)expected.getNotAlwaysBound(), (Object)actual.getNotAlwaysBound());
        AbstractSolutionSetStatsTestCase.assertEquals((String)"materialized", (Object)expected.getMaterialized(), (Object)actual.getMaterialized());
        AbstractSolutionSetStatsTestCase.assertEquals((String)"constants", (Object)expected.getConstants(), (Object)actual.getConstants());
    }

    protected static class MySolutionStats
    implements ISolutionSetStats {
        protected final long nsolutions;
        protected final Set<IVariable> usedVars;
        protected final Set<IVariable> notAlwaysBound;
        protected final Set<IVariable> alwaysBound;
        protected final Set<IVariable> materialized;
        protected final Map<IVariable, IConstant> constants;

        public MySolutionStats(long nsolutions, Set<IVariable> usedVars, Set<IVariable> notAlwaysBound, Set<IVariable> alwaysBound, Set<IVariable> materialized, Map<IVariable, IConstant> constants) {
            this.nsolutions = nsolutions;
            this.usedVars = usedVars;
            this.notAlwaysBound = notAlwaysBound;
            this.alwaysBound = alwaysBound;
            this.materialized = materialized;
            this.constants = constants;
        }

        public long getSolutionSetSize() {
            return this.nsolutions;
        }

        public Set<IVariable<?>> getUsedVars() {
            return this.usedVars;
        }

        public Set<IVariable<?>> getAlwaysBound() {
            return this.alwaysBound;
        }

        public Set<IVariable<?>> getNotAlwaysBound() {
            return this.notAlwaysBound;
        }

        public Set<IVariable<?>> getMaterialized() {
            return this.materialized;
        }

        public Map<IVariable<?>, IConstant<?>> getConstants() {
            return this.constants;
        }
    }
}

