/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.OrderByExpr;
import com.bigdata.rdf.sparql.ast.OrderByNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SliceNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.TestStaticAnalysis_CanJoinUsingConstraints;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTSetValueExpressionsOptimizer;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.openrdf.query.algebra.StatementPattern;

public class BSBMQ5Setup {
    final AtomicInteger nextId = new AtomicInteger(-1);
    public final BigdataURI rdfsLabel;
    public final BigdataURI productFeature;
    public final BigdataURI productPropertyNumeric1;
    public final BigdataURI productPropertyNumeric2;
    public final BigdataURI product53999;
    public final BigdataLiteral _120;
    public final BigdataLiteral _170;
    public final QueryRoot queryRoot;
    public final ProjectionNode projection;
    public final StatementPatternNode p0;
    public final StatementPatternNode p1;
    public final StatementPatternNode p2;
    public final StatementPatternNode p3;
    public final StatementPatternNode p4;
    public final StatementPatternNode p5;
    public final StatementPatternNode p6;
    public final FilterNode c0;
    public final FilterNode c1;
    public final FilterNode c2;
    public final FilterNode[] constraints;
    public final Set<FilterNode> NA = Collections.emptySet();
    public final Set<FilterNode> C0;
    public final Set<FilterNode> C1;
    public final Set<FilterNode> C2;

    public BSBMQ5Setup(AbstractTripleStore store) {
        BigdataValueFactory valueFactory = store.getLexiconRelation().getValueFactory();
        String rdfs = "http://www.w3.org/2000/01/rdf-schema#";
        String bsbm = "http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/vocabulary/";
        String productInstance = "http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/instances/dataFromProducer1/Product22";
        this.rdfsLabel = valueFactory.createURI("http://www.w3.org/2000/01/rdf-schema#label");
        this.productFeature = valueFactory.createURI("http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/vocabulary/productFeature");
        this.productPropertyNumeric1 = valueFactory.createURI("http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/vocabulary/productPropertyNumeric1");
        this.productPropertyNumeric2 = valueFactory.createURI("http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/vocabulary/productPropertyNumeric2");
        this.product53999 = valueFactory.createURI("http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/instances/dataFromProducer1/Product22");
        this._120 = valueFactory.createLiteral("120", XSD.INTEGER);
        this._170 = valueFactory.createLiteral("170", XSD.INTEGER);
        BigdataValue[] terms = new BigdataValue[]{this.rdfsLabel, this.productFeature, this.productPropertyNumeric1, this.productPropertyNumeric2, this.product53999, this._120, this._170};
        store.getLexiconRelation().addTerms(terms, terms.length, false);
        for (BigdataValue bv : terms) {
            bv.getIV().setValue(bv);
        }
        this.queryRoot = new QueryRoot(QueryType.SELECT);
        this.projection = new ProjectionNode();
        this.queryRoot.setProjection(this.projection);
        this.projection.addProjectionVar(new VarNode("product"));
        this.projection.addProjectionVar(new VarNode("productLabel"));
        JoinGroupNode whereClause = new JoinGroupNode();
        this.queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        this.p0 = new StatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(this.rdfsLabel.getIV()), (TermNode)new VarNode("productLabel"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        this.p0.setId(this.nextId.incrementAndGet());
        this.p1 = new StatementPatternNode((TermNode)new ConstantNode(this.product53999.getIV()), (TermNode)new ConstantNode(this.productFeature.getIV()), (TermNode)new VarNode("prodFeature"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        this.p1.setId(this.nextId.incrementAndGet());
        this.p2 = new StatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(this.productFeature.getIV()), (TermNode)new VarNode("prodFeature"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        this.p2.setId(this.nextId.incrementAndGet());
        this.p3 = new StatementPatternNode((TermNode)new ConstantNode(this.product53999.getIV()), (TermNode)new ConstantNode(this.productPropertyNumeric1.getIV()), (TermNode)new VarNode("origProperty1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        this.p3.setId(this.nextId.incrementAndGet());
        this.p4 = new StatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(this.productPropertyNumeric1.getIV()), (TermNode)new VarNode("simProperty1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        this.p4.setId(this.nextId.incrementAndGet());
        this.p5 = new StatementPatternNode((TermNode)new ConstantNode(this.product53999.getIV()), (TermNode)new ConstantNode(this.productPropertyNumeric2.getIV()), (TermNode)new VarNode("origProperty2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        this.p5.setId(this.nextId.incrementAndGet());
        this.p6 = new StatementPatternNode((TermNode)new VarNode("product"), (TermNode)new ConstantNode(this.productPropertyNumeric2.getIV()), (TermNode)new VarNode("simProperty2"), null, StatementPattern.Scope.DEFAULT_CONTEXTS);
        this.p6.setId(this.nextId.incrementAndGet());
        whereClause.addChild((IGroupMemberNode)this.p0);
        whereClause.addChild((IGroupMemberNode)this.p1);
        whereClause.addChild((IGroupMemberNode)this.p2);
        whereClause.addChild((IGroupMemberNode)this.p3);
        whereClause.addChild((IGroupMemberNode)this.p4);
        whereClause.addChild((IGroupMemberNode)this.p5);
        whereClause.addChild((IGroupMemberNode)this.p6);
        this.c0 = new FilterNode((IValueExpressionNode)FunctionNode.NE((ValueExpressionNode)new ConstantNode(this.product53999.getIV()), (ValueExpressionNode)new VarNode("product")));
        whereClause.addChild((IGroupMemberNode)this.c0);
        FunctionNode left = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("simProperty1"), new FunctionNode(FunctionRegistry.ADD, null, new ValueExpressionNode[]{new VarNode("origProperty1"), new ConstantNode(this._120.getIV())})});
        FunctionNode right = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("simProperty1"), new FunctionNode(FunctionRegistry.SUBTRACT, null, new ValueExpressionNode[]{new VarNode("origProperty1"), new ConstantNode(this._120.getIV())})});
        FunctionNode expr = new FunctionNode(FunctionRegistry.AND, null, new ValueExpressionNode[]{left, right});
        this.c1 = new FilterNode((IValueExpressionNode)expr);
        whereClause.addChild((IGroupMemberNode)this.c1);
        left = new FunctionNode(FunctionRegistry.LT, null, new ValueExpressionNode[]{new VarNode("simProperty2"), new FunctionNode(FunctionRegistry.ADD, null, new ValueExpressionNode[]{new VarNode("origProperty2"), new ConstantNode(this._170.getIV())})});
        right = new FunctionNode(FunctionRegistry.GT, null, new ValueExpressionNode[]{new VarNode("simProperty2"), new FunctionNode(FunctionRegistry.SUBTRACT, null, new ValueExpressionNode[]{new VarNode("origProperty2"), new ConstantNode(this._170.getIV())})});
        expr = new FunctionNode(FunctionRegistry.AND, null, new ValueExpressionNode[]{left, right});
        this.c2 = new FilterNode((IValueExpressionNode)expr);
        whereClause.addChild((IGroupMemberNode)this.c2);
        this.constraints = new FilterNode[]{this.c0, this.c1, this.c2};
        OrderByNode orderByNode = new OrderByNode();
        this.queryRoot.setOrderBy(orderByNode);
        orderByNode.addExpr(new OrderByExpr((IValueExpressionNode)new VarNode("productLabel"), true));
        this.queryRoot.setSlice(new SliceNode(0L, 5L));
        this.C0 = TestStaticAnalysis_CanJoinUsingConstraints.asSet(new FilterNode[]{this.c0});
        this.C1 = TestStaticAnalysis_CanJoinUsingConstraints.asSet(new FilterNode[]{this.c1});
        this.C2 = TestStaticAnalysis_CanJoinUsingConstraints.asSet(new FilterNode[]{this.c2});
        IBindingSet[] bsets = new IBindingSet[]{};
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(this.queryRoot), store);
        new ASTSetValueExpressionsOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)this.queryRoot, bsets));
    }
}

