/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.bop.Var;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.constraints.CompareBOp;
import com.bigdata.rdf.internal.constraints.XSDBooleanIVValueExpression;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupByNode;
import com.bigdata.rdf.sparql.ast.HavingNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.OrderByExpr;
import com.bigdata.rdf.sparql.ast.OrderByNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SliceNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.openrdf.query.algebra.Compare;

public class TestAST
extends TestCase {
    private static final Logger log = Logger.getLogger(TestAST.class);

    public TestAST() {
    }

    public TestAST(String name) {
        super(name);
    }

    public void testSimpleJoin() {
        JoinGroupNode root = new JoinGroupNode();
        root.addChild((IGroupMemberNode)this.sp(1));
        root.addChild((IGroupMemberNode)this.sp(2));
        root.addChild((IGroupMemberNode)this.filter(3));
        QueryRoot query = new QueryRoot(QueryType.SELECT);
        query.setWhereClause((GraphPatternGroup)root);
        if (log.isInfoEnabled()) {
            log.info((Object)("\n" + query.toString()));
        }
    }

    public void testSimpleOptional() {
        JoinGroupNode root = new JoinGroupNode();
        root.addChild((IGroupMemberNode)this.sp(1));
        JoinGroupNode optional = new JoinGroupNode(true);
        optional.addChild((IGroupMemberNode)this.sp(2));
        root.addChild((IGroupMemberNode)optional);
        QueryRoot query = new QueryRoot(QueryType.SELECT);
        query.setWhereClause((GraphPatternGroup)root);
        if (log.isInfoEnabled()) {
            log.info((Object)("\n" + query.toString()));
        }
    }

    public void testOptionalJoinGroup() {
        JoinGroupNode root = new JoinGroupNode();
        root.addChild((IGroupMemberNode)this.sp(1));
        JoinGroupNode optional = new JoinGroupNode(true);
        optional.addChild((IGroupMemberNode)this.sp(2));
        optional.addChild((IGroupMemberNode)this.sp(3));
        root.addChild((IGroupMemberNode)optional);
        QueryRoot query = new QueryRoot(QueryType.SELECT);
        query.setWhereClause((GraphPatternGroup)root);
        if (log.isInfoEnabled()) {
            log.info((Object)("\n" + query.toString()));
        }
    }

    public void testUnion() {
        JoinGroupNode g1 = new JoinGroupNode();
        g1.addChild((IGroupMemberNode)this.sp(1));
        g1.addChild((IGroupMemberNode)this.sp(2));
        JoinGroupNode g2 = new JoinGroupNode();
        g2.addChild((IGroupMemberNode)this.sp(3));
        g2.addChild((IGroupMemberNode)this.sp(4));
        UnionNode union = new UnionNode();
        union.addChild((IGroupMemberNode)g1);
        union.addChild((IGroupMemberNode)g2);
        QueryRoot query = new QueryRoot(QueryType.SELECT);
        query.setWhereClause((GraphPatternGroup)union);
        if (log.isInfoEnabled()) {
            log.info((Object)("\n" + query.toString()));
        }
    }

    public void testNestedUnion() {
        JoinGroupNode g1 = new JoinGroupNode();
        g1.addChild((IGroupMemberNode)this.sp(3));
        g1.addChild((IGroupMemberNode)this.sp(4));
        JoinGroupNode g2 = new JoinGroupNode();
        g2.addChild((IGroupMemberNode)this.sp(5));
        g2.addChild((IGroupMemberNode)this.sp(6));
        UnionNode union = new UnionNode();
        union.addChild((IGroupMemberNode)g1);
        union.addChild((IGroupMemberNode)g2);
        JoinGroupNode root = new JoinGroupNode();
        root.addChild((IGroupMemberNode)this.sp(1));
        root.addChild((IGroupMemberNode)this.filter(2));
        root.addChild((IGroupMemberNode)union);
        QueryRoot query = new QueryRoot(QueryType.SELECT);
        query.setWhereClause((GraphPatternGroup)root);
        if (log.isInfoEnabled()) {
            log.info((Object)("\n" + query.toString()));
        }
    }

    public void testEverything() {
        JoinGroupNode root = new JoinGroupNode();
        root.addChild((IGroupMemberNode)this.sp(1)).addChild((IGroupMemberNode)this.sp(2)).addChild((IGroupMemberNode)this.filter(3));
        JoinGroupNode j1 = new JoinGroupNode(false);
        j1.addChild((IGroupMemberNode)this.sp(4)).addChild((IGroupMemberNode)this.sp(5)).addChild((IGroupMemberNode)this.filter(6));
        JoinGroupNode j2 = new JoinGroupNode(false);
        j2.addChild((IGroupMemberNode)this.sp(7)).addChild((IGroupMemberNode)this.sp(8)).addChild((IGroupMemberNode)this.filter(9));
        UnionNode u1 = new UnionNode();
        u1.addChild(j1).addChild(j2);
        root.addChild((IGroupMemberNode)u1);
        JoinGroupNode j3 = new JoinGroupNode(true);
        j3.addChild((IGroupMemberNode)this.sp(10)).addChild((IGroupMemberNode)this.sp(11)).addChild((IGroupMemberNode)this.filter(12));
        root.addChild((IGroupMemberNode)j3);
        QueryRoot query = new QueryRoot(QueryType.SELECT);
        query.setWhereClause((GraphPatternGroup)root);
        ProjectionNode project = new ProjectionNode();
        project.setDistinct(true);
        project.addProjectionVar(new VarNode("s"));
        project.addProjectionVar(new VarNode("p"));
        query.setProjection(project);
        GroupByNode groupBy = new GroupByNode();
        groupBy.addExpr((IValueExpressionNode)new AssignmentNode(new VarNode("s"), (IValueExpressionNode)new VarNode("s")));
        HavingNode havingBy = new HavingNode();
        havingBy.addExpr((IValueExpressionNode)new LegacyTestValueExpressionNode((IValueExpression)new CompareBOp((IValueExpression)Var.var((String)"x"), (IValueExpression)Var.var((String)"y"), Compare.CompareOp.GT)));
        OrderByNode orderBy = new OrderByNode();
        orderBy.addExpr(new OrderByExpr((IValueExpressionNode)new VarNode("s"), true));
        orderBy.addExpr(new OrderByExpr((IValueExpressionNode)new VarNode("p"), false));
        query.setOrderBy(orderBy);
        query.setSlice(new SliceNode(10L, 100L));
        if (log.isInfoEnabled()) {
            log.info((Object)("\n" + query.toString()));
        }
        NamedSubqueriesNode subqueries = new NamedSubqueriesNode();
        NamedSubqueryRoot subquery = new NamedSubqueryRoot(QueryType.SELECT, "foo");
        ProjectionNode projection1 = new ProjectionNode();
        projection1.addProjectionVar(new VarNode("y"));
        subquery.setProjection(projection1);
        ConstantNode nameConstant = new ConstantNode((IV)TermId.mockIV((VTE)VTE.URI));
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("y"), (TermNode)nameConstant, (TermNode)new VarNode("name")));
        subquery.setWhereClause((GraphPatternGroup)whereClause);
        GroupByNode groupBy1 = new GroupByNode();
        groupBy1.addGroupByVar(new VarNode("y"));
        subquery.setGroupBy(groupBy1);
        subqueries.add((IQueryNode)subquery);
        query.setNamedSubqueries(subqueries);
        if (log.isInfoEnabled()) {
            log.info((Object)("\n" + query.toString()));
        }
    }

    public StatementPatternNode sp(int id) {
        return new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"));
    }

    public FilterNode filter(int id) {
        return new FilterNode((IValueExpressionNode)new LegacyTestValueExpressionNode((IValueExpression)new Filter(id)));
    }

    public Predicate pred(int id) {
        return new Predicate(BOp.NOARGS, NV.asMap((NV[])new NV[]{new NV(BOp.Annotations.BOP_ID, (Object)id)}));
    }

    public IValueExpression ve(int id) {
        return new Filter(id);
    }

    private static final class Filter
    extends XSDBooleanIVValueExpression {
        private static final long serialVersionUID = 1L;

        public Filter(int id) {
            super(BOp.NOARGS, NV.asMap((NV[])new NV[]{new NV(BOp.Annotations.BOP_ID, (Object)id)}));
        }

        protected boolean accept(IBindingSet bs) {
            return true;
        }
    }

    @Deprecated
    private static final class LegacyTestValueExpressionNode
    extends ValueExpressionNode {
        private LegacyTestValueExpressionNode(IValueExpression<? extends IV> ve) {
            super(ve);
        }

        public String toString(int i) {
            return this.toShortString();
        }
    }
}

