/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.BSBMQ5Setup;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.JoinSetUtil;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import java.util.Collections;

public class TestJoinSetUtil
extends AbstractASTEvaluationTestCase {
    public TestJoinSetUtil() {
    }

    public TestJoinSetUtil(String name) {
        super(name);
    }

    public void test_joinSetUtil_BSBMQ5() {
        BSBMQ5Setup s = new BSBMQ5Setup(this.store);
        StaticAnalysis sa = new StaticAnalysis(s.queryRoot);
        JoinSetUtil fixture = new JoinSetUtil(sa, null, s.queryRoot.getWhereClause());
        TestJoinSetUtil.assertEquals((String)"group", (Object)s.queryRoot.getWhereClause(), (Object)fixture.group);
        TestJoinSetUtil.assertEquals((String)"knownBound", Collections.emptySet(), (Object)fixture.knownBound);
        TestJoinSetUtil.assertEquals((Object[])new IJoinNode[]{s.p0, s.p1, s.p2, s.p3, s.p4, s.p5, s.p6}, (Object[])fixture.requiredJoins);
        TestJoinSetUtil.assertEquals((String)"requiredJoinCount", (int)7, (int)fixture.requiredJoinCount);
        TestJoinSetUtil.assertEquals((String)"preFilters", TestJoinSetUtil.asSet(new FilterNode[0]), (Object)fixture.preFilters);
        TestJoinSetUtil.assertEquals((String)"joinFilters", TestJoinSetUtil.asSet(new FilterNode[]{s.c0, s.c1, s.c2}), (Object)fixture.joinFilters);
        TestJoinSetUtil.assertEquals((String)"postFilters", TestJoinSetUtil.asSet(new FilterNode[0]), (Object)fixture.postFilters);
        TestJoinSetUtil.assertEquals(TestJoinSetUtil.asSet(new IVariable[]{Var.var((String)"product"), Var.var((String)"productLabel")}), (Object)fixture.vars[0]);
        TestJoinSetUtil.assertEquals(TestJoinSetUtil.asSet(new IVariable[]{Var.var((String)"prodFeature")}), (Object)fixture.vars[1]);
        TestJoinSetUtil.assertEquals(TestJoinSetUtil.asSet(new IVariable[]{Var.var((String)"product"), Var.var((String)"prodFeature")}), (Object)fixture.vars[2]);
        TestJoinSetUtil.assertEquals(TestJoinSetUtil.asSet(new IVariable[]{Var.var((String)"origProperty1")}), (Object)fixture.vars[3]);
        TestJoinSetUtil.assertEquals(TestJoinSetUtil.asSet(new IVariable[]{Var.var((String)"product"), Var.var((String)"simProperty1")}), (Object)fixture.vars[4]);
        TestJoinSetUtil.assertEquals(TestJoinSetUtil.asSet(new IVariable[]{Var.var((String)"origProperty2")}), (Object)fixture.vars[5]);
        TestJoinSetUtil.assertEquals(TestJoinSetUtil.asSet(new IVariable[]{Var.var((String)"product"), Var.var((String)"simProperty2")}), (Object)fixture.vars[6]);
        int[][] canJoin = new int[][]{{0, 0, 1, 0, 1, 0, 1}, {0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}};
        for (int i = 0; i < fixture.requiredJoinCount; ++i) {
            TestJoinSetUtil.assertEquals((String)("row=" + i), (int[])canJoin[i], (int[])fixture.canJoin[i]);
        }
        TestJoinSetUtil.assertEquals((int[])new int[]{3, 1, 4, 0, 3, 0, 3}, (int[])fixture.directJoinCount);
        TestJoinSetUtil.assertTrue((boolean)fixture.directJoinSets.contains(new JoinSetUtil.VertexJoinSet(TestJoinSetUtil.asSet(new Integer[]{0, 2, 1, 4, 6}), TestJoinSetUtil.asSet(new IVariable[]{Var.var((String)"product"), Var.var((String)"productLabel"), Var.var((String)"prodFeature"), Var.var((String)"simProperty1"), Var.var((String)"simProperty2")}))));
        TestJoinSetUtil.assertTrue((boolean)fixture.directJoinSets.contains(new JoinSetUtil.VertexJoinSet(TestJoinSetUtil.asSet(new Integer[]{3}), TestJoinSetUtil.asSet(new IVariable[]{Var.var((String)"origProperty1")}))));
        TestJoinSetUtil.assertTrue((boolean)fixture.directJoinSets.contains(new JoinSetUtil.VertexJoinSet(TestJoinSetUtil.asSet(new Integer[]{5}), TestJoinSetUtil.asSet(new IVariable[]{Var.var((String)"origProperty2")}))));
        TestJoinSetUtil.assertEquals((String)"#of join sets", (int)3, (int)fixture.directJoinSets.size());
    }
}

