/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.ExistsNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupByNode;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IGroupNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.ASTSearchOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTSetValueExpressionsOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTSubGroupJoinVarOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTWildcardProjectionOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.vocab.decls.FOAFVocabularyDecl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;

public class TestStaticAnalysis
extends AbstractASTEvaluationTestCase {
    private static final Logger log = Logger.getLogger(TestStaticAnalysis.class);
    private static final Set<IVariable<?>> EMPTY_SET = Collections.emptySet();

    public TestStaticAnalysis() {
    }

    public TestStaticAnalysis(String arg0) {
        super(arg0);
    }

    public void test_static_analysis01() throws MalformedQueryException {
        String queryStr = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x where { ?x rdf:type foaf:Person }";
        QueryRoot queryRoot = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x where { ?x rdf:type foaf:Person }", this.baseURI).getOriginalAST();
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet<Var> expected = new LinkedHashSet<Var>();
        expected.add(Var.var((String)"x"));
        TestStaticAnalysis.assertEquals(expected, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        TestStaticAnalysis.assertEquals(expected, (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)queryRoot.getWhereClause(), new LinkedHashSet(), true));
    }

    public void test_static_analysis02() throws MalformedQueryException {
        String queryStr = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x (12 as ?y) where { ?x rdf:type foaf:Person }";
        QueryRoot queryRoot = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x (12 as ?y) where { ?x rdf:type foaf:Person }", this.baseURI).getOriginalAST();
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet<Var> expectedProjected = new LinkedHashSet<Var>();
        expectedProjected.add(Var.var((String)"x"));
        expectedProjected.add(Var.var((String)"y"));
        TestStaticAnalysis.assertEquals(expectedProjected, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        LinkedHashSet<Var> expectedWhereClause = new LinkedHashSet<Var>();
        expectedWhereClause.add(Var.var((String)"x"));
        TestStaticAnalysis.assertEquals(expectedWhereClause, (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)queryRoot.getWhereClause(), new LinkedHashSet(), true));
    }

    public void test_static_analysis03() throws MalformedQueryException {
        String queryStr = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x (12 as ?y)\n  with \n{    select ?x {\n      ?x rdf:type foaf:Person .\n      ?x rdfs:label ?y .\n    }\n  } as %namedSet1 \n where {\n  include %namedSet1\n}";
        QueryRoot queryRoot = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x (12 as ?y)\n  with \n{    select ?x {\n      ?x rdf:type foaf:Person .\n      ?x rdfs:label ?y .\n    }\n  } as %namedSet1 \n where {\n  include %namedSet1\n}", this.baseURI).getOriginalAST();
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet<Var> expectedProjected = new LinkedHashSet<Var>();
        expectedProjected.add(Var.var((String)"x"));
        expectedProjected.add(Var.var((String)"y"));
        TestStaticAnalysis.assertEquals(expectedProjected, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        LinkedHashSet<Var> expectedWhereClause = new LinkedHashSet<Var>();
        expectedWhereClause.add(Var.var((String)"x"));
        TestStaticAnalysis.assertEquals(expectedWhereClause, (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)queryRoot.getWhereClause(), new LinkedHashSet(), true));
    }

    public void test_static_analysis04() throws MalformedQueryException {
        String queryStr = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x (12 as ?y)\n where {\n  ?q foaf:knows ?p .  {\n    select ?x {\n      ?x rdf:type foaf:Person .\n      ?x rdfs:label ?z .\n    }\n  }\n}";
        QueryRoot queryRoot = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x (12 as ?y)\n where {\n  ?q foaf:knows ?p .  {\n    select ?x {\n      ?x rdf:type foaf:Person .\n      ?x rdfs:label ?z .\n    }\n  }\n}", this.baseURI).getOriginalAST();
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet<Var> expectedProjected = new LinkedHashSet<Var>();
        expectedProjected.add(Var.var((String)"x"));
        expectedProjected.add(Var.var((String)"y"));
        TestStaticAnalysis.assertEquals(expectedProjected, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        LinkedHashSet<Var> expectedWhereClause = new LinkedHashSet<Var>();
        expectedWhereClause.add(Var.var((String)"x"));
        expectedWhereClause.add(Var.var((String)"p"));
        expectedWhereClause.add(Var.var((String)"q"));
        TestStaticAnalysis.assertEquals(expectedWhereClause, (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)queryRoot.getWhereClause(), new LinkedHashSet(), true));
    }

    public void test_static_analysis05() throws MalformedQueryException {
        String queryStr = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x (12 as ?y)\n where {\n    service ?uri {\n      ?x rdf:type foaf:Person .\n      ?x rdfs:label ?z .\n    }\n}";
        QueryRoot queryRoot = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x (12 as ?y)\n where {\n    service ?uri {\n      ?x rdf:type foaf:Person .\n      ?x rdfs:label ?z .\n    }\n}", this.baseURI).getOriginalAST();
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet<Var> expectedProjected = new LinkedHashSet<Var>();
        expectedProjected.add(Var.var((String)"x"));
        expectedProjected.add(Var.var((String)"y"));
        TestStaticAnalysis.assertEquals(expectedProjected, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        LinkedHashSet<Var> expectedWhereClause = new LinkedHashSet<Var>();
        expectedWhereClause.add(Var.var((String)"uri"));
        expectedWhereClause.add(Var.var((String)"x"));
        expectedWhereClause.add(Var.var((String)"z"));
        TestStaticAnalysis.assertEquals(expectedWhereClause, (Object)sa.getSpannedVariables((BOp)queryRoot.getWhereClause(), new LinkedHashSet()));
        expectedWhereClause = new LinkedHashSet();
        expectedWhereClause.add(Var.var((String)"x"));
        expectedWhereClause.add(Var.var((String)"z"));
        TestStaticAnalysis.assertEquals(expectedWhereClause, (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)queryRoot.getWhereClause(), new LinkedHashSet(), true));
    }

    public void test_static_analysis_join_vars() throws MalformedQueryException {
        String queryStr = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x ?o \n with {   select ?x where { ?x rdf:type foaf:Person }\n } AS %namedSet1 \nwhere { \n   ?x rdfs:label ?o \n   INCLUDE %namedSet1 \n}";
        QueryRoot queryRoot = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x ?o \n with {   select ?x where { ?x rdf:type foaf:Person }\n } AS %namedSet1 \nwhere { \n   ?x rdfs:label ?o \n   INCLUDE %namedSet1 \n}", this.baseURI).getOriginalAST();
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet<Var> expectedProjected = new LinkedHashSet<Var>();
        expectedProjected.add(Var.var((String)"x"));
        expectedProjected.add(Var.var((String)"o"));
        TestStaticAnalysis.assertEquals(expectedProjected, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        expectedProjected = new LinkedHashSet();
        expectedProjected.add(Var.var((String)"x"));
        NamedSubqueryRoot namedSubquery = (NamedSubqueryRoot)queryRoot.getNamedSubqueries().get(0);
        TestStaticAnalysis.assertEquals(expectedProjected, (Object)sa.getDefinitelyProducedBindings((QueryBase)namedSubquery));
        LinkedHashSet<Var> expectedWhereClause = new LinkedHashSet<Var>();
        expectedWhereClause.add(Var.var((String)"x"));
        expectedWhereClause.add(Var.var((String)"o"));
        TestStaticAnalysis.assertEquals(expectedWhereClause, (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)queryRoot.getWhereClause(), new LinkedHashSet(), true));
        LinkedHashSet<Var> expectedJoinVars = new LinkedHashSet<Var>();
        expectedJoinVars.add(Var.var((String)"x"));
        namedSubquery = (NamedSubqueryRoot)queryRoot.getNamedSubqueries().get(0);
        NamedSubqueryInclude anInclude = (NamedSubqueryInclude)BOpUtility.visitAll((BOp)queryRoot, NamedSubqueryInclude.class).next();
        Set vars = sa.getJoinVars(namedSubquery, anInclude, new LinkedHashSet());
        TestStaticAnalysis.assertEquals(expectedJoinVars, (Object)vars);
    }

    public void test_static_analysis_filter_nested_1() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example/>\nSELECT ?v \n{ :x :p ?v . FILTER(?v = 1) }";
        QueryRoot queryRoot = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT ?v \n{ :x :p ?v . FILTER(?v = 1) }", this.baseURI).getOriginalAST();
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        GraphPatternGroup whereClause = queryRoot.getWhereClause();
        Set<IVariable<?>> expected = TestStaticAnalysis.asSet(new String[]{"v"});
        TestStaticAnalysis.assertEquals(expected, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        TestStaticAnalysis.assertEquals(expected, (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expected, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(EMPTY_SET, (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)whereClause, new LinkedHashSet()));
    }

    public void test_static_analysis_filter_nested_2() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example/>\nSELECT ?v \n{ :x :p ?v . { FILTER(?v = 1) } }";
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT ?v \n{ :x :p ?v . { FILTER(?v = 1) } }", this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTSetValueExpressionsOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        if (log.isInfoEnabled()) {
            log.info((Object)("\nqueryStr=\nPREFIX : <http://example/>\nSELECT ?v \n{ :x :p ?v . { FILTER(?v = 1) } }\nAST:\n" + BOpUtility.toString((BOp)queryRoot)));
        }
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"v"}), (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        GraphPatternGroup whereClause = queryRoot.getWhereClause();
        Set<IVariable<?>> expected = TestStaticAnalysis.asSet(new String[]{"v"});
        TestStaticAnalysis.assertEquals(EMPTY_SET, (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)whereClause, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(expected, (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expected, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true));
        JoinGroupNode filterClause = (JoinGroupNode)queryRoot.getWhereClause().get(1);
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"v"}), (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)filterClause, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(EMPTY_SET, (Object)sa.getDefinitelyProducedBindings(filterClause, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(EMPTY_SET, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)filterClause, new LinkedHashSet(), true));
        FilterNode filter = (FilterNode)BOpUtility.visitAll((BOp)queryRoot, FilterNode.class).next();
        TestStaticAnalysis.assertEquals(Collections.singletonList(filter), (Object)sa.getPreFilters(filterClause));
        TestStaticAnalysis.assertEquals(Collections.emptyList(), (Object)sa.getJoinFilters(filterClause));
        TestStaticAnalysis.assertEquals(Collections.emptyList(), (Object)sa.getPostFilters(filterClause));
        TestStaticAnalysis.assertEquals(Collections.emptyList(), (Object)sa.getPruneFilters(filterClause));
    }

    public void test_static_analysis_filter_scope_1() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example/>\nSELECT * \n{ \n    :x :p ?v . \n    { :x :q ?w \n      OPTIONAL {  :x :p ?v2 FILTER(?v = 1) } \n    } \n}";
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT * \n{ \n    :x :p ?v . \n    { :x :q ?w \n      OPTIONAL {  :x :p ?v2 FILTER(?v = 1) } \n    } \n}", this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTSetValueExpressionsOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        queryRoot = (QueryRoot)new ASTWildcardProjectionOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        if (log.isInfoEnabled()) {
            log.info((Object)("\nqueryStr=\nPREFIX : <http://example/>\nSELECT * \n{ \n    :x :p ?v . \n    { :x :q ?w \n      OPTIONAL {  :x :p ?v2 FILTER(?v = 1) } \n    } \n}\nAST:\n" + BOpUtility.toString((BOp)queryRoot)));
        }
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"v", "w"}), (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        JoinGroupNode group = (JoinGroupNode)queryRoot.getWhereClause();
        TestStaticAnalysis.assertEquals(EMPTY_SET, (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)group, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"v"}), (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), false));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"v", "w"}), (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"v"}), (Object)sa.getMaybeProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), false));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"v", "w", "v2"}), (Object)sa.getMaybeProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), true));
        group = (JoinGroupNode)queryRoot.getWhereClause().get(1);
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"v"}), (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)group, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"w"}), (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), false));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"w"}), (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"w"}), (Object)sa.getMaybeProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), false));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"w", "v2"}), (Object)sa.getMaybeProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), true));
        group = (JoinGroupNode)queryRoot.getWhereClause().get(1).get(1);
        sa.getDefinitelyIncomingBindings((IGroupMemberNode)group, new LinkedHashSet());
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"v", "w"}), (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)group, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"v2"}), (Object)sa.getDefinitelyProducedBindings(group, new LinkedHashSet(), false));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"v2"}), (Object)sa.getDefinitelyProducedBindings(group, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"v2"}), (Object)sa.getMaybeProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), false));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"v2"}), (Object)sa.getMaybeProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), true));
        FilterNode filter = (FilterNode)BOpUtility.visitAll((BOp)queryRoot, FilterNode.class).next();
        TestStaticAnalysis.assertEquals(Collections.singletonList(filter), (Object)sa.getPreFilters(group));
        TestStaticAnalysis.assertEquals(Collections.emptyList(), (Object)sa.getJoinFilters(group));
        TestStaticAnalysis.assertEquals(Collections.emptyList(), (Object)sa.getPostFilters(group));
        TestStaticAnalysis.assertEquals(Collections.emptyList(), (Object)sa.getPruneFilters(group));
    }

    public void test_static_analysis_join_scope_1() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://example/>\nSELECT * \n{ \n    ?X  :name \"paul\" . \n    {?Y :name \"george\" . OPTIONAL { ?X :email ?Z } } \n}";
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://example/>\nSELECT * \n{ \n    ?X  :name \"paul\" . \n    {?Y :name \"george\" . OPTIONAL { ?X :email ?Z } } \n}", this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTWildcardProjectionOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        if (log.isInfoEnabled()) {
            log.info((Object)("\nqueryStr=\nPREFIX : <http://example/>\nSELECT * \n{ \n    ?X  :name \"paul\" . \n    {?Y :name \"george\" . OPTIONAL { ?X :email ?Z } } \n}\nAST:\n" + BOpUtility.toString((BOp)queryRoot)));
        }
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"X", "Y"}), (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        JoinGroupNode group = (JoinGroupNode)queryRoot.getWhereClause();
        TestStaticAnalysis.assertEquals(EMPTY_SET, (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)group, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"X"}), (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), false));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"X", "Y"}), (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"X"}), (Object)sa.getMaybeProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), false));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"X", "Y", "Z"}), (Object)sa.getMaybeProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), true));
        group = (JoinGroupNode)queryRoot.getWhereClause().get(1);
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"X"}), (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)group, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"Y"}), (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), false));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"Y"}), (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"Y"}), (Object)sa.getMaybeProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), false));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"Y", "X", "Z"}), (Object)sa.getMaybeProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), true));
        group = (JoinGroupNode)queryRoot.getWhereClause().get(1).get(1);
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"X", "Y"}), (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)group, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"X", "Z"}), (Object)sa.getDefinitelyProducedBindings(group, new LinkedHashSet(), false));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"X", "Z"}), (Object)sa.getDefinitelyProducedBindings(group, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"X", "Z"}), (Object)sa.getMaybeProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), false));
        TestStaticAnalysis.assertEquals(TestStaticAnalysis.asSet(new String[]{"X", "Z"}), (Object)sa.getMaybeProducedBindings((IBindingProducerNode)group, new LinkedHashSet(), true));
    }

    public void test_static_analysis_serviceCall() throws MalformedQueryException {
        String queryStr = "PREFIX bd: <http://www.bigdata.com/rdf/search#>\nSELECT ?subj ?score\nWHERE {\n   ?lit bd:search \"mike\" .\n   ?lit bd:relevance ?score .\n   ?subj ?p ?lit .\n}";
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX bd: <http://www.bigdata.com/rdf/search#>\nSELECT ?subj ?score\nWHERE {\n   ?lit bd:search \"mike\" .\n   ?lit bd:relevance ?score .\n   ?subj ?p ?lit .\n}", this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTSearchOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        if (log.isInfoEnabled()) {
            log.info((Object)("\nqueryStr=\nPREFIX bd: <http://www.bigdata.com/rdf/search#>\nSELECT ?subj ?score\nWHERE {\n   ?lit bd:search \"mike\" .\n   ?lit bd:relevance ?score .\n   ?subj ?p ?lit .\n}\nAST:\n" + BOpUtility.toString((BOp)queryRoot)));
        }
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet<Var> expectedProjected = new LinkedHashSet<Var>();
        expectedProjected.add(Var.var((String)"subj"));
        expectedProjected.add(Var.var((String)"score"));
        TestStaticAnalysis.assertEquals(expectedProjected, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        LinkedHashSet<Var> expected = new LinkedHashSet<Var>();
        expected.add(Var.var((String)"subj"));
        expected.add(Var.var((String)"score"));
        expected.add(Var.var((String)"p"));
        expected.add(Var.var((String)"lit"));
        TestStaticAnalysis.assertEquals(expected, (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)queryRoot.getWhereClause(), new LinkedHashSet(), true));
        expected = new LinkedHashSet();
        expected.add(Var.var((String)"subj"));
        expected.add(Var.var((String)"score"));
        expected.add(Var.var((String)"p"));
        expected.add(Var.var((String)"lit"));
        TestStaticAnalysis.assertEquals(expected, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)queryRoot.getWhereClause(), new LinkedHashSet(), true));
    }

    public void test_static_analysis_serviceCall2() throws MalformedQueryException {
        String queryStr = "SELECT ?s ?o1 ?o2\n{\n  SERVICE <http://localhost:18080/openrdf/repositories/endpoint1> {\n  ?s ?p ?o1 . }\n  OPTIONAL {\n    SERVICE <http://localhost:18080/openrdf/repositories/endpoint2> {\n    ?s ?p2 ?o2 }\n  }\n}";
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("SELECT ?s ?o1 ?o2\n{\n  SERVICE <http://localhost:18080/openrdf/repositories/endpoint1> {\n  ?s ?p ?o1 . }\n  OPTIONAL {\n    SERVICE <http://localhost:18080/openrdf/repositories/endpoint2> {\n    ?s ?p2 ?o2 }\n  }\n}", this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTSubGroupJoinVarOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        if (log.isInfoEnabled()) {
            log.info((Object)("\nqueryStr=\nSELECT ?s ?o1 ?o2\n{\n  SERVICE <http://localhost:18080/openrdf/repositories/endpoint1> {\n  ?s ?p ?o1 . }\n  OPTIONAL {\n    SERVICE <http://localhost:18080/openrdf/repositories/endpoint2> {\n    ?s ?p2 ?o2 }\n  }\n}\nAST:\n" + BOpUtility.toString((BOp)queryRoot)));
        }
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        GraphPatternGroup whereClause = queryRoot.getWhereClause();
        ServiceNode endpoint1 = (ServiceNode)whereClause.get(0);
        TestStaticAnalysis.assertEquals((Object)endpoint1.getServiceRef().getValue(), (Object)new URIImpl("http://localhost:18080/openrdf/repositories/endpoint1"));
        JoinGroupNode optionalGroup = (JoinGroupNode)whereClause.get(1);
        TestStaticAnalysis.assertTrue((boolean)optionalGroup.isOptional());
        ServiceNode endpoint2 = (ServiceNode)optionalGroup.get(0);
        TestStaticAnalysis.assertEquals((Object)endpoint2.getServiceRef().getValue(), (Object)new URIImpl("http://localhost:18080/openrdf/repositories/endpoint2"));
        LinkedHashSet<Var> expectedProjected = new LinkedHashSet<Var>();
        expectedProjected.add(Var.var((String)"s"));
        expectedProjected.add(Var.var((String)"o1"));
        TestStaticAnalysis.assertEquals(expectedProjected, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        LinkedHashSet<Var> expected = new LinkedHashSet<Var>();
        expected.add(Var.var((String)"s"));
        expected.add(Var.var((String)"p"));
        expected.add(Var.var((String)"o1"));
        TestStaticAnalysis.assertEquals(expected, (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)queryRoot.getWhereClause(), new LinkedHashSet(), true));
        expected = new LinkedHashSet();
        expected.add(Var.var((String)"s"));
        expected.add(Var.var((String)"p"));
        expected.add(Var.var((String)"o1"));
        expected.add(Var.var((String)"p2"));
        expected.add(Var.var((String)"o2"));
        TestStaticAnalysis.assertEquals(expected, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)queryRoot.getWhereClause(), new LinkedHashSet(), true));
        expected = new LinkedHashSet();
        expected.add(Var.var((String)"s"));
        expected.add(Var.var((String)"p"));
        expected.add(Var.var((String)"o1"));
        TestStaticAnalysis.assertEquals(expected, (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)endpoint1, new LinkedHashSet(), true));
        expected = new LinkedHashSet();
        expected.add(Var.var((String)"s"));
        expected.add(Var.var((String)"p2"));
        expected.add(Var.var((String)"o2"));
        TestStaticAnalysis.assertEquals(expected, (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)endpoint2, new LinkedHashSet(), true));
        expected = new LinkedHashSet();
        TestStaticAnalysis.assertEquals(expected, (Object)sa.getJoinVars(endpoint1, new LinkedHashSet()));
        expected = new LinkedHashSet();
        expected.add(Var.var((String)"s"));
        TestStaticAnalysis.assertEquals(expected, (Object)sa.getJoinVars(endpoint2, new LinkedHashSet()));
        expected = new LinkedHashSet();
        expected.add(Var.var((String)"s"));
        HashSet<IVariable> actual = new HashSet<IVariable>();
        for (IVariable v : optionalGroup.getJoinVars()) {
            actual.add(v);
        }
        TestStaticAnalysis.assertEquals(expected, actual);
    }

    public void test_static_analysis_filters() throws MalformedQueryException {
        String queryStr = "PREFIX : <http://www.bigdata.com/>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nSELECT ?a ?b \n WHERE {\n   ?a rdf:type foaf:Person . \n   ?a foaf:knows ?b .\n   { \n     ?a :age ?ageA .\n     ?b :age ?ageB .\n     FILTER ( ?a != ?b ) .\n     FILTER ( ?ageA > ?ageB) .\n     FILTER ( ?x < 100 ) .\n   }\n   FILTER ( ?ageA > 20 ) .\n   }";
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2("PREFIX : <http://www.bigdata.com/>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nSELECT ?a ?b \n WHERE {\n   ?a rdf:type foaf:Person . \n   ?a foaf:knows ?b .\n   { \n     ?a :age ?ageA .\n     ?b :age ?ageB .\n     FILTER ( ?a != ?b ) .\n     FILTER ( ?ageA > ?ageB) .\n     FILTER ( ?x < 100 ) .\n   }\n   FILTER ( ?ageA > 20 ) .\n   }", this.baseURI);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        QueryRoot queryRoot = astContainer.getOriginalAST();
        queryRoot = (QueryRoot)new ASTSetValueExpressionsOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, null)).getQueryNode();
        if (log.isInfoEnabled()) {
            log.info((Object)("\nqueryStr=\nPREFIX : <http://www.bigdata.com/>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nSELECT ?a ?b \n WHERE {\n   ?a rdf:type foaf:Person . \n   ?a foaf:knows ?b .\n   { \n     ?a :age ?ageA .\n     ?b :age ?ageB .\n     FILTER ( ?a != ?b ) .\n     FILTER ( ?ageA > ?ageB) .\n     FILTER ( ?x < 100 ) .\n   }\n   FILTER ( ?ageA > 20 ) .\n   }\nAST:\n" + BOpUtility.toString((BOp)queryRoot)));
        }
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        Iterator itr = BOpUtility.visitAll((BOp)queryRoot.getWhereClause(), JoinGroupNode.class);
        JoinGroupNode outerGroup = (JoinGroupNode)itr.next();
        JoinGroupNode innerGroup = (JoinGroupNode)itr.next();
        FilterNode tmp = null;
        for (IGroupMemberNode child : outerGroup) {
            if (!(child instanceof FilterNode)) continue;
            tmp = (FilterNode)child;
            break;
        }
        FilterNode ageA_GT_20 = tmp;
        TestStaticAnalysis.assertNotNull(ageA_GT_20);
        FilterNode GT = null;
        FilterNode NE = null;
        FilterNode LT = null;
        for (IGroupMemberNode child : innerGroup) {
            if (!(child instanceof FilterNode)) continue;
            FilterNode tmp2 = (FilterNode)child;
            FunctionNode expr = (FunctionNode)tmp2.getValueExpressionNode();
            if (expr.getFunctionURI().equals((Object)FunctionRegistry.GT)) {
                GT = tmp2;
                continue;
            }
            if (expr.getFunctionURI().equals((Object)FunctionRegistry.NE)) {
                NE = tmp2;
                continue;
            }
            if (expr.getFunctionURI().equals((Object)FunctionRegistry.LT)) {
                LT = tmp2;
                continue;
            }
            throw new AssertionError();
        }
        FilterNode ageA_GT_ageB = GT;
        FilterNode a_NE_b = NE;
        FilterNode x_LT_10 = LT;
        TestStaticAnalysis.assertNotNull(ageA_GT_ageB);
        TestStaticAnalysis.assertNotNull(a_NE_b);
        TestStaticAnalysis.assertNotNull(x_LT_10);
        TestStaticAnalysis.assertEquals((String)"pre-filters", Collections.singletonList(a_NE_b), (Object)sa.getPreFilters(innerGroup));
        TestStaticAnalysis.assertEquals((String)"join-filters", Collections.singletonList(ageA_GT_ageB), (Object)sa.getJoinFilters(innerGroup));
        TestStaticAnalysis.assertEquals((String)"post-filters", Collections.singletonList(x_LT_10), (Object)sa.getPostFilters(innerGroup));
        TestStaticAnalysis.assertEquals((String)"prune-filters", Collections.singletonList(x_LT_10), (Object)sa.getPruneFilters(innerGroup));
        TestStaticAnalysis.assertEquals((String)"definitely-and-filters", TestStaticAnalysis.asSet(new String[]{"a", "b", "ageA", "ageB", "x"}), (Object)sa.getDefinitelyProducedBindingsAndFilterVariables((IGroupNode)innerGroup, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals((String)"pre-filters", Collections.emptyList(), (Object)sa.getPreFilters(outerGroup));
        TestStaticAnalysis.assertEquals((String)"join-filters", Collections.emptyList(), (Object)sa.getJoinFilters(outerGroup));
        TestStaticAnalysis.assertEquals((String)"post-filters", Collections.singletonList(ageA_GT_20), (Object)sa.getPostFilters(outerGroup));
        TestStaticAnalysis.assertEquals((String)"prune-filters", Collections.emptyList(), (Object)sa.getPruneFilters(outerGroup));
        TestStaticAnalysis.assertEquals((String)"definitely-and-filters", TestStaticAnalysis.asSet(new String[]{"a", "b", "ageA"}), (Object)sa.getDefinitelyProducedBindingsAndFilterVariables((IGroupNode)outerGroup, new LinkedHashSet()));
    }

    public void test_static_analysis_getMaybeProducedBindings() {
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        IV q = this.makeIV((Value)new URIImpl("http://example/q"));
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("a"));
        projection.addProjectionVar(new VarNode("n"));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        StatementPatternNode sp1 = new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("n"));
        whereClause.addChild((IGroupMemberNode)sp1);
        StatementPatternNode sp2 = new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("m"));
        whereClause.addChild((IGroupMemberNode)sp2);
        sp2.setOptional(true);
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        TestStaticAnalysis.assertEquals(Collections.emptySet(), (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)whereClause, new LinkedHashSet()));
        LinkedHashSet<Var> expectedVars = new LinkedHashSet<Var>();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(whereClause, new LinkedHashSet(), true));
        expectedVars.add(Var.var((String)"m"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(Collections.emptySet(), (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)sp1, new LinkedHashSet()));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)sp1, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)sp1, new LinkedHashSet(), true));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)sp2, new LinkedHashSet()));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"m"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings((IBindingProducerNode)sp2, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)sp2, new LinkedHashSet(), true));
    }

    public void test_static_analysis_minus_sharedVariables() {
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        IV q = this.makeIV((Value)new URIImpl("http://example/q"));
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("a"));
        projection.addProjectionVar(new VarNode("n"));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("n")));
        JoinGroupNode minusGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)minusGroup);
        minusGroup.setMinus(true);
        minusGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("n")));
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet<Var> expectedVars = new LinkedHashSet<Var>();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((QueryBase)queryRoot));
        TestStaticAnalysis.assertEquals(Collections.emptySet(), (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)whereClause, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(Collections.emptySet(), (Object)sa.getMaybeIncomingBindings((IGroupMemberNode)whereClause, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(whereClause, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)minusGroup, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeIncomingBindings((IGroupMemberNode)minusGroup, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(minusGroup, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)minusGroup, new LinkedHashSet(), true));
    }

    public void test_static_analysis_minus_nothingShared() {
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        JoinGroupNode minusGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)minusGroup);
        minusGroup.setMinus(true);
        minusGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new VarNode("y"), (TermNode)new VarNode("z")));
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet<Var> expectedVars = new LinkedHashSet<Var>();
        expectedVars.add(Var.var((String)"s"));
        expectedVars.add(Var.var((String)"p"));
        expectedVars.add(Var.var((String)"o"));
        LinkedHashSet<Var> otherVars = new LinkedHashSet<Var>();
        otherVars.add(Var.var((String)"x"));
        otherVars.add(Var.var((String)"y"));
        otherVars.add(Var.var((String)"z"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((QueryBase)queryRoot));
        TestStaticAnalysis.assertEquals(Collections.emptySet(), (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)whereClause, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(Collections.emptySet(), (Object)sa.getMaybeIncomingBindings((IGroupMemberNode)whereClause, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(whereClause, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)minusGroup, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeIncomingBindings((IGroupMemberNode)minusGroup, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(otherVars, (Object)sa.getDefinitelyProducedBindings(minusGroup, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(otherVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)minusGroup, new LinkedHashSet(), true));
    }

    public void test_static_analysis_minus_and_optional() {
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        IV q = this.makeIV((Value)new URIImpl("http://example/q"));
        IV three = this.makeIV((Value)new LiteralImpl("3.0", XSD.DECIMAL));
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("a"));
        projection.addProjectionVar(new VarNode("n"));
        projection.addProjectionVar(new VarNode("b"));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("n")));
        JoinGroupNode optGroup1 = new JoinGroupNode(true);
        whereClause.addChild((IGroupMemberNode)optGroup1);
        optGroup1.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("b"), (TermNode)new ConstantNode(p), (TermNode)new ConstantNode(three)));
        JoinGroupNode minusGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)minusGroup);
        minusGroup.setMinus(true);
        minusGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("n")));
        JoinGroupNode optGroup2 = new JoinGroupNode(true);
        minusGroup.addChild((IGroupMemberNode)optGroup2);
        optGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("c"), (TermNode)new ConstantNode(q), (TermNode)new ConstantNode(three)));
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet<Var> expectedVars = new LinkedHashSet<Var>();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        expectedVars.add(Var.var((String)"b"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((QueryBase)queryRoot));
        TestStaticAnalysis.assertEquals(Collections.emptySet(), (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)whereClause, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(Collections.emptySet(), (Object)sa.getMaybeIncomingBindings((IGroupMemberNode)whereClause, new LinkedHashSet()));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(whereClause, new LinkedHashSet(), true));
        expectedVars.add(Var.var((String)"b"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)optGroup1, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeIncomingBindings((IGroupMemberNode)optGroup1, new LinkedHashSet()));
        expectedVars.clear();
        expectedVars.add(Var.var((String)"b"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(optGroup1, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)optGroup1, new LinkedHashSet(), true));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)minusGroup, new LinkedHashSet()));
        expectedVars.add(Var.var((String)"b"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeIncomingBindings((IGroupMemberNode)minusGroup, new LinkedHashSet()));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(minusGroup, new LinkedHashSet(), true));
        expectedVars.add(Var.var((String)"c"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)minusGroup, new LinkedHashSet(), true));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)optGroup2, new LinkedHashSet()));
        expectedVars.add(Var.var((String)"b"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeIncomingBindings((IGroupMemberNode)optGroup2, new LinkedHashSet()));
        expectedVars.clear();
        expectedVars.add(Var.var((String)"c"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(optGroup2, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)optGroup2, new LinkedHashSet(), true));
    }

    public void test_static_analysis_subGroups_and_optional() {
        IV p = this.makeIV((Value)new URIImpl("http://example/p"));
        IV q = this.makeIV((Value)new URIImpl("http://example/q"));
        IV three = this.makeIV((Value)new LiteralImpl("3.0", XSD.DECIMAL));
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("a"));
        projection.addProjectionVar(new VarNode("n"));
        projection.addProjectionVar(new VarNode("b"));
        projection.addProjectionVar(new VarNode("c"));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(p), (TermNode)new VarNode("n")));
        JoinGroupNode childGroup = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)childGroup);
        childGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(q), (TermNode)new VarNode("n")));
        JoinGroupNode optGroup2 = new JoinGroupNode(true);
        childGroup.addChild((IGroupMemberNode)optGroup2);
        optGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("c"), (TermNode)new ConstantNode(q), (TermNode)new ConstantNode(three)));
        JoinGroupNode optGroup1 = new JoinGroupNode(true);
        whereClause.addChild((IGroupMemberNode)optGroup1);
        optGroup1.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("b"), (TermNode)new ConstantNode(p), (TermNode)new ConstantNode(three)));
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet<Var> expectedVars = new LinkedHashSet<Var>();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        expectedVars.add(Var.var((String)"b"));
        expectedVars.add(Var.var((String)"c"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((QueryBase)queryRoot));
        TestStaticAnalysis.assertEquals(Collections.emptySet(), (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)whereClause, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(Collections.emptySet(), (Object)sa.getMaybeIncomingBindings((IGroupMemberNode)whereClause, new LinkedHashSet()));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(whereClause, new LinkedHashSet(), true));
        expectedVars.add(Var.var((String)"b"));
        expectedVars.add(Var.var((String)"c"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)childGroup, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeIncomingBindings((IGroupMemberNode)childGroup, new LinkedHashSet()));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(childGroup, new LinkedHashSet(), true));
        expectedVars.add(Var.var((String)"c"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)childGroup, new LinkedHashSet(), true));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)optGroup2, new LinkedHashSet()));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeIncomingBindings((IGroupMemberNode)optGroup2, new LinkedHashSet()));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"c"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(optGroup2, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)optGroup2, new LinkedHashSet(), true));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"n"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyIncomingBindings((IGroupMemberNode)optGroup1, new LinkedHashSet()));
        expectedVars.add(Var.var((String)"c"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeIncomingBindings((IGroupMemberNode)optGroup1, new LinkedHashSet()));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"b"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(optGroup1, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)optGroup1, new LinkedHashSet(), true));
    }

    public void test_static_analysis_getProjectedVars() {
        IV a = this.makeIV((Value)RDF.TYPE);
        IV polititian = this.makeIV((Value)new URIImpl("http://www.rdfabout.com/rdf/schema/politico/Politician"));
        IV name = this.makeIV((Value)new URIImpl("http://www.rdfabout.com/rdf/schema/usgovt/name"));
        IV sponsor = this.makeIV((Value)new URIImpl("http://www.rdfabout.com/rdf/schema/usgovt/sponsor"));
        IV title = this.makeIV((Value)new URIImpl("http://www.rdfabout.com/rdf/schema/usgovt/title"));
        IV N = this.makeIV((Value)new URIImpl("http://www.w3.org/2001/vcard-rdf/3.0#N"));
        IV family = this.makeIV((Value)new URIImpl("http://www.w3.org/2001/vcard-rdf/3.0#Family"));
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("var1"));
        projection.addProjectionVar(new VarNode("var6"));
        projection.addProjectionVar(new VarNode("var4"));
        projection.addProjectionVar(new VarNode("var10"));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var1"), (TermNode)new ConstantNode(a), (TermNode)new ConstantNode(polititian), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode optionalGroup1 = new JoinGroupNode(true);
        whereClause.addChild((IGroupMemberNode)optionalGroup1);
        optionalGroup1.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var1"), (TermNode)new ConstantNode(name), (TermNode)new VarNode("var6"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode optionalGroup2 = new JoinGroupNode(true);
        whereClause.addChild((IGroupMemberNode)optionalGroup2);
        optionalGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var12"), (TermNode)new ConstantNode(sponsor), (TermNode)new VarNode("var1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        optionalGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var12"), (TermNode)new ConstantNode(title), (TermNode)new VarNode("var4"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        JoinGroupNode optionalGroup3 = new JoinGroupNode(true);
        whereClause.addChild((IGroupMemberNode)optionalGroup3);
        optionalGroup3.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var1"), (TermNode)new ConstantNode(N), (TermNode)new VarNode("var13"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        optionalGroup3.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("var13"), (TermNode)new ConstantNode(family), (TermNode)new VarNode("var10"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet exogenousVars = new LinkedHashSet();
        LinkedHashSet<Var> expectedVars = new LinkedHashSet<Var>();
        expectedVars.add(Var.var((String)"var1"));
        expectedVars.add(Var.var((String)"var6"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getProjectedVars((IGroupMemberNode)optionalGroup1, (GraphPatternGroup)optionalGroup1, (QueryBase)queryRoot, exogenousVars, new LinkedHashSet()));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"var1"));
        expectedVars.add(Var.var((String)"var4"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getProjectedVars((IGroupMemberNode)optionalGroup2, (GraphPatternGroup)optionalGroup2, (QueryBase)queryRoot, exogenousVars, new LinkedHashSet()));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"var1"));
        expectedVars.add(Var.var((String)"var10"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getProjectedVars((IGroupMemberNode)optionalGroup3, (GraphPatternGroup)optionalGroup3, (QueryBase)queryRoot, exogenousVars, new LinkedHashSet()));
    }

    public void test_static_analysis_projection_01() {
        IV rdfType = this.makeIV((Value)RDF.TYPE);
        IV foafPerson = this.makeIV((Value)FOAFVocabularyDecl.Person);
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionExpression(new AssignmentNode(new VarNode("b"), (IValueExpressionNode)new VarNode("a")));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(rdfType), (TermNode)new ConstantNode(foafPerson)));
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet exogenousVars = new LinkedHashSet();
        LinkedHashSet<Var> expectedVars = new LinkedHashSet<Var>();
        expectedVars.add(Var.var((String)"b"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((QueryBase)queryRoot));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"a"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(whereClause, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true));
    }

    public void test_static_analysis_projection_02() {
        IV rdfType = this.makeIV((Value)RDF.TYPE);
        IV foafPerson = this.makeIV((Value)FOAFVocabularyDecl.Person);
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionExpression(new AssignmentNode(new VarNode("b"), (IValueExpressionNode)new VarNode("a")));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        JoinGroupNode optionalGroup = new JoinGroupNode(true);
        whereClause.addChild((IGroupMemberNode)optionalGroup);
        optionalGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("a"), (TermNode)new ConstantNode(rdfType), (TermNode)new ConstantNode(foafPerson)));
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet exogenousVars = new LinkedHashSet();
        LinkedHashSet<Var> expectedVars = new LinkedHashSet<Var>();
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        expectedVars.add(Var.var((String)"b"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((QueryBase)queryRoot));
        expectedVars = new LinkedHashSet();
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(whereClause, new LinkedHashSet(), true));
        expectedVars.add(Var.var((String)"a"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"a"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(optionalGroup, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)optionalGroup, new LinkedHashSet(), true));
    }

    public void test_static_analysis_projection_03() {
        IV foafPerson = this.makeIV((Value)FOAFVocabularyDecl.Person);
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionExpression(new AssignmentNode(new VarNode("b"), (IValueExpressionNode)new ConstantNode(foafPerson)));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet exogenousVars = new LinkedHashSet();
        LinkedHashSet<Var> expectedVars = new LinkedHashSet<Var>();
        expectedVars.add(Var.var((String)"b"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((QueryBase)queryRoot));
        expectedVars = new LinkedHashSet();
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(whereClause, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true));
    }

    public void test_static_analysis_projection_04() {
        IV rdfType = this.makeIV((Value)RDF.TYPE);
        IV foafPerson = this.makeIV((Value)FOAFVocabularyDecl.Person);
        IV age = this.makeIV((Value)new URIImpl("http://example.org/age"));
        IV grade = this.makeIV((Value)new URIImpl("http://example.org/grade"));
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("a"));
        projection.addProjectionVar(new VarNode("b"));
        projection.addProjectionExpression(new AssignmentNode(new VarNode("c"), (IValueExpressionNode)FunctionNode.binary((URI)FunctionRegistry.DIVIDE, (TermNode)new VarNode("a"), (TermNode)new VarNode("b"))));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType), (TermNode)new ConstantNode(foafPerson)));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(age), (TermNode)new VarNode("a")));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(grade), (TermNode)new VarNode("b")));
        IBindingSet[] bindingSets = new IBindingSet[]{};
        ASTContainer astContainer = new ASTContainer(queryRoot);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        queryRoot = (QueryRoot)new ASTSetValueExpressionsOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, bindingSets)).getQueryNode();
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet exogenousVars = new LinkedHashSet();
        LinkedHashSet<Var> expectedVars = new LinkedHashSet<Var>();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"b"));
        expectedVars.add(Var.var((String)"c"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((QueryBase)queryRoot));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"x"));
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"b"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(whereClause, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true));
    }

    public void test_static_analysis_projection_05() {
        IV rdfType = this.makeIV((Value)RDF.TYPE);
        IV foafPerson = this.makeIV((Value)FOAFVocabularyDecl.Person);
        IV age = this.makeIV((Value)new URIImpl("http://example.org/age"));
        IV grade = this.makeIV((Value)new URIImpl("http://example.org/grade"));
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("a"));
        projection.addProjectionVar(new VarNode("b"));
        projection.addProjectionExpression(new AssignmentNode(new VarNode("c"), (IValueExpressionNode)FunctionNode.binary((URI)FunctionRegistry.DIVIDE, (TermNode)new VarNode("a"), (TermNode)new VarNode("b"))));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType), (TermNode)new ConstantNode(foafPerson)));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(age), (TermNode)new VarNode("a")));
        JoinGroupNode optionalGroup = new JoinGroupNode(true);
        whereClause.addChild((IGroupMemberNode)optionalGroup);
        optionalGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(grade), (TermNode)new VarNode("b")));
        IBindingSet[] bindingSets = new IBindingSet[]{};
        ASTContainer astContainer = new ASTContainer(queryRoot);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        queryRoot = (QueryRoot)new ASTSetValueExpressionsOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, bindingSets)).getQueryNode();
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet exogenousVars = new LinkedHashSet();
        LinkedHashSet<Var> expectedVars = new LinkedHashSet<Var>();
        expectedVars.add(Var.var((String)"a"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        expectedVars.add(Var.var((String)"b"));
        expectedVars.add(Var.var((String)"c"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((QueryBase)queryRoot));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"x"));
        expectedVars.add(Var.var((String)"a"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(whereClause, new LinkedHashSet(), true));
        expectedVars.add(Var.var((String)"b"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"x"));
        expectedVars.add(Var.var((String)"b"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(optionalGroup, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)optionalGroup, new LinkedHashSet(), true));
    }

    public void test_static_analysis_projection_06() {
        IV rdfType = this.makeIV((Value)RDF.TYPE);
        IV foafPerson = this.makeIV((Value)FOAFVocabularyDecl.Person);
        IV age = this.makeIV((Value)new URIImpl("http://example.org/age"));
        IV grade = this.makeIV((Value)new URIImpl("http://example.org/grade"));
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("a"));
        projection.addProjectionVar(new VarNode("b"));
        projection.addProjectionExpression(new AssignmentNode(new VarNode("c"), (IValueExpressionNode)FunctionNode.binary((URI)FunctionRegistry.DIVIDE, (TermNode)new VarNode("a"), (TermNode)new VarNode("b"))));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType), (TermNode)new ConstantNode(foafPerson)));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(age), (TermNode)new VarNode("a")));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(grade), (TermNode)new VarNode("b")));
        GroupByNode groupBy = new GroupByNode();
        queryRoot.setGroupBy(groupBy);
        groupBy.addGroupByVar(new VarNode("b"));
        IBindingSet[] bindingSets = new IBindingSet[]{};
        ASTContainer astContainer = new ASTContainer(queryRoot);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        queryRoot = (QueryRoot)new ASTSetValueExpressionsOptimizer().optimize(context, new QueryNodeWithBindingSet((IQueryNode)queryRoot, bindingSets)).getQueryNode();
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        LinkedHashSet exogenousVars = new LinkedHashSet();
        LinkedHashSet<Var> expectedVars = new LinkedHashSet<Var>();
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"b"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings((QueryBase)queryRoot));
        expectedVars.add(Var.var((String)"c"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((QueryBase)queryRoot));
        expectedVars = new LinkedHashSet();
        expectedVars.add(Var.var((String)"x"));
        expectedVars.add(Var.var((String)"a"));
        expectedVars.add(Var.var((String)"b"));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getDefinitelyProducedBindings(whereClause, new LinkedHashSet(), true));
        TestStaticAnalysis.assertEquals(expectedVars, (Object)sa.getMaybeProducedBindings((IBindingProducerNode)whereClause, new LinkedHashSet(), true));
    }

    public void test_findParent_01() {
        IV rdfType = this.makeIV((Value)RDF.TYPE);
        IV foafPerson = this.makeIV((Value)FOAFVocabularyDecl.Person);
        IV age = this.makeIV((Value)new URIImpl("http://example.org/age"));
        IV grade = this.makeIV((Value)new URIImpl("http://example.org/grade"));
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("a"));
        projection.addProjectionVar(new VarNode("b"));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType), (TermNode)new ConstantNode(foafPerson)));
        UnionNode unionNode = new UnionNode();
        whereClause.addChild((IGroupMemberNode)unionNode);
        JoinGroupNode joinGroup1 = new JoinGroupNode();
        unionNode.addChild(joinGroup1);
        joinGroup1.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(age), (TermNode)new VarNode("a")));
        JoinGroupNode joinGroup2 = new JoinGroupNode();
        unionNode.addChild(joinGroup2);
        joinGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(grade), (TermNode)new VarNode("b")));
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        TestStaticAnalysis.assertTrue((unionNode == sa.findParent((GraphPatternGroup)joinGroup1) ? 1 : 0) != 0);
        TestStaticAnalysis.assertTrue((unionNode == sa.findParent((GraphPatternGroup)joinGroup2) ? 1 : 0) != 0);
        TestStaticAnalysis.assertTrue((whereClause == sa.findParent((GraphPatternGroup)unionNode) ? 1 : 0) != 0);
        TestStaticAnalysis.assertTrue((queryRoot == sa.findParent((GraphPatternGroup)whereClause) ? 1 : 0) != 0);
    }

    public void test_findParent_02() {
        IV rdfType = this.makeIV((Value)RDF.TYPE);
        IV foafPerson = this.makeIV((Value)FOAFVocabularyDecl.Person);
        IV age = this.makeIV((Value)new URIImpl("http://example.org/age"));
        IV grade = this.makeIV((Value)new URIImpl("http://example.org/grade"));
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("a"));
        projection.addProjectionVar(new VarNode("b"));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType), (TermNode)new ConstantNode(foafPerson)));
        SubqueryRoot subqueryRoot = new SubqueryRoot(QueryType.SELECT);
        whereClause.addChild((IGroupMemberNode)subqueryRoot);
        JoinGroupNode subqueryWhereClause = new JoinGroupNode();
        subqueryRoot.setWhereClause((GraphPatternGroup)subqueryWhereClause);
        subqueryWhereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(age), (TermNode)new VarNode("a")));
        subqueryWhereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(grade), (TermNode)new VarNode("b")));
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        TestStaticAnalysis.assertTrue((subqueryRoot == sa.findParent((GraphPatternGroup)subqueryWhereClause) ? 1 : 0) != 0);
        TestStaticAnalysis.assertTrue((whereClause == subqueryRoot.getParent() ? 1 : 0) != 0);
    }

    public void test_findParent_03() {
        IV rdfType = this.makeIV((Value)RDF.TYPE);
        IV foafPerson = this.makeIV((Value)FOAFVocabularyDecl.Person);
        IV age = this.makeIV((Value)new URIImpl("http://example.org/age"));
        IV grade = this.makeIV((Value)new URIImpl("http://example.org/grade"));
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        String namedSet = "set1";
        NamedSubqueryRoot subqueryRoot = new NamedSubqueryRoot(QueryType.SELECT, "set1");
        JoinGroupNode subqueryWhereClause = new JoinGroupNode();
        subqueryRoot.setWhereClause((GraphPatternGroup)subqueryWhereClause);
        subqueryWhereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(age), (TermNode)new VarNode("a")));
        subqueryWhereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(grade), (TermNode)new VarNode("b")));
        queryRoot.getNamedSubqueriesNotNull().add((IQueryNode)subqueryRoot);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("a"));
        projection.addProjectionVar(new VarNode("b"));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType), (TermNode)new ConstantNode(foafPerson)));
        NamedSubqueryInclude include = new NamedSubqueryInclude("set1");
        whereClause.addChild((IGroupMemberNode)include);
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        TestStaticAnalysis.assertTrue((subqueryRoot == sa.findParent((GraphPatternGroup)subqueryWhereClause) ? 1 : 0) != 0);
        TestStaticAnalysis.assertTrue((whereClause == include.getParent() ? 1 : 0) != 0);
    }

    public void test_findParent_04() {
        IV rdfType = this.makeIV((Value)RDF.TYPE);
        IV foafPerson = this.makeIV((Value)FOAFVocabularyDecl.Person);
        IV age = this.makeIV((Value)new URIImpl("http://example.org/age"));
        IV grade = this.makeIV((Value)new URIImpl("http://example.org/grade"));
        IV serviceUri = this.makeIV((Value)new URIImpl("http://example.org/service"));
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        queryRoot.setProjection(projection);
        projection.addProjectionVar(new VarNode("a"));
        projection.addProjectionVar(new VarNode("b"));
        JoinGroupNode whereClause = new JoinGroupNode();
        queryRoot.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(rdfType), (TermNode)new ConstantNode(foafPerson)));
        JoinGroupNode serviceGroup = new JoinGroupNode();
        serviceGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(age), (TermNode)new VarNode("a")));
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(serviceUri), (GraphPatternGroup)serviceGroup);
        whereClause.addChild((IGroupMemberNode)serviceNode);
        JoinGroupNode existsGroup = new JoinGroupNode();
        existsGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("x"), (TermNode)new ConstantNode(grade), (TermNode)new VarNode("b")));
        FilterNode filterNode = new FilterNode((IValueExpressionNode)new ExistsNode(new VarNode("anon-var-1"), (GraphPatternGroup)existsGroup));
        whereClause.addChild((IGroupMemberNode)filterNode);
        StaticAnalysis sa = new StaticAnalysis(queryRoot);
        TestStaticAnalysis.assertTrue((serviceNode == sa.findParent((GraphPatternGroup)serviceGroup) ? 1 : 0) != 0);
        TestStaticAnalysis.assertTrue((filterNode == sa.findParent((GraphPatternGroup)existsGroup) ? 1 : 0) != 0);
        TestStaticAnalysis.assertTrue((queryRoot == sa.findParent((GraphPatternGroup)whereClause) ? 1 : 0) != 0);
    }
}

