/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IConstant;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import java.util.Collections;
import junit.framework.TestCase2;

public class TestStaticAnalysis_CanJoin
extends TestCase2 {
    public TestStaticAnalysis_CanJoin() {
    }

    public TestStaticAnalysis_CanJoin(String name) {
        super(name);
    }

    protected IV mockIV() {
        return TermId.mockIV((VTE)VTE.URI);
    }

    public void test_canJoin_correctRejection() {
        block5: {
            StaticAnalysis sa;
            StatementPatternNode p1;
            block4: {
                ConstantNode p = new ConstantNode((IConstant)new Constant((Object)this.mockIV()));
                ConstantNode q = new ConstantNode((IConstant)new Constant((Object)this.mockIV()));
                ConstantNode r = new ConstantNode((IConstant)new Constant((Object)this.mockIV()));
                VarNode x = new VarNode("x");
                VarNode y = new VarNode("y");
                VarNode z = new VarNode("z");
                p1 = new StatementPatternNode((TermNode)p, (TermNode)y, (TermNode)z);
                StatementPatternNode p2 = new StatementPatternNode((TermNode)x, (TermNode)q, (TermNode)r);
                sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT));
                try {
                    sa.canJoin(null, (IJoinNode)p2);
                    TestStaticAnalysis_CanJoin.fail((String)("Expecting: " + IllegalArgumentException.class));
                }
                catch (IllegalArgumentException ex) {
                    if (!log.isInfoEnabled()) break block4;
                    log.info((Object)("Ignoring expected exception: " + ex));
                }
            }
            try {
                sa.canJoin((IJoinNode)p1, null);
                TestStaticAnalysis_CanJoin.fail((String)("Expecting: " + IllegalArgumentException.class));
            }
            catch (IllegalArgumentException ex) {
                if (!log.isInfoEnabled()) break block5;
                log.info((Object)("Ignoring expected exception: " + ex));
            }
        }
    }

    public void test_canJoin() {
        ConstantNode p = new ConstantNode((IConstant)new Constant((Object)this.mockIV()));
        ConstantNode q = new ConstantNode((IConstant)new Constant((Object)this.mockIV()));
        ConstantNode r = new ConstantNode((IConstant)new Constant((Object)this.mockIV()));
        VarNode u = new VarNode("u");
        VarNode x = new VarNode("x");
        VarNode y = new VarNode("y");
        VarNode z = new VarNode("z");
        StatementPatternNode p1 = new StatementPatternNode((TermNode)x, (TermNode)y, (TermNode)p);
        StatementPatternNode p2 = new StatementPatternNode((TermNode)y, (TermNode)z, (TermNode)q);
        StatementPatternNode p3 = new StatementPatternNode((TermNode)u, (TermNode)z, (TermNode)r);
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT));
        TestStaticAnalysis_CanJoin.assertTrue((boolean)sa.canJoin((IJoinNode)p1, (IJoinNode)p2));
        TestStaticAnalysis_CanJoin.assertTrue((boolean)sa.canJoin((IJoinNode)p2, (IJoinNode)p3));
        TestStaticAnalysis_CanJoin.assertFalse((boolean)sa.canJoin((IJoinNode)p1, (IJoinNode)p3));
        TestStaticAnalysis_CanJoin.assertTrue((boolean)sa.canJoin((IJoinNode)p1, (IJoinNode)p1));
    }

    public void test_canJoin_filtersAreIngored() {
        ConstantNode p = new ConstantNode((IConstant)new Constant((Object)this.mockIV()));
        ConstantNode q = new ConstantNode((IConstant)new Constant((Object)this.mockIV()));
        ConstantNode r = new ConstantNode((IConstant)new Constant((Object)this.mockIV()));
        VarNode x = new VarNode("x");
        VarNode y = new VarNode("y");
        VarNode z = new VarNode("z");
        StatementPatternNode p1 = new StatementPatternNode((TermNode)p, (TermNode)q, (TermNode)x);
        StatementPatternNode p2 = new StatementPatternNode((TermNode)y, (TermNode)r, (TermNode)z);
        p2.setOptional(true);
        p2.setAttachedJoinFilters(Collections.singletonList(new FilterNode((IValueExpressionNode)x)));
        StaticAnalysis sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT));
        TestStaticAnalysis_CanJoin.assertFalse((boolean)sa.canJoin((IJoinNode)p1, (IJoinNode)p2));
    }
}

