/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IConstant;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.BSBMQ5Setup;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;

public class TestStaticAnalysis_CanJoinUsingConstraints
extends AbstractASTEvaluationTestCase {
    private static final Logger log = Logger.getLogger(TestStaticAnalysis_CanJoinUsingConstraints.class);

    public TestStaticAnalysis_CanJoinUsingConstraints() {
    }

    public TestStaticAnalysis_CanJoinUsingConstraints(String name) {
        super(name);
    }

    private IV mockIV() {
        return TermId.mockIV((VTE)VTE.URI);
    }

    public void test_canJoinUsingConstraints_illegalArgument() {
        block17: {
            StaticAnalysis sa;
            StatementPatternNode p2;
            StatementPatternNode p1;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                ConstantNode p = new ConstantNode((IConstant)new Constant((Object)this.mockIV()));
                                ConstantNode q = new ConstantNode((IConstant)new Constant((Object)this.mockIV()));
                                ConstantNode r = new ConstantNode((IConstant)new Constant((Object)this.mockIV()));
                                VarNode x = new VarNode("x");
                                VarNode y = new VarNode("y");
                                p1 = new StatementPatternNode((TermNode)x, (TermNode)q, (TermNode)r);
                                p2 = new StatementPatternNode((TermNode)y, (TermNode)p, (TermNode)q);
                                sa = new StaticAnalysis(new QueryRoot(QueryType.SELECT));
                                try {
                                    sa.canJoinUsingConstraints(null, (IJoinNode)p1, new FilterNode[0]);
                                    TestStaticAnalysis_CanJoinUsingConstraints.fail((String)("Expecting: " + IllegalArgumentException.class));
                                }
                                catch (IllegalArgumentException ex) {
                                    if (!log.isInfoEnabled()) break block12;
                                    log.info((Object)("Expecting: " + IllegalArgumentException.class));
                                }
                            }
                            try {
                                sa.canJoinUsingConstraints(new IJoinNode[]{p1}, null, new FilterNode[0]);
                                TestStaticAnalysis_CanJoinUsingConstraints.fail((String)("Expecting: " + IllegalArgumentException.class));
                            }
                            catch (IllegalArgumentException ex) {
                                if (!log.isInfoEnabled()) break block13;
                                log.info((Object)("Expecting: " + IllegalArgumentException.class));
                            }
                        }
                        try {
                            sa.canJoinUsingConstraints(new IJoinNode[0], (IJoinNode)p1, new FilterNode[0]);
                            TestStaticAnalysis_CanJoinUsingConstraints.fail((String)("Expecting: " + IllegalArgumentException.class));
                        }
                        catch (IllegalArgumentException ex) {
                            if (!log.isInfoEnabled()) break block14;
                            log.info((Object)("Expecting: " + IllegalArgumentException.class));
                        }
                    }
                    try {
                        sa.canJoinUsingConstraints(new IJoinNode[]{p2, null}, (IJoinNode)p1, new FilterNode[0]);
                        TestStaticAnalysis_CanJoinUsingConstraints.fail((String)("Expecting: " + IllegalArgumentException.class));
                    }
                    catch (IllegalArgumentException ex) {
                        if (!log.isInfoEnabled()) break block15;
                        log.info((Object)("Expecting: " + IllegalArgumentException.class));
                    }
                }
                try {
                    sa.canJoinUsingConstraints(new IJoinNode[]{p2, p1}, (IJoinNode)p1, new FilterNode[0]);
                    TestStaticAnalysis_CanJoinUsingConstraints.fail((String)("Expecting: " + IllegalArgumentException.class));
                }
                catch (IllegalArgumentException ex) {
                    if (!log.isInfoEnabled()) break block16;
                    log.info((Object)("Expecting: " + IllegalArgumentException.class));
                }
            }
            try {
                sa.canJoinUsingConstraints(new IJoinNode[]{p2}, (IJoinNode)p1, new FilterNode[]{new FilterNode((IValueExpressionNode)new VarNode("x")), null});
                TestStaticAnalysis_CanJoinUsingConstraints.fail((String)("Expecting: " + IllegalArgumentException.class));
            }
            catch (IllegalArgumentException ex) {
                if (!log.isInfoEnabled()) break block17;
                log.info((Object)("Expecting: " + IllegalArgumentException.class));
            }
        }
    }

    public void test_canJoinUsingConstraints_1step_productVar() {
        BSBMQ5Setup s = new BSBMQ5Setup(this.store);
        StaticAnalysis sa = new StaticAnalysis(s.queryRoot);
        IJoinNode[] a = new IJoinNode[]{s.p0, s.p2, s.p4, s.p6};
        for (int i = 0; i < a.length; ++i) {
            for (int j = i; j < a.length; ++j) {
                IJoinNode t0 = a[i];
                IJoinNode t1 = a[j];
                TestStaticAnalysis_CanJoinUsingConstraints.assertTrue((boolean)sa.canJoin(t0, t1));
                TestStaticAnalysis_CanJoinUsingConstraints.assertTrue((boolean)sa.canJoin(t1, t0));
                if (t0 == t1) continue;
                TestStaticAnalysis_CanJoinUsingConstraints.assertTrue((boolean)sa.canJoinUsingConstraints(new IJoinNode[]{t0}, t1, new FilterNode[0]));
                TestStaticAnalysis_CanJoinUsingConstraints.assertTrue((boolean)sa.canJoinUsingConstraints(new IJoinNode[]{t1}, t0, new FilterNode[0]));
            }
        }
    }

    public void test_canJoinUsingConstraints_multiStep_productVar() {
        int index;
        BSBMQ5Setup s = new BSBMQ5Setup(this.store);
        StaticAnalysis sa = new StaticAnalysis(s.queryRoot);
        Random r = new Random();
        IJoinNode[] a = new IJoinNode[]{s.p0, s.p2, s.p4, s.p6};
        int existingPathLength = r.nextInt(3) + 1;
        IJoinNode[] path = new IJoinNode[existingPathLength];
        LinkedHashSet<Integer> used = new LinkedHashSet<Integer>();
        for (int i = 0; i < path.length; ++i) {
            int index2;
            while (used.contains(index2 = r.nextInt(a.length))) {
            }
            used.add(index2);
            path[i] = a[index2];
        }
        while (used.contains(index = r.nextInt(a.length))) {
        }
        used.add(index);
        IJoinNode vertex = a[index];
        for (int i = 0; i < path.length - 1; ++i) {
            TestStaticAnalysis_CanJoinUsingConstraints.assertTrue((boolean)sa.canJoin(path[i], path[i + 1]));
        }
        TestStaticAnalysis_CanJoinUsingConstraints.assertTrue((boolean)sa.canJoinUsingConstraints(path, vertex, new FilterNode[0]));
    }

    public void test_canJoinUsingConstraints_p3_p4() {
        BSBMQ5Setup s = new BSBMQ5Setup(this.store);
        StaticAnalysis sa = new StaticAnalysis(s.queryRoot);
        TestStaticAnalysis_CanJoinUsingConstraints.assertFalse((boolean)sa.canJoin((IJoinNode)s.p3, (IJoinNode)s.p4));
        TestStaticAnalysis_CanJoinUsingConstraints.assertFalse((boolean)sa.canJoin((IJoinNode)s.p4, (IJoinNode)s.p3));
        TestStaticAnalysis_CanJoinUsingConstraints.assertFalse((boolean)sa.canJoinUsingConstraints(new IJoinNode[]{s.p3}, (IJoinNode)s.p4, new FilterNode[0]));
        TestStaticAnalysis_CanJoinUsingConstraints.assertFalse((boolean)sa.canJoinUsingConstraints(new IJoinNode[]{s.p4}, (IJoinNode)s.p3, new FilterNode[0]));
        TestStaticAnalysis_CanJoinUsingConstraints.assertFalse((boolean)sa.canJoinUsingConstraints(new IJoinNode[]{s.p3}, (IJoinNode)s.p4, new FilterNode[]{s.c2}));
        TestStaticAnalysis_CanJoinUsingConstraints.assertFalse((boolean)sa.canJoinUsingConstraints(new IJoinNode[]{s.p4}, (IJoinNode)s.p3, new FilterNode[]{s.c2}));
        TestStaticAnalysis_CanJoinUsingConstraints.assertTrue((boolean)sa.canJoinUsingConstraints(new IJoinNode[]{s.p3}, (IJoinNode)s.p4, new FilterNode[]{s.c1}));
        TestStaticAnalysis_CanJoinUsingConstraints.assertTrue((boolean)sa.canJoinUsingConstraints(new IJoinNode[]{s.p4}, (IJoinNode)s.p3, new FilterNode[]{s.c1}));
    }

    public void test_canJoinUsingConstraints_p5_p6() {
        BSBMQ5Setup s = new BSBMQ5Setup(this.store);
        StaticAnalysis sa = new StaticAnalysis(s.queryRoot);
        TestStaticAnalysis_CanJoinUsingConstraints.assertFalse((boolean)sa.canJoin((IJoinNode)s.p5, (IJoinNode)s.p6));
        TestStaticAnalysis_CanJoinUsingConstraints.assertFalse((boolean)sa.canJoin((IJoinNode)s.p6, (IJoinNode)s.p5));
        TestStaticAnalysis_CanJoinUsingConstraints.assertFalse((boolean)sa.canJoinUsingConstraints(new IJoinNode[]{s.p5}, (IJoinNode)s.p6, new FilterNode[0]));
        TestStaticAnalysis_CanJoinUsingConstraints.assertFalse((boolean)sa.canJoinUsingConstraints(new IJoinNode[]{s.p6}, (IJoinNode)s.p5, new FilterNode[0]));
        TestStaticAnalysis_CanJoinUsingConstraints.assertFalse((boolean)sa.canJoinUsingConstraints(new IJoinNode[]{s.p5}, (IJoinNode)s.p6, new FilterNode[]{s.c1}));
        TestStaticAnalysis_CanJoinUsingConstraints.assertFalse((boolean)sa.canJoinUsingConstraints(new IJoinNode[]{s.p6}, (IJoinNode)s.p5, new FilterNode[]{s.c1}));
        TestStaticAnalysis_CanJoinUsingConstraints.assertTrue((boolean)sa.canJoinUsingConstraints(new IJoinNode[]{s.p5}, (IJoinNode)s.p6, new FilterNode[]{s.c2}));
        TestStaticAnalysis_CanJoinUsingConstraints.assertTrue((boolean)sa.canJoinUsingConstraints(new IJoinNode[]{s.p6}, (IJoinNode)s.p5, new FilterNode[]{s.c2}));
    }

    public void test_attachConstraints_BSBM_Q5_path01() {
        BSBMQ5Setup s = new BSBMQ5Setup(this.store);
        StaticAnalysis sa = new StaticAnalysis(s.queryRoot);
        IJoinNode[] path = new IJoinNode[]{s.p1, s.p2, s.p4, s.p6, s.p0, s.p3, s.p5};
        FilterNode[][] actual = sa.getJoinGraphConstraints(path, s.constraints, null, true);
        Set[] expected = new Set[]{s.NA, s.C0, s.NA, s.NA, s.NA, s.C1, s.C2};
        TestStaticAnalysis_CanJoinUsingConstraints.assertSameConstraints(expected, actual);
    }

    public void test_attachConstraints_BSBM_Q5_path02() {
        BSBMQ5Setup s = new BSBMQ5Setup(this.store);
        StaticAnalysis sa = new StaticAnalysis(s.queryRoot);
        IJoinNode[] path = new IJoinNode[]{s.p5, s.p3, s.p1, s.p0, s.p2, s.p4, s.p6};
        FilterNode[][] actual = sa.getJoinGraphConstraints(path, s.constraints, null, true);
        Set[] expected = new Set[]{s.NA, s.NA, s.NA, s.C0, s.NA, s.C1, s.C2};
        TestStaticAnalysis_CanJoinUsingConstraints.assertSameConstraints(expected, actual);
    }

    public void test_attachConstraints_BSBM_Q5_path03() {
        BSBMQ5Setup s = new BSBMQ5Setup(this.store);
        StaticAnalysis sa = new StaticAnalysis(s.queryRoot);
        IJoinNode[] path = new IJoinNode[]{s.p3, s.p4, s.p5, s.p6, s.p1, s.p2, s.p0};
        FilterNode[][] actual = sa.getJoinGraphConstraints(path, s.constraints, null, true);
        Set[] expected = new Set[]{s.NA, TestStaticAnalysis_CanJoinUsingConstraints.asSet(new FilterNode[]{s.c0, s.c1}), s.NA, s.C2, s.NA, s.NA, s.NA};
        TestStaticAnalysis_CanJoinUsingConstraints.assertSameConstraints(expected, actual);
    }

    public void test_attachConstraints_BSBM_Q5_path04() {
        BSBMQ5Setup s = new BSBMQ5Setup(this.store);
        StaticAnalysis sa = new StaticAnalysis(s.queryRoot);
        IJoinNode[] path = new IJoinNode[]{s.p5, s.p6, s.p0, s.p2, s.p1, s.p4, s.p3};
        FilterNode[][] actual = sa.getJoinGraphConstraints(path, s.constraints, null, true);
        Set[] expected = new Set[]{s.NA, TestStaticAnalysis_CanJoinUsingConstraints.asSet(new FilterNode[]{s.c0, s.c2}), s.NA, s.NA, s.NA, s.NA, s.C1};
        TestStaticAnalysis_CanJoinUsingConstraints.assertSameConstraints(expected, actual);
    }

    static void assertSameConstraints(Set<FilterNode>[] expected, FilterNode[][] actual) {
        TestStaticAnalysis_CanJoinUsingConstraints.assertEquals((String)"length", (int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Set<FilterNode> e = expected[i];
            Object[] a = actual[i];
            if (e.size() != a.length) {
                TestStaticAnalysis_CanJoinUsingConstraints.fail((String)("Differs at expected[" + i + "] : expecting " + e.size() + ", not " + a.length + " elements: " + Arrays.toString(a)));
            }
            for (int j = 0; j < a.length; ++j) {
                boolean foundRef = false;
                for (FilterNode t : e) {
                    if (t != a[j]) continue;
                    foundRef = true;
                    break;
                }
                if (foundRef) continue;
                TestStaticAnalysis_CanJoinUsingConstraints.fail((String)("Differs at expected[" + i + "][" + j + "] : actual=" + a[j]));
            }
        }
    }
}

