/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.cache;

import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.sparql.ast.cache.CacheConnectionFactory;
import com.bigdata.rdf.sparql.ast.cache.ICacheConnection;
import java.lang.ref.WeakReference;
import java.util.Properties;
import junit.framework.TestCase2;

public class TestCacheConnectionFactory
extends TestCase2 {
    public TestCacheConnectionFactory() {
    }

    public TestCacheConnectionFactory(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_basics() {
        Properties properties = new Properties();
        properties.setProperty(Journal.Options.BUFFER_MODE, BufferMode.Transient.toString());
        properties.setProperty(Journal.Options.INITIAL_EXTENT, "10485760");
        QueryEngine queryEngine = null;
        Journal jnl = new Journal(properties);
        try {
            queryEngine = QueryEngineFactory.getInstance().getQueryController((IIndexManager)jnl);
            TestCacheConnectionFactory.assertNotNull((Object)queryEngine);
            TestCacheConnectionFactory.assertNull((Object)CacheConnectionFactory.getExistingCacheConnection((QueryEngine)queryEngine));
            TestCacheConnectionFactory.assertNull((Object)CacheConnectionFactory.getExistingCacheConnection((QueryEngine)queryEngine));
            ICacheConnection cache = CacheConnectionFactory.getCacheConnection((QueryEngine)queryEngine);
            TestCacheConnectionFactory.assertTrue((cache == CacheConnectionFactory.getExistingCacheConnection((QueryEngine)queryEngine) ? 1 : 0) != 0);
        }
        finally {
            if (queryEngine != null) {
                queryEngine.shutdownNow();
            }
            jnl.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_memoryLeak() throws InterruptedException {
        Journal jnl;
        int i;
        WeakReference[] refs;
        block9: {
            int limit = 200;
            Properties properties = new Properties();
            properties.setProperty(Journal.Options.BUFFER_MODE, BufferMode.Transient.toString());
            properties.setProperty(Journal.Options.INITIAL_EXTENT, "10485760");
            int ncreated = 0;
            refs = new WeakReference[200];
            WeakReference[] refs2 = new WeakReference[200];
            try {
                try {
                    for (i = 0; i < 200; ++i) {
                        jnl = new Journal(properties);
                        refs[i] = new WeakReference<Journal>(jnl);
                        QueryEngine queryEngine = QueryEngineFactory.getInstance().getQueryController((IIndexManager)jnl);
                        refs2[i] = new WeakReference<QueryEngine>(queryEngine);
                        TestCacheConnectionFactory.assertNull((Object)CacheConnectionFactory.getExistingCacheConnection((QueryEngine)queryEngine));
                        TestCacheConnectionFactory.assertNull((Object)CacheConnectionFactory.getExistingCacheConnection((QueryEngine)queryEngine));
                        ICacheConnection cache = CacheConnectionFactory.getCacheConnection((QueryEngine)queryEngine);
                        TestCacheConnectionFactory.assertTrue((cache == CacheConnectionFactory.getExistingCacheConnection((QueryEngine)queryEngine) ? 1 : 0) != 0);
                        ++ncreated;
                    }
                }
                catch (OutOfMemoryError err) {
                    log.error((Object)("Out of memory after creating " + ncreated + " instances."));
                }
                System.gc();
                Thread.sleep(1000L);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Created " + ncreated + " instances."));
                }
                int nalive = CacheConnectionFactory.getCacheCount();
                if (log.isInfoEnabled()) {
                    log.info((Object)("There are " + nalive + " instances which are still alive."));
                }
                if (nalive != ncreated) break block9;
                TestCacheConnectionFactory.fail((String)"No instances were finalized.");
            }
            catch (Throwable throwable) {
                for (int i2 = 0; i2 < refs.length; ++i2) {
                    Journal jnl2;
                    Journal journal = jnl2 = refs[i2] == null ? null : (Journal)refs[i2].get();
                    if (jnl2 == null) continue;
                    jnl2.destroy();
                }
                throw throwable;
            }
        }
        for (i = 0; i < refs.length; ++i) {
            Journal journal = jnl = refs[i] == null ? null : (Journal)refs[i].get();
            if (jnl == null) continue;
            jnl.destroy();
        }
    }
}

