/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.engine.AbstractQueryEngineTestCase;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.io.IOException;
import java.io.InputStream;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.RDFHandlerBase;

public abstract class AbstractDataAndSPARQLTestCase
extends AbstractASTEvaluationTestCase {
    public AbstractDataAndSPARQLTestCase() {
    }

    public AbstractDataAndSPARQLTestCase(String name) {
        super(name);
    }

    public class AbsHelper {
        protected final String queryStr;
        protected ASTContainer astContainer;

        public AbsHelper(String queryStr) {
            this.queryStr = queryStr;
        }

        protected AbstractTripleStore getTripleStore() {
            return AbstractDataAndSPARQLTestCase.this.store;
        }

        protected void compareTupleQueryResults(TupleQueryResult queryResult, TupleQueryResult expectedResult, boolean checkOrder) throws QueryEvaluationException {
            AbstractQueryEngineTestCase.compareTupleQueryResults((String)AbstractDataAndSPARQLTestCase.this.getName(), (String)"", (AbstractTripleStore)AbstractDataAndSPARQLTestCase.this.store, (ASTContainer)this.astContainer, (TupleQueryResult)queryResult, (TupleQueryResult)expectedResult, (boolean)false, (boolean)checkOrder);
        }

        long loadData(InputStream is, RDFFormat format, String uri) {
            RDFParser rdfParser = ((RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format)).getParser();
            rdfParser.setValueFactory((ValueFactory)AbstractDataAndSPARQLTestCase.this.store.getValueFactory());
            rdfParser.setVerifyData(true);
            rdfParser.setStopAtFirstError(true);
            rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            AddStatementHandler handler = new AddStatementHandler();
            if (this.getTripleStore().isQuads()) {
                handler.setContext((Resource)new URIImpl(uri));
            }
            rdfParser.setRDFHandler((RDFHandler)handler);
            try {
                rdfParser.parse(is, AbstractDataAndSPARQLTestCase.this.baseURI);
                long l = handler.close();
                return l;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private class AddStatementHandler
        extends RDFHandlerBase {
            private final StatementBuffer<Statement> buffer;
            private Resource context = null;
            private long n = 0L;

            public AddStatementHandler() {
                this.buffer = new StatementBuffer(AbstractDataAndSPARQLTestCase.this.store, 1000);
            }

            public void setContext(Resource context) {
                this.context = context;
            }

            public void handleStatement(Statement stmt) throws RDFHandlerException {
                Resource s = stmt.getSubject();
                URI p = stmt.getPredicate();
                Value o = stmt.getObject();
                Resource c = stmt.getContext() == null ? this.context : stmt.getContext();
                this.buffer.add(s, p, o, c, StatementEnum.Explicit);
                ++this.n;
            }

            public long close() {
                this.buffer.flush();
                return this.n;
            }
        }
    }
}

