/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.engine.AbstractQueryEngineTestCase;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.journal.IBTreeManager;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.eval.ASTDeferredIVResolution;
import com.bigdata.rdf.sparql.ast.eval.ASTEvalHelper;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataAndSPARQLTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.dawg.DAWGTestResultSetUtil;
import org.openrdf.query.impl.TupleQueryResultBuilder;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.BooleanQueryResultParserRegistry;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.StatementCollector;

public abstract class AbstractDataDrivenSPARQLTestCase
extends AbstractDataAndSPARQLTestCase {
    private static final Logger log = Logger.getLogger(AbstractDataDrivenSPARQLTestCase.class);

    public AbstractDataDrivenSPARQLTestCase() {
    }

    public AbstractDataDrivenSPARQLTestCase(String name) {
        super(name);
    }

    private static InputStream getResourceAsStream(String resource) {
        File file;
        InputStream is = AbstractDataDrivenSPARQLTestCase.class.getResourceAsStream(resource);
        if (is == null) {
            is = AbstractDataDrivenSPARQLTestCase.class.getClassLoader().getResourceAsStream(resource);
        }
        if (is == null && (file = new File(resource)).exists()) {
            try {
                is = new FileInputStream(resource);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (is == null) {
            try {
                is = new URL(resource).openStream();
            }
            catch (MalformedURLException e) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (is == null) {
            throw new RuntimeException("Not found: " + resource);
        }
        if (resource.toLowerCase().endsWith(".gz")) {
            try {
                is = new GZIPInputStream(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (resource.toLowerCase().endsWith(".zip")) {
            is = new ZipInputStream(is);
        }
        return is;
    }

    private static String getResourceAsString(String resource) {
        StringBuilder sb = new StringBuilder();
        InputStream is = AbstractDataDrivenSPARQLTestCase.getResourceAsStream(resource);
        if (is == null) {
            throw new RuntimeException("Not found: " + resource);
        }
        try {
            String s;
            LineNumberReader r = new LineNumberReader(new InputStreamReader(is));
            while ((s = r.readLine()) != null) {
                sb.append(s);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class UpdateTestHelper
    extends AbstractDataAndSPARQLTestCase.AbsHelper {
        public ASTContainer getASTContainer() {
            return this.astContainer;
        }

        @Override
        public AbstractTripleStore getTripleStore() {
            return AbstractDataDrivenSPARQLTestCase.this.store;
        }

        public UpdateTestHelper(String testURI) throws Exception {
            this(testURI, testURI + ".rq", testURI + ".trig");
        }

        public UpdateTestHelper(String testURI, String queryFileURL, String dataFileURL) throws Exception {
            this(testURI, queryFileURL, new String[]{dataFileURL});
        }

        public UpdateTestHelper(String testURI, String queryFileURL, String[] dataFileURLs) throws Exception {
            super(AbstractDataDrivenSPARQLTestCase.this, AbstractDataDrivenSPARQLTestCase.getResourceAsString(queryFileURL));
            if (log.isInfoEnabled()) {
                log.info((Object)("\ntestURI:\n" + testURI));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("\nquery:\n" + this.queryStr));
            }
            if (dataFileURLs != null) {
                for (String dataFileURL : dataFileURLs) {
                    long nparsed = this.loadData(dataFileURL);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("\nLoaded " + nparsed + " statements from " + dataFileURL));
                }
            }
            String baseURI = "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/dataset/manifest#" + queryFileURL;
            Bigdata2ASTSPARQLParser parser = new Bigdata2ASTSPARQLParser();
            this.astContainer = parser.parseUpdate2(this.queryStr, baseURI);
            ASTDeferredIVResolution.resolveUpdate((AbstractTripleStore)AbstractDataDrivenSPARQLTestCase.this.store, (ASTContainer)this.astContainer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long loadData(String resource) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading " + resource));
            }
            String baseURL = new File(resource).toURI().toString();
            InputStream is = null;
            try {
                is = AbstractDataDrivenSPARQLTestCase.getResourceAsStream(resource);
                RDFFormat rdfFormat = RDFFormat.forFileName((String)resource);
                if (rdfFormat == null) {
                    throw new RuntimeException("Unknown format: resource=" + resource);
                }
                long l = this.loadData(is, rdfFormat, baseURL);
                return l;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Could not close: resource=" + resource), (Throwable)e);
                    }
                    is = null;
                }
            }
        }
    }

    public class TestHelper
    extends AbstractDataAndSPARQLTestCase.AbsHelper {
        private final String resultFileURL;
        private final boolean checkOrder;
        public Set<Statement> expectedGraphQueryResult;

        public ASTContainer getASTContainer() {
            return this.astContainer;
        }

        @Override
        public AbstractTripleStore getTripleStore() {
            return AbstractDataDrivenSPARQLTestCase.this.store;
        }

        public TestHelper(String testURI) throws Exception {
            this(testURI, testURI + ".rq", testURI + ".trig", testURI + ".srx");
        }

        public TestHelper(String testURI, String queryFileURL, String dataFileURL, String resultFileURL) throws Exception {
            this(testURI, queryFileURL, dataFileURL, resultFileURL, false);
        }

        public TestHelper(String testURI, String queryFileURL, String[] dataFileURLs, String resultFileURL) throws Exception {
            this(testURI, queryFileURL, dataFileURLs, resultFileURL, false);
        }

        public TestHelper(String testURI, String queryFileURL, String dataFileURL, String resultFileURL, boolean checkOrder) throws Exception {
            this(testURI, queryFileURL, new String[]{dataFileURL}, resultFileURL, checkOrder);
        }

        public TestHelper(String testURI, String queryFileURL, String[] dataFileURLs, String resultFileURL, boolean checkOrder) throws Exception {
            super(AbstractDataDrivenSPARQLTestCase.this, AbstractDataDrivenSPARQLTestCase.getResourceAsString(queryFileURL));
            this.expectedGraphQueryResult = null;
            if (log.isInfoEnabled()) {
                log.info((Object)("\ntestURI:\n" + testURI));
            }
            this.resultFileURL = resultFileURL;
            this.checkOrder = checkOrder;
            if (log.isInfoEnabled()) {
                log.info((Object)("\nquery:\n" + this.queryStr));
            }
            if (dataFileURLs != null) {
                for (String dataFileURL : dataFileURLs) {
                    long nparsed = this.loadData(dataFileURL);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("\nLoaded " + nparsed + " statements from " + dataFileURL));
                }
            }
            String baseURI = "http://www.w3.org/2001/sw/DataAccess/tests/data-r2/dataset/manifest#" + queryFileURL;
            this.astContainer = new Bigdata2ASTSPARQLParser().parseQuery2(this.queryStr, baseURI);
            QueryEngineFactory.getInstance().getQueryController((IIndexManager)((IBTreeManager)AbstractDataDrivenSPARQLTestCase.this.store.getIndexManager()));
        }

        public ASTContainer runTest() throws Exception {
            QueryRoot queryRoot = this.astContainer.getOriginalAST();
            switch (queryRoot.getQueryType()) {
                case SELECT: {
                    TupleQueryResult expectedResult = this.readExpectedTupleQueryResult();
                    TupleQueryResult queryResult = ASTEvalHelper.evaluateTupleQuery((AbstractTripleStore)AbstractDataDrivenSPARQLTestCase.this.store, (ASTContainer)this.astContainer, (QueryBindingSet)new QueryBindingSet(), null);
                    this.compareTupleQueryResults(queryResult, expectedResult);
                    break;
                }
                case DESCRIBE: 
                case CONSTRUCT: {
                    Set<Statement> expectedResult = this.readExpectedGraphQueryResult();
                    GraphQueryResult gqr = ASTEvalHelper.evaluateGraphQuery((AbstractTripleStore)AbstractDataDrivenSPARQLTestCase.this.store, (ASTContainer)this.astContainer, (QueryBindingSet)new QueryBindingSet(), null);
                    Set queryResult = Iterations.asSet((Iteration)gqr);
                    this.compareGraphs(queryResult, expectedResult);
                    break;
                }
                case ASK: {
                    boolean queryResult = ASTEvalHelper.evaluateBooleanQuery((AbstractTripleStore)AbstractDataDrivenSPARQLTestCase.this.store, (ASTContainer)this.astContainer, (BindingSet)new QueryBindingSet(), null);
                    boolean expectedResult = this.readExpectedBooleanQueryResult();
                    TestCase.assertEquals((boolean)expectedResult, (boolean)queryResult);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown query type: " + queryRoot.getQueryType());
                }
            }
            return this.astContainer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TupleQueryResult readExpectedTupleQueryResult() throws Exception {
            TupleQueryResultFormat tqrFormat = QueryResultIO.getParserFormatForFileName((String)this.resultFileURL);
            if (tqrFormat != null) {
                try (InputStream in = AbstractDataDrivenSPARQLTestCase.getResourceAsStream(this.resultFileURL);){
                    TupleQueryResultParser parser = QueryResultIO.createParser((TupleQueryResultFormat)tqrFormat);
                    parser.setValueFactory((ValueFactory)AbstractDataDrivenSPARQLTestCase.this.store.getValueFactory());
                    TupleQueryResultBuilder qrBuilder = new TupleQueryResultBuilder();
                    parser.setTupleQueryResultHandler((TupleQueryResultHandler)qrBuilder);
                    parser.parse(in);
                    TupleQueryResult tupleQueryResult = qrBuilder.getQueryResult();
                    return tupleQueryResult;
                }
            }
            Set<Statement> resultGraph = this.readExpectedGraphQueryResult();
            return DAWGTestResultSetUtil.toTupleQueryResult(resultGraph);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean readExpectedBooleanQueryResult() throws Exception {
            BooleanQueryResultFormat bqrFormat = (BooleanQueryResultFormat)BooleanQueryResultParserRegistry.getInstance().getFileFormatForFileName(this.resultFileURL);
            if (bqrFormat != null) {
                try (InputStream in = AbstractDataDrivenSPARQLTestCase.getResourceAsStream(this.resultFileURL);){
                    boolean bl = QueryResultIO.parse((InputStream)in, (BooleanQueryResultFormat)bqrFormat);
                    return bl;
                }
            }
            Set<Statement> resultGraph = this.readExpectedGraphQueryResult();
            return DAWGTestResultSetUtil.toBooleanQueryResult(resultGraph);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Statement> readExpectedGraphQueryResult() throws Exception {
            if (this.expectedGraphQueryResult != null) {
                return this.expectedGraphQueryResult;
            }
            RDFFormat rdfFormat = Rio.getParserFormatForFileName((String)this.resultFileURL);
            if (rdfFormat != null) {
                RDFParser parser = Rio.createParser((RDFFormat)rdfFormat);
                parser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
                parser.setPreserveBNodeIDs(true);
                parser.setValueFactory((ValueFactory)AbstractDataDrivenSPARQLTestCase.this.store.getValueFactory());
                LinkedHashSet<Statement> result = new LinkedHashSet<Statement>();
                parser.setRDFHandler((RDFHandler)new StatementCollector(result));
                try (InputStream in = AbstractDataDrivenSPARQLTestCase.getResourceAsStream(this.resultFileURL);){
                    parser.parse(in, this.resultFileURL);
                }
                this.expectedGraphQueryResult = result;
                return result;
            }
            throw new RuntimeException("Unable to determine file type of results file: " + this.resultFileURL);
        }

        private void compareTupleQueryResults(TupleQueryResult queryResult, TupleQueryResult expectedResult) throws QueryEvaluationException {
            this.compareTupleQueryResults(queryResult, expectedResult, this.checkOrder);
        }

        public void compareGraphs(Set<Statement> queryResult, Set<Statement> expectedResult) {
            AbstractQueryEngineTestCase.compareGraphs((String)AbstractDataDrivenSPARQLTestCase.this.getName(), queryResult, expectedResult);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long loadData(String resource) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading " + resource));
            }
            String baseURL = new File(resource).toURI().toString();
            InputStream is = null;
            try {
                is = AbstractDataDrivenSPARQLTestCase.getResourceAsStream(resource);
                RDFFormat rdfFormat = RDFFormat.forFileName((String)resource);
                if (rdfFormat == null) {
                    throw new RuntimeException("Unknown format: resource=" + resource);
                }
                long l = this.loadData(is, rdfFormat, baseURL);
                return l;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Could not close: resource=" + resource), (Throwable)e);
                    }
                    is = null;
                }
            }
        }
    }
}

