/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.eval.ASTEvalHelper;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataAndSPARQLTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.rio.RDFFormat;

public abstract class AbstractInlineSELECTTestCase
extends AbstractDataAndSPARQLTestCase {
    private static final Logger log = Logger.getLogger(AbstractInlineSELECTTestCase.class);
    private final Map<String, String> prefixes = new HashMap<String, String>();

    public AbstractInlineSELECTTestCase() {
    }

    public AbstractInlineSELECTTestCase(String name) {
        super(name);
        this.addPrefix("", "http://example.org/banana#");
        this.addPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.addPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.addPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
    }

    public void addPrefix(String prefix, String namespace) {
        this.prefixes.put(prefix, namespace);
    }

    protected abstract String trigData();

    public String sparqlPrefixes() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.prefixes.entrySet()) {
            sb.append("PREFIX ");
            sb.append(entry.getKey());
            sb.append(": <");
            sb.append(entry.getValue());
            sb.append(">\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public String ttlPrefixes() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.prefixes.entrySet()) {
            sb.append("@prefix ");
            sb.append(entry.getKey());
            sb.append(": <");
            sb.append(entry.getValue());
            sb.append(">.\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public class Execute
    extends AbstractDataAndSPARQLTestCase.AbsHelper {
        private static final String FILL_IN_URI = "http://please-do-not-user-relative-uris/";

        private TupleQueryResult executeSelect(String sparql) throws QueryEvaluationException, MalformedQueryException {
            String prefixes = AbstractInlineSELECTTestCase.this.sparqlPrefixes();
            this.astContainer = new Bigdata2ASTSPARQLParser().parseQuery2(prefixes + sparql, FILL_IN_URI);
            return ASTEvalHelper.evaluateTupleQuery((AbstractTripleStore)AbstractInlineSELECTTestCase.this.store, (ASTContainer)this.astContainer, (QueryBindingSet)new QueryBindingSet(), null);
        }

        public Execute(String queryStr) throws Exception {
            super(AbstractInlineSELECTTestCase.this, queryStr);
            if (log.isInfoEnabled()) {
                log.info((Object)("\nquery:\n" + queryStr));
            }
        }

        private long loadData(String data) throws UnsupportedEncodingException {
            if (data == null || data.length() == 0) {
                return 0L;
            }
            data = AbstractInlineSELECTTestCase.this.ttlPrefixes() + data;
            byte[] utf8Data = data.getBytes("utf-8");
            ByteArrayInputStream is = new ByteArrayInputStream(utf8Data);
            String uri = FILL_IN_URI;
            RDFFormat format = RDFFormat.TRIG;
            return this.loadData(is, format, uri);
        }

        public void expectResultSet(String vars, String ... bindings) throws Exception {
            TupleQueryResult expectedResult = this.expectedTupleQueryResult(vars, bindings);
            this.loadData(this.trigData());
            TupleQueryResult queryResult = this.executeSelect(this.queryStr);
            this.compareTupleQueryResults(queryResult, expectedResult, false);
        }

        private TupleQueryResult expectedTupleQueryResult(String vars, String ... bindings) throws QueryEvaluationException, MalformedQueryException {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ");
            sb.append(vars);
            sb.append("\n{} BINDINGS ");
            sb.append(vars);
            sb.append("{\n");
            for (String binding : bindings) {
                sb.append(" ( ");
                sb.append(binding);
                sb.append(" )\n");
            }
            sb.append("}\n");
            return this.executeSelect(sb.toString());
        }

        protected String trigData() {
            return AbstractInlineSELECTTestCase.this.trigData();
        }
    }
}

