/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import junit.framework.TestCase;

public class TestBlockingBufferPerformance740
extends AbstractDataDrivenSPARQLTestCase {
    public TestBlockingBufferPerformance740() {
    }

    public TestBlockingBufferPerformance740(String name) {
        super(name);
    }

    public void test_ticket_740() throws Exception {
        new AbstractDataDrivenSPARQLTestCase.TestHelper("blocking-buffer-740", "blocking-buffer-740.rq", "blocking-buffer-740.rdf", "blocking-buffer-740.srx"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ASTContainer runTest() throws Exception {
                ASTContainer aSTContainer;
                ThreadMXBean mgmt = ManagementFactory.getThreadMXBean();
                long startCpuTime = this.currentTotalCpuTime(mgmt);
                long startWallClock = System.currentTimeMillis();
                try {
                    aSTContainer = super.runTest();
                    long cpuTime = this.currentTotalCpuTime(mgmt) - startCpuTime;
                }
                catch (Throwable throwable) {
                    long cpuTime = this.currentTotalCpuTime(mgmt) - startCpuTime;
                    long clockTime = System.currentTimeMillis() - startWallClock;
                    double utilization = (double)(cpuTime /= 1000000L) * 1.0 / (double)clockTime;
                    TestCase.assertTrue((String)("Performance was poor: " + (int)(utilization * 100.0) + "% [< 80%]"), (utilization > 0.8 ? 1 : 0) != 0);
                    System.out.println("BlockingBuffer: performance was good: " + (int)(utilization * 100.0) + "%");
                    throw throwable;
                }
                long clockTime = System.currentTimeMillis() - startWallClock;
                double utilization = (double)(cpuTime /= 1000000L) * 1.0 / (double)clockTime;
                TestCase.assertTrue((String)("Performance was poor: " + (int)(utilization * 100.0) + "% [< 80%]"), (utilization > 0.8 ? 1 : 0) != 0);
                System.out.println("BlockingBuffer: performance was good: " + (int)(utilization * 100.0) + "%");
                return aSTContainer;
            }

            private long currentTotalCpuTime(ThreadMXBean mgmt) {
                long rslt = 0L;
                for (long tid : mgmt.getAllThreadIds()) {
                    long t = mgmt.getThreadCpuTime(tid);
                    if (t == -1L) continue;
                    rslt += t;
                }
                return rslt;
            }
        }.runTest();
    }
}

