/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.ConstructNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.eval.ASTConstructIterator;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import java.util.LinkedList;
import java.util.List;

public class TestConstruct
extends AbstractDataDrivenSPARQLTestCase {
    public TestConstruct() {
    }

    public TestConstruct(String name) {
        super(name);
    }

    public void test_construct_1() throws Exception {
        ASTContainer ast = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "construct-1", "construct-1.rq", "construct-1.trig", "construct-1-result.trig").runTest();
        ConstructNode construct = ast.getOptimizedAST().getConstruct();
        TestConstruct.assertNotNull((Object)construct);
        TestConstruct.assertFalse((boolean)construct.isNativeDistinct());
    }

    public void test_construct_1a() throws Exception {
        ASTContainer ast = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "construct-1", "construct-1a.rq", "construct-1.trig", "construct-1-result.trig").runTest();
        ConstructNode construct = ast.getOptimizedAST().getConstruct();
        TestConstruct.assertNotNull((Object)construct);
        TestConstruct.assertTrue((boolean)construct.isNativeDistinct());
    }

    public void test_construct_1b() throws Exception {
        ASTContainer ast = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "construct-1", "construct-1b.rq", "construct-1.trig", "construct-1-result.trig").runTest();
        ConstructNode construct = ast.getOptimizedAST().getConstruct();
        TestConstruct.assertNotNull((Object)construct);
        TestConstruct.assertTrue((boolean)construct.isNativeDistinct());
    }

    public void test_construct_2() throws Exception {
        new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "construct-2", "construct-2.rq", "construct-2.trig", "construct-2-result.trig").runTest();
    }

    public void test_construct_3() throws Exception {
        new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "construct-3", "construct-3.rq", "construct-3.trig", "construct-3-result.trig").runTest();
    }

    public void test_construct_without_where_clause() throws Exception {
        new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "construct-without-where-clause", "construct-without-where-clause.rq", "construct-without-where-clause.trig", "construct-without-where-clause-result.trig").runTest();
    }

    public void test_construct_5() throws Exception {
        new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "construct-5", "construct-5.rq", "construct-5.trig", "construct-5-result.trig").runTest();
    }

    private static List<StatementPatternNode> getConstructTemplates(QueryRoot queryRoot) {
        LinkedList<StatementPatternNode> templates = new LinkedList<StatementPatternNode>();
        ConstructNode construct = queryRoot.getConstruct();
        for (StatementPatternNode pat : construct) {
            if (pat.isGround()) continue;
            templates.add(pat);
        }
        return templates;
    }

    public void test_isObviouslyDistinct_01() throws Exception {
        ASTContainer ast = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "construct-isObviouslyDistinct-01", "construct-isObviouslyDistinct-01.rq", "construct-isObviouslyDistinct-01.trig", "construct-isObviouslyDistinct-01-result.trig").runTest();
        QueryRoot optimizedQuery = ast.getOptimizedAST();
        TestConstruct.assertTrue((boolean)ASTConstructIterator.isObviouslyDistinct((boolean)this.store.isQuads(), TestConstruct.getConstructTemplates(optimizedQuery), (GraphPatternGroup)optimizedQuery.getWhereClause()));
    }

    public void test_isObviouslyDistinct_02() throws Exception {
        ASTContainer ast = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "construct-isObviouslyDistinct-02", "construct-isObviouslyDistinct-02.rq", "construct-isObviouslyDistinct-02.trig", "construct-isObviouslyDistinct-02-result.trig").runTest();
        QueryRoot optimizedQuery = ast.getOptimizedAST();
        TestConstruct.assertTrue((boolean)ASTConstructIterator.isObviouslyDistinct((boolean)this.store.isQuads(), TestConstruct.getConstructTemplates(optimizedQuery), (GraphPatternGroup)optimizedQuery.getWhereClause()));
    }

    public void test_isObviouslyDistinct_03() throws Exception {
        ASTContainer ast = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "construct-isObviouslyDistinct-03", "construct-isObviouslyDistinct-03.rq", "construct-isObviouslyDistinct-03.trig", "construct-isObviouslyDistinct-03-result.trig").runTest();
        QueryRoot optimizedQuery = ast.getOptimizedAST();
        TestConstruct.assertFalse((boolean)ASTConstructIterator.isObviouslyDistinct((boolean)this.store.isQuads(), TestConstruct.getConstructTemplates(optimizedQuery), (GraphPatternGroup)optimizedQuery.getWhereClause()));
    }

    public void test_isObviouslyDistinct_04() throws Exception {
        ASTContainer ast = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "construct-isObviouslyDistinct-04", "construct-isObviouslyDistinct-04.rq", "construct-isObviouslyDistinct-04.trig", "construct-isObviouslyDistinct-04-result.trig").runTest();
        QueryRoot optimizedQuery = ast.getOptimizedAST();
        TestConstruct.assertTrue((boolean)ASTConstructIterator.isObviouslyDistinct((boolean)this.store.isQuads(), TestConstruct.getConstructTemplates(optimizedQuery), (GraphPatternGroup)optimizedQuery.getWhereClause()));
    }

    public void test_isObviouslyDistinct_05() throws Exception {
        ASTContainer ast = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "construct-isObviouslyDistinct-05", "construct-isObviouslyDistinct-05.rq", "construct-isObviouslyDistinct-05.trig", "construct-isObviouslyDistinct-05-result.trig").runTest();
        QueryRoot optimizedQuery = ast.getOptimizedAST();
        TestConstruct.assertTrue((boolean)ASTConstructIterator.isObviouslyDistinct((boolean)this.store.isQuads(), TestConstruct.getConstructTemplates(optimizedQuery), (GraphPatternGroup)optimizedQuery.getWhereClause()));
    }
}

