/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.constraints.XSDBooleanIVValueExpression;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;

public class TestCustomFunction
extends AbstractDataDrivenSPARQLTestCase {
    public TestCustomFunction() {
    }

    public TestCustomFunction(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_custom_function_1() throws Exception {
        URIImpl myFunctionUri = new URIImpl("http://www.bigdata.com/myFunction");
        FunctionRegistry.Factory myFactory = new FunctionRegistry.Factory(){

            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs((ValueExpressionNode[])args, (Class[])new Class[]{ValueExpressionNode.class});
                IValueExpression ve = AST2BOpUtility.toVE((BOpContextBase)context, (GlobalAnnotations)globals, (IValueExpressionNode)args[0]);
                return new MyFunctionBOp((IValueExpression<? extends IV>)ve, globals);
            }
        };
        FunctionRegistry.add((URI)myFunctionUri, (FunctionRegistry.Factory)myFactory);
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper("custom-function-1").runTest();
        }
        finally {
            FunctionRegistry.remove((URI)myFunctionUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_custom_function_2() throws Exception {
        URIImpl myFunctionUri = new URIImpl("http://www.bigdata.com/myFunction2");
        MyFilterFactory myFactory = new MyFilterFactory();
        FunctionRegistry.add((URI)myFunctionUri, (FunctionRegistry.Factory)myFactory);
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper("custom-function-2").runTest();
        }
        finally {
            FunctionRegistry.remove((URI)myFunctionUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_custom_function_3() throws Exception {
        URIImpl myFunctionUri = new URIImpl("http://www.bigdata.com/myFunction");
        MyFunctionFactory myFactory = new MyFunctionFactory();
        FunctionRegistry.add((URI)myFunctionUri, (FunctionRegistry.Factory)myFactory);
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper("custom-function-3").runTest();
        }
        finally {
            FunctionRegistry.remove((URI)myFunctionUri);
        }
    }

    private static class MyFilterBOp
    extends XSDBooleanIVValueExpression
    implements INeedsMaterialization {
        private static final long serialVersionUID = 1L;

        public MyFilterBOp(MyFilterBOp op) {
            super((XSDBooleanIVValueExpression)op);
        }

        public MyFilterBOp(BOp[] args, Map<String, Object> anns) {
            super(args, anns);
        }

        public MyFilterBOp(IValueExpression<? extends IV> x) {
            this(new BOp[]{x}, BOp.NOANNS);
        }

        protected boolean accept(IBindingSet bset) {
            IV arg0 = (IV)this.get(0).get(bset);
            if (arg0 == null || !arg0.isLiteral()) {
                throw new SparqlTypeErrorException();
            }
            Literal lit = MyFilterBOp.asLiteral((IV)arg0);
            return lit.getLabel().equals("Mike");
        }

        public INeedsMaterialization.Requirement getRequirement() {
            return INeedsMaterialization.Requirement.SOMETIMES;
        }
    }

    private static class MyFilterFactory
    implements FunctionRegistry.Factory {
        private MyFilterFactory() {
        }

        public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
            FunctionRegistry.checkArgs((ValueExpressionNode[])args, (Class[])new Class[]{ValueExpressionNode.class});
            IValueExpression ve = AST2BOpUtility.toVE((BOpContextBase)context, (GlobalAnnotations)globals, (IValueExpressionNode)args[0]);
            return new MyFilterBOp((IValueExpression<? extends IV>)ve);
        }
    }

    private static class MyFunctionBOp
    extends IVValueExpression<IV>
    implements INeedsMaterialization {
        private static final long serialVersionUID = 1L;

        public MyFunctionBOp(MyFunctionBOp op) {
            super((IVValueExpression)op);
        }

        public MyFunctionBOp(BOp[] args, Map<String, Object> anns) {
            super(args, anns);
        }

        public MyFunctionBOp(IValueExpression<? extends IV> x, GlobalAnnotations globals) {
            super(x, globals, new NV[0]);
        }

        public IV get(IBindingSet bset) {
            IV arg = this.getAndCheckLiteral(0, bset);
            Literal lit = MyFunctionBOp.asLiteral((IV)arg);
            LiteralImpl lit2 = new LiteralImpl(lit.getLabel() + "-" + lit.getLabel());
            IV ret = this.asIV((Value)lit2, bset);
            return ret;
        }

        public INeedsMaterialization.Requirement getRequirement() {
            return INeedsMaterialization.Requirement.SOMETIMES;
        }
    }

    private static class MyFunctionFactory
    implements FunctionRegistry.Factory {
        private MyFunctionFactory() {
        }

        public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
            FunctionRegistry.checkArgs((ValueExpressionNode[])args, (Class[])new Class[]{ValueExpressionNode.class});
            IValueExpression ve = AST2BOpUtility.toVE((BOpContextBase)context, (GlobalAnnotations)globals, (IValueExpressionNode)args[0]);
            return new MyFunctionBOp((IValueExpression<? extends IV>)ve, globals);
        }
    }
}

