/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.DescribeModeEnum;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.cache.IDescribeCache;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.decls.FOAFVocabularyDecl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class TestDescribe
extends AbstractDataDrivenSPARQLTestCase {
    public TestDescribe() {
    }

    public TestDescribe(String name) {
        super(name);
    }

    protected IDescribeCache getDescribeCache(ASTContainer astContainer, AbstractTripleStore store) {
        AST2BOpContext context = new AST2BOpContext(astContainer, store);
        IDescribeCache describeCache = context.describeCache != null && astContainer.getOriginalAST().getQueryType() == QueryType.DESCRIBE ? context.getDescribeCache() : null;
        return describeCache;
    }

    protected Set<Statement> getExpectedDescription(BigdataValue resource, AbstractDataDrivenSPARQLTestCase.TestHelper h) {
        Set<Statement> expectedStatements = h.expectedGraphQueryResult;
        HashSet<Statement> graph = new HashSet<Statement>();
        for (Statement stmt : expectedStatements) {
            if (stmt.getSubject().equals(resource)) {
                graph.add(stmt);
                continue;
            }
            if (!stmt.getObject().equals(resource)) continue;
            graph.add(stmt);
        }
        return graph.isEmpty() ? null : graph;
    }

    private void assertDescribedResource(BigdataValue describedResource, IDescribeCache describeCache, AbstractDataDrivenSPARQLTestCase.TestHelper h) {
        Graph actualGraph = describeCache.lookup(describedResource.getIV());
        TestDescribe.assertNotNull((Object)actualGraph);
        Set<Statement> expectedGraph = this.getExpectedDescription(describedResource, h);
        h.compareGraphs(new HashSet<Statement>((Collection<Statement>)actualGraph), expectedGraph);
        for (Statement stmt : actualGraph) {
            TestDescribe.assertTrue((boolean)(stmt instanceof BigdataStatement));
            BigdataStatement st = (BigdataStatement)stmt;
            TestDescribe.assertNotNull((Object)st.s());
            TestDescribe.assertNotNull((Object)st.p());
            TestDescribe.assertNotNull((Object)st.o());
            if (st.getContext() == null) continue;
            TestDescribe.assertNotNull((Object)st.c());
        }
    }

    public void test_describe_1() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "describe-1", "describe-1.rq", "describe-1.trig", "describe-1-result.trig");
        TestDescribe.assertEquals((Object)QueryType.DESCRIBE, (Object)h.getASTContainer().getOriginalAST().getQueryType());
        IDescribeCache describeCache = this.getDescribeCache(h.getASTContainer(), h.getTripleStore());
        BigdataValueFactory f = h.getTripleStore().getValueFactory();
        BigdataURI dc = f.createURI("http://www.bigdata.com/DC");
        BigdataValue[] values = new BigdataValue[]{dc};
        h.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        if (describeCache != null) {
            for (BigdataValue v : values) {
                TestDescribe.assertNull((Object)describeCache.lookup(v.getIV()));
            }
        }
        h.runTest();
        if (describeCache != null) {
            for (BigdataValue v : values) {
                this.assertDescribedResource(v, describeCache, h);
            }
        }
        TestDescribe.assertEquals((Object)QueryType.DESCRIBE, (Object)h.getASTContainer().getOriginalAST().getQueryType());
        TestDescribe.assertEquals((Object)QueryType.CONSTRUCT, (Object)h.getASTContainer().getOptimizedAST().getQueryType());
        TestDescribe.assertNull((Object)h.getASTContainer().getOptimizedAST().getProjection().getDescribeMode());
    }

    public void test_describe_2() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "describe-2", "describe-2.rq", "describe-2.trig", "describe-2-result.trig");
        IDescribeCache describeCache = this.getDescribeCache(h.getASTContainer(), h.getTripleStore());
        BigdataValueFactory f = h.getTripleStore().getValueFactory();
        BigdataURI mike = f.createURI("http://www.bigdata.com/Mike");
        BigdataURI bryan = f.createURI("http://www.bigdata.com/Bryan");
        BigdataValue[] values = new BigdataValue[]{mike, bryan};
        h.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        if (describeCache != null) {
            for (BigdataValue v : values) {
                TestDescribe.assertNull((Object)describeCache.lookup(v.getIV()));
            }
        }
        h.runTest();
        if (describeCache != null) {
            for (BigdataValue v : values) {
                this.assertDescribedResource(v, describeCache, h);
            }
        }
    }

    public void test_describe_3() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "describe-3", "describe-3.rq", "describe-3.trig", "describe-3-result.trig");
        IDescribeCache describeCache = this.getDescribeCache(h.getASTContainer(), h.getTripleStore());
        BigdataValueFactory f = h.getTripleStore().getValueFactory();
        BigdataURI dc = f.createURI("http://www.bigdata.com/DC");
        BigdataURI mike = f.createURI("http://www.bigdata.com/Mike");
        BigdataURI bryan = f.createURI("http://www.bigdata.com/Bryan");
        BigdataValue[] values = new BigdataValue[]{dc, mike, bryan};
        h.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        if (describeCache != null) {
            for (BigdataValue v : values) {
                TestDescribe.assertNull((Object)describeCache.lookup(v.getIV()));
            }
        }
        h.runTest();
        if (describeCache != null) {
            for (BigdataValue v : values) {
                this.assertDescribedResource(v, describeCache, h);
            }
        }
    }

    public void test_describe_4() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "describe-4", "describe-4.rq", "describe-4.trig", "describe-4-result.trig");
        IDescribeCache describeCache = this.getDescribeCache(h.getASTContainer(), h.getTripleStore());
        BigdataValueFactory f = h.getTripleStore().getValueFactory();
        BigdataURI mike = f.createURI("http://www.bigdata.com/mike");
        BigdataValue[] values = new BigdataValue[]{mike};
        h.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        if (describeCache != null) {
            for (BigdataValue v : values) {
                TestDescribe.assertNull((Object)describeCache.lookup(v.getIV()));
            }
        }
        h.runTest();
        if (describeCache != null) {
            for (BigdataValue v : values) {
                this.assertDescribedResource(v, describeCache, h);
            }
        }
    }

    public void test_describe_5() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "describe-5", "describe-5.rq", "describe-5.trig", "describe-5-result.trig");
        IDescribeCache describeCache = this.getDescribeCache(h.getASTContainer(), h.getTripleStore());
        BigdataValueFactory f = h.getTripleStore().getValueFactory();
        BigdataURI mike = f.createURI("http://www.bigdata.com/mike");
        BigdataURI rdf = f.createURI("http://www.bigdata.com/rdf");
        BigdataValue[] values = new BigdataValue[]{mike, rdf};
        h.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        if (describeCache != null) {
            for (BigdataValue v : values) {
                TestDescribe.assertNull((Object)describeCache.lookup(v.getIV()));
            }
        }
        h.runTest();
        if (describeCache != null) {
            for (BigdataValue v : values) {
                this.assertDescribedResource(v, describeCache, h);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_describe_1_invalidation() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "describe-1", "describe-1.rq", "describe-1.trig", "describe-1-result.trig");
        IDescribeCache describeCache = this.getDescribeCache(h.getASTContainer(), h.getTripleStore());
        BigdataValueFactory f = h.getTripleStore().getValueFactory();
        BigdataURI dc = f.createURI("http://www.bigdata.com/DC");
        BigdataURI foafPerson = f.asValue(FOAFVocabularyDecl.Person);
        BigdataURI rdfType = f.asValue(RDF.TYPE);
        BigdataValue[] values = new BigdataValue[]{dc, foafPerson, rdfType};
        h.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        for (BigdataValue v : values) {
            TestDescribe.assertNotNull((String)v.toString(), (Object)v.getIV());
        }
        if (describeCache != null) {
            for (BigdataValue v : values) {
                TestDescribe.assertNull((Object)describeCache.lookup(v.getIV()));
            }
        }
        h.runTest();
        if (describeCache != null) {
            this.assertDescribedResource((BigdataValue)dc, describeCache, h);
            BigdataSail sail = new BigdataSail(h.getTripleStore());
            try {
                sail.initialize();
                try (BigdataSail.BigdataSailConnection conn = sail.getConnection();){
                    conn.addStatement((Resource)dc, (URI)rdfType, (Value)foafPerson, new Resource[0]);
                    conn.commit();
                }
            }
            finally {
                sail.shutDown();
            }
            TestDescribe.assertNull((Object)describeCache.lookup(dc.getIV()));
        }
    }

    public void test_describe_SymmetricOneStep_1() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "describe-SymmetricOneStep-1", "describe-SymmetricOneStep-1.rq", "describe-SymmetricOneStep-1.trig", "describe-SymmetricOneStep-1-result.trig");
        TestDescribe.assertEquals((Object)QueryType.DESCRIBE, (Object)h.getASTContainer().getOriginalAST().getQueryType());
        IDescribeCache describeCache = this.getDescribeCache(h.getASTContainer(), h.getTripleStore());
        BigdataValueFactory f = h.getTripleStore().getValueFactory();
        BigdataURI dc = f.createURI("http://www.bigdata.com/DC");
        BigdataValue[] values = new BigdataValue[]{dc};
        h.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        if (describeCache != null) {
            for (BigdataValue v : values) {
                TestDescribe.assertNull((Object)describeCache.lookup(v.getIV()));
            }
        }
        h.runTest();
        if (describeCache != null) {
            for (BigdataValue v : values) {
                this.assertDescribedResource(v, describeCache, h);
            }
        }
        TestDescribe.assertEquals((Object)QueryType.DESCRIBE, (Object)h.getASTContainer().getOriginalAST().getQueryType());
        TestDescribe.assertEquals((Object)QueryType.CONSTRUCT, (Object)h.getASTContainer().getOptimizedAST().getQueryType());
        TestDescribe.assertEquals((Object)DescribeModeEnum.SymmetricOneStep, (Object)h.getASTContainer().getOptimizedAST().getProjection().getDescribeMode());
    }

    public void test_describe_ForwardOneStep_1() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "describe-ForwardOneStep-1", "describe-ForwardOneStep-1.rq", "describe-ForwardOneStep-1.trig", "describe-ForwardOneStep-1-result.trig");
        TestDescribe.assertEquals((Object)QueryType.DESCRIBE, (Object)h.getASTContainer().getOriginalAST().getQueryType());
        IDescribeCache describeCache = this.getDescribeCache(h.getASTContainer(), h.getTripleStore());
        BigdataValueFactory f = h.getTripleStore().getValueFactory();
        BigdataURI dc = f.createURI("http://www.bigdata.com/DC");
        BigdataValue[] values = new BigdataValue[]{dc};
        h.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        if (describeCache != null) {
            for (BigdataValue v : values) {
                TestDescribe.assertNull((Object)describeCache.lookup(v.getIV()));
            }
        }
        h.runTest();
        if (describeCache != null) {
            for (BigdataValue v : values) {
                this.assertDescribedResource(v, describeCache, h);
            }
        }
        TestDescribe.assertEquals((Object)QueryType.DESCRIBE, (Object)h.getASTContainer().getOriginalAST().getQueryType());
        TestDescribe.assertEquals((Object)QueryType.CONSTRUCT, (Object)h.getASTContainer().getOptimizedAST().getQueryType());
        TestDescribe.assertEquals((Object)DescribeModeEnum.ForwardOneStep, (Object)h.getASTContainer().getOptimizedAST().getProjection().getDescribeMode());
    }

    public void test_describe_CBD_1() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "describe-CBD-1", "describe-CBD-1.rq", "describe-CBD-1.rdf", "describe-CBD-1-result.rdf");
        TestDescribe.assertEquals((Object)QueryType.DESCRIBE, (Object)h.getASTContainer().getOriginalAST().getQueryType());
        h.runTest();
        TestDescribe.assertEquals((Object)DescribeModeEnum.CBD, (Object)h.getASTContainer().getOptimizedAST().getProjection().getDescribeMode());
    }

    public void test_describe_SCBD_1() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "describe-SCBD-1", "describe-SCBD-1.rq", "describe-SCBD-1.rdf", "describe-SCBD-1-result.rdf");
        TestDescribe.assertEquals((Object)QueryType.DESCRIBE, (Object)h.getASTContainer().getOriginalAST().getQueryType());
        h.runTest();
        TestDescribe.assertEquals((Object)DescribeModeEnum.SCBD, (Object)h.getASTContainer().getOptimizedAST().getProjection().getDescribeMode());
    }
}

