/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.join.DistinctTermScanOp;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestDistinctTermScanOptimizer
extends AbstractDataDrivenSPARQLTestCase {
    public TestDistinctTermScanOptimizer() {
    }

    public TestDistinctTermScanOptimizer(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TestDistinctTermScanOptimizer.class.getSimpleName());
        suite.addTestSuite(TestQuadsModeAPs.class);
        suite.addTestSuite(TestTriplesModeAPs.class);
        return suite;
    }

    public static class TestQuadsModeAPs
    extends TestDistinctTermScanOptimizer {
        public void test_distinctTermScan_quads_01() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "distinctTermScan_quads_01", "distinctTermScan_quads_01.rq", "distinctTermScan_quads_01.trig", "distinctTermScan_quads_01.srx");
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
        }

        public void test_distinctTermScan_quads_01b() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "distinctTermScan_quads_01b", "distinctTermScan_quads_01b.rq", "distinctTermScan_quads_01.trig", "distinctTermScan_quads_01b.srx");
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
        }

        public void test_distinctTermScan_quads_01c() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "distinctTermScan_quads_01c", "distinctTermScan_quads_01c.rq", "distinctTermScan_quads_01.trig", "distinctTermScan_quads_01c.srx");
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
        }

        public void test_distinctTermScan_quads_02() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "distinctTermScan_quads_02", "distinctTermScan_quads_02.rq", "distinctTermScan_quads_01.trig", "distinctTermScan_quads_02.srx");
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
        }

        public void test_distinctTermScan_quads_correctRejection_01() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "distinctTermScan_quads_correctRejection_01", "distinctTermScan_quads_correctRejection_01.rq", "distinctTermScan_quads_01.trig", "distinctTermScan_quads_correctRejection_01.srx");
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)0, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
        }

        public void test_distinctTermScan_quads_correctRejection_02() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "distinctTermScan_quads_correctRejection_02", "distinctTermScan_quads_correctRejection_02.rq", "distinctTermScan_quads_01.trig", "distinctTermScan_quads_correctRejection_02.srx");
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
        }
    }

    public static class TestTriplesModeAPs
    extends TestDistinctTermScanOptimizer {
        @Override
        public Properties getProperties() {
            Properties properties = new Properties(super.getProperties());
            properties.setProperty(AbstractTripleStore.Options.QUADS, "false");
            properties.setProperty(AbstractTripleStore.Options.TRIPLES_MODE, "true");
            return properties;
        }

        public void test_distinctTermScan_triples_01() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "distinctTermScan_triples_01", "distinctTermScan_triples_01.rq", "distinctTermScan_triples_01.ttl", "distinctTermScan_triples_01.srx");
            h.runTest();
            TestTriplesModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
        }

        public void test_distinctTermScan_triples_02() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "distinctTermScan_triples_02", "distinctTermScan_triples_02.rq", "distinctTermScan_triples_01.ttl", "distinctTermScan_triples_02.srx");
            h.runTest();
            TestTriplesModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
        }

        public void test_distinctTermScan_triples_03() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "distinctTermScan_triples_03", "distinctTermScan_triples_03.rq", "distinctTermScan_triples_01.ttl", "distinctTermScan_triples_03.srx");
            h.runTest();
            TestTriplesModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
        }

        public void test_distinctTermScan_triples_correctRejection_01() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "distinctTermScan_triples_correctRejection_01", "distinctTermScan_triples_correctRejection_01.rq", "distinctTermScan_triples_correctRejection_01.ttl", "distinctTermScan_triples_correctRejection_01.srx");
            h.runTest();
            TestTriplesModeAPs.assertEquals((int)0, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
        }

        public void test_distinctTermScan_triples_subQuery_01() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "distinctTermScan_triples_subQuery_01", "distinctTermScan_triples_subQuery_01.rq", "distinctTermScan_triples_01.ttl", "distinctTermScan_triples_subQuery_01.srx");
            h.runTest();
            TestTriplesModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
            TestTriplesModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getOptimizedAST(), NamedSubqueryInclude.class).size());
        }
    }
}

