/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.join.FastRangeCountOp;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import com.bigdata.rdf.sparql.ast.eval.TestDistinctTermScanOptimizer;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestFastRangeCountOptimizer
extends AbstractDataDrivenSPARQLTestCase {
    public TestFastRangeCountOptimizer() {
    }

    public TestFastRangeCountOptimizer(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TestFastRangeCountOptimizer.class.getSimpleName());
        suite.addTestSuite(TestQuadsModeAPs.class);
        suite.addTestSuite(TestTriplesModeAPs.class);
        return suite;
    }

    public static class TestQuadsModeAPs
    extends TestFastRangeCountOptimizer {
        public void test_fastRangeCount_quads_01() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "fastRangeCount_quads_01", "fastRangeCount_quads_01.rq", "fastRangeCount_quads_01.trig", "fastRangeCount_quads_01.srx");
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }

        public void test_fastRangeCount_quads_02() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "fastRangeCount_quads_02", "fastRangeCount_quads_02.rq", "fastRangeCount_quads_01.trig", "fastRangeCount_quads_02.srx");
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }

        public void test_fastRangeCount_quads_03() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "fastRangeCount_quads_03", "fastRangeCount_quads_03.rq", "fastRangeCount_quads_01.trig", "fastRangeCount_quads_03.srx");
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }

        public void test_fastRangeCount_quads_04() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "fastRangeCount_quads_04", "fastRangeCount_quads_04.rq", "fastRangeCount_quads_01.trig", "fastRangeCount_quads_04.srx");
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }

        public void test_fastRangeCount_quads_05() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "fastRangeCount_quads_05", "fastRangeCount_quads_05.rq", "fastRangeCount_quads_01.trig", "fastRangeCount_quads_05.srx");
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)0, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }

        public void test_fastRangeCount_delete_markers() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "fastRangeCount_quads_04", "fastRangeCount_quads_04.rq", "fastRangeCount_quads_01.trig", "fastRangeCount_quads_04.srx");
            this.enableDeleteMarkersInIndes();
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)0, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }
    }

    public static class TestTriplesModeAPs
    extends TestDistinctTermScanOptimizer {
        @Override
        public Properties getProperties() {
            Properties properties = new Properties(super.getProperties());
            properties.setProperty(AbstractTripleStore.Options.QUADS, "false");
            properties.setProperty(AbstractTripleStore.Options.TRIPLES_MODE, "true");
            return properties;
        }

        public void test_fastRangeCount_triples_01() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "fastRangeCount_triples_01", "fastRangeCount_triples_01.rq", "fastRangeCount_triples_01.ttl", "fastRangeCount_triples_01.srx");
            h.runTest();
            TestTriplesModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }

        public void test_fastRangeCount_triples_02() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "fastRangeCount_triples_02", "fastRangeCount_triples_02.rq", "fastRangeCount_triples_01.ttl", "fastRangeCount_triples_02.srx");
            h.runTest();
            TestTriplesModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }

        public void test_fastRangeCount_delete_markers() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "fastRangeCount_triples_02", "fastRangeCount_triples_02.rq", "fastRangeCount_triples_01.ttl", "fastRangeCount_triples_02.srx");
            this.enableDeleteMarkersInIndes();
            h.runTest();
            TestTriplesModeAPs.assertEquals((int)0, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }
    }
}

