/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.bop.join.HTreeHashJoinOp;
import com.bigdata.bop.join.JVMHashJoinOp;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import com.bigdata.rdf.spo.SPOKeyOrder;
import java.util.Iterator;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestHashJoin
extends AbstractDataDrivenSPARQLTestCase {
    public TestHashJoin() {
    }

    public TestHashJoin(String name) {
        super(name);
    }

    public void test_hash_join_1() throws Exception {
        ASTContainer astContainer = new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "hash-join-1").runTest();
        PipelineOp queryPlan = astContainer.getQueryPlan();
        if (!BOpUtility.visitAll((BOp)queryPlan, JVMHashJoinOp.class).hasNext()) {
            TestHashJoin.fail((String)("Expecting a JVM-based hash join in the query plan: " + astContainer.toString()));
        }
    }

    public void test_hash_join_1b() throws Exception {
        ASTContainer astContainer = new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "hash-join-1b").runTest();
        PipelineOp queryPlan = astContainer.getQueryPlan();
        if (!BOpUtility.visitAll((BOp)queryPlan, HTreeHashJoinOp.class).hasNext()) {
            TestHashJoin.fail((String)("Expecting an HTree-based hash join in the query plan: " + astContainer.toString()));
        }
    }

    public void test_hash_join_2() throws Exception {
        ASTContainer astContainer = new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "hash-join-2").runTest();
        PipelineOp queryPlan = astContainer.getQueryPlan();
        Iterator itr = BOpUtility.visitAll((BOp)queryPlan, Predicate.class);
        Predicate pred = (Predicate)itr.next();
        IV p = (IV)pred.get(1).get();
        if (p.getValue().equals(RDF.TYPE)) {
            pred = (Predicate)itr.next();
            p = (IV)pred.get(1).get();
        }
        TestHashJoin.assertEquals((Object)RDFS.LABEL, (Object)p.getValue());
        TestHashJoin.assertEquals((Object)SPOKeyOrder.PCSO, (Object)pred.getKeyOrder());
        TestHashJoin.assertEquals((Object)SPOKeyOrder.PCSO, (Object)SPOKeyOrder.getKeyOrder((IPredicate)pred, (int)4));
        pred = (Predicate)pred.clearProperty(IPredicate.Annotations.KEY_ORDER);
        TestHashJoin.assertEquals(null, (Object)pred.getKeyOrder());
        TestHashJoin.assertEquals((Object)SPOKeyOrder.POCS, (Object)SPOKeyOrder.getKeyOrder((IPredicate)pred, (int)4));
    }
}

