/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.bop.join.HashIndexOp;
import com.bigdata.bop.join.NestedLoopJoinOp;
import com.bigdata.bop.join.PipelineJoin;
import com.bigdata.bop.join.SolutionSetHashJoinOp;
import com.bigdata.bop.rdf.join.ChunkedMaterializationOp;
import com.bigdata.bop.solutions.ProjectionOp;
import com.bigdata.bop.solutions.SliceOp;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IBTreeManager;
import com.bigdata.journal.Options;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import com.bigdata.rdf.sparql.ast.ssets.SolutionSetManager;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.LinkedList;
import java.util.Properties;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class TestInclude
extends AbstractDataDrivenSPARQLTestCase {
    public TestInclude() {
    }

    public TestInclude(String name) {
        super(name);
    }

    @Override
    public Properties getProperties() {
        Properties properties = (Properties)super.getProperties().clone();
        properties.setProperty(Options.BUFFER_MODE, BufferMode.MemStore.name());
        return properties;
    }

    protected <T> IConstant<T> asConst(T val) {
        return new Constant(val);
    }

    public void test_include_02() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper testHelper = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "include_02", "include_02.rq", "include_02.trig", "include_02.srx", true);
        AbstractTripleStore tripleStore = testHelper.getTripleStore();
        BigdataValueFactory vf = tripleStore.getValueFactory();
        QueryEngine queryEngine = QueryEngineFactory.getInstance().getQueryController(tripleStore.getIndexManager());
        SolutionSetManager sparqlCache = new SolutionSetManager((IBTreeManager)queryEngine.getIndexManager(), tripleStore.getNamespace(), tripleStore.getTimestamp());
        String solutionSet = "%solutionSet1";
        Var x = Var.var((String)"x");
        Var y = Var.var((String)"y");
        Var z = Var.var((String)"z");
        XSDNumericIV one = new XSDNumericIV(1);
        one.setValue((BigdataValue)vf.createLiteral(1));
        XSDNumericIV two = new XSDNumericIV(2);
        XSDNumericIV three = new XSDNumericIV(3);
        XSDNumericIV four = new XSDNumericIV(4);
        four.setValue((BigdataValue)vf.createLiteral(4));
        XSDNumericIV five = new XSDNumericIV(5);
        five.setValue((BigdataValue)vf.createLiteral(5));
        LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(one));
        bset.set((IVariable)y, this.asConst(two));
        bsets.add(bset);
        bset = new ListBindingSet();
        bsets.add(bset);
        bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(three));
        bset.set((IVariable)y, this.asConst(four));
        bset.set((IVariable)z, this.asConst(five));
        bsets.add(bset);
        IBindingSet[] bindingSets = bsets.toArray(new IBindingSet[0]);
        sparqlCache.putSolutions("%solutionSet1", BOpUtility.asIterator((IBindingSet[])bindingSets));
        ASTContainer astContainer = testHelper.runTest();
        PipelineOp queryPlan = astContainer.getQueryPlan();
        TestInclude.assertTrue((boolean)(queryPlan instanceof SliceOp));
        PipelineOp projectionOp = (PipelineOp)queryPlan.get(0);
        TestInclude.assertTrue((boolean)(projectionOp instanceof ProjectionOp));
        PipelineOp includeOp = (PipelineOp)projectionOp.get(0);
        TestInclude.assertTrue((boolean)(includeOp instanceof NestedLoopJoinOp));
    }

    public void test_include_03a() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper testHelper = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "include_03a", "include_03a.rq", "include_03.trig", "include_03.srx", false);
        AbstractTripleStore tripleStore = testHelper.getTripleStore();
        BigdataValueFactory vf = tripleStore.getValueFactory();
        QueryEngine queryEngine = QueryEngineFactory.getInstance().getQueryController(tripleStore.getIndexManager());
        SolutionSetManager sparqlCache = new SolutionSetManager((IBTreeManager)queryEngine.getIndexManager(), tripleStore.getNamespace(), tripleStore.getTimestamp());
        String solutionSet = "%solutionSet1";
        Var x = Var.var((String)"x");
        Var y = Var.var((String)"y");
        BigdataURI Mike = vf.createURI("http://www.bigdata.com/Mike");
        BigdataURI Bryan = vf.createURI("http://www.bigdata.com/Bryan");
        BigdataURI DC = vf.createURI("http://www.bigdata.com/DC");
        tripleStore.addTerms(new BigdataValue[]{Mike, Bryan, DC});
        TestInclude.assertNotNull((Object)Mike.getIV());
        TestInclude.assertNotNull((Object)Bryan.getIV());
        TestInclude.assertNotNull((Object)DC.getIV());
        XSDNumericIV one = new XSDNumericIV(1);
        one.setValue((BigdataValue)vf.createLiteral(1));
        XSDNumericIV two = new XSDNumericIV(2);
        two.setValue((BigdataValue)vf.createLiteral(2));
        XSDNumericIV four = new XSDNumericIV(4);
        four.setValue((BigdataValue)vf.createLiteral(4));
        LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(Mike.getIV()));
        bset.set((IVariable)y, this.asConst(two));
        bsets.add(bset);
        bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(Bryan.getIV()));
        bset.set((IVariable)y, this.asConst(four));
        bsets.add(bset);
        bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(DC.getIV()));
        bset.set((IVariable)y, this.asConst(one));
        bsets.add(bset);
        IBindingSet[] bindingSets = bsets.toArray(new IBindingSet[0]);
        sparqlCache.putSolutions("%solutionSet1", BOpUtility.asIterator((IBindingSet[])bindingSets));
        ASTContainer astContainer = testHelper.runTest();
        PipelineOp queryPlan = astContainer.getQueryPlan();
        TestInclude.assertTrue((boolean)(queryPlan instanceof ChunkedMaterializationOp));
        PipelineOp projectionOp = (PipelineOp)queryPlan.get(0);
        TestInclude.assertTrue((boolean)(projectionOp instanceof ProjectionOp));
        PipelineOp joinOp = (PipelineOp)projectionOp.get(0);
        TestInclude.assertTrue((boolean)(joinOp instanceof PipelineJoin));
        PipelineOp includeOp = (PipelineOp)joinOp.get(0);
        TestInclude.assertTrue((boolean)(includeOp instanceof NestedLoopJoinOp));
    }

    public void test_include_03() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper testHelper = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "include_03", "include_03.rq", "include_03.trig", "include_03.srx", false);
        AbstractTripleStore tripleStore = testHelper.getTripleStore();
        BigdataValueFactory vf = tripleStore.getValueFactory();
        QueryEngine queryEngine = QueryEngineFactory.getInstance().getQueryController(tripleStore.getIndexManager());
        SolutionSetManager sparqlCache = new SolutionSetManager((IBTreeManager)queryEngine.getIndexManager(), tripleStore.getNamespace(), tripleStore.getTimestamp());
        String solutionSet = "%solutionSet1";
        Var x = Var.var((String)"x");
        Var y = Var.var((String)"y");
        BigdataURI Mike = vf.createURI("http://www.bigdata.com/Mike");
        BigdataURI Bryan = vf.createURI("http://www.bigdata.com/Bryan");
        BigdataURI DC = vf.createURI("http://www.bigdata.com/DC");
        tripleStore.addTerms(new BigdataValue[]{Mike, Bryan, DC});
        TestInclude.assertNotNull((Object)Mike.getIV());
        TestInclude.assertNotNull((Object)Bryan.getIV());
        TestInclude.assertNotNull((Object)DC.getIV());
        XSDNumericIV one = new XSDNumericIV(1);
        one.setValue((BigdataValue)vf.createLiteral(1));
        XSDNumericIV two = new XSDNumericIV(2);
        two.setValue((BigdataValue)vf.createLiteral(2));
        XSDNumericIV four = new XSDNumericIV(4);
        four.setValue((BigdataValue)vf.createLiteral(4));
        LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
        ListBindingSet bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(Mike.getIV()));
        bset.set((IVariable)y, this.asConst(two));
        bsets.add(bset);
        bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(Bryan.getIV()));
        bset.set((IVariable)y, this.asConst(four));
        bsets.add(bset);
        bset = new ListBindingSet();
        bset.set((IVariable)x, this.asConst(DC.getIV()));
        bset.set((IVariable)y, this.asConst(one));
        bsets.add(bset);
        IBindingSet[] bindingSets = bsets.toArray(new IBindingSet[0]);
        sparqlCache.putSolutions("%solutionSet1", BOpUtility.asIterator((IBindingSet[])bindingSets));
        ASTContainer astContainer = testHelper.runTest();
        PipelineOp queryPlan = astContainer.getQueryPlan();
        TestInclude.assertTrue((boolean)(queryPlan instanceof ChunkedMaterializationOp));
        TestInclude.assertTrue((boolean)(queryPlan.get(0) instanceof ProjectionOp));
        PipelineOp solutionSetHashJoinOp = (PipelineOp)queryPlan.get(0).get(0);
        TestInclude.assertTrue((boolean)(solutionSetHashJoinOp instanceof SolutionSetHashJoinOp));
        PipelineOp hashIndexOp = (PipelineOp)solutionSetHashJoinOp.get(0);
        TestInclude.assertTrue((boolean)(hashIndexOp instanceof HashIndexOp));
        PipelineOp pipelineJoinOp = (PipelineOp)hashIndexOp.get(0);
        TestInclude.assertTrue((boolean)(pipelineJoinOp instanceof PipelineJoin));
    }

    public void test_stressTests() throws Exception {
        for (int i = 0; i < 100; ++i) {
            TestSuite suite = new TestSuite(IncludeStressTests.class.getSimpleName());
            suite.addTestSuite(IncludeStressTests.class);
            suite.run(new TestResult());
        }
    }

    public static class IncludeStressTests
    extends AbstractDataDrivenSPARQLTestCase {
        public IncludeStressTests() {
        }

        public IncludeStressTests(String name) {
            super(name);
        }

        public void test_include_01() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper testHelper = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "include_01", "include_01.rq", "include_01.trig", "include_01.srx", true);
            AbstractTripleStore tripleStore = testHelper.getTripleStore();
            BigdataValueFactory vf = tripleStore.getValueFactory();
            QueryEngine queryEngine = QueryEngineFactory.getInstance().getQueryController(tripleStore.getIndexManager());
            SolutionSetManager sparqlCache = new SolutionSetManager((IBTreeManager)queryEngine.getIndexManager(), tripleStore.getNamespace(), tripleStore.getTimestamp());
            String solutionSet = "%solutionSet1";
            Var x = Var.var((String)"x");
            Var y = Var.var((String)"y");
            Var z = Var.var((String)"z");
            XSDNumericIV one = new XSDNumericIV(1);
            one.setValue((BigdataValue)vf.createLiteral(1));
            XSDNumericIV two = new XSDNumericIV(2);
            XSDNumericIV three = new XSDNumericIV(3);
            XSDNumericIV four = new XSDNumericIV(4);
            four.setValue((BigdataValue)vf.createLiteral(4));
            XSDNumericIV five = new XSDNumericIV(5);
            five.setValue((BigdataValue)vf.createLiteral(5));
            LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
            ListBindingSet bset = new ListBindingSet();
            bset.set((IVariable)x, this.asConst(one));
            bset.set((IVariable)y, this.asConst(two));
            bsets.add(bset);
            bset = new ListBindingSet();
            bsets.add(bset);
            bset = new ListBindingSet();
            bset.set((IVariable)x, this.asConst(three));
            bset.set((IVariable)y, this.asConst(four));
            bset.set((IVariable)z, this.asConst(five));
            bsets.add(bset);
            IBindingSet[] bindingSets = bsets.toArray(new IBindingSet[0]);
            sparqlCache.putSolutions("%solutionSet1", BOpUtility.asIterator((IBindingSet[])bindingSets));
            ASTContainer astContainer = testHelper.runTest();
            PipelineOp queryPlan = astContainer.getQueryPlan();
            IncludeStressTests.assertTrue((boolean)(queryPlan instanceof ProjectionOp));
            PipelineOp includeOp = (PipelineOp)queryPlan.get(0);
            IncludeStressTests.assertTrue((boolean)(includeOp instanceof NestedLoopJoinOp));
        }

        protected <T> IConstant<T> asConst(T val) {
            return new Constant(val);
        }
    }
}

