/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.NV;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.AndBOp;
import com.bigdata.rdf.internal.constraints.FalseBOp;
import com.bigdata.rdf.internal.constraints.OrBOp;
import com.bigdata.rdf.internal.constraints.SparqlTypeErrorBOp;
import com.bigdata.rdf.internal.constraints.TrueBOp;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.rule.IRule;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

public class TestInlineConstraints
extends AbstractDataDrivenSPARQLTestCase {
    public TestInlineConstraints() {
    }

    public TestInlineConstraints(String name) {
        super(name);
    }

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.INLINE_DATE_TIMES, "true");
        return props;
    }

    public void testGT() throws Exception {
        new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "inline-constraints-gt").runTest();
    }

    public void testGE() throws Exception {
        new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "inline-constraints-ge").runTest();
    }

    public void testLT() throws Exception {
        new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "inline-constraints-lt").runTest();
    }

    public void testLE() throws Exception {
        new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "inline-constraints-le").runTest();
    }

    public void testMath() throws Exception {
        new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "inline-constraints-math").runTest();
    }

    public void testCompareDates() throws Exception {
        new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "inline-constraints-dt").runTest();
    }

    public void testAnd() {
        TrueBOp T = TrueBOp.INSTANCE;
        FalseBOp F = FalseBOp.INSTANCE;
        SparqlTypeErrorBOp E = SparqlTypeErrorBOp.INSTANCE;
        ListBindingSet bs = new ListBindingSet();
        AndBOp and = new AndBOp((IValueExpression)T, (IValueExpression)T);
        XSDBooleanIV iv = and.get((IBindingSet)bs);
        TestInlineConstraints.assertTrue((boolean)iv.booleanValue());
        and = new AndBOp((IValueExpression)T, (IValueExpression)F);
        iv = and.get((IBindingSet)bs);
        TestInlineConstraints.assertFalse((boolean)iv.booleanValue());
        and = new AndBOp((IValueExpression)F, (IValueExpression)T);
        iv = and.get((IBindingSet)bs);
        TestInlineConstraints.assertFalse((boolean)iv.booleanValue());
        and = new AndBOp((IValueExpression)F, (IValueExpression)F);
        iv = and.get((IBindingSet)bs);
        TestInlineConstraints.assertFalse((boolean)iv.booleanValue());
        and = new AndBOp((IValueExpression)T, (IValueExpression)E);
        try {
            and.get((IBindingSet)bs);
            TestInlineConstraints.assertTrue((boolean)false);
        }
        catch (SparqlTypeErrorException ex) {
            // empty catch block
        }
        and = new AndBOp((IValueExpression)E, (IValueExpression)T);
        try {
            and.get((IBindingSet)bs);
            TestInlineConstraints.assertTrue((boolean)false);
        }
        catch (SparqlTypeErrorException ex) {
            // empty catch block
        }
        and = new AndBOp((IValueExpression)E, (IValueExpression)F);
        iv = and.get((IBindingSet)bs);
        TestInlineConstraints.assertFalse((boolean)iv.booleanValue());
        and = new AndBOp((IValueExpression)F, (IValueExpression)E);
        iv = and.get((IBindingSet)bs);
        TestInlineConstraints.assertFalse((boolean)iv.booleanValue());
        and = new AndBOp((IValueExpression)E, (IValueExpression)E);
        try {
            and.get((IBindingSet)bs);
            TestInlineConstraints.assertTrue((boolean)false);
        }
        catch (SparqlTypeErrorException ex) {
            // empty catch block
        }
    }

    public void testOr() {
        TrueBOp T = TrueBOp.INSTANCE;
        FalseBOp F = FalseBOp.INSTANCE;
        SparqlTypeErrorBOp E = SparqlTypeErrorBOp.INSTANCE;
        ListBindingSet bs = new ListBindingSet();
        OrBOp or = new OrBOp((IValueExpression)T, (IValueExpression)T);
        XSDBooleanIV iv = or.get((IBindingSet)bs);
        TestInlineConstraints.assertTrue((boolean)iv.booleanValue());
        or = new OrBOp((IValueExpression)T, (IValueExpression)F);
        iv = or.get((IBindingSet)bs);
        TestInlineConstraints.assertTrue((boolean)iv.booleanValue());
        or = new OrBOp((IValueExpression)F, (IValueExpression)T);
        iv = or.get((IBindingSet)bs);
        TestInlineConstraints.assertTrue((boolean)iv.booleanValue());
        or = new OrBOp((IValueExpression)F, (IValueExpression)F);
        iv = or.get((IBindingSet)bs);
        TestInlineConstraints.assertFalse((boolean)iv.booleanValue());
        or = new OrBOp((IValueExpression)E, (IValueExpression)T);
        iv = or.get((IBindingSet)bs);
        TestInlineConstraints.assertTrue((boolean)iv.booleanValue());
        or = new OrBOp((IValueExpression)T, (IValueExpression)E);
        iv = or.get((IBindingSet)bs);
        TestInlineConstraints.assertTrue((boolean)iv.booleanValue());
        or = new OrBOp((IValueExpression)F, (IValueExpression)E);
        try {
            or.get((IBindingSet)bs);
            TestInlineConstraints.assertTrue((boolean)false);
        }
        catch (SparqlTypeErrorException ex) {
            // empty catch block
        }
        or = new OrBOp((IValueExpression)E, (IValueExpression)F);
        try {
            or.get((IBindingSet)bs);
            TestInlineConstraints.assertTrue((boolean)false);
        }
        catch (SparqlTypeErrorException ex) {
            // empty catch block
        }
        or = new OrBOp((IValueExpression)E, (IValueExpression)E);
        try {
            or.get((IBindingSet)bs);
            TestInlineConstraints.assertTrue((boolean)false);
        }
        catch (SparqlTypeErrorException ex) {
            // empty catch block
        }
    }

    private IPredicate toPredicate(AbstractTripleStore database, AtomicInteger idFactory, IVariableOrConstant<IV> s, IVariableOrConstant<IV> p, IVariableOrConstant<IV> o) {
        LinkedList<NV> anns = new LinkedList<NV>();
        BOp[] vars = new BOp[]{s, p, o};
        anns.add(new NV(IPredicate.Annotations.RELATION_NAME, (Object)new String[]{database.getSPORelation().getNamespace()}));
        anns.add(new NV(IPredicate.Annotations.TIMESTAMP, (Object)database.getSPORelation().getTimestamp()));
        anns.add(new NV(IPredicate.Annotations.FLAGS, (Object)267));
        anns.add(new NV(BOp.Annotations.BOP_ID, (Object)idFactory.incrementAndGet()));
        return new SPOPredicate(vars, anns.toArray(new NV[anns.size()]));
    }

    private IChunkedOrderedIterator<IBindingSet> runQuery(AbstractTripleStore db, IRule rule) throws Exception {
        TestInlineConstraints.fail((String)"refactor test suite");
        return null;
    }
}

