/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.BufferAnnotations;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.Var;
import com.bigdata.bop.controller.INamedSubqueryOp;
import com.bigdata.bop.controller.ServiceCallJoin;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.join.HashJoinOp;
import com.bigdata.bop.join.PipelineJoin;
import com.bigdata.bop.join.SolutionSetHashJoinOp;
import com.bigdata.bop.solutions.ProjectionOp;
import com.bigdata.bop.solutions.SliceOp;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.QueryOptimizerEnum;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.SubqueryBase;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import com.bigdata.rdf.sparql.ast.eval.service.OpenrdfNativeMockServiceFactory;
import com.bigdata.rdf.sparql.ast.hints.QueryHintException;
import com.bigdata.rdf.sparql.ast.service.ServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.util.InnerCause;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.Striterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.BindingSet;
import org.openrdf.query.impl.MapBindingSet;

public class TestQueryHints
extends AbstractDataDrivenSPARQLTestCase {
    private static final Logger log = Logger.getLogger(TestQueryHints.class);

    public TestQueryHints() {
    }

    public TestQueryHints(String name) {
        super(name);
    }

    private static Iterator<BOp> visitQueryHints(BOp op, final String name) {
        return new Striterator(BOpUtility.preOrderIteratorWithAnnotations((BOp)op)).addFilter((IFilter)new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean isValid(Object arg0) {
                if (!(arg0 instanceof BOp)) {
                    return false;
                }
                BOp tmp = (BOp)arg0;
                if (tmp.getProperty(name) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found as bare property: name=" + name + ", op=" + tmp.toShortString() + "#" + tmp.hashCode()));
                    }
                    return true;
                }
                Properties queryHints = (Properties)tmp.getProperty("queryHints");
                if (queryHints != null && queryHints.getProperty(name) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found as query hint: name=" + name + ", op=" + tmp.toShortString() + "#" + tmp.hashCode()));
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private static int countQueryHints(BOp op, String name) {
        int n = 0;
        Iterator<BOp> itr = TestQueryHints.visitQueryHints(op, name);
        while (itr.hasNext()) {
            itr.next();
            ++n;
        }
        return n;
    }

    public void test_query_hints_01() throws Exception {
        ASTContainer astContainer = new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "query-hints-01").runTest();
        TestQueryHints.assertEquals((String)"http://www.bigdata.com/queryHints#", (String)((String)astContainer.getOriginalAST().getPrefixDecls().get("hint")));
        if (log.isInfoEnabled()) {
            log.info((Object)BOpUtility.toString((BOp)astContainer.getOptimizedAST()));
        }
        JoinGroupNode whereClause = (JoinGroupNode)astContainer.getOptimizedAST().getWhereClause();
        TestQueryHints.assertEquals((Object)QueryOptimizerEnum.None, (Object)whereClause.getQueryOptimizer());
        TestQueryHints.assertEquals((String)"10", (String)whereClause.getQueryHint(PipelineOp.Annotations.MAX_PARALLEL, "-1"));
        TestQueryHints.assertEquals((String)"20", (String)whereClause.getQueryHint(PipelineOp.Annotations.PIPELINE_QUEUE_CAPACITY, "-1"));
        TestQueryHints.assertEquals((String)"20", (String)whereClause.getQueryHint(PipelineOp.Annotations.CHUNK_OF_CHUNKS_CAPACITY, "-1"));
        TestQueryHints.assertNull((Object)whereClause.getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertEquals((int)1, (int)TestQueryHints.countQueryHints((BOp)astContainer.getOptimizedAST(), PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertSameIteratorAnyOrder((Object[])new Object[]{whereClause}, TestQueryHints.visitQueryHints((BOp)astContainer.getOptimizedAST(), "optimizer"));
        TestQueryHints.assertEquals((int)2, (int)whereClause.arity());
        StatementPatternNode sp = (StatementPatternNode)whereClause.get(0);
        TestQueryHints.assertEquals((Object)RDFS.LABEL, (Object)sp.p().getValue());
        TestQueryHints.assertEquals((int)10, (int)Integer.parseInt(sp.getQueryHint(PipelineOp.Annotations.MAX_PARALLEL, "-1")));
        TestQueryHints.assertEquals((int)20, (int)Integer.parseInt(sp.getQueryHint(PipelineOp.Annotations.PIPELINE_QUEUE_CAPACITY, "-1")));
        TestQueryHints.assertEquals((int)20, (int)Integer.parseInt(sp.getQueryHint(BufferAnnotations.CHUNK_OF_CHUNKS_CAPACITY, "-1")));
        TestQueryHints.assertNull((Object)sp.getProperty("optimizer"));
        sp = (StatementPatternNode)whereClause.get(1);
        TestQueryHints.assertEquals((Object)RDF.TYPE, (Object)sp.p().getValue());
        TestQueryHints.assertEquals((int)1000, (int)Integer.parseInt(sp.getQueryHint(BufferAnnotations.CHUNK_CAPACITY, "-1")));
        TestQueryHints.assertEquals((int)20, (int)Integer.parseInt(sp.getQueryHint(BufferAnnotations.CHUNK_OF_CHUNKS_CAPACITY, "-1")));
        TestQueryHints.assertNull((Object)sp.getProperty("optimizer"));
        if (log.isInfoEnabled()) {
            log.info((Object)BOpUtility.toString((BOp)astContainer.getQueryPlan()));
        }
        Iterator jitr = BOpUtility.visitAll((BOp)astContainer.getQueryPlan(), PipelineJoin.class);
        PipelineJoin[] joins = new PipelineJoin[2];
        joins[1] = (PipelineJoin)jitr.next();
        joins[0] = (PipelineJoin)jitr.next();
        TestQueryHints.assertFalse((boolean)jitr.hasNext());
        PipelineJoin join = joins[0];
        IPredicate pred = join.getPredicate();
        if (log.isInfoEnabled()) {
            log.info((Object)("pred=" + BOpUtility.toString((BOp)pred)));
        }
        TestQueryHints.assertEquals((Object)RDFS.LABEL, (Object)((IV)pred.get(1).get()).getValue());
        TestQueryHints.assertEquals((int)10, (int)join.getMaxParallel());
        TestQueryHints.assertEquals((int)20, (int)Integer.parseInt((String)join.getProperty(PipelineOp.Annotations.PIPELINE_QUEUE_CAPACITY, (Object)"-1")));
        TestQueryHints.assertEquals((int)20, (int)join.getChunkOfChunksCapacity());
        TestQueryHints.assertNull((Object)pred.getProperty(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertEquals((Object)"20", (Object)pred.getProperty(PipelineOp.Annotations.CHUNK_OF_CHUNKS_CAPACITY));
        TestQueryHints.assertNull((Object)pred.getProperty(PipelineOp.Annotations.PIPELINE_QUEUE_CAPACITY));
        TestQueryHints.assertNull((Object)pred.getProperty(IPredicate.Annotations.FULLY_BUFFERED_READ_THRESHOLD));
        join = joins[1];
        pred = join.getPredicate();
        if (log.isInfoEnabled()) {
            log.info((Object)("pred=" + BOpUtility.toString((BOp)pred)));
        }
        TestQueryHints.assertEquals((Object)RDF.TYPE, (Object)((IV)pred.get(1).get()).getValue());
        TestQueryHints.assertEquals((int)10, (int)join.getMaxParallel());
        TestQueryHints.assertEquals((int)1000, (int)join.getChunkCapacity());
        TestQueryHints.assertEquals((int)20, (int)join.getChunkOfChunksCapacity());
        TestQueryHints.assertEquals((Object)"1000", (Object)pred.getProperty(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertEquals((Object)"20", (Object)pred.getProperty(PipelineOp.Annotations.CHUNK_OF_CHUNKS_CAPACITY));
        TestQueryHints.assertNull((Object)pred.getProperty(PipelineOp.Annotations.PIPELINE_QUEUE_CAPACITY));
        TestQueryHints.assertNull((Object)pred.getProperty(IPredicate.Annotations.FULLY_BUFFERED_READ_THRESHOLD));
        Iterator projItr = BOpUtility.visitAll((BOp)astContainer.getQueryPlan(), ProjectionOp.class);
        TestQueryHints.assertTrue((boolean)projItr.hasNext());
        ProjectionOp projection = (ProjectionOp)projItr.next();
        TestQueryHints.assertNull((Object)projection.getProperty(PipelineOp.Annotations.MAX_PARALLEL));
        TestQueryHints.assertNull((Object)projection.getProperty(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertNotNull((Object)projection.getProperty(PipelineOp.Annotations.CHUNK_OF_CHUNKS_CAPACITY));
        TestQueryHints.assertEquals((int)20, (int)projection.getChunkOfChunksCapacity());
        TestQueryHints.assertFalse((boolean)projItr.hasNext());
    }

    public void test_query_hints_02() throws Exception {
        ASTContainer astContainer = new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "query-hints-02").runTest();
        String expectedIdStr = "458aed8b-2c76-4d29-9cf0-d18d6a74bc0e";
        UUID expectedId = UUID.fromString("458aed8b-2c76-4d29-9cf0-d18d6a74bc0e");
        String actualIdStr = astContainer.getQueryHint("queryId");
        TestQueryHints.assertEquals((String)"458aed8b-2c76-4d29-9cf0-d18d6a74bc0e", (String)actualIdStr);
        TestQueryHints.assertEquals((int)2, (int)astContainer.getOptimizedAST().getWhereClause().arity());
        TestQueryHints.assertEquals((Object)expectedId, (Object)astContainer.getQueryPlan().getProperty(QueryEngine.Annotations.QUERY_ID));
    }

    public void test_query_hints_03() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "query-hints-03").runTest();
        }
        catch (Throwable t) {
            TestQueryHints.assertTrue((boolean)InnerCause.isInnerCause((Throwable)t, QueryHintException.class));
        }
    }

    public void test_query_hints_04a() throws Exception {
        ASTContainer astContainer = new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "query-hints-04a").runTest();
        NamedSubqueriesNode namedSubqueries = astContainer.getOptimizedAST().getNamedSubqueries();
        TestQueryHints.assertNull((Object)namedSubqueries);
    }

    public void test_query_hints_04b() throws Exception {
        ASTContainer astContainer = new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "query-hints-04b").runTest();
        NamedSubqueriesNode namedSubqueries = astContainer.getOptimizedAST().getNamedSubqueries();
        TestQueryHints.assertNotNull((Object)namedSubqueries);
        TestQueryHints.assertEquals((int)1, (int)namedSubqueries.arity());
    }

    public void test_query_hints_05() throws Exception {
        ASTContainer astContainer = new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "query-hints-05").runTest();
        JoinGroupNode whereClause = (JoinGroupNode)astContainer.getOptimizedAST().getWhereClause();
        TestQueryHints.assertEquals((Object)QueryOptimizerEnum.None, (Object)whereClause.getQueryOptimizer());
        TestQueryHints.assertEquals((int)2, (int)whereClause.arity());
        StatementPatternNode sp = (StatementPatternNode)whereClause.get(0);
        TestQueryHints.assertEquals((Object)RDFS.LABEL, (Object)sp.p().getValue());
        sp = (StatementPatternNode)whereClause.get(1);
        TestQueryHints.assertEquals((Object)RDF.TYPE, (Object)sp.p().getValue());
        TestQueryHints.assertEquals((String)SPOKeyOrder.PCSO.toString(), (String)sp.getQueryHint(IPredicate.Annotations.KEY_ORDER));
        TestQueryHints.assertEquals((String)"true", (String)sp.getQueryHint("hashJoin"));
        Iterator jitr = BOpUtility.visitAll((BOp)astContainer.getQueryPlan(), PipelineJoin.class);
        TestQueryHints.assertTrue((boolean)jitr.hasNext());
        PipelineJoin join = (PipelineJoin)jitr.next();
        TestQueryHints.assertEquals((Object)RDFS.LABEL, (Object)((IV)join.getPredicate().get(1).get()).getValue());
        TestQueryHints.assertFalse((boolean)jitr.hasNext());
        jitr = BOpUtility.visitAll((BOp)astContainer.getQueryPlan(), HashJoinOp.class);
        TestQueryHints.assertTrue((boolean)jitr.hasNext());
        join = (HashJoinOp)jitr.next();
        TestQueryHints.assertEquals((Object)RDF.TYPE, (Object)((IV)join.getPredicate().get(1).get()).getValue());
        IPredicate pred = join.getPredicate();
        TestQueryHints.assertEquals((Object)SPOKeyOrder.PCSO, (Object)pred.getKeyOrder());
        TestQueryHints.assertFalse((boolean)jitr.hasNext());
    }

    public void test_query_hints_05a() throws Exception {
        ASTContainer astContainer = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "query-hints-05a", "query-hints-05a.rq", "query-hints-05.trig", "query-hints-05.srx").runTest();
        JoinGroupNode whereClause = (JoinGroupNode)astContainer.getOptimizedAST().getWhereClause();
        TestQueryHints.assertEquals((Object)QueryOptimizerEnum.None, (Object)whereClause.getQueryOptimizer());
        TestQueryHints.assertEquals((int)2, (int)whereClause.arity());
        StatementPatternNode sp = (StatementPatternNode)whereClause.get(0);
        TestQueryHints.assertEquals((Object)RDFS.LABEL, (Object)sp.p().getValue());
        sp = (StatementPatternNode)whereClause.get(1);
        TestQueryHints.assertEquals((Object)RDF.TYPE, (Object)sp.p().getValue());
        TestQueryHints.assertEquals((String)SPOKeyOrder.PCSO.toString(), (String)sp.getQueryHint(IPredicate.Annotations.KEY_ORDER));
        PipelineJoin[] joins = BOpUtility.toList((Iterator)BOpUtility.visitAll((BOp)astContainer.getQueryPlan(), PipelineJoin.class)).toArray(new PipelineJoin[0]);
        TestQueryHints.assertEquals((String)"#joins", (int)2, (int)joins.length);
        PipelineJoin join = joins[1];
        TestQueryHints.assertEquals((Object)RDFS.LABEL, (Object)((IV)join.getPredicate().get(1).get()).getValue());
        join = joins[0];
        TestQueryHints.assertEquals((Object)RDF.TYPE, (Object)((IV)join.getPredicate().get(1).get()).getValue());
        IPredicate pred = join.getPredicate();
        TestQueryHints.assertEquals((Object)SPOKeyOrder.PCSO, (Object)pred.getKeyOrder());
    }

    public void test_query_hints_06() throws Exception {
        ASTContainer astContainer = new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "query-hints-06").runTest();
        if (log.isInfoEnabled()) {
            log.info((Object)BOpUtility.toString((BOp)astContainer.getOptimizedAST()));
        }
        QueryRoot queryRoot = astContainer.getOptimizedAST();
        JoinGroupNode whereClause = (JoinGroupNode)queryRoot.getWhereClause();
        Iterator it = BOpUtility.visitAll((BOp)astContainer.getOptimizedAST(), SubqueryBase.class);
        TestQueryHints.assertTrue((boolean)it.hasNext());
        SubqueryBase subqueryRoot = (SubqueryBase)it.next();
        TestQueryHints.assertFalse((boolean)it.hasNext());
        TestQueryHints.assertNotNull((Object)astContainer.getOptimizedAST().getNamedSubqueries());
        NamedSubqueryInclude nsi = (NamedSubqueryInclude)BOpUtility.getOnly((BOp)whereClause, NamedSubqueryInclude.class);
        List sps = BOpUtility.toList((BOp)queryRoot, StatementPatternNode.class);
        TestQueryHints.assertEquals((int)2, (int)sps.size());
        StatementPatternNode queryRootSP = (StatementPatternNode)BOpUtility.getOnly((BOp)whereClause, StatementPatternNode.class);
        StatementPatternNode subqueryRootSP = (StatementPatternNode)BOpUtility.getOnly((BOp)subqueryRoot.getWhereClause(), StatementPatternNode.class);
        TestQueryHints.assertSameIteratorAnyOrder((Object[])new Object[]{whereClause, subqueryRoot.getWhereClause()}, TestQueryHints.visitQueryHints((BOp)astContainer.getOptimizedAST(), "optimizer"));
        TestQueryHints.assertEquals((int)0, (int)TestQueryHints.countQueryHints((BOp)astContainer.getOptimizedAST(), "chunkSize"));
        TestQueryHints.assertNotNull((Object)queryRoot.getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertNotNull((Object)queryRoot.getProjection().getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertNotNull((Object)queryRoot.getWhereClause().getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertNotNull((Object)queryRootSP.getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertNotNull((Object)queryRoot.getSlice().getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertNotNull((Object)nsi.getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertNotNull((Object)subqueryRoot.getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertNotNull((Object)subqueryRoot.getProjection().getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertNotNull((Object)subqueryRoot.getWhereClause().getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertNotNull((Object)subqueryRootSP.getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertNotNull((Object)subqueryRoot.getSlice().getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertEquals((String)"5", (String)queryRoot.getProjection().getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertEquals((String)"5", (String)subqueryRoot.getProjection().getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertEquals((String)"1001", (String)queryRootSP.getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        TestQueryHints.assertEquals((String)"251", (String)subqueryRootSP.getQueryHint(PipelineOp.Annotations.CHUNK_CAPACITY));
        PipelineOp queryPlan = astContainer.getQueryPlan();
        if (log.isInfoEnabled()) {
            log.info((Object)BOpUtility.toString((BOp)astContainer.getQueryPlan()));
        }
        Iterator itr = BOpUtility.visitAll((BOp)queryPlan, PipelineJoin.class);
        PipelineJoin join = (PipelineJoin)itr.next();
        TestQueryHints.assertEquals((Object)Var.var((String)"o"), (Object)join.getPredicate().get(2));
        TestQueryHints.assertEquals((String)join.toString(), (int)1001, (int)join.getChunkCapacity());
        join = (PipelineJoin)itr.next();
        TestQueryHints.assertTrue((boolean)join.getPredicate().get(2).isConstant());
        TestQueryHints.assertEquals((String)join.toString(), (int)251, (int)join.getChunkCapacity());
        List sliceOps = BOpUtility.toList((BOp)queryPlan, SliceOp.class);
        TestQueryHints.assertEquals((int)2, (int)sliceOps.size());
        SliceOp queryRootSliceOp = ((SliceOp)sliceOps.get(0)).getLimit() == 20L ? (SliceOp)sliceOps.get(0) : (SliceOp)sliceOps.get(1);
        SliceOp subqueryRootSliceOp = ((SliceOp)sliceOps.get(0)).getLimit() == 10L ? (SliceOp)sliceOps.get(0) : (SliceOp)sliceOps.get(1);
        TestQueryHints.assertFalse((queryRootSliceOp == subqueryRootSliceOp ? 1 : 0) != 0);
        TestQueryHints.assertEquals((int)5, (int)queryRootSliceOp.getChunkCapacity());
        TestQueryHints.assertEquals((int)5, (int)subqueryRootSliceOp.getChunkCapacity());
        List projectionOps = BOpUtility.toList((BOp)queryPlan, ProjectionOp.class);
        TestQueryHints.assertEquals((int)2, (int)projectionOps.size());
        ProjectionOp queryRootProjectionOp = ((ProjectionOp)projectionOps.get(0)).getVariables().length == 2 ? (ProjectionOp)projectionOps.get(0) : (ProjectionOp)projectionOps.get(1);
        ProjectionOp subqueryRootProjectionOp = ((ProjectionOp)projectionOps.get(0)).getVariables().length == 1 ? (ProjectionOp)projectionOps.get(0) : (ProjectionOp)projectionOps.get(1);
        TestQueryHints.assertFalse((queryRootProjectionOp == subqueryRootProjectionOp ? 1 : 0) != 0);
        TestQueryHints.assertEquals((int)5, (int)queryRootProjectionOp.getChunkCapacity());
        TestQueryHints.assertEquals((int)5, (int)subqueryRootProjectionOp.getChunkCapacity());
        INamedSubqueryOp namedSubqueryOp = (INamedSubqueryOp)BOpUtility.getOnly((BOp)queryPlan, INamedSubqueryOp.class);
        TestQueryHints.assertEquals((int)5, (int)((PipelineOp)namedSubqueryOp).getChunkCapacity());
        SolutionSetHashJoinOp solutionSetHashJoin = (SolutionSetHashJoinOp)BOpUtility.getOnly((BOp)queryPlan, SolutionSetHashJoinOp.class);
        TestQueryHints.assertEquals((int)5, (int)solutionSetHashJoin.getChunkCapacity());
    }

    public void test_query_hints_07() throws Exception {
        ASTContainer astContainer = new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "query-hints-07").runTest();
        PipelineOp queryPlan = astContainer.getQueryPlan();
        Iterator itr = BOpUtility.visitAll((BOp)queryPlan, PipelineJoin.class);
        PipelineJoin join = (PipelineJoin)itr.next();
        TestQueryHints.assertTrue((boolean)join.getPredicate().get(2).isConstant());
        TestQueryHints.assertEquals((String)join.toString(), (boolean)true, (boolean)join.isPipelinedEvaluation());
        join = (PipelineJoin)itr.next();
        TestQueryHints.assertEquals((Object)Var.var((String)"o"), (Object)join.getPredicate().get(2));
        TestQueryHints.assertEquals((String)join.toString(), (boolean)false, (boolean)join.isPipelinedEvaluation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_query_hints_08() throws Exception {
        ASTContainer astContainer;
        TestQueryHints.assertTrue((boolean)true);
        URIImpl serviceURI = new URIImpl("http://www.bigdata.com/mockService");
        LinkedList<BindingSet> serviceSolutions = new LinkedList<BindingSet>();
        MapBindingSet bset = new MapBindingSet();
        bset.addBinding("x", (Value)new URIImpl("http://www.bigdata.com/Mike"));
        serviceSolutions.add((BindingSet)bset);
        bset = new MapBindingSet();
        bset.addBinding("x", (Value)new URIImpl("http://www.bigdata.com/Bryan"));
        serviceSolutions.add((BindingSet)bset);
        ServiceRegistry.getInstance().add((URI)serviceURI, (ServiceFactory)new OpenrdfNativeMockServiceFactory(serviceSolutions));
        try {
            astContainer = new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "query-hints-08").runTest();
        }
        finally {
            ServiceRegistry.getInstance().remove((URI)serviceURI);
        }
        PipelineOp queryPlan = astContainer.getQueryPlan();
        Iterator itr = BOpUtility.visitAll((BOp)queryPlan, ServiceCallJoin.class);
        ServiceCallJoin join = (ServiceCallJoin)itr.next();
        TestQueryHints.assertFalse((boolean)itr.hasNext());
        TestQueryHints.assertEquals((String)join.toString(), (boolean)false, (boolean)join.isPipelinedEvaluation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_query_hints_08b() throws Exception {
        ASTContainer astContainer;
        TestQueryHints.assertTrue((boolean)true);
        URIImpl serviceURI = new URIImpl("http://www.bigdata.com/mockService");
        LinkedList<BindingSet> serviceSolutions = new LinkedList<BindingSet>();
        MapBindingSet bset = new MapBindingSet();
        bset.addBinding("x", (Value)new URIImpl("http://www.bigdata.com/Mike"));
        serviceSolutions.add((BindingSet)bset);
        bset = new MapBindingSet();
        bset.addBinding("x", (Value)new URIImpl("http://www.bigdata.com/Bryan"));
        serviceSolutions.add((BindingSet)bset);
        ServiceRegistry.getInstance().add((URI)serviceURI, (ServiceFactory)new OpenrdfNativeMockServiceFactory(serviceSolutions));
        try {
            astContainer = new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "query-hints-08b").runTest();
        }
        finally {
            ServiceRegistry.getInstance().remove((URI)serviceURI);
        }
        PipelineOp queryPlan = astContainer.getQueryPlan();
        Iterator itr = BOpUtility.visitAll((BOp)queryPlan, ServiceCallJoin.class);
        ServiceCallJoin join = (ServiceCallJoin)itr.next();
        TestQueryHints.assertFalse((boolean)itr.hasNext());
        TestQueryHints.assertEquals((String)join.toString(), (boolean)true, (boolean)join.isPipelinedEvaluation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_query_hints_09() throws Exception {
        ASTContainer astContainer;
        URIImpl serviceURI = new URIImpl("http://www.bigdata.com/mockService");
        LinkedList<BindingSet> serviceSolutions = new LinkedList<BindingSet>();
        MapBindingSet bset = new MapBindingSet();
        bset.addBinding("x", (Value)new URIImpl("http://www.bigdata.com/Mike"));
        serviceSolutions.add((BindingSet)bset);
        bset = new MapBindingSet();
        bset.addBinding("x", (Value)new URIImpl("http://www.bigdata.com/Bryan"));
        serviceSolutions.add((BindingSet)bset);
        ServiceRegistry.getInstance().add((URI)serviceURI, (ServiceFactory)new OpenrdfNativeMockServiceFactory(serviceSolutions));
        try {
            astContainer = new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "query-hints-09").runTest();
        }
        finally {
            ServiceRegistry.getInstance().remove((URI)serviceURI);
        }
        PipelineOp queryPlan = astContainer.getQueryPlan();
        Iterator itr = BOpUtility.visitAll((BOp)queryPlan, ServiceCallJoin.class);
        ServiceCallJoin join = (ServiceCallJoin)itr.next();
        TestQueryHints.assertFalse((boolean)itr.hasNext());
        TestQueryHints.assertEquals((String)join.toString(), (int)1001, (int)join.getChunkCapacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_query_hints_10() throws Exception {
        ASTContainer astContainer;
        URIImpl serviceURI = new URIImpl("http://www.bigdata.com/mockService");
        LinkedList<BindingSet> serviceSolutions = new LinkedList<BindingSet>();
        MapBindingSet bset = new MapBindingSet();
        bset.addBinding("x", (Value)new URIImpl("http://www.bigdata.com/Mike"));
        serviceSolutions.add((BindingSet)bset);
        bset = new MapBindingSet();
        bset.addBinding("x", (Value)new URIImpl("http://www.bigdata.com/Bryan"));
        serviceSolutions.add((BindingSet)bset);
        ServiceRegistry.getInstance().add((URI)serviceURI, (ServiceFactory)new OpenrdfNativeMockServiceFactory(serviceSolutions));
        try {
            astContainer = new AbstractDataDrivenSPARQLTestCase.TestHelper(this, "query-hints-10").runTest();
        }
        finally {
            ServiceRegistry.getInstance().remove((URI)serviceURI);
        }
        PipelineOp queryPlan = astContainer.getQueryPlan();
        Iterator itr = BOpUtility.visitAll((BOp)queryPlan, ServiceCallJoin.class);
        ServiceCallJoin join = (ServiceCallJoin)itr.next();
        TestQueryHints.assertFalse((boolean)itr.hasNext());
        TestQueryHints.assertEquals((String)join.toString(), (int)13, (int)join.getMaxParallel());
    }
}

