/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.List;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestSimpleBindingsOptimizer
extends AbstractDataDrivenSPARQLTestCase {
    public TestSimpleBindingsOptimizer() {
    }

    public TestSimpleBindingsOptimizer(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TestSimpleBindingsOptimizer.class.getSimpleName());
        suite.addTestSuite(TestQuadsModeAPs.class);
        suite.addTestSuite(TestTriplesModeAPs.class);
        return suite;
    }

    public void assertPredicateUsesConstant_01(SPOPredicate pred) {
        Constant c = (Constant)pred.get(2);
        TermId tId = (TermId)c.get();
        TestSimpleBindingsOptimizer.assertEquals((String)"type", (String)c.getVar().getName());
        TestSimpleBindingsOptimizer.assertEquals((String)"http://bigdata.com#Person", (String)tId.getValue().toString());
    }

    public void test_simpleBindingsOptimizer_triples_02() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper h = (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("simpleBindingsOptimizer_triples_02", "simpleBindingsOptimizer_02.rq", "simpleBindingsOptimizer_02.trig", "simpleBindingsOptimizer_02.srx");
        h.runTest();
        List spoPredicates = BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), SPOPredicate.class);
        TestSimpleBindingsOptimizer.assertEquals((int)1, (int)spoPredicates.size());
        IVariableOrConstant var = ((SPOPredicate)spoPredicates.get(0)).get(2);
        TestSimpleBindingsOptimizer.assertTrue((boolean)(var instanceof Var));
    }

    public static class TestQuadsModeAPs
    extends TestSimpleBindingsOptimizer {
        public void test_simpleBindingsOptimizer_quads_01() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("test_simpleBindingsOptimizer_quads_01", "simpleBindingsOptimizer_01.rq", "simpleBindingsOptimizer_01.trig", "simpleBindingsOptimizer_01.srx");
            h.runTest();
            List spoPredicates = BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), SPOPredicate.class);
            TestQuadsModeAPs.assertEquals((int)1, (int)spoPredicates.size());
            this.assertPredicateUsesConstant_01((SPOPredicate)spoPredicates.get(0));
        }
    }

    public static class TestTriplesModeAPs
    extends TestSimpleBindingsOptimizer {
        @Override
        public Properties getProperties() {
            Properties properties = new Properties(super.getProperties());
            properties.setProperty(AbstractTripleStore.Options.QUADS, "false");
            properties.setProperty(AbstractTripleStore.Options.TRIPLES_MODE, "true");
            return properties;
        }

        public void test_simpleBindingsOptimizer_triples_01() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("simpleBindingsOptimizer_triples_01", "simpleBindingsOptimizer_01.rq", "simpleBindingsOptimizer_01.ttl", "simpleBindingsOptimizer_01.srx");
            h.runTest();
            List spoPredicates = BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), SPOPredicate.class);
            TestTriplesModeAPs.assertEquals((int)1, (int)spoPredicates.size());
            this.assertPredicateUsesConstant_01((SPOPredicate)spoPredicates.get(0));
        }

        @Override
        public void test_simpleBindingsOptimizer_triples_02() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("simpleBindingsOptimizer_triples_02", "simpleBindingsOptimizer_02.rq", "simpleBindingsOptimizer_02.ttl", "simpleBindingsOptimizer_02.srx");
            h.runTest();
            List spoPredicates = BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), SPOPredicate.class);
            TestTriplesModeAPs.assertEquals((int)1, (int)spoPredicates.size());
            IVariableOrConstant var = ((SPOPredicate)spoPredicates.get(0)).get(2);
            TestTriplesModeAPs.assertTrue((boolean)(var instanceof Var));
        }
    }
}

