/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.join.DistinctTermScanOp;
import com.bigdata.bop.join.FastRangeCountOp;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestSimpleGroupByAndCountOptimizer
extends AbstractDataDrivenSPARQLTestCase {
    public TestSimpleGroupByAndCountOptimizer() {
    }

    public TestSimpleGroupByAndCountOptimizer(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TestSimpleGroupByAndCountOptimizer.class.getSimpleName());
        suite.addTestSuite(TestTriplesModeAPs.class);
        suite.addTestSuite(TestQuadsModeAPs.class);
        return suite;
    }

    public static class TestQuadsModeAPs
    extends TestSimpleGroupByAndCountOptimizer {
        public void test_distinctTermScan_quads_01() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "distinctTermScan_quads_01", "simpleGroupByAndCount_quads_01.rq", "simpleGroupByAndCount_quads.trig", "simpleGroupByAndCount_quads_01.srx");
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
            TestQuadsModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }

        public void test_distinctTermScan_quads_02() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "distinctTermScan_quads_02", "simpleGroupByAndCount_quads_02.rq", "simpleGroupByAndCount_quads.trig", "simpleGroupByAndCount_quads_02.srx");
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)0, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
            TestQuadsModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }

        public void test_distinctTermScan_quads_03() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "distinctTermScan_quads_03", "simpleGroupByAndCount_quads_03.rq", "simpleGroupByAndCount_quads.trig", "simpleGroupByAndCount_quads_03.srx");
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
            TestQuadsModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }

        public void test_distinctTermScan_quads_delete_markers() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "distinctTermScan_quads_03", "simpleGroupByAndCount_quads_03.rq", "simpleGroupByAndCount_quads.trig", "simpleGroupByAndCount_quads_03.srx");
            this.enableDeleteMarkersInIndes();
            h.runTest();
            TestQuadsModeAPs.assertEquals((int)0, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
            TestQuadsModeAPs.assertEquals((int)0, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }
    }

    public static class TestTriplesModeAPs
    extends TestSimpleGroupByAndCountOptimizer {
        @Override
        public Properties getProperties() {
            Properties properties = new Properties(super.getProperties());
            properties.setProperty(AbstractTripleStore.Options.QUADS, "false");
            properties.setProperty(AbstractTripleStore.Options.TRIPLES_MODE, "true");
            return properties;
        }

        public void test_simpleGroupByAndCount_01() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "simpleGroupByAndCount_triples_01", "simpleGroupByAndCount_triples_01.rq", "simpleGroupByAndCount_triples.ttl", "simpleGroupByAndCount_triples_01.srx");
            h.runTest();
            TestTriplesModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
            TestTriplesModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }

        public void test_simpleGroupByAndCount_02() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "simpleGroupByAndCount_triples_02", "simpleGroupByAndCount_triples_02.rq", "simpleGroupByAndCount_triples.ttl", "simpleGroupByAndCount_triples_02.srx");
            h.runTest();
            TestTriplesModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
            TestTriplesModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }

        public void test_simpleGroupByAndCount_03() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "simpleGroupByAndCount_triples_03", "simpleGroupByAndCount_triples_03.rq", "simpleGroupByAndCount_triples.ttl", "simpleGroupByAndCount_triples_03.srx");
            h.runTest();
            TestTriplesModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
        }

        public void test_simpleGroupByAndCount_04() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "simpleGroupByAndCount_triples_04", "simpleGroupByAndCount_triples_04.rq", "simpleGroupByAndCount_triples.ttl", "simpleGroupByAndCount_triples_04.srx");
            h.runTest();
            TestTriplesModeAPs.assertEquals((int)1, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
            TestTriplesModeAPs.assertEquals((int)0, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
        }

        public void test_simpleGroupByAndCount_delete_markers() throws Exception {
            AbstractDataDrivenSPARQLTestCase.TestHelper h = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "simpleGroupByAndCount_triples_04", "simpleGroupByAndCount_triples_04.rq", "simpleGroupByAndCount_triples.ttl", "simpleGroupByAndCount_triples_04.srx");
            this.enableDeleteMarkersInIndes();
            h.runTest();
            TestTriplesModeAPs.assertEquals((int)0, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), FastRangeCountOp.class).size());
            TestTriplesModeAPs.assertEquals((int)0, (int)BOpUtility.toList((BOp)h.getASTContainer().getQueryPlan(), DistinctTermScanOp.class).size());
        }
    }
}

