/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval.reif;

import com.bigdata.BigdataStatics;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Options;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class TestReificationDoneRightEval
extends AbstractDataDrivenSPARQLTestCase {
    public static final String TEST_RESOURCE_PREFIX = "/com/bigdata/rdf/sparql/ast/eval/reif/";

    public TestReificationDoneRightEval() {
    }

    public TestReificationDoneRightEval(String name) {
        super(name);
    }

    public void test_reificationDoneRight_00() throws Exception {
        BigdataValueFactory vf = this.store.getValueFactory();
        BigdataURI SAP = vf.createURI("http://example.com/SAP");
        BigdataURI bought = vf.createURI("http://example.com/bought");
        BigdataURI sybase = vf.createURI("http://example.com/sybase");
        BigdataURI dcSource = vf.createURI("http://purl.org/dc/terms/source");
        BigdataURI dcCreated = vf.createURI("http://purl.org/dc/terms/created");
        BigdataURI newsSybase = vf.createURI("http://example.com/news/us-sybase");
        BigdataLiteral createdDate = vf.createLiteral("2011-04-05T12:00:00Z", XSD.DATETIME);
        BigdataURI g1 = vf.createURI("http://example.com/g1");
        BigdataValue[] terms = new BigdataValue[]{SAP, bought, sybase, dcSource, dcCreated, newsSybase, createdDate, g1};
        BigdataURI context = this.store.isQuads() ? g1 : null;
        this.store.addTerms(terms);
        BigdataStatement s0 = vf.createStatement((Resource)SAP, (URI)bought, (Value)sybase, (Resource)context, StatementEnum.Explicit);
        BigdataBNode s1 = vf.createBNode("s1");
        s1.setStatementIdentifier(true);
        SPO spo = new SPO(s0);
        s1.setIV((IV)new SidIV((ISPO)spo));
        BigdataStatement mds1 = vf.createStatement((Resource)s1, (URI)dcSource, (Value)newsSybase, (Resource)context, StatementEnum.Explicit);
        BigdataStatement mds2 = vf.createStatement((Resource)s1, (URI)dcCreated, (Value)createdDate, (Resource)context, StatementEnum.Explicit);
        ISPO[] stmts = new ISPO[]{new SPO(s0), new SPO(mds1), new SPO(mds2)};
        this.store.addStatements(stmts, stmts.length);
        AbstractDataDrivenSPARQLTestCase.TestHelper h = (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-00", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/empty.ttl", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02.srx");
        h.runTest();
    }

    public void test_reificationDoneRight_00_loadDataFromFile() throws Exception {
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-00-loadFromFile", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02.ttlx", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02.srx").runTest();
    }

    public void test_reificationDoneRight_00a() throws Exception {
        BigdataValueFactory vf = this.store.getValueFactory();
        BigdataURI SAP = vf.createURI("http://example.com/SAP");
        BigdataURI bought = vf.createURI("http://example.com/bought");
        BigdataURI sybase = vf.createURI("http://example.com/sybase");
        BigdataURI dcSource = vf.createURI("http://purl.org/dc/terms/source");
        BigdataURI dcCreated = vf.createURI("http://purl.org/dc/terms/created");
        BigdataURI newsSybase = vf.createURI("http://example.com/news/us-sybase");
        BigdataLiteral createdDate = vf.createLiteral("2011-04-05T12:00:00Z", XSD.DATETIME);
        BigdataURI g1 = vf.createURI("http://example.com/g1");
        BigdataValue[] terms = new BigdataValue[]{SAP, bought, sybase, dcSource, dcCreated, newsSybase, createdDate, g1};
        BigdataURI context = this.store.isQuads() ? g1 : null;
        this.store.addTerms(terms);
        BigdataStatement s0 = vf.createStatement((Resource)SAP, (URI)bought, (Value)sybase, (Resource)context, StatementEnum.Explicit);
        BigdataBNode s1 = vf.createBNode("s1");
        s1.setStatementIdentifier(true);
        SPO spo = new SPO(SAP.getIV(), bought.getIV(), sybase.getIV(), null, StatementEnum.Explicit);
        s1.setIV((IV)new SidIV((ISPO)spo));
        BigdataStatement mds1 = vf.createStatement((Resource)s1, (URI)dcSource, (Value)newsSybase, (Resource)context, StatementEnum.Explicit);
        BigdataStatement mds2 = vf.createStatement((Resource)s1, (URI)dcCreated, (Value)createdDate, (Resource)context, StatementEnum.Explicit);
        ISPO[] stmts = new ISPO[]{new SPO(s0), new SPO(mds1), new SPO(mds2)};
        this.store.addStatements(stmts, stmts.length);
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-00a", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02a.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/empty.ttl", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02a.srx").runTest();
    }

    public void test_reificationDoneRight_00a_loadFromFile() throws Exception {
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-00a-loadFromFile", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02a.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02.ttlx", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02a.srx").runTest();
    }

    public void test_reificationDoneRight_01() throws Exception {
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01.ttl", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01.srx").runTest();
    }

    public void test_reificationDoneRight_01_usingRDRData() throws Exception {
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01-usingRDRData", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01.ttlx", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01.srx").runTest();
    }

    public void test_reificationDoneRight_01a() throws Exception {
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01a", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01a.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01.ttl", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01a.srx").runTest();
    }

    public void test_reificationDoneRight_01a_usingRDRData() throws Exception {
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01a-usingRDRData", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01a.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01.ttlx", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-01a.srx").runTest();
    }

    public void test_reificationDoneRight_02() throws Exception {
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02.ttl", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02.srx").runTest();
    }

    public void test_reificationDoneRight_02_usingRDRData() throws Exception {
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02.ttlx", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02.srx").runTest();
    }

    public void test_reificationDoneRight_02a() throws Exception {
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02a", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02a.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02a.ttl", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02a.srx").runTest();
    }

    public void test_reificationDoneRight_02a_usingRDRData() throws Exception {
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02a", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02a.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02a.ttlx", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-02a.srx").runTest();
    }

    public void test_reificationDoneRight_03() throws Exception {
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-03", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-03.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-03.ttl", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-03.srx").runTest();
    }

    public void test_reificationDoneRight_03a() throws Exception {
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-03a", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-03a.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-03a.ttl", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-03a.srx").runTest();
    }

    public void test_reificationDoneRight_04() throws Exception {
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-04", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-04.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-04.ttlx", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-04.srx").runTest();
    }

    public void test_reificationDoneRight_05a() throws Exception {
        if (!BigdataStatics.runKnownBadTests) {
            return;
        }
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-05a", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-05a.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-05.ttl", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-05.srx").runTest();
    }

    public void test_reificationDoneRight_05b() throws Exception {
        (AbstractDataDrivenSPARQLTestCase)this.new AbstractDataDrivenSPARQLTestCase.TestHelper("/com/bigdata/rdf/sparql/ast/eval/reif/rdr-05b", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-05b.rq", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-05.ttl", "/com/bigdata/rdf/sparql/ast/eval/reif/rdr-05.srx").runTest();
    }

    @Override
    public Properties getProperties() {
        Properties properties = (Properties)super.getProperties().clone();
        properties.setProperty(AbstractTripleStore.Options.QUADS, "false");
        properties.setProperty(AbstractTripleStore.Options.STATEMENT_IDENTIFIERS, "true");
        properties.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(Options.BUFFER_MODE, BufferMode.Transient.toString());
        return properties;
    }
}

