/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval.rto;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.bop.joinGraph.rto.JoinGraph;
import com.bigdata.bop.joinGraph.rto.Path;
import com.bigdata.journal.IBTreeManager;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import junit.framework.TestCase;
import org.apache.log4j.Logger;

public class AbstractRTOTestCase
extends AbstractDataDrivenSPARQLTestCase {
    protected static final Logger log = Logger.getLogger(AbstractRTOTestCase.class);

    public AbstractRTOTestCase() {
    }

    public AbstractRTOTestCase(String name) {
        super(name);
    }

    protected void assertSameJoinOrder(int[] expected, AbstractDataDrivenSPARQLTestCase.TestHelper helper) throws Exception {
        this.assertSameJoinOrder(Collections.singletonList(expected), helper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertSameJoinOrder(List<int[]> expectedOrders, AbstractDataDrivenSPARQLTestCase.TestHelper helper) throws Exception {
        IRunningQuery q;
        ASTContainer astContainer;
        UUID queryId = UUID.randomUUID();
        helper.getASTContainer().setQueryHint("queryId", queryId.toString());
        QueryEngine queryEngine = QueryEngineFactory.getInstance().getExistingQueryController((IBTreeManager)helper.getTripleStore().getIndexManager());
        MyQueryListener l = new MyQueryListener(queryId);
        try {
            queryEngine.addListener((QueryEngine.IRunningQueryListener)l);
            astContainer = helper.runTest();
        }
        finally {
            queryEngine.removeListener((QueryEngine.IRunningQueryListener)l);
        }
        PipelineOp queryPlan = astContainer.getQueryPlan();
        JoinGraph joinGraph = (JoinGraph)BOpUtility.getOnly((BOp)queryPlan, JoinGraph.class);
        AbstractRTOTestCase.assertNotNull((Object)joinGraph);
        Path tmp = null;
        Iterator<IRunningQuery> i$ = l.getRunningQueries().iterator();
        while (i$.hasNext() && (tmp = joinGraph.getPath(q = i$.next())) == null) {
        }
        Path path = tmp;
        AbstractRTOTestCase.assertNotNull(path);
        if (log.isInfoEnabled()) {
            log.info((Object)("path=" + path));
        }
        for (int[] expected : expectedOrders) {
            if (!Arrays.equals(expected, path.getVertexIds())) continue;
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("RTO JOIN ORDER");
        sb.append("expectedOrders=(");
        boolean first = true;
        for (int[] expected : expectedOrders) {
            if (!first) {
                sb.append(", ");
                first = false;
            }
            sb.append(" " + Arrays.toString(expected));
        }
        sb.append(", actual=" + Arrays.toString(path.getVertexIds()));
        AbstractRTOTestCase.fail((String)sb.toString());
    }

    protected static class MyQueryListener
    implements QueryEngine.IRunningQueryListener {
        private final UUID queryId;
        private final Set<IRunningQuery> queries = new LinkedHashSet<IRunningQuery>();

        public MyQueryListener(UUID queryId) {
            if (queryId == null) {
                throw new IllegalArgumentException();
            }
            this.queryId = queryId;
        }

        public void notify(IRunningQuery q) {
            this.queries.add(q);
        }

        public Set<IRunningQuery> getRunningQueries() {
            if (this.queries.isEmpty()) {
                TestCase.fail((String)"Not found.");
            }
            return this.queries;
        }
    }
}

