/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval.rto;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sparql.ast.QueryHints;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import com.bigdata.rdf.sparql.ast.eval.rto.AbstractRTOTestCase;
import java.util.LinkedList;
import java.util.Properties;
import junit.framework.AssertionFailedError;

public class TestRTO_BSBM
extends AbstractRTOTestCase {
    public TestRTO_BSBM() {
    }

    public TestRTO_BSBM(String name) {
        super(name);
    }

    @Override
    public Properties getProperties() {
        Properties properties = (Properties)super.getProperties().clone();
        properties.setProperty(BigdataSail.Options.TRIPLES_MODE, "true");
        properties.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        return properties;
    }

    public void test_BSBM_Q1_noSolutions() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper helper = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "rto/BSBM-Q1", "rto/BSBM-Q1.rq", new String[0], "rto/BSBM-Q1-noSolutions.srx");
        this.assertSameJoinOrder(new int[]{2, 1, 3, 4, 5}, helper);
    }

    public void test_BSBM_Q1_pc100() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper helper = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "rto/BSBM-Q1", "rto/BSBM-Q1.rq", "src/test/resources/data/bsbm/dataset_pc100.nt", "rto/BSBM-Q1.srx");
        try {
            this.assertSameJoinOrder(new int[]{2, 4, 1, 3, 5}, helper);
        }
        catch (AssertionFailedError er) {
            log.warn((Object)er);
        }
        this.assertSameJoinOrder(new int[]{3, 2, 4, 1, 5}, helper);
    }

    public void test_BSBM_Q2_pc100() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper helper = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "rto/BSBM-Q2", "rto/BSBM-Q2.rq", "src/test/resources/data/bsbm/dataset_pc100.nt", "rto/BSBM-Q2.srx");
        int[] expected = new int[]{3, 4, 5, 1, 2, 6, 7, 8, 9, 10, 11, 12};
        this.assertSameJoinOrder(expected, helper);
    }

    public void test_BSBM_Q3_pc100() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper helper = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "rto/BSBM-Q3", "rto/BSBM-Q3.rq", "src/test/resources/data/bsbm/dataset_pc100.nt", "rto/BSBM-Q3.srx");
        int[] expected = new int[]{2, 5, 1, 3, 4};
        this.assertSameJoinOrder(expected, helper);
    }

    public void test_BSBM_Q4_pc100() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper helper = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "rto/BSBM-Q4", "rto/BSBM-Q4.rq", "src/test/resources/data/bsbm/dataset_pc100.nt", "rto/BSBM-Q4.srx");
        int[] expected = new int[]{9, 6, 7, 8, 10, 11};
        this.assertSameJoinOrder(expected, helper);
    }

    public void test_BSBM_Q5_pc100() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper helper = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "rto/BSBM-Q5", "rto/BSBM-Q5.rq", "src/test/resources/data/bsbm/dataset_pc100.nt", "rto/BSBM-Q5.srx");
        LinkedList<int[]> expectedOrders = new LinkedList<int[]>();
        expectedOrders.add(new int[]{1, 3, 2, 5, 4, 7, 6});
        expectedOrders.add(new int[]{1, 3, 5, 4, 2, 7, 6});
        this.assertSameJoinOrder(expectedOrders, helper);
    }

    public void test_BSBM_Q7_pc100() throws Exception {
        int[] nArray;
        AbstractDataDrivenSPARQLTestCase.TestHelper helper = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "rto/BSBM-Q7", "rto/BSBM-Q7.rq", "src/test/resources/data/bsbm/dataset_pc100.nt", "rto/BSBM-Q7.srx");
        LinkedList<int[]> expectedOrders = new LinkedList<int[]>();
        if (QueryHints.DEFAULT_PIPELINED_HASH_JOIN) {
            int[] nArray2 = new int[7];
            nArray2[0] = 7;
            nArray2[1] = 6;
            nArray2[2] = 8;
            nArray2[3] = 4;
            nArray2[4] = 5;
            nArray2[5] = 9;
            nArray = nArray2;
            nArray2[6] = 10;
        } else {
            int[] nArray3 = new int[7];
            nArray3[0] = 8;
            nArray3[1] = 7;
            nArray3[2] = 9;
            nArray3[3] = 5;
            nArray3[4] = 6;
            nArray3[5] = 10;
            nArray = nArray3;
            nArray3[6] = 11;
        }
        expectedOrders.add(nArray);
        expectedOrders.add(new int[]{8, 7, 5, 9, 6, 10, 11});
        this.assertSameJoinOrder(expectedOrders, helper);
    }

    public void test_BSBM_Q7b_pc100() throws Exception {
        int[] nArray;
        AbstractDataDrivenSPARQLTestCase.TestHelper helper = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "rto/BSBM-Q7b", "rto/BSBM-Q7b.rq", "src/test/resources/data/bsbm/dataset_pc100.nt", "rto/BSBM-Q7b.srx");
        if (QueryHints.DEFAULT_PIPELINED_HASH_JOIN) {
            int[] nArray2 = new int[4];
            nArray2[0] = 4;
            nArray2[1] = 5;
            nArray2[2] = 6;
            nArray = nArray2;
            nArray2[3] = 7;
        } else {
            int[] nArray3 = new int[4];
            nArray3[0] = 5;
            nArray3[1] = 6;
            nArray3[2] = 7;
            nArray = nArray3;
            nArray3[3] = 8;
        }
        int[] expected = nArray;
        this.assertSameJoinOrder(expected, helper);
    }

    public void test_BSBM_Q8_pc100() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper helper = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "rto/BSBM-Q8", "rto/BSBM-Q8.rq", "src/test/resources/data/bsbm/dataset_pc100.nt", "rto/BSBM-Q8.srx");
        int[] expected = new int[]{1, 3, 2, 4, 5, 6};
        this.assertSameJoinOrder(expected, helper);
    }

    public void test_BSBM_Q10_pc100() throws Exception {
        AbstractDataDrivenSPARQLTestCase.TestHelper helper = new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "rto/BSBM-Q10", "rto/BSBM-Q10.rq", "src/test/resources/data/bsbm/dataset_pc100.nt", "rto/BSBM-Q10.srx");
        int[] expected = new int[]{1, 7, 5, 2, 3, 4, 6};
        this.assertSameJoinOrder(expected, helper);
    }
}

