/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval.service;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.DummyConstantNode;
import com.bigdata.service.geospatial.GeoSpatialDefaultLiteralSerializer;
import com.bigdata.service.geospatial.GeoSpatialSearchException;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class GeoSpatialTestWKTLiteralSerializer
extends GeoSpatialDefaultLiteralSerializer {
    public String[] toComponents(String literalString) {
        if (literalString == null) {
            return new String[0];
        }
        String core = literalString.substring(6, literalString.length() - 1);
        return core.split(",");
    }

    public String fromComponents(Object[] components) {
        if (components == null) {
            return "";
        }
        if (components.length != 2) {
            throw new GeoSpatialSearchException("Expected component string of lenth 2, but was " + components.length);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Point(");
        buf.append(components[0]);
        buf.append(",");
        buf.append(components[1]);
        buf.append(")");
        return buf.toString();
    }

    public IV<?, ?> serializeLocation(BigdataValueFactory vf, Object latitude, Object longitude) {
        StringBuffer buf = new StringBuffer();
        buf.append("Point(");
        buf.append(latitude);
        buf.append(",");
        buf.append(longitude);
        buf.append(")");
        return DummyConstantNode.toDummyIV((BigdataValue)vf.createLiteral(buf.toString(), (URI)new URIImpl("http://www.opengis.net/ont/geosparql#wktLiteral")));
    }
}

