/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval.service;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Options;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.impl.extensions.InvalidGeoSpatialLiteralError;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.service.geospatial.GeoSpatialSearchException;
import java.util.Properties;

public class TestGeoSpatialCorrectRejection
extends AbstractDataDrivenSPARQLTestCase {
    public TestGeoSpatialCorrectRejection() {
    }

    public TestGeoSpatialCorrectRejection(String name) {
        super(name);
    }

    public void testCRWrongDataFormat01() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-wrongdataformat01", "geo-cr-wrongdataformat.rq", "geo-cr-wrongdataformat01.nt", "geo-cr-empty.srx").runTest();
        }
        catch (Throwable e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(InvalidGeoSpatialLiteralError.class.getName()));
            return;
        }
        throw new RuntimeException("Invalid geospatial literal should have been rejected.");
    }

    public void testCRWrongDataFormat02() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-wrongdataformat01", "geo-cr-wrongdataformat.rq", "geo-cr-wrongdataformat01.nt", "geo-cr-empty.srx").runTest();
        }
        catch (Throwable e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(InvalidGeoSpatialLiteralError.class.getName()));
            return;
        }
        throw new RuntimeException("Invalid geospatial literal should have been rejected.");
    }

    public void testCRWrongDataFormat03() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-wrongdataformat03", "geo-cr-wrongdataformat.rq", "geo-cr-wrongdataformat03.nt", "geo-cr-empty.srx").runTest();
        }
        catch (Throwable e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(InvalidGeoSpatialLiteralError.class.getName()));
            return;
        }
        throw new RuntimeException("Invalid geospatial literal should have been rejected.");
    }

    public void testCRMissingTimeStart() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-missingtimestart", "geo-cr-missingtimestart.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRMissingTimeEnd() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-missingtimeend", "geo-cr-missingtimeend.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRUnusableTimeStart() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-unusabletimestart", "geo-cr-unusabletimestart.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRUnusableTimeEnd() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-unusabletimeend", "geo-cr-unusabletimeend.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRMissingCustomFields01() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-missingcustomfields", "geo-cr-missingcustomfields01.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRMissingCustomFields02() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-missingcustomfields", "geo-cr-missingcustomfields02.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRMissingCustomFields03() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-missingcustomfields", "geo-cr-missingcustomfields03.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRMissingCustomFields04() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-missingcustomfields", "geo-cr-missingcustomfields04.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRIncompleteCustomFields() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-incompletecustomfields", "geo-cr-incompletecustomfields.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRUnusableCustomFields() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-unusablecustomfields", "geo-cr-unusablecustomfields.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRTooManyCustomFields() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-toomanycustomfields", "geo-cr-toomanycustomfields.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRMissingGeoFunction() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-missinggeofunction", "geo-cr-missinggeofunction.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRInvalidGeoFunction() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-invalidgeofunction", "geo-cr-invalidgeofunction.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRUnusableGeoFunction() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-unusablegeofunction", "geo-cr-unusablegeofunction.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRMissingCoordSystem() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-missingcoordsystem", "geo-cr-missingcoordsystem.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRUnusableCoordSystem() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-unusablecoordsystem", "geo-cr-unusablecoordsystem.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRInRectangleNoSouthWest() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-inrectanglenosouthwest", "geo-cr-inrectanglenosouthwest.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRInRectangleInvalidSouthWest() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-inrectangleinvalidsouthwest", "geo-cr-inrectangleinvalidsouthwest.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRInRectangleNoNorthEast() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-inrectanglenonortheast", "geo-cr-inrectanglenonortheast.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRInRectangleInvalidNorthEast() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-inrectangleinvalidnortheast", "geo-cr-inrectangleinvalidnortheast.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRInRectangleCenterGiven() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-inrectanglecentergiven", "geo-cr-inrectanglecentergiven.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRInRectangleRadiusGiven() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-inrectangleradiusgiven", "geo-cr-inrectangleradiusgiven.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRInCircleSouthWestGiven() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-incirclesouthwestgiven", "geo-cr-incirclesouthwestgiven.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRInCircleNorthEastGiven() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-incirclenortheastgiven", "geo-cr-incirclenortheastgiven.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRInCircleNoCenterGiven() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-incirclenocentergiven", "geo-cr-incirclenocentergiven.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRInCircleInvalidCenterGiven() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-incircleinvalidcentergiven", "geo-cr-incircleinvalidcentergiven.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRInCircleNoRadiusGiven() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-incirclenoradiusgiven", "geo-cr-incirclenoradiusgiven.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRInCircleInvalidRadiusGiven() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-incircleinvalidradiusgiven", "geo-cr-incircleinvalidradiusgiven.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRLocationValueButNoLocation() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-locationvaluebutnolocation", "geo-cr-locationvaluebutnolocation.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRLocationAndTimeValueButNoLocation() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-locationandtimevaluebutnolocation", "geo-cr-locationandtimevaluebutnolocation.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRLocationAndTimeValueButNoTime() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-locationandtimevaluebutnotime", "geo-cr-locationandtimevaluebutnotime.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRLatValueButNoLocation() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-latvaluebutnolocation", "geo-cr-latvaluebutnolocation.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRLonValueButNoLocation() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-lonvaluebutnolocation", "geo-cr-lonvaluebutnolocation.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRTimeValueButNoTime() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-timevaluebutnotime", "geo-cr-timevaluebutnotime.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRDistanceButNoGeospatialComponent() {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-distancevaluebutnogeospatial", "geo-cr-distancevaluebutnogeospatial.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRDistanceButRectangleQuery() {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-distancevaluebutrectanglequery", "geo-cr-distancevaluebutrectanglequery.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRCustomFieldsValueButNoCustomFields() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-customfieldsvaluebutnocustomfields", "geo-cr-customfieldsvaluebutnocustomfields.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    public void testCRUnknownGeoSpatialDatatype() throws Exception {
        try {
            new AbstractDataDrivenSPARQLTestCase.TestHelper((AbstractDataDrivenSPARQLTestCase)this, "geo-cr-unknowngeospatialdatatype", "geo-cr-unknowngeospatialdatatype.rq", "empty.trig", "geo-cr-empty.srx").runTest();
        }
        catch (Exception e) {
            TestGeoSpatialCorrectRejection.assertTrue((boolean)e.toString().contains(GeoSpatialSearchException.class.getName()));
            return;
        }
        throw new RuntimeException("Expected to run into exception.");
    }

    @Override
    public Properties getProperties() {
        Properties properties = (Properties)super.getProperties().clone();
        properties.setProperty(AbstractTripleStore.Options.QUADS, "false");
        properties.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(Options.BUFFER_MODE, BufferMode.Transient.toString());
        properties.setProperty(AbstractTripleStore.Options.GEO_SPATIAL, "true");
        properties.setProperty(AbstractTripleStore.Options.GEO_SPATIAL_DATATYPE_CONFIG + ".0", "{\"config\": { \"uri\": \"http://my.custom.datatype/x-y-z\", \"fields\": [ { \"valueType\": \"DOUBLE\", \"multiplier\": \"1000\", \"serviceMapping\": \"x\" }, { \"valueType\": \"DOUBLE\", \"multiplier\": \"1000\", \"serviceMapping\": \"y\" }, { \"valueType\": \"DOUBLE\", \"multiplier\": \"1000\", \"serviceMapping\": \"z\" } ]}}");
        properties.setProperty(AbstractTripleStore.Options.GEO_SPATIAL_DATATYPE_CONFIG + ".1", "{\"config\": { \"uri\": \"http://my.custom.datatype/time-x-y-z\", \"fields\": [ { \"valueType\": \"LONG\", \"minVal\" : \"0\", \"multiplier\": \"1\", \"serviceMapping\": \"TIME\" }, { \"valueType\": \"DOUBLE\", \"multiplier\": \"1000\", \"serviceMapping\": \"x\" }, { \"valueType\": \"DOUBLE\", \"multiplier\": \"1000\", \"serviceMapping\": \"y\" }, { \"valueType\": \"DOUBLE\", \"multiplier\": \"1000\", \"serviceMapping\": \"z\" }]}}");
        properties.setProperty(AbstractTripleStore.Options.GEO_SPATIAL_DATATYPE_CONFIG + ".2", "{\"config\": { \"uri\": \"http://my.custom.datatype/x-y-z-lat-lon\", \"fields\": [ { \"valueType\": \"DOUBLE\", \"minVal\" : \"-1000\", \"multiplier\": \"10\", \"serviceMapping\": \"x\" }, { \"valueType\": \"DOUBLE\", \"minVal\" : \"-10\", \"multiplier\": \"100\", \"serviceMapping\": \"y\" }, { \"valueType\": \"DOUBLE\", \"minVal\" : \"-2\", \"multiplier\": \"1000\", \"serviceMapping\": \"z\" }, { \"valueType\": \"DOUBLE\", \"minVal\" : \"0\", \"multiplier\": \"1000000\", \"serviceMapping\": \"LATITUDE\" }, { \"valueType\": \"DOUBLE\", \"minVal\" : \"0\", \"multiplier\": \"100000\", \"serviceMapping\": \"LONGITUDE\" } ]}}");
        properties.setProperty(AbstractTripleStore.Options.GEO_SPATIAL_DATATYPE_CONFIG + ".3", "{\"config\": { \"uri\": \"http://my.custom.datatype/x-y-z-lat-lon-time\", \"fields\": [ { \"valueType\": \"DOUBLE\", \"minVal\" : \"-1000\", \"multiplier\": \"10\", \"serviceMapping\": \"x\" }, { \"valueType\": \"DOUBLE\", \"minVal\" : \"-10\", \"multiplier\": \"100\", \"serviceMapping\": \"y\" }, { \"valueType\": \"DOUBLE\", \"minVal\" : \"-2\", \"multiplier\": \"1000\", \"serviceMapping\": \"z\" }, { \"valueType\": \"DOUBLE\", \"minVal\" : \"0\", \"multiplier\": \"1000000\", \"serviceMapping\": \"LATITUDE\" }, { \"valueType\": \"DOUBLE\", \"minVal\" : \"0\", \"multiplier\": \"100000\", \"serviceMapping\": \"LONGITUDE\" }, { \"valueType\": \"LONG\", \"minVal\" : \"0\", \"multiplier\": \"1\", \"serviceMapping\": \"TIME\" } ]}}");
        properties.setProperty(AbstractTripleStore.Options.GEO_SPATIAL_DATATYPE_CONFIG + ".4", "{\"config\": { \"uri\": \"http://my.custom.datatype/x-y-z-lat-lon-time-coord\", \"fields\": [ { \"valueType\": \"DOUBLE\", \"minVal\" : \"-1000\", \"multiplier\": \"10\", \"serviceMapping\": \"x\" }, { \"valueType\": \"DOUBLE\", \"minVal\" : \"-10\", \"multiplier\": \"100\", \"serviceMapping\": \"y\" }, { \"valueType\": \"DOUBLE\", \"minVal\" : \"-2\", \"multiplier\": \"1000\", \"serviceMapping\": \"z\" }, { \"valueType\": \"DOUBLE\", \"minVal\" : \"0\", \"multiplier\": \"1000000\", \"serviceMapping\": \"LATITUDE\" }, { \"valueType\": \"DOUBLE\", \"minVal\" : \"0\", \"multiplier\": \"100000\", \"serviceMapping\": \"LONGITUDE\" }, { \"valueType\": \"LONG\", \"minVal\" : \"0\", \"multiplier\": \"1\", \"serviceMapping\": \"TIME\" }, { \"valueType\": \"LONG\", \"minVal\" : \"0\", \"multiplier\": \"1\", \"serviceMapping\": \"COORD_SYSTEM\" } ]}}");
        properties.setProperty(AbstractTripleStore.Options.GEO_SPATIAL_DATATYPE_CONFIG + ".5", "{\"config\": { \"uri\": \"http://my.custom.datatype/lat-lon\", \"fields\": [ { \"valueType\": \"DOUBLE\", \"minVal\" : \"0\", \"multiplier\": \"1000000\", \"serviceMapping\": \"LATITUDE\" }, { \"valueType\": \"DOUBLE\", \"minVal\" : \"0\", \"multiplier\": \"100000\", \"serviceMapping\": \"LONGITUDE\" } ]}}");
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, "com.bigdata.rdf.sparql.ast.eval.service.GeoSpatialTestVocabulary");
        return properties;
    }
}

