/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval.service;

import com.bigdata.rdf.internal.impl.extensions.InvalidGeoSpatialDatatypeConfigurationError;
import com.bigdata.rdf.sparql.ast.eval.AbstractDataDrivenSPARQLTestCase;
import com.bigdata.service.geospatial.GeoSpatialConfig;
import com.bigdata.service.geospatial.GeoSpatialDatatypeConfiguration;
import com.bigdata.service.geospatial.GeoSpatialDatatypeFieldConfiguration;
import java.util.ArrayList;
import java.util.List;

public class TestGeoSpatialServiceConfigurationParsing
extends AbstractDataDrivenSPARQLTestCase {
    public TestGeoSpatialServiceConfigurationParsing() {
    }

    public TestGeoSpatialServiceConfigurationParsing(String name) {
        super(name);
    }

    public void testAcceptSingleDatatypeConfig() {
        String config1Uri = "http://my.custom.datatype1.uri";
        String config1 = this.sampleConfigComplete("http://my.custom.datatype1.uri");
        ArrayList<String> datatypeConfigs = new ArrayList<String>();
        datatypeConfigs.add(config1);
        GeoSpatialConfig conf = new GeoSpatialConfig(datatypeConfigs, "http://my.custom.datatype1.uri");
        List parsedDatatypeConfigs = conf.getDatatypeConfigs();
        TestGeoSpatialServiceConfigurationParsing.assertEquals((int)parsedDatatypeConfigs.size(), (int)1);
        GeoSpatialDatatypeConfiguration parsedDatatypeConfig = (GeoSpatialDatatypeConfiguration)parsedDatatypeConfigs.get(0);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((String)parsedDatatypeConfig.getUri().stringValue(), (String)"http://my.custom.datatype1.uri");
        List fields = parsedDatatypeConfig.getFields();
        TestGeoSpatialServiceConfigurationParsing.assertEquals((int)fields.size(), (int)5);
        GeoSpatialDatatypeFieldConfiguration field0 = (GeoSpatialDatatypeFieldConfiguration)fields.get(0);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field0.getValueType(), (Object)GeoSpatialDatatypeFieldConfiguration.ValueType.DOUBLE);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((long)field0.getMultiplier(), (long)100000L);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field0.getMinValue(), null);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field0.getServiceMapping(), (Object)GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LATITUDE);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((String)field0.getCustomServiceMapping(), null);
        GeoSpatialDatatypeFieldConfiguration field1 = (GeoSpatialDatatypeFieldConfiguration)fields.get(1);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field1.getValueType(), (Object)GeoSpatialDatatypeFieldConfiguration.ValueType.DOUBLE);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((long)field1.getMultiplier(), (long)100000L);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field1.getMinValue(), null);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field1.getServiceMapping(), (Object)GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LONGITUDE);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((String)field1.getCustomServiceMapping(), null);
        GeoSpatialDatatypeFieldConfiguration field2 = (GeoSpatialDatatypeFieldConfiguration)fields.get(2);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field2.getValueType(), (Object)GeoSpatialDatatypeFieldConfiguration.ValueType.LONG);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((long)field2.getMultiplier(), (long)1L);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field2.getMinValue(), (Object)0L);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field2.getServiceMapping(), (Object)GeoSpatialDatatypeFieldConfiguration.ServiceMapping.TIME);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((String)field2.getCustomServiceMapping(), null);
        GeoSpatialDatatypeFieldConfiguration field3 = (GeoSpatialDatatypeFieldConfiguration)fields.get(3);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field3.getValueType(), (Object)GeoSpatialDatatypeFieldConfiguration.ValueType.LONG);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((long)field3.getMultiplier(), (long)1L);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field3.getMinValue(), (Object)1L);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field3.getServiceMapping(), (Object)GeoSpatialDatatypeFieldConfiguration.ServiceMapping.COORD_SYSTEM);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((String)field3.getCustomServiceMapping(), null);
        GeoSpatialDatatypeFieldConfiguration field4 = (GeoSpatialDatatypeFieldConfiguration)fields.get(4);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field4.getValueType(), (Object)GeoSpatialDatatypeFieldConfiguration.ValueType.DOUBLE);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((long)field4.getMultiplier(), (long)5L);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field4.getMinValue(), (Object)2L);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field4.getServiceMapping(), (Object)GeoSpatialDatatypeFieldConfiguration.ServiceMapping.CUSTOM);
        TestGeoSpatialServiceConfigurationParsing.assertEquals((String)field4.getCustomServiceMapping(), (String)"myCustomMappingStr");
    }

    public void testAcceptMultipleDatatypeConfigs() {
        String config1Uri = "http://my.custom.datatype1.uri";
        String config2Uri = "http://my.custom.datatype2.uri";
        String config3Uri = "http://my.custom.datatype3.uri";
        String config1 = this.sampleConfigComplete("http://my.custom.datatype1.uri");
        String config2 = this.sampleConfigComplete("http://my.custom.datatype2.uri");
        String config3 = this.sampleConfigComplete("http://my.custom.datatype3.uri");
        ArrayList<String> datatypeConfigs = new ArrayList<String>();
        datatypeConfigs.add(config1);
        datatypeConfigs.add(config2);
        datatypeConfigs.add(config3);
        GeoSpatialConfig conf = new GeoSpatialConfig(datatypeConfigs, "http://my.custom.datatype1.uri");
        List parsedDatatypeConfigs = conf.getDatatypeConfigs();
        TestGeoSpatialServiceConfigurationParsing.assertEquals((int)parsedDatatypeConfigs.size(), (int)3);
        for (int i = 0; i < parsedDatatypeConfigs.size(); ++i) {
            GeoSpatialDatatypeConfiguration parsedDatatypeConfig = (GeoSpatialDatatypeConfiguration)parsedDatatypeConfigs.get(i);
            if (i == 0) {
                TestGeoSpatialServiceConfigurationParsing.assertEquals((String)parsedDatatypeConfig.getUri().stringValue(), (String)"http://my.custom.datatype1.uri");
            } else if (i == 1) {
                TestGeoSpatialServiceConfigurationParsing.assertEquals((String)parsedDatatypeConfig.getUri().stringValue(), (String)"http://my.custom.datatype2.uri");
            } else if (i == 2) {
                TestGeoSpatialServiceConfigurationParsing.assertEquals((String)parsedDatatypeConfig.getUri().stringValue(), (String)"http://my.custom.datatype3.uri");
            }
            List fields = parsedDatatypeConfig.getFields();
            TestGeoSpatialServiceConfigurationParsing.assertEquals((int)fields.size(), (int)5);
            GeoSpatialDatatypeFieldConfiguration field0 = (GeoSpatialDatatypeFieldConfiguration)fields.get(0);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field0.getValueType(), (Object)GeoSpatialDatatypeFieldConfiguration.ValueType.DOUBLE);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((long)field0.getMultiplier(), (long)100000L);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field0.getMinValue(), null);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field0.getServiceMapping(), (Object)GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LATITUDE);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((String)field0.getCustomServiceMapping(), null);
            GeoSpatialDatatypeFieldConfiguration field1 = (GeoSpatialDatatypeFieldConfiguration)fields.get(1);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field1.getValueType(), (Object)GeoSpatialDatatypeFieldConfiguration.ValueType.DOUBLE);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((long)field1.getMultiplier(), (long)100000L);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field1.getMinValue(), null);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field1.getServiceMapping(), (Object)GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LONGITUDE);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((String)field1.getCustomServiceMapping(), null);
            GeoSpatialDatatypeFieldConfiguration field2 = (GeoSpatialDatatypeFieldConfiguration)fields.get(2);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field2.getValueType(), (Object)GeoSpatialDatatypeFieldConfiguration.ValueType.LONG);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((long)field2.getMultiplier(), (long)1L);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field2.getMinValue(), (Object)0L);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field2.getServiceMapping(), (Object)GeoSpatialDatatypeFieldConfiguration.ServiceMapping.TIME);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((String)field2.getCustomServiceMapping(), null);
            GeoSpatialDatatypeFieldConfiguration field3 = (GeoSpatialDatatypeFieldConfiguration)fields.get(3);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field3.getValueType(), (Object)GeoSpatialDatatypeFieldConfiguration.ValueType.LONG);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((long)field3.getMultiplier(), (long)1L);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field3.getMinValue(), (Object)1L);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field3.getServiceMapping(), (Object)GeoSpatialDatatypeFieldConfiguration.ServiceMapping.COORD_SYSTEM);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((String)field3.getCustomServiceMapping(), null);
            GeoSpatialDatatypeFieldConfiguration field4 = (GeoSpatialDatatypeFieldConfiguration)fields.get(4);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field4.getValueType(), (Object)GeoSpatialDatatypeFieldConfiguration.ValueType.DOUBLE);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((long)field4.getMultiplier(), (long)5L);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field4.getMinValue(), (Object)2L);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((Object)field4.getServiceMapping(), (Object)GeoSpatialDatatypeFieldConfiguration.ServiceMapping.CUSTOM);
            TestGeoSpatialServiceConfigurationParsing.assertEquals((String)field4.getCustomServiceMapping(), (String)"myCustomMappingStr");
        }
    }

    public void testRejectConfigWithNoFields() {
        String config1Uri = "http://my.custom.datatype1.uri";
        String config1 = this.sampleConfigNoFields("http://my.custom.datatype1.uri");
        ArrayList<String> datatypeConfigs = new ArrayList<String>();
        datatypeConfigs.add(config1);
        try {
            new GeoSpatialConfig(datatypeConfigs, "http://my.custom.datatype1.uri");
        }
        catch (InvalidGeoSpatialDatatypeConfigurationError e) {
            return;
        }
        throw new RuntimeException("Expected to run into exception, but did not.");
    }

    public void testRejectSyntacticallyInvalidConfig() {
        String config1Uri = "http://my.custom.datatype1.uri";
        String config1 = this.sampleConfigSyntacticallyInvalid("http://my.custom.datatype1.uri");
        ArrayList<String> datatypeConfigs = new ArrayList<String>();
        datatypeConfigs.add(config1);
        try {
            new GeoSpatialConfig(datatypeConfigs, "http://my.custom.datatype1.uri");
        }
        catch (IllegalArgumentException e) {
            return;
        }
        throw new RuntimeException("Expected to run into exception, but did not.");
    }

    public void testRejectMissingDatatypeConfiguration() {
        String configUri = "http://my.custom.datatype1.uri";
        String config = this.sampleConfigWithMissingValueType("http://my.custom.datatype1.uri");
        ArrayList<String> datatypeConfigs = new ArrayList<String>();
        datatypeConfigs.add(config);
        try {
            new GeoSpatialConfig(datatypeConfigs, "http://my.custom.datatype1.uri");
        }
        catch (InvalidGeoSpatialDatatypeConfigurationError e) {
            return;
        }
        throw new RuntimeException("Expected to run into exception, but did not.");
    }

    public void testRejectMissingServiceMappingConfiguration() {
        String configUri = "http://my.custom.datatype1.uri";
        String config = this.sampleConfigWithMissingServiceMapping("http://my.custom.datatype1.uri");
        ArrayList<String> datatypeConfigs = new ArrayList<String>();
        datatypeConfigs.add(config);
        try {
            new GeoSpatialConfig(datatypeConfigs, "http://my.custom.datatype1.uri");
        }
        catch (InvalidGeoSpatialDatatypeConfigurationError e) {
            return;
        }
        throw new RuntimeException("Expected to run into exception, but did not.");
    }

    public void testRejectMappingConflict() {
        String configUri = "http://my.custom.datatype1.uri";
        String config = this.sampleConfigWithMappingConflict("http://my.custom.datatype1.uri");
        ArrayList<String> datatypeConfigs = new ArrayList<String>();
        datatypeConfigs.add(config);
        try {
            new GeoSpatialConfig(datatypeConfigs, "http://my.custom.datatype1.uri");
        }
        catch (InvalidGeoSpatialDatatypeConfigurationError e) {
            return;
        }
        throw new RuntimeException("Expected to run into exception, but did not.");
    }

    public void testRejectInvalidUri() {
        String configUri = "this is not a valid uri";
        String config = this.sampleConfigWithMappingConflict("this is not a valid uri");
        ArrayList<String> datatypeConfigs = new ArrayList<String>();
        datatypeConfigs.add(config);
        try {
            new GeoSpatialConfig(datatypeConfigs, "this is not a valid uri");
        }
        catch (InvalidGeoSpatialDatatypeConfigurationError e) {
            return;
        }
        throw new RuntimeException("Expected to run into exception, but did not.");
    }

    public void testRejectUriConflict() {
        String configUri = "http://my.custom.datatype1.uri";
        String config1 = this.sampleConfigWithMappingConflict("http://my.custom.datatype1.uri");
        String config2 = this.sampleConfigWithMappingConflict("http://my.custom.datatype1.uri");
        ArrayList<String> datatypeConfigs = new ArrayList<String>();
        datatypeConfigs.add(config1);
        datatypeConfigs.add(config2);
        try {
            new GeoSpatialConfig(datatypeConfigs, "http://my.custom.datatype1.uri");
        }
        catch (InvalidGeoSpatialDatatypeConfigurationError e) {
            return;
        }
        throw new RuntimeException("Expected to run into exception, but did not.");
    }

    String sampleConfigComplete(String uri) {
        String config = "{\"config\": { \"uri\": \"" + uri + "\", " + "  \"fields\": [ " + "    { \"valueType\": \"DOUBLE\", \"multiplier\": \"100000\", \"serviceMapping\": \"LATITUDE\" }, " + "    { \"valueType\": \"DOUBLE\", \"multiplier\": \"100000\", \"serviceMapping\": \"LONGITUDE\" }, " + "    { \"valueType\": \"LONG\", \"multiplier\": \"1\", \"minValue\" : \"0\" , \"serviceMapping\": \"TIME\"  }, " + "    { \"valueType\": \"LONG\", \"multiplier\": \"1\", \"minValue\" : \"1\" , \"serviceMapping\" : \"COORD_SYSTEM\"  }, " + "    { \"valueType\": \"DOUBLE\", \"multiplier\": \"5\", \"minValue\" : \"2\" , \"serviceMapping\" : \"myCustomMappingStr\"  } " + "  ]" + " }" + "}";
        return config;
    }

    String sampleConfigNoFields(String uri) {
        String config = "{\"config\": { \"uri\": \"" + uri + "\", " + "  \"fields\": [] " + " }" + "}";
        return config;
    }

    String sampleConfigSyntacticallyInvalid(String uri) {
        String config = "{\"config\": { \"uri\": \"" + uri + "\", " + "  \"fields\": " + "    { \"valueType\": \"DOUBLE\", \"multiplier\": \"100000\", \"serviceMapping\": \"LATITUDE\" }, " + "    { \"valueType\": \"DOUBLE\", \"multiplier\": \"100000\", \"serviceMapping\": \"LONGITUDE\" }, " + "    { \"valueType\": \"LONG\", \"multiplier\": \"1\", \"minValue\" : \"0\" , \"serviceMapping\": \"TIME\"  }, " + "    { \"valueType\": \"LONG\", \"multiplier\": \"1\", \"minValue\" : \"1\" , \"serviceMapping\" : \"COORD_SYSTEM\"  }, " + "    { \"valueType\": \"DOUBLE\", \"multiplier\": \"5\", \"minValue\" : \"2\" , \"serviceMapping\" : \"myCustomMappingStr\"  } " + "  ]" + " }" + "}";
        return config;
    }

    String sampleConfigWithMappingConflict(String uri) {
        String config = "{\"config\": { \"uri\": \"" + uri + "\", " + "  \"fields\": [ " + "    { \"valueType\": \"DOUBLE\", \"multiplier\": \"100000\", \"serviceMapping\": \"LATITUDE\" }, " + "    { \"valueType\": \"DOUBLE\", \"multiplier\": \"100000\", \"serviceMapping\": \"LONGITUDE\" }, " + "    { \"valueType\": \"LONG\", \"multiplier\": \"1\", \"minValue\" : \"0\" , \"serviceMapping\": \"LATITUDE\"  }, " + "    { \"valueType\": \"LONG\", \"multiplier\": \"1\", \"minValue\" : \"1\" , \"serviceMapping\" : \"COORD_SYSTEM\"  }, " + "    { \"valueType\": \"DOUBLE\", \"multiplier\": \"5\", \"minValue\" : \"2\" , \"serviceMapping\" : \"myCustomMappingStr\"  } " + "  ]" + " }" + "}";
        return config;
    }

    String sampleConfigWithMissingValueType(String uri) {
        String config = "{\"config\": { \"uri\": \"" + uri + "\", " + "  \"fields\": [ " + "    { \"multiplier\": \"100000\", \"serviceMapping\": \"LATITUDE\" } " + "  ]" + " }" + "}";
        return config;
    }

    String sampleConfigWithMissingServiceMapping(String uri) {
        String config = "{\"config\": { \"uri\": \"" + uri + "\", " + "  \"fields\": [ " + "    { \"valueType\": \"DOUBLE\", \"multiplier\": \"100000\" } " + "  ]" + " }" + "}";
        return config;
    }
}

