/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval.service;

import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.sparql.PrefixDeclProcessor;
import com.bigdata.rdf.sparql.AbstractBigdataExprBuilderTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.service.IRemoteSparqlQueryBuilder;
import com.bigdata.rdf.sparql.ast.service.RemoteSparql10QueryBuilder;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.vocabulary.DC;
import org.openrdf.query.BindingSet;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.impl.MapBindingSet;

public class TestRemoteSparql10QueryBuilder
extends AbstractBigdataExprBuilderTestCase {
    public TestRemoteSparql10QueryBuilder() {
    }

    public TestRemoteSparql10QueryBuilder(String name) {
        super(name);
    }

    protected IRemoteSparqlQueryBuilder newFixture(ServiceNode serviceNode, BindingSet[] a) {
        return new RemoteSparql10QueryBuilder(serviceNode);
    }

    private void addResolveIVs(BigdataValue ... values) {
        this.tripleStore.getLexiconRelation().addTerms(values, values.length, false);
        for (BigdataValue v : values) {
            v.getIV().setValue(v);
        }
    }

    public void test_service_001() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("foo", "http://www.bigdata.com/foo");
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList bindingSets = new LinkedList();
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql10QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_001b() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("foo", "http://www.bigdata.com/foo");
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        bindingSets.add(new MapBindingSet());
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql10QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_002() throws Exception {
        BigdataURI dcCreator = this.valueFactory.asValue(DC.CREATOR);
        BigdataURI book1 = this.valueFactory.createURI("http://example.org/book/book1");
        BigdataURI book2 = this.valueFactory.createURI("http://example.org/book/book2");
        BigdataURI author1 = this.valueFactory.createURI("http://example.org/author/author1");
        BigdataURI author2 = this.valueFactory.createURI("http://example.org/author/author2");
        this.addResolveIVs(new BigdataValue[]{dcCreator, book1, book2, author1, author2});
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("foo", "http://www.bigdata.com/foo");
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        bset.addBinding("s", (Value)book1);
        bset.addBinding("p", (Value)DC.CREATOR);
        bset.addBinding("o", (Value)author1);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("s", (Value)book2);
        bset.addBinding("p", (Value)DC.CREATOR);
        bset.addBinding("o", (Value)author2);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union = new UnionNode();
        whereClause.addChild((IGroupMemberNode)union);
        JoinGroupNode graphPattern = new JoinGroupNode();
        union.addChild(graphPattern);
        graphPattern.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new ConstantNode(book1.getIV()))));
        graphPattern.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("p"), (ValueExpressionNode)new ConstantNode(dcCreator.getIV()))));
        graphPattern.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("o"), (ValueExpressionNode)new ConstantNode(author1.getIV()))));
        graphPattern.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        graphPattern = new JoinGroupNode();
        union.addChild(graphPattern);
        graphPattern.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new ConstantNode(book2.getIV()))));
        graphPattern.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("p"), (ValueExpressionNode)new ConstantNode(dcCreator.getIV()))));
        graphPattern.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("o"), (ValueExpressionNode)new ConstantNode(author2.getIV()))));
        graphPattern.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql10QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_003() throws Exception {
        BigdataURI dcCreator = this.valueFactory.asValue(DC.CREATOR);
        BigdataURI book1 = this.valueFactory.createURI("http://example.org/book/book1");
        BigdataURI book2 = this.valueFactory.createURI("http://example.org/book/book2");
        BigdataLiteral book3 = this.valueFactory.createLiteral("Semantic Web Primer");
        BigdataLiteral book4 = this.valueFactory.createLiteral("Semantic Web Primer", "DE");
        BigdataLiteral book5 = this.valueFactory.createLiteral("12", XSD.INT);
        BigdataLiteral book6 = this.valueFactory.createLiteral("true", XSD.BOOLEAN);
        this.addResolveIVs(new BigdataValue[]{dcCreator, book1, book2, book3, book4, book5, book6});
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("book")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?book ?p ?o}";
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("", "http://example.org/book/");
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"book"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        bset.addBinding("book", (Value)book1);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("book", (Value)book2);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("book", (Value)book3);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("book", (Value)book4);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("book", (Value)book5);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("book", (Value)book6);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("book"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union = new UnionNode();
        whereClause.addChild((IGroupMemberNode)union);
        JoinGroupNode graphPattern = new JoinGroupNode();
        union.addChild(graphPattern);
        graphPattern.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("book"), (ValueExpressionNode)new ConstantNode(book1.getIV()))));
        graphPattern.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        graphPattern = new JoinGroupNode();
        union.addChild(graphPattern);
        graphPattern.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("book"), (ValueExpressionNode)new ConstantNode(book2.getIV()))));
        graphPattern.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        graphPattern = new JoinGroupNode();
        union.addChild(graphPattern);
        graphPattern.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("book"), (ValueExpressionNode)new ConstantNode(book3.getIV()))));
        graphPattern.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        graphPattern = new JoinGroupNode();
        union.addChild(graphPattern);
        graphPattern.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("book"), (ValueExpressionNode)new ConstantNode(book4.getIV()))));
        graphPattern.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        graphPattern = new JoinGroupNode();
        union.addChild(graphPattern);
        graphPattern.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("book"), (ValueExpressionNode)new ConstantNode(book5.getIV()))));
        graphPattern.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        graphPattern = new JoinGroupNode();
        union.addChild(graphPattern);
        graphPattern.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("book"), (ValueExpressionNode)new ConstantNode(book6.getIV()))));
        graphPattern.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql10QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_004() throws Exception {
        BigdataBNode bnd1 = this.valueFactory.createBNode("abc");
        this.addResolveIVs(new BigdataValue[]{bnd1});
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        bset.addBinding("s", (Value)new BNodeImpl("abc"));
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql10QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_005() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        BNodeImpl tmp = new BNodeImpl("abc");
        bset.addBinding("s", (Value)tmp);
        bset.addBinding("o", (Value)tmp);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"))));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql10QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_006() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o1")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o . ?s ?p ?o1 }";
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        projectedVars.add(Var.var((String)"o1"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        BNodeImpl tmp = new BNodeImpl("abc");
        bset.addBinding("s", (Value)tmp);
        bset.addBinding("o", (Value)tmp);
        bset.addBinding("o1", (Value)tmp);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        projection.addProjectionVar(new VarNode("o1"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.AND((ValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o")), (ValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o1")))));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql10QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_007() throws Exception {
        BigdataLiteral book1 = this.valueFactory.createLiteral("Semantic Web Primer");
        this.addResolveIVs(new BigdataValue[]{book1});
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        BNodeImpl tmp = new BNodeImpl("abc");
        bset.addBinding("s", (Value)tmp);
        bset.addBinding("o", (Value)tmp);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("s", (Value)book1);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union = new UnionNode();
        whereClause.addChild((IGroupMemberNode)union);
        JoinGroupNode joinGroup = new JoinGroupNode();
        union.addChild(joinGroup);
        joinGroup.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"))));
        joinGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        joinGroup = new JoinGroupNode();
        union.addChild(joinGroup);
        joinGroup.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new ConstantNode(book1.getIV()))));
        joinGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql10QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_008() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        BNodeImpl tmp = new BNodeImpl("abc");
        bset.addBinding("s", (Value)tmp);
        bset.addBinding("o", (Value)tmp);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        BNodeImpl tmp1 = new BNodeImpl("foo");
        BNodeImpl tmp2 = new BNodeImpl("bar");
        bset.addBinding("s", (Value)tmp1);
        bset.addBinding("o", (Value)tmp2);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause);
        UnionNode union = new UnionNode();
        whereClause.addChild((IGroupMemberNode)union);
        JoinGroupNode joinGroup = new JoinGroupNode();
        union.addChild(joinGroup);
        joinGroup.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"))));
        joinGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        joinGroup = new JoinGroupNode();
        union.addChild(joinGroup);
        joinGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql10QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }
}

