/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval.service;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.sparql.PrefixDeclProcessor;
import com.bigdata.rdf.sparql.AbstractBigdataExprBuilderTestCase;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.service.IRemoteSparqlQueryBuilder;
import com.bigdata.rdf.sparql.ast.service.RemoteSparql11QueryBuilder;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.DC;
import org.openrdf.query.BindingSet;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.impl.MapBindingSet;

public class TestRemoteSparql11QueryBuilder
extends AbstractBigdataExprBuilderTestCase {
    private static final Logger log = Logger.getLogger(TestRemoteSparql11QueryBuilder.class);

    public TestRemoteSparql11QueryBuilder() {
    }

    public TestRemoteSparql11QueryBuilder(String name) {
        super(name);
    }

    protected IRemoteSparqlQueryBuilder newFixture(ServiceNode serviceNode, BindingSet[] a) {
        return new RemoteSparql11QueryBuilder(serviceNode);
    }

    private void addResolveIVs(BigdataValue ... values) {
        this.tripleStore.getLexiconRelation().addTerms(values, values.length, false);
        for (BigdataValue v : values) {
            v.getIV().setValue(v);
        }
    }

    private IConstant<?> asConstant(IV<?, ?> iv) {
        return new Constant(iv);
    }

    public void test_service_001() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("foo", "http://www.bigdata.com/foo");
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList bindingSets = new LinkedList();
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        if (queryStr.toUpperCase().indexOf("BINDINGS") != -1) {
            TestRemoteSparql11QueryBuilder.fail((String)"BINDINGS clause should be suppressed.");
        }
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql11QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_001b() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("foo", "http://www.bigdata.com/foo");
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        bindingSets.add(new MapBindingSet());
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        if (queryStr.toUpperCase().indexOf("BINDINGS") != -1) {
            TestRemoteSparql11QueryBuilder.fail((String)"BINDINGS clause should be suppressed.");
        }
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql11QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_002() throws Exception {
        BigdataURI dcCreator = this.valueFactory.asValue(DC.CREATOR);
        BigdataURI book1 = this.valueFactory.createURI("http://example.org/book/book1");
        BigdataURI book2 = this.valueFactory.createURI("http://example.org/book/book2");
        BigdataURI author1 = this.valueFactory.createURI("http://example.org/author/author1");
        BigdataURI author2 = this.valueFactory.createURI("http://example.org/author/author2");
        this.addResolveIVs(new BigdataValue[]{dcCreator, book1, book2, author1, author2});
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("foo", "http://www.bigdata.com/foo");
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        bset.addBinding("s", (Value)book1);
        bset.addBinding("p", (Value)DC.CREATOR);
        bset.addBinding("o", (Value)author1);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("s", (Value)book2);
        bset.addBinding("p", (Value)DC.CREATOR);
        bset.addBinding("o", (Value)author2);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        LinkedHashSet<Var> vars = new LinkedHashSet<Var>();
        LinkedList<ListBindingSet> solutionsIn = new LinkedList<ListBindingSet>();
        BindingsClause bindingsClause = new BindingsClause(vars, solutionsIn);
        expected.setBindingsClause(bindingsClause);
        vars.add(Var.var((String)"s"));
        vars.add(Var.var((String)"p"));
        vars.add(Var.var((String)"o"));
        ListBindingSet bset2 = new ListBindingSet();
        bset2.set((IVariable)Var.var((String)"s"), this.asConstant(book1.getIV()));
        bset2.set((IVariable)Var.var((String)"p"), this.asConstant(dcCreator.getIV()));
        bset2.set((IVariable)Var.var((String)"o"), this.asConstant(author1.getIV()));
        solutionsIn.add(bset2);
        bset2 = new ListBindingSet();
        bset2.set((IVariable)Var.var((String)"s"), this.asConstant(book2.getIV()));
        bset2.set((IVariable)Var.var((String)"p"), this.asConstant(dcCreator.getIV()));
        bset2.set((IVariable)Var.var((String)"o"), this.asConstant(author2.getIV()));
        solutionsIn.add(bset2);
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql11QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_003() throws Exception {
        BigdataURI dcCreator = this.valueFactory.asValue(DC.CREATOR);
        BigdataURI book1 = this.valueFactory.createURI("http://example.org/book/book1");
        BigdataURI book2 = this.valueFactory.createURI("http://example.org/book/book2");
        BigdataLiteral book3 = this.valueFactory.createLiteral("Semantic Web Primer");
        BigdataLiteral book4 = this.valueFactory.createLiteral("Semantic Web Primer", "DE");
        BigdataLiteral book5 = this.valueFactory.createLiteral("12", XSD.INT);
        BigdataLiteral book6 = this.valueFactory.createLiteral("true", XSD.BOOLEAN);
        this.addResolveIVs(new BigdataValue[]{dcCreator, book1, book2, book3, book4, book5, book6});
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("book")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?book ?p ?o}";
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>(PrefixDeclProcessor.defaultDecls);
        prefixDecls.put("", "http://example.org/book/");
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"book"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        bset.addBinding("book", (Value)book1);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("book", (Value)book2);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("book", (Value)book3);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("book", (Value)book4);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("book", (Value)book5);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("book", (Value)book6);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("book"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("book"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        LinkedHashSet<Var> vars = new LinkedHashSet<Var>();
        LinkedList<ListBindingSet> solutionsIn = new LinkedList<ListBindingSet>();
        BindingsClause bindingsClause = new BindingsClause(vars, solutionsIn);
        expected.setBindingsClause(bindingsClause);
        vars.add(Var.var((String)"book"));
        ListBindingSet bset2 = new ListBindingSet();
        bset2.set((IVariable)Var.var((String)"book"), this.asConstant(book1.getIV()));
        solutionsIn.add(bset2);
        bset2 = new ListBindingSet();
        bset2.set((IVariable)Var.var((String)"book"), this.asConstant(book2.getIV()));
        solutionsIn.add(bset2);
        bset2 = new ListBindingSet();
        bset2.set((IVariable)Var.var((String)"book"), this.asConstant(book3.getIV()));
        solutionsIn.add(bset2);
        bset2 = new ListBindingSet();
        bset2.set((IVariable)Var.var((String)"book"), this.asConstant(book4.getIV()));
        solutionsIn.add(bset2);
        bset2 = new ListBindingSet();
        bset2.set((IVariable)Var.var((String)"book"), this.asConstant(book5.getIV()));
        solutionsIn.add(bset2);
        bset2 = new ListBindingSet();
        bset2.set((IVariable)Var.var((String)"book"), this.asConstant(book6.getIV()));
        solutionsIn.add(bset2);
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql11QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_004() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        bset.addBinding("s", (Value)new BNodeImpl("abc"));
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        LinkedHashSet<Var> vars = new LinkedHashSet<Var>();
        LinkedList<ListBindingSet> solutionsIn = new LinkedList<ListBindingSet>();
        BindingsClause bindingsClause = new BindingsClause(vars, solutionsIn);
        expected.setBindingsClause(bindingsClause);
        vars.add(Var.var((String)"s"));
        ListBindingSet bset2 = new ListBindingSet();
        solutionsIn.add(bset2);
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql11QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_005() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        BNodeImpl tmp = new BNodeImpl("abc");
        bset.addBinding("s", (Value)tmp);
        bset.addBinding("o", (Value)tmp);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o"))));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        LinkedHashSet<Var> vars = new LinkedHashSet<Var>();
        LinkedList<ListBindingSet> solutionsIn = new LinkedList<ListBindingSet>();
        BindingsClause bindingsClause = new BindingsClause(vars, solutionsIn);
        expected.setBindingsClause(bindingsClause);
        vars.add(Var.var((String)"s"));
        vars.add(Var.var((String)"o"));
        ListBindingSet bset2 = new ListBindingSet();
        solutionsIn.add(bset2);
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql11QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_006() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o1")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o . ?s ?p ?o1 }";
        LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        projectedVars.add(Var.var((String)"o1"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        BNodeImpl tmp = new BNodeImpl("abc");
        bset.addBinding("s", (Value)tmp);
        bset.addBinding("o", (Value)tmp);
        bset.addBinding("o1", (Value)tmp);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
        String queryStr = fixture.getSparqlQuery(a);
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        expected.setPrefixDecls(prefixDecls);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("o"));
        projection.addProjectionVar(new VarNode("o1"));
        expected.setProjection(projection);
        JoinGroupNode whereClause = new JoinGroupNode();
        whereClause.addChild((IGroupMemberNode)new FilterNode((IValueExpressionNode)FunctionNode.AND((ValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o")), (ValueExpressionNode)FunctionNode.sameTerm((ValueExpressionNode)new VarNode("s"), (ValueExpressionNode)new VarNode("o1")))));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        whereClause.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o1"), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
        expected.setWhereClause((GraphPatternGroup)whereClause);
        LinkedHashSet<Var> vars = new LinkedHashSet<Var>();
        LinkedList<ListBindingSet> solutionsIn = new LinkedList<ListBindingSet>();
        BindingsClause bindingsClause = new BindingsClause(vars, solutionsIn);
        expected.setBindingsClause(bindingsClause);
        vars.add(Var.var((String)"s"));
        vars.add(Var.var((String)"o"));
        vars.add(Var.var((String)"o1"));
        ListBindingSet bset2 = new ListBindingSet();
        solutionsIn.add(bset2);
        QueryRoot actual = this.parse(queryStr, this.baseURI);
        TestRemoteSparql11QueryBuilder.assertSameAST(queryStr, (IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_service_007() throws Exception {
        block2: {
            BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
            JoinGroupNode groupNode = new JoinGroupNode();
            groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
            String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
            LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
            ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
            LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
            projectedVars.add(Var.var((String)"s"));
            projectedVars.add(Var.var((String)"p"));
            projectedVars.add(Var.var((String)"o"));
            serviceNode.setExprImage(exprImage);
            serviceNode.setPrefixDecls(prefixDecls);
            serviceNode.setProjectedVars(projectedVars);
            LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
            MapBindingSet bset = new MapBindingSet();
            BNodeImpl tmp = new BNodeImpl("abc");
            bset.addBinding("s", (Value)tmp);
            bset.addBinding("o", (Value)tmp);
            bindingSets.add(bset);
            bset = new MapBindingSet();
            bset.addBinding("s", (Value)new LiteralImpl("Semantic Web Primer"));
            bindingSets.add(bset);
            BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
            try {
                IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
                fixture.getSparqlQuery(a);
                TestRemoteSparql11QueryBuilder.fail((String)("Expecting: " + UnsupportedOperationException.class));
            }
            catch (UnsupportedOperationException ex) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)("Ignoring expected exception: " + ex));
            }
        }
    }

    public void test_service_008() throws Exception {
        block2: {
            BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
            JoinGroupNode groupNode = new JoinGroupNode();
            groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
            String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
            LinkedHashMap prefixDecls = new LinkedHashMap(PrefixDeclProcessor.defaultDecls);
            ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
            LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
            projectedVars.add(Var.var((String)"s"));
            projectedVars.add(Var.var((String)"p"));
            projectedVars.add(Var.var((String)"o"));
            serviceNode.setExprImage(exprImage);
            serviceNode.setPrefixDecls(prefixDecls);
            serviceNode.setProjectedVars(projectedVars);
            LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
            MapBindingSet bset = new MapBindingSet();
            BNodeImpl tmp = new BNodeImpl("abc");
            bset.addBinding("s", (Value)tmp);
            bset.addBinding("o", (Value)tmp);
            bindingSets.add(bset);
            bset = new MapBindingSet();
            BNodeImpl tmp1 = new BNodeImpl("foo");
            BNodeImpl tmp2 = new BNodeImpl("bar");
            bset.addBinding("s", (Value)tmp1);
            bset.addBinding("o", (Value)tmp2);
            bindingSets.add(bset);
            BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
            try {
                IRemoteSparqlQueryBuilder fixture = this.newFixture(serviceNode, a);
                fixture.getSparqlQuery(a);
                TestRemoteSparql11QueryBuilder.fail((String)("Expecting: " + UnsupportedOperationException.class));
            }
            catch (UnsupportedOperationException ex) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)("Ignoring expected exception: " + ex));
            }
        }
    }
}

