/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval.service;

import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.AbstractBigdataExprBuilderTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.service.IRemoteSparqlQueryBuilder;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.RemoteServiceOptions;
import com.bigdata.rdf.sparql.ast.service.RemoteSparql10QueryBuilder;
import com.bigdata.rdf.sparql.ast.service.RemoteSparql11DraftQueryBuilder;
import com.bigdata.rdf.sparql.ast.service.RemoteSparql11QueryBuilder;
import com.bigdata.rdf.sparql.ast.service.RemoteSparqlBuilderFactory;
import com.bigdata.rdf.sparql.ast.service.SPARQLVersion;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.DC;
import org.openrdf.query.BindingSet;
import org.openrdf.query.impl.MapBindingSet;

public class TestRemoteSparqlBuilderFactory
extends AbstractBigdataExprBuilderTestCase {
    public TestRemoteSparqlBuilderFactory() {
    }

    public TestRemoteSparqlBuilderFactory(String name) {
        super(name);
    }

    private void addResolveIVs(BigdataValue ... values) {
        this.tripleStore.getLexiconRelation().addTerms(values, values.length, false);
        for (BigdataValue v : values) {
            v.getIV().setValue(v);
        }
    }

    public void test_service_001() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>();
        prefixDecls.put("foo", "http://www.bigdata.com/foo");
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList bindingSets = new LinkedList();
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        RemoteServiceOptions options = new RemoteServiceOptions();
        options.setSPARQLVersion(SPARQLVersion.SPARQL_10);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql10QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql11QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11_DRAFT_BINDINGS);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql11DraftQueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
    }

    public void test_service_001b() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>();
        prefixDecls.put("foo", "http://www.bigdata.com/foo");
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        bindingSets.add(new MapBindingSet());
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        RemoteServiceOptions options = new RemoteServiceOptions();
        options.setSPARQLVersion(SPARQLVersion.SPARQL_10);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql10QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql11QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11_DRAFT_BINDINGS);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql11DraftQueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
    }

    public void test_service_002() throws Exception {
        BigdataURI dcCreator = this.valueFactory.asValue(DC.CREATOR);
        BigdataURI book1 = this.valueFactory.createURI("http://example.org/book/book1");
        BigdataURI book2 = this.valueFactory.createURI("http://example.org/book/book2");
        BigdataURI author1 = this.valueFactory.createURI("http://example.org/author/author1");
        BigdataURI author2 = this.valueFactory.createURI("http://example.org/author/author2");
        this.addResolveIVs(new BigdataValue[]{dcCreator, book1, book2, author1, author2});
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>();
        prefixDecls.put("foo", "http://www.bigdata.com/foo");
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        bset.addBinding("s", (Value)book1);
        bset.addBinding("p", (Value)DC.CREATOR);
        bset.addBinding("o", (Value)author1);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("s", (Value)book2);
        bset.addBinding("p", (Value)DC.CREATOR);
        bset.addBinding("o", (Value)author2);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        RemoteServiceOptions options = new RemoteServiceOptions();
        options.setSPARQLVersion(SPARQLVersion.SPARQL_10);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql10QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql11QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11_DRAFT_BINDINGS);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql11DraftQueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
    }

    public void test_service_003() throws Exception {
        BigdataURI dcCreator = this.valueFactory.asValue(DC.CREATOR);
        BigdataURI book1 = this.valueFactory.createURI("http://example.org/book/book1");
        BigdataURI book2 = this.valueFactory.createURI("http://example.org/book/book2");
        BigdataLiteral book3 = this.valueFactory.createLiteral("Semantic Web Primer");
        BigdataLiteral book4 = this.valueFactory.createLiteral("Semantic Web Primer", "DE");
        BigdataLiteral book5 = this.valueFactory.createLiteral("12", XSD.INT);
        BigdataLiteral book6 = this.valueFactory.createLiteral("true", XSD.BOOLEAN);
        this.addResolveIVs(new BigdataValue[]{dcCreator, book1, book2, book3, book4, book5, book6});
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("book")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?book ?p ?o}";
        LinkedHashMap<String, String> prefixDecls = new LinkedHashMap<String, String>();
        prefixDecls.put("", "http://example.org/book/");
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"book"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        bset.addBinding("book", (Value)book1);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("book", (Value)book2);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("book", (Value)book3);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("book", (Value)book4);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("book", (Value)book5);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("book", (Value)book6);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        RemoteServiceOptions options = new RemoteServiceOptions();
        options.setSPARQLVersion(SPARQLVersion.SPARQL_10);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql10QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql11QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11_DRAFT_BINDINGS);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql11DraftQueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
    }

    public void test_service_004() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap prefixDecls = new LinkedHashMap();
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        bset.addBinding("s", (Value)new BNodeImpl("abc"));
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        RemoteServiceOptions options = new RemoteServiceOptions();
        options.setSPARQLVersion(SPARQLVersion.SPARQL_10);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql10QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql11QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11_DRAFT_BINDINGS);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql11DraftQueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
    }

    public void test_service_005() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap prefixDecls = new LinkedHashMap();
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        BNodeImpl tmp = new BNodeImpl("abc");
        bset.addBinding("s", (Value)tmp);
        bset.addBinding("o", (Value)tmp);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        RemoteServiceOptions options = new RemoteServiceOptions();
        options.setSPARQLVersion(SPARQLVersion.SPARQL_10);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql10QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql11QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11_DRAFT_BINDINGS);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql11DraftQueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
    }

    public void test_service_006() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o1")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o . ?s ?p ?o1 }";
        LinkedHashMap prefixDecls = new LinkedHashMap();
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        projectedVars.add(Var.var((String)"o1"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        BNodeImpl tmp = new BNodeImpl("abc");
        bset.addBinding("s", (Value)tmp);
        bset.addBinding("o", (Value)tmp);
        bset.addBinding("o1", (Value)tmp);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        RemoteServiceOptions options = new RemoteServiceOptions();
        options.setSPARQLVersion(SPARQLVersion.SPARQL_10);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql10QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql11QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11_DRAFT_BINDINGS);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql11DraftQueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
    }

    public void test_service_007() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap prefixDecls = new LinkedHashMap();
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        BNodeImpl tmp = new BNodeImpl("abc");
        bset.addBinding("s", (Value)tmp);
        bset.addBinding("o", (Value)tmp);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        bset.addBinding("s", (Value)new LiteralImpl("Semantic Web Primer"));
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        RemoteServiceOptions options = new RemoteServiceOptions();
        options.setSPARQLVersion(SPARQLVersion.SPARQL_10);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql10QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql10QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11_DRAFT_BINDINGS);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql10QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
    }

    public void test_service_008() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap prefixDecls = new LinkedHashMap();
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        projectedVars.add(Var.var((String)"p"));
        projectedVars.add(Var.var((String)"o"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        BNodeImpl tmp = new BNodeImpl("abc");
        bset.addBinding("s", (Value)tmp);
        bset.addBinding("o", (Value)tmp);
        bindingSets.add(bset);
        bset = new MapBindingSet();
        BNodeImpl tmp1 = new BNodeImpl("foo");
        BNodeImpl tmp2 = new BNodeImpl("bar");
        bset.addBinding("s", (Value)tmp1);
        bset.addBinding("o", (Value)tmp2);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        RemoteServiceOptions options = new RemoteServiceOptions();
        options.setSPARQLVersion(SPARQLVersion.SPARQL_10);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql10QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql10QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11_DRAFT_BINDINGS);
        TestRemoteSparqlBuilderFactory.assertEquals(RemoteSparql10QueryBuilder.class, RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a).getClass());
    }

    public void test_service_009() throws Exception {
        BigdataURI serviceURI = this.valueFactory.createURI("http://www.bigdata.com/myService");
        String exprImage = "SERVICE <" + serviceURI + "> { ?s ?p ?o }";
        LinkedHashMap prefixDecls = new LinkedHashMap();
        JoinGroupNode groupNode = new JoinGroupNode();
        groupNode.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("o")));
        ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(this.makeIV((BigdataValue)serviceURI)), (GraphPatternGroup)groupNode);
        LinkedHashSet<Var> projectedVars = new LinkedHashSet<Var>();
        projectedVars.add(Var.var((String)"s"));
        serviceNode.setExprImage(exprImage);
        serviceNode.setPrefixDecls(prefixDecls);
        serviceNode.setProjectedVars(projectedVars);
        LinkedList<MapBindingSet> bindingSets = new LinkedList<MapBindingSet>();
        MapBindingSet bset = new MapBindingSet();
        BigdataURI tmp1 = this.valueFactory.createURI("p:p1");
        BigdataLiteral tmp2 = this.valueFactory.createLiteral("lit1");
        bset.addBinding("p", (Value)tmp1);
        bset.addBinding("o", (Value)tmp2);
        bindingSets.add(bset);
        BindingSet[] a = bindingSets.toArray(new BindingSet[bindingSets.size()]);
        RemoteServiceOptions options = new RemoteServiceOptions();
        options.setSPARQLVersion(SPARQLVersion.SPARQL_10);
        IRemoteSparqlQueryBuilder queryBuilder = RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a);
        String actualQueryStrVersion_10 = queryBuilder.getSparqlQuery(a).replaceAll("\\s+", " ");
        String expectedSparqlVersion_10 = new String("SELECT  ?s WHERE { FILTER ( sameTerm( ?p, <p:p1>) ). FILTER ( sameTerm( ?o, \"lit1\") ).  ?s ?p ?o } ").replaceAll("\\s+", " ");
        TestRemoteSparqlBuilderFactory.assertEquals((String)expectedSparqlVersion_10, (String)actualQueryStrVersion_10);
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11);
        queryBuilder = RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a);
        String actualQueryStrVersion_11 = queryBuilder.getSparqlQuery(a).replaceAll("\\s+", " ");
        String expectedSparqlVersion_11 = new String("SELECT  ?s WHERE { ?s ?p ?o } VALUES ( ?p ?o) { ( <p:p1> \"lit1\" ) } ").replaceAll("\\s+", " ");
        TestRemoteSparqlBuilderFactory.assertEquals((String)expectedSparqlVersion_11, (String)actualQueryStrVersion_11);
        options.setSPARQLVersion(SPARQLVersion.SPARQL_11_DRAFT_BINDINGS);
        queryBuilder = RemoteSparqlBuilderFactory.get((IServiceOptions)options, (ServiceNode)serviceNode, (BindingSet[])a);
        String actualQueryStrVersion_11_DRAFT_BINDINGS = queryBuilder.getSparqlQuery(a).replaceAll("\\s+", " ");
        String expectedSparqlVersion_11_DRAFT_BINDINGS = new String("SELECT  ?s WHERE { ?s ?p ?o } BINDINGS ?p ?o { ( <p:p1> \"lit1\" ) } ").replaceAll("\\s+", " ");
        TestRemoteSparqlBuilderFactory.assertEquals((String)actualQueryStrVersion_11_DRAFT_BINDINGS, (String)expectedSparqlVersion_11_DRAFT_BINDINGS);
    }
}

