/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval.service;

import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Options;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sparql.AbstractBigdataExprBuilderTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.eval.CustomServiceFactoryBase;
import com.bigdata.rdf.sparql.ast.service.CustomServiceFactory;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.OpenrdfNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.RemoteServiceFactoryImpl;
import com.bigdata.rdf.sparql.ast.service.RemoteServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCall;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.eclipse.jetty.client.HttpClient;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sail.SailException;

public class TestServiceRegistry
extends AbstractBigdataExprBuilderTestCase {
    private static final Logger log = Logger.getLogger(TestServiceRegistry.class);

    public TestServiceRegistry() {
    }

    public TestServiceRegistry(String name) {
        super(name);
    }

    @Override
    protected Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(Options.BUFFER_MODE, BufferMode.Transient.toString());
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_addGetRemove() {
        URIImpl serviceURI1 = new URIImpl("http://www.bigdata.com/myService/" + this.getName() + "/" + UUID.randomUUID());
        URIImpl serviceURI2 = new URIImpl("http://www.bigdata.com/myService2/" + this.getName() + "/" + UUID.randomUUID());
        RemoteServiceOptions options = new RemoteServiceOptions();
        RemoteServiceFactoryImpl serviceFactory = new RemoteServiceFactoryImpl(options);
        try {
            TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI1));
            TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI2));
            ServiceRegistry.getInstance().add((URI)serviceURI1, (ServiceFactory)serviceFactory);
            TestServiceRegistry.assertNotNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI1));
            TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI2));
            TestServiceRegistry.assertTrue((serviceFactory == ServiceRegistry.getInstance().get((URI)serviceURI1) ? 1 : 0) != 0);
        }
        finally {
            ServiceRegistry.getInstance().remove((URI)serviceURI1);
        }
        TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI1));
        TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_serviceAlias() {
        URIImpl serviceURI1 = new URIImpl("http://www.bigdata.com/myService/" + this.getName() + "/" + UUID.randomUUID());
        URIImpl serviceURI2 = new URIImpl("http://www.bigdata.com/myService2/" + this.getName() + "/" + UUID.randomUUID());
        RemoteServiceOptions options = new RemoteServiceOptions();
        RemoteServiceFactoryImpl serviceFactory = new RemoteServiceFactoryImpl(options);
        try {
            block11: {
                TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI1));
                TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI2));
                ServiceRegistry.getInstance().add((URI)serviceURI1, (ServiceFactory)serviceFactory);
                TestServiceRegistry.assertNotNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI1));
                TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI2));
                TestServiceRegistry.assertTrue((serviceFactory == ServiceRegistry.getInstance().get((URI)serviceURI1) ? 1 : 0) != 0);
                try {
                    ServiceRegistry.getInstance().addAlias((URI)serviceURI1, (URI)serviceURI1);
                    TestServiceRegistry.fail((String)("Expecting: " + IllegalStateException.class));
                }
                catch (IllegalStateException ex) {
                    if (!log.isInfoEnabled()) break block11;
                    log.info((Object)("Ignoring expected exception: " + ex));
                }
            }
            ServiceRegistry.getInstance().addAlias((URI)serviceURI1, (URI)serviceURI2);
            TestServiceRegistry.assertNotNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI1));
            TestServiceRegistry.assertNotNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI2));
            TestServiceRegistry.assertTrue((serviceFactory == ServiceRegistry.getInstance().get((URI)serviceURI1) ? 1 : 0) != 0);
            TestServiceRegistry.assertTrue((serviceFactory == ServiceRegistry.getInstance().get((URI)serviceURI2) ? 1 : 0) != 0);
            try {
                ServiceRegistry.getInstance().addAlias((URI)serviceURI1, (URI)serviceURI2);
                TestServiceRegistry.fail((String)("Expecting: " + IllegalStateException.class));
            }
            catch (IllegalStateException ex) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Ignoring expected exception: " + ex));
                }
            }
        }
        finally {
            ServiceRegistry.getInstance().remove((URI)serviceURI1);
            ServiceRegistry.getInstance().remove((URI)serviceURI2);
        }
        TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI1));
        TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI2));
        try {
            ServiceRegistry.getInstance().addAlias((URI)serviceURI1, (URI)serviceURI2);
        }
        finally {
            ServiceRegistry.getInstance().remove((URI)serviceURI2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_serviceAlias2() {
        AbstractTripleStore store = this.getStore(this.getProperties());
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI serviceURI1 = f.createURI("http://www.bigdata.com/myService/" + this.getName() + "/" + UUID.randomUUID());
            BigdataURI serviceURI2 = f.createURI("http://www.bigdata.com/myService2/" + this.getName() + "/" + UUID.randomUUID());
            BigdataValue[] values = new BigdataValue[]{serviceURI1, serviceURI2};
            store.getLexiconRelation().addTerms(values, values.length, false);
            try {
                TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI1));
                TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI2));
                ServiceRegistry.getInstance().addAlias((URI)serviceURI1, (URI)serviceURI2);
                TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI1));
                TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI2));
                QueryEngine queryEngine = QueryEngineFactory.getInstance().getQueryController(store.getIndexManager());
                HttpClient cm = queryEngine.getClientConnectionManager();
                JoinGroupNode groupNode = new JoinGroupNode();
                ServiceNode serviceNode = new ServiceNode((TermNode)new ConstantNode(serviceURI1.getIV()), (GraphPatternGroup)groupNode);
                ServiceCall serviceCall = ServiceRegistry.getInstance().toServiceCall(store, cm, (URI)serviceURI1, serviceNode, null);
                TestServiceRegistry.assertNotNull((Object)serviceCall);
                serviceCall = ServiceRegistry.getInstance().toServiceCall(store, cm, (URI)serviceURI2, serviceNode, null);
                TestServiceRegistry.assertNotNull((Object)serviceCall);
            }
            finally {
                ServiceRegistry.getInstance().remove((URI)serviceURI1);
            }
        }
        finally {
            store.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_customService() throws SailException {
        URIImpl serviceURI1 = new URIImpl("http://www.bigdata.com/myService/" + this.getName() + "/" + UUID.randomUUID());
        MyCustomServiceFactory serviceFactory = new MyCustomServiceFactory((IServiceOptions)new OpenrdfNativeServiceOptions());
        try {
            TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI1));
            ServiceRegistry.getInstance().add((URI)serviceURI1, (ServiceFactory)serviceFactory);
            TestServiceRegistry.assertNotNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI1));
            TestServiceRegistry.assertTrue((serviceFactory == ServiceRegistry.getInstance().get((URI)serviceURI1) ? 1 : 0) != 0);
            Iterator itr = ServiceRegistry.getInstance().customServices();
            boolean found = false;
            while (itr.hasNext()) {
                CustomServiceFactory t = (CustomServiceFactory)itr.next();
                if (t != serviceFactory) continue;
                found = true;
            }
            TestServiceRegistry.assertTrue((boolean)found);
            AbstractTripleStore store = this.getStore(this.getProperties());
            try {
                BigdataSail sail = new BigdataSail(store.getNamespace(), store.getIndexManager());
                try {
                    sail.initialize();
                    TestServiceRegistry.assertEquals((String)"nstarted", (int)0, (int)serviceFactory.nstarted.get());
                    try (BigdataSail.BigdataSailConnection conn = sail.getConnection();){
                        TestServiceRegistry.assertEquals((String)"nstarted", (int)1, (int)serviceFactory.nstarted.get());
                    }
                }
                finally {
                    sail.shutDown();
                }
            }
            finally {
                store.destroy();
            }
            TestServiceRegistry.assertEquals((String)"nstarted", (int)1, (int)serviceFactory.nstarted.get());
        }
        finally {
            ServiceRegistry.getInstance().remove((URI)serviceURI1);
        }
        TestServiceRegistry.assertNull((Object)ServiceRegistry.getInstance().get((URI)serviceURI1));
    }

    private static class MyCustomServiceFactory
    extends CustomServiceFactoryBase {
        public final AtomicInteger nstarted = new AtomicInteger();
        private final IServiceOptions serviceOptions;

        public MyCustomServiceFactory(IServiceOptions serviceOptions) {
            this.serviceOptions = serviceOptions;
        }

        public IServiceOptions getServiceOptions() {
            return this.serviceOptions;
        }

        public ServiceCall<?> create(ServiceCallCreateParams params) {
            throw new UnsupportedOperationException();
        }

        public void startConnection(BigdataSail.BigdataSailConnection conn) {
            this.nstarted.incrementAndGet();
        }
    }
}

