/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval.update;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.rdf.update.AbstractAddRemoveStatementsOp;
import com.bigdata.bop.rdf.update.ChunkedResolutionOp;
import com.bigdata.bop.rdf.update.CommitOp;
import com.bigdata.bop.rdf.update.InsertStatementsOp;
import com.bigdata.bop.rdf.update.ParseOp;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.InsertData;
import com.bigdata.rdf.sparql.ast.LoadGraph;
import com.bigdata.rdf.sparql.ast.UpdateRoot;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestUpdateBootstrap
extends AbstractASTEvaluationTestCase {
    private static final Logger log = Logger.getLogger(TestUpdateBootstrap.class);

    public TestUpdateBootstrap() {
    }

    public TestUpdateBootstrap(String name) {
        super(name);
    }

    public void test_insert_data() throws Exception {
        UpdateRoot updateRoot = new UpdateRoot();
        InsertData op = new InsertData();
        updateRoot.addChild((IGroupMemberNode)op);
        IV g1 = this.makeIV((Value)this.valueFactory.createURI("http://www.bigdata.com/g1"));
        IV mike = this.makeIV((Value)this.valueFactory.createURI("http://www.bigdata.com/Mike"));
        IV bryan = this.makeIV((Value)this.valueFactory.createURI("http://www.bigdata.com/Bryan"));
        IV dc = this.makeIV((Value)this.valueFactory.createURI("http://www.bigdata.com/DC"));
        IV rdfType = this.makeIV((Value)this.valueFactory.asValue(RDF.TYPE));
        IV rdfsLabel = this.makeIV((Value)this.valueFactory.asValue(RDFS.LABEL));
        IV foafPerson = this.makeIV((Value)this.valueFactory.createURI("http://xmlns.com/foaf/0.1/Person"));
        IV mikeL = this.makeIV((Value)this.valueFactory.createLiteral("Mike"));
        IV bryanL = this.makeIV((Value)this.valueFactory.createLiteral("Bryan"));
        IV dcL = this.makeIV((Value)this.valueFactory.createLiteral("DC"));
        ISPO[] data = new ISPO[]{new SPO(mike, rdfType, foafPerson, g1, StatementEnum.Explicit), new SPO(bryan, rdfType, foafPerson, g1, StatementEnum.Explicit), new SPO(mike, rdfsLabel, mikeL, g1, StatementEnum.Explicit), new SPO(bryan, rdfsLabel, bryanL, g1, StatementEnum.Explicit), new SPO(dc, rdfsLabel, dcL, g1, StatementEnum.Explicit)};
        TestUpdateBootstrap.fail((String)"Finish test");
        ASTContainer astContainer = new ASTContainer(updateRoot);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        long txId = 0L;
        int bopId = 1;
        int resolutionId = bopId++;
        int insertStatementsId = bopId++;
        int commitId = bopId++;
        ChunkedResolutionOp left = null;
        left = new ChunkedResolutionOp(TestUpdateBootstrap.leftOrEmpty(left), NV.asMap((NV[])new NV[]{new NV(BOp.Annotations.BOP_ID, (Object)resolutionId), new NV(ChunkedResolutionOp.Annotations.TIMESTAMP, (Object)0L), new NV(ChunkedResolutionOp.Annotations.RELATION_NAME, (Object)new String[]{context.getLexiconNamespace()})}));
        left = new InsertStatementsOp(TestUpdateBootstrap.leftOrEmpty((PipelineOp)left), NV.asMap((NV[])new NV[]{new NV(BOp.Annotations.BOP_ID, (Object)insertStatementsId), new NV(ChunkedResolutionOp.Annotations.TIMESTAMP, (Object)0L), new NV(ChunkedResolutionOp.Annotations.RELATION_NAME, (Object)new String[]{context.getNamespace()})}));
        left = new CommitOp(TestUpdateBootstrap.leftOrEmpty((PipelineOp)left), NV.asMap((NV[])new NV[]{new NV(BOp.Annotations.BOP_ID, (Object)commitId), new NV(CommitOp.Annotations.TIMESTAMP, (Object)0L), new NV(CommitOp.Annotations.PIPELINED, (Object)false)}));
        LinkedList<ListBindingSet> bsets = new LinkedList<ListBindingSet>();
        Var s = Var.var((String)"s");
        Var p = Var.var((String)"p");
        Var o = Var.var((String)"o");
        Var c = Var.var((String)"c");
        for (ISPO spo : data) {
            ListBindingSet bset = new ListBindingSet();
            bset.set((IVariable)s, (IConstant)new Constant((Object)spo.s()));
            bset.set((IVariable)p, (IConstant)new Constant((Object)spo.p()));
            bset.set((IVariable)o, (IConstant)new Constant((Object)spo.o()));
            if (spo.c() != null) {
                bset.set((IVariable)c, (IConstant)new Constant((Object)spo.c()));
            }
            bsets.add(bset);
        }
        AbstractRunningQuery future = context.queryEngine.eval((BOp)left, bsets.toArray(new IBindingSet[bsets.size()]));
        future.get();
        if (log.isInfoEnabled()) {
            log.info((Object)this.store.dumpStore());
        }
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI mike2 = f.createURI("http://www.bigdata.com/Mike");
        BigdataURI bryan2 = f.createURI("http://www.bigdata.com/Bryan");
        BigdataURI dc2 = f.createURI("http://www.bigdata.com/DC");
        BigdataURI g12 = f.createURI("http://www.bigdata.com/g1");
        BigdataURI rdfType2 = f.asValue(RDF.TYPE);
        BigdataURI rdfsLabel2 = f.asValue(RDFS.LABEL);
        BigdataURI foafPerson2 = f.createURI("http://xmlns.com/foaf/0.1/Person");
        BigdataLiteral mikeL2 = f.createLiteral("Mike");
        BigdataLiteral bryanL2 = f.createLiteral("Bryan");
        BigdataLiteral DCL = f.createLiteral("DC");
        BigdataValue[] values = new BigdataValue[]{mike2, bryan2, dc2, g12, rdfType2, rdfsLabel2, foafPerson2, mikeL2, bryanL2, DCL};
        this.store.getLexiconRelation().addTerms(values, values.length, true);
        for (BigdataValue v : values) {
            IV iv = v.getIV();
            TestUpdateBootstrap.assertFalse((boolean)iv.isNullIV());
        }
        TestUpdateBootstrap.assertTrue((boolean)this.store.hasStatement((Resource)mike2, (URI)rdfType2, (Value)foafPerson2, (Resource)g12));
        TestUpdateBootstrap.assertTrue((boolean)this.store.hasStatement((Resource)bryan2, (URI)rdfType2, (Value)foafPerson2, (Resource)g12));
        TestUpdateBootstrap.assertTrue((boolean)this.store.hasStatement((Resource)mike2, (URI)rdfsLabel2, (Value)mikeL2, (Resource)g12));
        TestUpdateBootstrap.assertTrue((boolean)this.store.hasStatement((Resource)bryan2, (URI)rdfsLabel2, (Value)bryanL2, (Resource)g12));
        TestUpdateBootstrap.assertTrue((boolean)this.store.hasStatement((Resource)dc2, (URI)rdfsLabel2, (Value)DCL, (Resource)g12));
        BOpStats stats = (BOpStats)future.getStats().get(resolutionId);
        long expectedCount = values.length;
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].getIV().isInline()) continue;
            --expectedCount;
        }
        TestUpdateBootstrap.assertEquals((String)"mutationCount", (long)expectedCount, (long)stats.mutationCount.get());
        stats = (BOpStats)future.getStats().get(insertStatementsId);
        expectedCount = 5L;
        TestUpdateBootstrap.assertEquals((String)"mutationCount", (long)5L, (long)stats.mutationCount.get());
    }

    public void test_load_data() throws Exception {
        UpdateRoot updateRoot = new UpdateRoot();
        LoadGraph op = new LoadGraph();
        updateRoot.addChild((IGroupMemberNode)op);
        op.setSourceGraph(new ConstantNode(this.makeIV((Value)new URIImpl("file:src/test/java/com/bigdata/rdf/sparql/ast/eval/update/load_01.trig"))));
        ASTContainer astContainer = new ASTContainer(updateRoot);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        long txId = 0L;
        int bopId = 1;
        int parseId = bopId++;
        int resolutionId = bopId++;
        int insertStatementsId = bopId++;
        int commitId = bopId++;
        ParseOp left = null;
        HashMap<String, Object> anns = new HashMap<String, Object>();
        anns.put(BOp.Annotations.BOP_ID, parseId);
        anns.put(ParseOp.Annotations.SOURCE_URI, op.getSourceGraph().getValue());
        if (op.getTargetGraph() != null) {
            anns.put(ParseOp.Annotations.TARGET_URI, op.getTargetGraph());
        }
        anns.put(ParseOp.Annotations.TIMESTAMP, 0L);
        anns.put(ParseOp.Annotations.RELATION_NAME, new String[]{context.getNamespace()});
        anns.put(ParseOp.Annotations.CHUNK_CAPACITY, 100000);
        left = new ParseOp(TestUpdateBootstrap.leftOrEmpty(left), anns);
        left = new ChunkedResolutionOp(TestUpdateBootstrap.leftOrEmpty((PipelineOp)left), NV.asMap((NV[])new NV[]{new NV(ChunkedResolutionOp.Annotations.BOP_ID, (Object)resolutionId), new NV(ChunkedResolutionOp.Annotations.TIMESTAMP, (Object)0L), new NV(ChunkedResolutionOp.Annotations.RELATION_NAME, (Object)new String[]{context.getLexiconNamespace()})}));
        left = new InsertStatementsOp(TestUpdateBootstrap.leftOrEmpty((PipelineOp)left), NV.asMap((NV[])new NV[]{new NV(BOp.Annotations.BOP_ID, (Object)insertStatementsId), new NV(AbstractAddRemoveStatementsOp.Annotations.TIMESTAMP, (Object)0L), new NV(AbstractAddRemoveStatementsOp.Annotations.RELATION_NAME, (Object)new String[]{context.getNamespace()})}));
        left = new CommitOp(TestUpdateBootstrap.leftOrEmpty((PipelineOp)left), NV.asMap((NV[])new NV[]{new NV(BOp.Annotations.BOP_ID, (Object)commitId), new NV(CommitOp.Annotations.TIMESTAMP, (Object)0L), new NV(CommitOp.Annotations.PIPELINED, (Object)false)}));
        AbstractRunningQuery future = context.queryEngine.eval((BOp)left);
        future.get();
        if (log.isInfoEnabled()) {
            log.info((Object)this.store.dumpStore());
        }
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI mike = f.createURI("http://www.bigdata.com/Mike");
        BigdataURI bryan = f.createURI("http://www.bigdata.com/Bryan");
        BigdataURI dc = f.createURI("http://www.bigdata.com/DC");
        BigdataURI g1 = f.createURI("http://www.bigdata.com/g1");
        BigdataURI rdfType = f.asValue(RDF.TYPE);
        BigdataURI rdfsLabel = f.asValue(RDFS.LABEL);
        BigdataURI foafPerson = f.createURI("http://xmlns.com/foaf/0.1/Person");
        BigdataLiteral mikeL = f.createLiteral("Mike");
        BigdataLiteral bryanL = f.createLiteral("Bryan");
        BigdataLiteral DCL = f.createLiteral("DC");
        BigdataValue[] values = new BigdataValue[]{mike, bryan, dc, g1, rdfType, rdfsLabel, foafPerson, mikeL, bryanL, DCL};
        this.store.getLexiconRelation().addTerms(values, values.length, true);
        for (BigdataValue v : values) {
            IV iv = v.getIV();
            TestUpdateBootstrap.assertFalse((boolean)iv.isNullIV());
        }
        TestUpdateBootstrap.assertTrue((boolean)this.store.hasStatement((Resource)mike, (URI)rdfType, (Value)foafPerson, (Resource)g1));
        TestUpdateBootstrap.assertTrue((boolean)this.store.hasStatement((Resource)bryan, (URI)rdfType, (Value)foafPerson, (Resource)g1));
        TestUpdateBootstrap.assertTrue((boolean)this.store.hasStatement((Resource)mike, (URI)rdfsLabel, (Value)mikeL, (Resource)g1));
        TestUpdateBootstrap.assertTrue((boolean)this.store.hasStatement((Resource)bryan, (URI)rdfsLabel, (Value)bryanL, (Resource)g1));
        TestUpdateBootstrap.assertTrue((boolean)this.store.hasStatement((Resource)dc, (URI)rdfsLabel, (Value)DCL, (Resource)g1));
        BOpStats stats = (BOpStats)future.getStats().get(resolutionId);
        long expectedCount = values.length;
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].getIV().isInline()) continue;
            --expectedCount;
        }
        TestUpdateBootstrap.assertEquals((String)"mutationCount", (long)expectedCount, (long)stats.mutationCount.get());
        stats = (BOpStats)future.getStats().get(insertStatementsId);
        expectedCount = 5L;
        TestUpdateBootstrap.assertEquals((String)"mutationCount", (long)5L, (long)stats.mutationCount.get());
    }

    protected static BOp[] leftOrEmpty(PipelineOp left) {
        BOp[] bOpArray;
        if (left == null) {
            bOpArray = BOp.NOARGS;
        } else {
            BOp[] bOpArray2 = new BOp[1];
            bOpArray = bOpArray2;
            bOpArray2[0] = left;
        }
        return bOpArray;
    }
}

