/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.IsBoundBOp;
import com.bigdata.rdf.internal.constraints.OrBOp;
import com.bigdata.rdf.sparql.ast.ASTBase;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.ArbitraryLengthPathNode;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.ExistsNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupMemberNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.NotExistsNode;
import com.bigdata.rdf.sparql.ast.PathNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.PropertyPathNode;
import com.bigdata.rdf.sparql.ast.PropertyPathUnionNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SliceNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpBase;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.explainhints.ExplainHints;
import com.bigdata.rdf.sparql.ast.optimizers.ASTPropertyPathOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.algebra.StatementPattern;

public abstract class AbstractOptimizerTestCase
extends AbstractASTEvaluationTestCase {
    protected AbstractOptimizerTestCase(String name) {
        super(name);
    }

    protected AbstractOptimizerTestCase() {
    }

    abstract IASTOptimizer newOptimizer();

    protected StatementPatternNode newStatementPatternNode(TermNode s, TermNode p, TermNode o) {
        return this.newStatementPatternNode(s, p, o, -1L, false);
    }

    protected StatementPatternNode newStatementPatternNode(TermNode s, TermNode p, TermNode o, long cardinality) {
        return this.newStatementPatternNode(s, p, o, cardinality, false);
    }

    protected StatementPatternNode newStatementPatternNode(TermNode s, TermNode p, TermNode o, long cardinality, boolean optional) {
        StatementPatternNode sp = new StatementPatternNode(s, p, o);
        if (cardinality != -1L) {
            sp.setProperty(Annotations.ESTIMATED_CARDINALITY, (Object)cardinality);
        }
        if (optional) {
            sp.setOptional(true);
        }
        return sp;
    }

    protected static final class ASTPropertyPathOptimizerInTest
    extends ASTPropertyPathOptimizer {
        private int counter = 0;

        protected ASTPropertyPathOptimizerInTest() {
        }

        protected VarNode anonVar(String anon) {
            VarNode v = new VarNode(anon + this.counter++);
            v.setAnonymous(true);
            return v;
        }
    }

    public abstract class Helper {
        protected QueryRoot given;
        protected QueryRoot expected;
        protected ASTBase tmp;
        protected final String w = "w";
        protected final String x = "x";
        protected final String y = "y";
        protected final String z = "z";
        protected final String s = "s";
        protected final String p = "p";
        protected final String o = "o";
        protected final IV a = this.iv("a");
        protected final IV b = this.iv("b");
        protected final IV c = this.iv("c");
        protected final IV d = this.iv("d");
        protected final IV e = this.iv("e");
        protected final IV f = this.iv("f");
        protected final IV g = this.iv("g");
        protected final IV h = this.iv("h");
        private VarNode rightVar;
        private VarNode leftVar;
        int varCount = 0;
        private GlobalAnnotations globals = new GlobalAnnotations(AbstractOptimizerTestCase.this.getName(), -1L);

        public void test() {
            IASTOptimizer rewriter = AbstractOptimizerTestCase.this.newOptimizer();
            AST2BOpContext context = this.getAST2BOpContext(this.given);
            IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)this.given, new IBindingSet[0])).getQueryNode();
            AbstractOptimizerTestCase.assertSameAST((IQueryNode)this.expected, actual);
        }

        AST2BOpContext getAST2BOpContext(QueryRoot given) {
            return new AST2BOpContext(new ASTContainer(given), AbstractOptimizerTestCase.this.store);
        }

        public void testWhileIgnoringExplainHints() {
            IASTOptimizer rewriter = AbstractOptimizerTestCase.this.newOptimizer();
            AST2BOpContext context = this.getAST2BOpContext(this.given);
            IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)this.given, new IBindingSet[0])).getQueryNode();
            ExplainHints.removeExplainHintAnnotationsFromBOp((BOp)actual);
            AbstractOptimizerTestCase.assertSameAST((IQueryNode)this.expected, actual);
        }

        private IV iv(String id) {
            return AbstractOptimizerTestCase.this.makeIV((Value)new URIImpl("http://example/" + id));
        }

        protected VarNode wildcard() {
            return this.varNode("*");
        }

        protected QueryRoot select(VarNode[] varNodes, NamedSubqueryRoot namedSubQuery, JoinGroupNode where, HelperFlag ... flags) {
            QueryRoot rslt = this.select(varNodes, where, flags);
            rslt.getNamedSubqueriesNotNull().add((IQueryNode)namedSubQuery);
            return rslt;
        }

        protected QueryRoot select(VarNode[] varNodes, JoinGroupNode where, HelperFlag ... flags) {
            return this.select(this.projection(varNodes), where, flags);
        }

        protected ProjectionNode projection(VarNode ... varNodes) {
            ProjectionNode projection = new ProjectionNode();
            for (VarNode varNode : varNodes) {
                projection.addProjectionVar(varNode);
            }
            return projection;
        }

        protected ProjectionNode projection(AssignmentNode ... assignmentNodes) {
            ProjectionNode projection = new ProjectionNode();
            for (AssignmentNode varNode : assignmentNodes) {
                projection.addProjectionExpression(varNode);
            }
            return projection;
        }

        protected QueryRoot select(ProjectionNode projection, JoinGroupNode where, HelperFlag ... flags) {
            QueryRoot select = new QueryRoot(QueryType.SELECT);
            return this.select(select, projection, where, flags);
        }

        protected QueryRoot select(VarNode varNode, NamedSubqueryRoot namedSubQuery, JoinGroupNode where, HelperFlag ... flags) {
            return this.select(new VarNode[]{varNode}, namedSubQuery, where, flags);
        }

        protected QueryRoot select(VarNode varNode, JoinGroupNode where, HelperFlag ... flags) {
            return this.select(new VarNode[]{varNode}, where, flags);
        }

        protected SubqueryRoot selectSubQuery(ProjectionNode projection, JoinGroupNode where, HelperFlag ... flags) {
            SubqueryRoot rslt = new SubqueryRoot(QueryType.SELECT);
            return this.select(rslt, projection, where, flags);
        }

        private <T extends QueryBase> T select(T select, ProjectionNode projection, JoinGroupNode where, HelperFlag ... flags) {
            assert (projection != null);
            select.setProjection(projection);
            select.setWhereClause((GraphPatternGroup)where);
            for (HelperFlag flag : flags) {
                flag.apply((ASTBase)select);
            }
            return select;
        }

        protected SubqueryRoot ask(VarNode varNode, JoinGroupNode where) {
            SubqueryRoot rslt = new SubqueryRoot(QueryType.ASK);
            ProjectionNode projection = new ProjectionNode();
            varNode.setAnonymous(true);
            rslt.setProjection(projection);
            projection.addProjectionExpression(new AssignmentNode(varNode, (IValueExpressionNode)varNode));
            rslt.setWhereClause((GraphPatternGroup)where);
            rslt.setAskVar(this.toValueExpression(varNode));
            return rslt;
        }

        protected NamedSubqueryRoot namedSubQuery(String name, VarNode varNode, JoinGroupNode where, ApplyAnnotation ... annotations) {
            NamedSubqueryRoot namedSubquery = new NamedSubqueryRoot(QueryType.SELECT, name);
            ProjectionNode projection = new ProjectionNode();
            namedSubquery.setProjection(projection);
            projection.addProjectionExpression(new AssignmentNode(varNode, (IValueExpressionNode)new VarNode(varNode)));
            namedSubquery.setWhereClause((GraphPatternGroup)where);
            return this.applyAnnotations(namedSubquery, annotations);
        }

        protected GroupMemberNodeBase namedSubQueryInclude(String name, ApplyAnnotation ... annotations) {
            return (GroupMemberNodeBase)this.applyAnnotations(new NamedSubqueryInclude(name), annotations);
        }

        protected <T extends ASTBase> T applyAnnotations(T target, ApplyAnnotation ... annotations) {
            for (ApplyAnnotation annotation : annotations) {
                annotation.apply(target);
            }
            return target;
        }

        protected VarNode leftVar() {
            this.leftVar = this.newAlppVar("-tVarLeft-", this.leftVar);
            return this.leftVar;
        }

        protected VarNode rightVar() {
            this.rightVar = this.newAlppVar("-tVarRight-", this.rightVar);
            return this.rightVar;
        }

        private VarNode newAlppVar(String prefix, VarNode v) {
            if (v != null) {
                return v;
            }
            v = this.varNode(prefix + this.varCount++);
            v.setAnonymous(true);
            return v;
        }

        protected ArbitraryLengthPathNode arbitartyLengthPropertyPath(TermNode left, TermNode right, HelperFlag card, JoinGroupNode joinGroupNode) {
            assert (this.leftVar != null);
            assert (this.rightVar != null);
            ArbitraryLengthPathNode rslt = new ArbitraryLengthPathNode(left, right, this.leftVar, this.rightVar, PathNode.PathMod.ONE_OR_MORE);
            card.apply((ASTBase)rslt);
            rslt.setArg(0, (BOp)joinGroupNode);
            this.leftVar = null;
            this.rightVar = null;
            return rslt;
        }

        protected VarNode[] varNodes(String ... names) {
            VarNode[] rslt = new VarNode[names.length];
            for (int i = 0; i < names.length; ++i) {
                rslt[i] = this.varNode(names[i]);
            }
            return rslt;
        }

        protected VarNode varNode(String varName) {
            return new VarNode(varName);
        }

        protected TermNode constantNode(IV iv) {
            return new ConstantNode(iv);
        }

        protected TermNode constantNode(String c) {
            return new ConstantNode(this.iv(c));
        }

        protected PropertyPathNode propertyPathNode(TermNode s, String pattern, TermNode o) {
            return new PropertyPathNode(s, this.pathNode(pattern), o);
        }

        protected PathNode pathNode(String pattern) {
            String[] seq = pattern.split("/");
            PathNode.PathElt[] elements = new PathNode.PathElt[seq.length];
            PathNode.PathMod mod = null;
            for (int i = 0; i < seq.length; ++i) {
                String s = seq[i];
                boolean inverse = s.charAt(0) == '^';
                switch (s.charAt(s.length() - 1)) {
                    case '*': {
                        mod = PathNode.PathMod.ZERO_OR_MORE;
                        break;
                    }
                    case '+': {
                        mod = PathNode.PathMod.ONE_OR_MORE;
                        break;
                    }
                    case '?': {
                        mod = PathNode.PathMod.ZERO_OR_ONE;
                    }
                }
                String c = s.substring(inverse ? 1 : 0, s.length() - (mod != null ? 1 : 0));
                elements[i] = new PathNode.PathElt((BOp)this.constantNode(c), inverse, mod);
            }
            return new PathNode(new PathNode.PathAlternative(new PathNode.PathSequence[]{new PathNode.PathSequence(elements)}));
        }

        protected StatementPatternProperty property(String name, Object value) {
            return new StatementPatternProperty(name, value);
        }

        protected StatementPatternNode statementPatternNode(TermNode s, TermNode p, TermNode o, Object ... more) {
            StatementPatternNode rslt = AbstractOptimizerTestCase.this.newStatementPatternNode(s, p, o);
            if (more.length > 0) {
                int i = 0;
                if (more[0] instanceof TermNode) {
                    rslt.setC((TermNode)more[0]);
                    i = 1;
                }
                while (i < more.length) {
                    if (more[i] instanceof Integer) {
                        rslt.setProperty(Annotations.ESTIMATED_CARDINALITY, (Object)((Integer)more[i]));
                    } else if (more[i] instanceof StatementPatternProperty) {
                        StatementPatternProperty prop = (StatementPatternProperty)more[i];
                        rslt.setProperty(prop.annotation, prop.value);
                    } else {
                        HelperFlag flag = (HelperFlag)((Object)more[i]);
                        flag.apply((ASTBase)rslt);
                    }
                    ++i;
                }
            }
            return rslt;
        }

        private <E extends IGroupMemberNode, T extends GraphPatternGroup<E>> T initGraphPatternGroup(T rslt, Object ... statements) {
            for (Object mem : statements) {
                if (mem instanceof IGroupMemberNode) {
                    rslt.addChild((IGroupMemberNode)mem);
                    continue;
                }
                ((HelperFlag)((Object)mem)).apply((ASTBase)rslt);
            }
            return rslt;
        }

        protected JoinGroupNode joinGroupNode(TermNode context, Object ... statements) {
            JoinGroupNode rslt = this.joinGroupNode(statements);
            rslt.setContext(context);
            return rslt;
        }

        protected JoinGroupNode joinGroupNode(Object ... statements) {
            return this.initGraphPatternGroup(new JoinGroupNode(), statements);
        }

        protected JoinGroupNode where(IGroupMemberNode ... statements) {
            return this.joinGroupNode(statements);
        }

        protected PropertyPathUnionNode propertyPathUnionNode(Object ... statements) {
            return this.initGraphPatternGroup(new PropertyPathUnionNode(), statements);
        }

        protected UnionNode unionNode(Object ... statements) {
            return this.initGraphPatternGroup(new UnionNode(), statements);
        }

        protected FunctionNode bound(VarNode varNode) {
            FunctionNode rslt = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{varNode});
            rslt.setValueExpression((IValueExpression)new IsBoundBOp(varNode.getValueExpression()));
            return rslt;
        }

        protected FunctionNode knownUnbound(VarNode varNode) {
            VarNode vv = this.varNode("-unbound-var-" + varNode.getValueExpression().getName() + "-0");
            FunctionNode rslt = new FunctionNode(FunctionRegistry.BOUND, null, new ValueExpressionNode[]{vv});
            rslt.setValueExpression((IValueExpression)new IsBoundBOp(vv.getValueExpression()));
            return rslt;
        }

        protected FilterNode filter(IValueExpressionNode f) {
            return new FilterNode(f);
        }

        protected IValueExpressionNode functionNode(String uri, ValueExpressionNode ... args) {
            return this.functionNode((URI)new URIImpl(uri), args);
        }

        protected IValueExpressionNode functionNode(URI uri, ValueExpressionNode ... args) {
            return new FunctionNode(uri, null, args);
        }

        protected ServiceNode service(TermNode serviceRef, GraphPatternGroup<IGroupMemberNode> groupNode) {
            return new ServiceNode(serviceRef, groupNode);
        }

        protected AssignmentNode bind(IValueExpressionNode valueNode, VarNode varNode) {
            return new AssignmentNode(varNode, valueNode);
        }

        protected FunctionNode or(ValueExpressionNode v1, ValueExpressionNode v2) {
            FunctionNode rslt = FunctionNode.OR((ValueExpressionNode)v1, (ValueExpressionNode)v2);
            rslt.setValueExpression((IValueExpression)new OrBOp(v1.getValueExpression(), v2.getValueExpression()));
            return rslt;
        }

        protected ExistsNode exists(VarNode v, GraphPatternGroup<IGroupMemberNode> jg) {
            v.setAnonymous(true);
            ExistsNode existsNode = new ExistsNode(v, jg);
            existsNode.setValueExpression(this.toValueExpression(v));
            return existsNode;
        }

        protected IVariable<? extends IV> toValueExpression(VarNode v) {
            return (IVariable)AST2BOpUtility.toVE((BOpContextBase)AbstractOptimizerTestCase.this.getBOpContext(), (GlobalAnnotations)this.globals, (IValueExpressionNode)v);
        }

        protected IConstant<? extends IV> toValueExpression(ConstantNode v) {
            return (IConstant)AST2BOpUtility.toVE((BOpContextBase)AbstractOptimizerTestCase.this.getBOpContext(), (GlobalAnnotations)this.globals, (IValueExpressionNode)v);
        }

        private IValueExpression<? extends IV> toValueExpression(FunctionNode n) {
            return AST2BOpUtility.toVE((BOpContextBase)AbstractOptimizerTestCase.this.getBOpContext(), (GlobalAnnotations)this.globals, (IValueExpressionNode)n);
        }

        protected NotExistsNode notExists(VarNode v, GraphPatternGroup<IGroupMemberNode> jg) {
            return new NotExistsNode(v, jg);
        }

        protected ASTBase getTmp() {
            return this.tmp;
        }

        protected ApplyAnnotation joinOn(final VarNode ... joinVars) {
            return new ApplyAnnotation(){

                @Override
                public void apply(ASTBase target) {
                    target.setProperty("joinVars", (Object)joinVars);
                }
            };
        }

        protected ApplyAnnotation dependsOn(final String ... dependsOn) {
            return new ApplyAnnotation(){

                @Override
                public void apply(ASTBase target) {
                    ((NamedSubqueryRoot)target).setDependsOn(dependsOn);
                }
            };
        }

        protected ApplyAnnotation slice(final long offset, final long limit) {
            return new ApplyAnnotation(){

                @Override
                public void apply(ASTBase target) {
                    ((QueryBase)target).setSlice(new SliceNode(offset, limit));
                }
            };
        }

        protected class StatementPatternProperty {
            private String annotation;
            private Object value;

            public StatementPatternProperty(String annotation, Object value) {
                this.annotation = annotation;
                this.value = value;
            }

            public String getAnnotation() {
                return this.annotation;
            }

            public Object getValue() {
                return this.value;
            }
        }
    }

    static enum HelperFlag {
        ZERO_OR_ONE{

            @Override
            public void apply(ASTBase sp) {
                HelperFlag.setPathMod((ArbitraryLengthPathNode)sp, PathNode.PathMod.ZERO_OR_ONE);
            }
        }
        ,
        ZERO_OR_MORE{

            @Override
            public void apply(ASTBase sp) {
                HelperFlag.setPathMod((ArbitraryLengthPathNode)sp, PathNode.PathMod.ZERO_OR_MORE);
            }
        }
        ,
        ONE_OR_MORE{

            @Override
            public void apply(ASTBase sp) {
                HelperFlag.setPathMod((ArbitraryLengthPathNode)sp, PathNode.PathMod.ONE_OR_MORE);
            }
        }
        ,
        DEFAULT_CONTEXTS{

            @Override
            public void apply(ASTBase sp) {
                ((StatementPatternNode)sp).setScope(StatementPattern.Scope.DEFAULT_CONTEXTS);
            }
        }
        ,
        NAMED_CONTEXTS{

            @Override
            public void apply(ASTBase sp) {
                ((StatementPatternNode)sp).setScope(StatementPattern.Scope.DEFAULT_CONTEXTS);
            }
        }
        ,
        OPTIONAL{

            @Override
            public void apply(ASTBase sp) {
                sp.setProperty("optional", (Object)true);
            }
        }
        ,
        DISTINCT{

            @Override
            public void apply(ASTBase rslt) {
                ((QueryBase)rslt).getProjection().setDistinct(true);
            }
        }
        ,
        REDUCED{

            @Override
            public void apply(ASTBase rslt) {
                ((QueryBase)rslt).getProjection().setReduced(true);
            }
        }
        ,
        NOT_DISTINCT{

            @Override
            public void apply(ASTBase rslt) {
                ((QueryBase)rslt).getProjection().setDistinct(false);
            }
        }
        ,
        NOT_REDUCED{

            @Override
            public void apply(ASTBase rslt) {
                ((QueryBase)rslt).getProjection().setReduced(false);
            }
        }
        ,
        SUBGROUP_OF_ALP{

            @Override
            public void apply(ASTBase sp) {
                ((JoinGroupNode)sp).setSubgroupOfALPNode(true);
            }
        };


        public abstract void apply(ASTBase var1);

        private static void setPathMod(ArbitraryLengthPathNode alp, PathNode.PathMod mod) {
            alp.setProperty(Annotations.LOWER_BOUND, (Object)(mod == PathNode.PathMod.ONE_OR_MORE ? 1L : 0L));
            alp.setProperty(Annotations.UPPER_BOUND, (Object)(mod == PathNode.PathMod.ZERO_OR_ONE ? 1L : Long.MAX_VALUE));
        }
    }

    public static interface ApplyAnnotation {
        public void apply(ASTBase var1);
    }

    public static interface Annotations
    extends GraphPatternGroup.Annotations,
    ArbitraryLengthPathNode.Annotations,
    AST2BOpBase.Annotations,
    StatementPatternNode.Annotations {
    }
}

