/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.HavingNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNodeContainer;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.PropertyPathNode;
import com.bigdata.rdf.sparql.ast.QueryHints;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.RangeNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractOptimizerTestCase;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.BDS;
import com.bigdata.service.fts.FTS;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Striterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Value;

public abstract class AbstractOptimizerTestCaseWithUtilityMethods
extends AbstractOptimizerTestCase {
    public AbstractOptimizerTestCaseWithUtilityMethods() {
    }

    public AbstractOptimizerTestCaseWithUtilityMethods(String name) {
        super(name);
    }

    StatementPatternNode stmtPatternWithVar(String varName) {
        return this.stmtPatternWithVar(varName, false);
    }

    StatementPatternNode stmtPatternWithVars(final String varName1, final String varName2) {
        StatementPatternNode spn = (StatementPatternNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.statementPatternNode((TermNode)this.varNode(varName1), this.constantNode(this.a), (TermNode)this.varNode(varName2), new Object[0]);
            }
        }.getTmp();
        return spn;
    }

    StatementPatternNode stmtPatternWithVarsOptional(String varName1, String varName2) {
        StatementPatternNode spn = this.stmtPatternWithVars(varName1, varName2);
        spn.setOptional(true);
        return spn;
    }

    StatementPatternNode stmtPatternWithVarOptional(String varName) {
        return this.stmtPatternWithVar(varName, true);
    }

    StatementPatternNode stmtPatternWithVar(final String varName, boolean optional) {
        StatementPatternNode spn = (StatementPatternNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.statementPatternNode((TermNode)this.varNode(varName), this.constantNode(this.a), this.constantNode(this.b), new Object[0]);
            }
        }.getTmp();
        spn.setOptional(optional);
        return spn;
    }

    StatementPatternNode[] stmtPatternsWithVars(String ... varNames) {
        StatementPatternNode[] statementPatterns = new StatementPatternNode[varNames.length];
        for (int i = 0; i < varNames.length; ++i) {
            statementPatterns[i] = this.stmtPatternWithVar(varNames[i], false);
        }
        return statementPatterns;
    }

    FilterNode filterWithVar(final String varName) {
        FilterNode fn = (FilterNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.filter((IValueExpressionNode)FunctionNode.EQ((ValueExpressionNode)this.varNode(varName), (ValueExpressionNode)this.constantNode(this.a)));
            }
        }.getTmp();
        return (FilterNode)this.resolveVEs((IGroupMemberNode)fn);
    }

    FilterNode filterWithVars(final String varName1, final String varName2) {
        FilterNode fn = (FilterNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.filter((IValueExpressionNode)FunctionNode.NE((ValueExpressionNode)this.varNode(varName1), (ValueExpressionNode)this.varNode(varName2)));
            }
        }.getTmp();
        return (FilterNode)this.resolveVEs((IGroupMemberNode)fn);
    }

    FilterNode filterExistsWithVars(String anonymousVar, String ... varNames) {
        final StatementPatternNode[] statementPatterns = this.stmtPatternsWithVars(varNames);
        final VarNode askVar = new VarNode(anonymousVar);
        askVar.setAnonymous(true);
        FilterNode fn = (FilterNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.filter((IValueExpressionNode)this.notExists(askVar, (GraphPatternGroup<IGroupMemberNode>)this.joinGroupNode(statementPatterns)));
            }
        }.getTmp();
        return (FilterNode)this.resolveVEs((IGroupMemberNode)fn);
    }

    FilterNode filterNotExistsWithVars(String anonymousVar, String ... varNames) {
        final StatementPatternNode[] statementPatterns = this.stmtPatternsWithVars(varNames);
        final VarNode askVar = new VarNode(anonymousVar);
        askVar.setAnonymous(true);
        FilterNode fn = (FilterNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.filter((IValueExpressionNode)this.exists(askVar, (GraphPatternGroup<IGroupMemberNode>)this.joinGroupNode(statementPatterns)));
            }
        }.getTmp();
        return (FilterNode)this.resolveVEs((IGroupMemberNode)fn);
    }

    SubqueryRoot filterExistsOrNotExistsSubqueryWithVars(String anonymousVar, String ... varNames) {
        SubqueryRoot sqr = new SubqueryRoot(QueryType.ASK);
        ProjectionNode projection = new ProjectionNode();
        sqr.setProjection(projection);
        projection.addProjectionExpression(new AssignmentNode(new VarNode(anonymousVar), (IValueExpressionNode)new VarNode(anonymousVar)));
        for (String varName : varNames) {
            projection.addProjectionExpression(new AssignmentNode(new VarNode(varName), (IValueExpressionNode)new VarNode(varName)));
        }
        VarNode askVar = new VarNode(anonymousVar);
        askVar.setAnonymous(true);
        sqr.setAskVar(askVar.getValueExpression());
        sqr.setWhereClause((GraphPatternGroup)this.joinGroupWithVars(varNames));
        sqr.setFilterExistsMode(QueryHints.DEFAULT_FILTER_EXISTS);
        return sqr;
    }

    JoinGroupNode joinGroupWithVars(String ... varNames) {
        final StatementPatternNode[] statementPatterns = this.stmtPatternsWithVars(varNames);
        JoinGroupNode jgn = (JoinGroupNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.joinGroupNode(statementPatterns);
            }
        }.getTmp();
        return jgn;
    }

    UnionNode unionWithVars(final String varLeft, String ... varsRight) {
        final StatementPatternNode[] statementPatternsRight = this.stmtPatternsWithVars(varsRight);
        UnionNode unionNode = (UnionNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.unionNode(this.joinGroupNode(AbstractOptimizerTestCaseWithUtilityMethods.this.stmtPatternWithVar(varLeft, false)), this.joinGroupNode(statementPatternsRight));
            }
        }.getTmp();
        return unionNode;
    }

    AssignmentNode assignmentWithConst(final String boundVar) {
        AssignmentNode an = (AssignmentNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.bind((IValueExpressionNode)this.constantNode(this.a), this.varNode(boundVar));
            }
        }.getTmp();
        return an;
    }

    AssignmentNode assignmentWithVar(final String boundVar, final String usedVar) {
        AssignmentNode an = (AssignmentNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.bind((IValueExpressionNode)this.varNode(usedVar), this.varNode(boundVar));
            }
        }.getTmp();
        return an;
    }

    AssignmentNode[] assignmentWithVars(String ... varNames) {
        AssignmentNode[] assignmentNodes = new AssignmentNode[varNames.length];
        for (int i = 0; i < varNames.length; ++i) {
            assignmentNodes[i] = this.assignmentWithVar(varNames[i], varNames[i]);
        }
        return assignmentNodes;
    }

    BindingsClause bindingsClauseWithVars(String ... varNames) {
        LinkedHashSet<Var> declaredVars = new LinkedHashSet<Var>();
        for (String varName : varNames) {
            declaredVars.add(Var.var((String)varName));
        }
        ArrayList bindingSets = new ArrayList();
        ListBindingSet bs = new ListBindingSet();
        for (String varName : varNames) {
            bs.set((IVariable)Var.var((String)varName), (IConstant)new Constant((Object)TermId.mockIV((VTE)VTE.URI)));
        }
        return new BindingsClause(declaredVars, bindingSets);
    }

    SubqueryRoot subqueryWithVars(String ... varNames) {
        final AssignmentNode[] assignments = this.assignmentWithVars(varNames);
        final StatementPatternNode[] statementPatterns = this.stmtPatternsWithVars(varNames);
        SubqueryRoot subquery = (SubqueryRoot)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.selectSubQuery(this.projection(assignments), this.where(new IGroupMemberNode[]{this.joinGroupNode(statementPatterns)}), new AbstractOptimizerTestCase.HelperFlag[0]);
            }
        }.getTmp();
        return subquery;
    }

    PropertyPathNode alpNodeWithVars(final String varName1, final String varName2) {
        PropertyPathNode alpNode = (PropertyPathNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.propertyPathNode((TermNode)this.varNode(varName1), "c*", (TermNode)this.varNode(varName2));
            }
        }.getTmp();
        return alpNode;
    }

    ServiceNode serviceSparql11WithConstant(String ... varNames) {
        final JoinGroupNode jgn = this.joinGroupWithVars(varNames);
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI serviceEndpoint = f.createURI("http://custom.endpoint");
        final IV serviceEndpointIV = this.makeIV((Value)serviceEndpoint);
        BigdataValue[] values = new BigdataValue[]{serviceEndpoint};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ServiceNode serviceNode = (ServiceNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.service(this.constantNode(serviceEndpointIV), (GraphPatternGroup<IGroupMemberNode>)jgn);
            }
        }.getTmp();
        return serviceNode;
    }

    ServiceNode serviceSparql11WithVariable(final String endpointVar, String ... varNames) {
        final JoinGroupNode jgn = this.joinGroupWithVars(varNames);
        ServiceNode serviceNode = (ServiceNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.service((TermNode)this.varNode(endpointVar), (GraphPatternGroup<IGroupMemberNode>)jgn);
            }
        }.getTmp();
        return serviceNode;
    }

    ServiceNode serviceBDSWithVariable(final String inputVar) {
        BigdataValueFactory f = this.store.getValueFactory();
        final BigdataURI bdsSearch = f.createURI("http://www.bigdata.com/rdf/search#search");
        final BigdataURI predSearch = f.createURI(BDS.SEARCH.toString());
        final BigdataURI predSearchTimeout = f.createURI(BDS.SEARCH_TIMEOUT.toString());
        final BigdataURI predMatchExact = f.createURI(BDS.MATCH_EXACT.toString());
        BigdataValue[] values = new BigdataValue[]{bdsSearch, predSearch, predSearchTimeout, predMatchExact};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ServiceNode serviceNode = (ServiceNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.service(this.constantNode(AbstractOptimizerTestCaseWithUtilityMethods.this.makeIV((Value)bdsSearch)), (GraphPatternGroup<IGroupMemberNode>)this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode(inputVar), this.constantNode(AbstractOptimizerTestCaseWithUtilityMethods.this.makeIV((Value)predSearch)), this.constantNode("search"), new Object[0]), this.statementPatternNode((TermNode)this.varNode(inputVar), this.constantNode(AbstractOptimizerTestCaseWithUtilityMethods.this.makeIV((Value)predSearchTimeout)), this.constantNode("1000"), new Object[0]), this.statementPatternNode((TermNode)this.varNode(inputVar), this.constantNode(AbstractOptimizerTestCaseWithUtilityMethods.this.makeIV((Value)predMatchExact)), this.constantNode("false"), new Object[0])));
            }
        }.getTmp();
        return serviceNode;
    }

    ServiceNode serviceFTSWithVariable(final String resultVar, String scoreVar, String snippetVar, final String searchVar, final String endpointVar, final String paramsVar) {
        BigdataValueFactory f = this.store.getValueFactory();
        final BigdataURI ftsSearch = f.createURI("http://www.bigdata.com/rdf/fts#search");
        final BigdataURI predSearch = f.createURI(FTS.SEARCH.toString());
        final BigdataURI predEndpoint = f.createURI(FTS.ENDPOINT.toString());
        final BigdataURI predParams = f.createURI(FTS.PARAMS.toString());
        BigdataValue[] values = new BigdataValue[]{ftsSearch, predSearch, predEndpoint, predParams};
        this.store.getLexiconRelation().addTerms(values, values.length, false);
        ServiceNode serviceNode = (ServiceNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.service(this.constantNode(AbstractOptimizerTestCaseWithUtilityMethods.this.makeIV((Value)ftsSearch)), (GraphPatternGroup<IGroupMemberNode>)this.joinGroupNode(this.statementPatternNode((TermNode)this.varNode(resultVar), this.constantNode(AbstractOptimizerTestCaseWithUtilityMethods.this.makeIV((Value)predSearch)), (TermNode)this.varNode(searchVar), new Object[0]), this.statementPatternNode((TermNode)this.varNode(resultVar), this.constantNode(AbstractOptimizerTestCaseWithUtilityMethods.this.makeIV((Value)predEndpoint)), (TermNode)this.varNode(endpointVar), new Object[0]), this.statementPatternNode((TermNode)this.varNode(resultVar), this.constantNode(AbstractOptimizerTestCaseWithUtilityMethods.this.makeIV((Value)predParams)), (TermNode)this.varNode(paramsVar), new Object[0])));
            }
        }.getTmp();
        return serviceNode;
    }

    public Set<IVariable<?>> varSet(String ... varNames) {
        HashSet varSet = new HashSet();
        for (String varName : varNames) {
            varSet.add((IVariable<?>)Var.var((String)varName));
        }
        return varSet;
    }

    IGroupMemberNode resolveVEs(IGroupMemberNode groupNode) {
        QueryRoot query = new QueryRoot(QueryType.SELECT);
        JoinGroupNode jgn = new JoinGroupNode(groupNode);
        query.setWhereClause((GraphPatternGroup)jgn);
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(query), this.store);
        GlobalAnnotations globals = new GlobalAnnotations(context.getLexiconNamespace(), context.getTimestamp());
        IStriterator it = new Striterator(BOpUtility.preOrderIteratorWithAnnotations((BOp)groupNode)).addFilter((IFilter)new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean isValid(Object obj) {
                if (obj instanceof IValueExpressionNodeContainer) {
                    return true;
                }
                if (obj instanceof HavingNode) {
                    return true;
                }
                return obj instanceof StatementPatternNode;
            }
        });
        while (it.hasNext()) {
            StatementPatternNode sp;
            RangeNode range;
            Object op = it.next();
            if (op instanceof IValueExpressionNodeContainer) {
                AST2BOpUtility.toVE((BOpContextBase)this.getBOpContext(), (GlobalAnnotations)globals, (IValueExpressionNode)((IValueExpressionNodeContainer)op).getValueExpressionNode());
                continue;
            }
            if (op instanceof HavingNode) {
                HavingNode havingNode = (HavingNode)op;
                for (IValueExpressionNode node : havingNode) {
                    AST2BOpUtility.toVE((BOpContextBase)this.getBOpContext(), (GlobalAnnotations)globals, (IValueExpressionNode)node);
                }
                continue;
            }
            if (!(op instanceof StatementPatternNode) || (range = (sp = (StatementPatternNode)op).getRange()) == null) continue;
            if (range.from() != null) {
                AST2BOpUtility.toVE((BOpContextBase)this.getBOpContext(), (GlobalAnnotations)globals, (IValueExpressionNode)range.from());
            }
            if (range.to() == null) continue;
            AST2BOpUtility.toVE((BOpContextBase)this.getBOpContext(), (GlobalAnnotations)globals, (IValueExpressionNode)range.to());
        }
        return groupNode;
    }

    StaticAnalysis statisAnalysisForNodes(List<IGroupMemberNode> nodes) {
        final IGroupMemberNode[] nodesArr = nodes.toArray(new IGroupMemberNode[nodes.size()]);
        JoinGroupNode jgn = (JoinGroupNode)new AbstractOptimizerTestCase.Helper(){
            {
                super(AbstractOptimizerTestCaseWithUtilityMethods.this);
                this.tmp = this.joinGroupNode(nodesArr);
            }
        }.getTmp();
        QueryRoot queryRoot = new QueryRoot(QueryType.SELECT);
        queryRoot.setWhereClause((GraphPatternGroup)jgn);
        return new StaticAnalysis(queryRoot, (IEvaluationContext)new AST2BOpContext(new ASTContainer(queryRoot), this.store));
    }
}

