/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.BSBMQ5Setup;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTAttachJoinFiltersOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.ASTSetValueExpressionsOptimizer;
import java.util.Collections;
import java.util.List;

public class TestASTAttachJoinFiltersOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTAttachJoinFiltersOptimizer() {
    }

    public TestASTAttachJoinFiltersOptimizer(String name) {
        super(name);
    }

    public void test_attachFilters() {
        IBindingSet[] bsets = new IBindingSet[]{};
        BSBMQ5Setup s = new BSBMQ5Setup(this.store);
        QueryRoot given = s.queryRoot;
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        whereClause.addChild((IGroupMemberNode)s.p5);
        whereClause.addChild((IGroupMemberNode)s.p3);
        whereClause.addChild((IGroupMemberNode)s.p1);
        whereClause.addChild((IGroupMemberNode)s.p0);
        whereClause.addChild((IGroupMemberNode)s.p2);
        whereClause.addChild((IGroupMemberNode)s.p4);
        whereClause.addChild((IGroupMemberNode)s.p6);
        whereClause.addChild((IGroupMemberNode)s.c0);
        whereClause.addChild((IGroupMemberNode)s.c1);
        whereClause.addChild((IGroupMemberNode)s.c2);
        BSBMQ5Setup s2 = new BSBMQ5Setup(this.store);
        QueryRoot expected = s2.queryRoot;
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        whereClause2.addChild((IGroupMemberNode)s2.p5);
        whereClause2.addChild((IGroupMemberNode)s2.p3);
        whereClause2.addChild((IGroupMemberNode)s2.p1);
        whereClause2.addChild((IGroupMemberNode)s2.p0);
        whereClause2.addChild((IGroupMemberNode)s2.p2);
        whereClause2.addChild((IGroupMemberNode)s2.p4);
        whereClause2.addChild((IGroupMemberNode)s2.p6);
        s2.c0.setParent(null);
        s2.c1.setParent(null);
        s2.c2.setParent(null);
        s2.p0.setAttachedJoinFilters(Collections.singletonList(s2.c0));
        s2.p4.setAttachedJoinFilters(Collections.singletonList(s2.c1));
        s2.p6.setAttachedJoinFilters(Collections.singletonList(s2.c2));
        ASTAttachJoinFiltersOptimizer rewriter = new ASTAttachJoinFiltersOptimizer();
        AST2BOpContext context = new AST2BOpContext(new ASTContainer(given), this.store);
        IQueryNode actual = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)given, bsets)).getQueryNode();
        TestASTAttachJoinFiltersOptimizer.assertSameAST((IQueryNode)expected, actual);
        IQueryNode actual2 = rewriter.optimize(context, new QueryNodeWithBindingSet((IQueryNode)BOpUtility.deepCopy((BOp)expected), bsets)).getQueryNode();
        TestASTAttachJoinFiltersOptimizer.assertSameAST((IQueryNode)expected, actual2);
    }

    public void test_redundantFilter() {
        String sampleInstance = "http://www.example.com/I";
        BigdataURI someUri = this.valueFactory.createURI("http://www.example.com/I");
        BigdataValue[] terms = new BigdataValue[]{someUri};
        this.store.getLexiconRelation().addTerms(terms, terms.length, false);
        for (BigdataValue bv : terms) {
            bv.getIV().setValue(bv);
        }
        QueryRoot qUnoptimized = new QueryRoot(QueryType.SELECT);
        VarNode varS = new VarNode("s");
        VarNode varP = new VarNode("p");
        VarNode varO = new VarNode("o");
        JoinGroupNode innerJoin = new JoinGroupNode();
        innerJoin.addArg((BOp)new StatementPatternNode((TermNode)varS, (TermNode)varP, (TermNode)varO));
        ProjectionNode innerProjection = new ProjectionNode();
        innerProjection.addProjectionVar(new VarNode("s"));
        SubqueryRoot qUnoptimizedInner = new SubqueryRoot(QueryType.SELECT);
        qUnoptimizedInner.setProjection(innerProjection);
        qUnoptimizedInner.setWhereClause((GraphPatternGroup)innerJoin);
        FilterNode f1 = new FilterNode((IValueExpressionNode)FunctionNode.NE((ValueExpressionNode)new ConstantNode(someUri.getIV()), (ValueExpressionNode)varS));
        FilterNode f2 = new FilterNode((IValueExpressionNode)FunctionNode.NE((ValueExpressionNode)new ConstantNode(someUri.getIV()), (ValueExpressionNode)varS));
        JoinGroupNode outerJoin = new JoinGroupNode();
        outerJoin.addArg((BOp)qUnoptimizedInner);
        outerJoin.addArg((BOp)f1);
        outerJoin.addArg((BOp)f2);
        ProjectionNode projection = new ProjectionNode();
        projection.addProjectionVar(varS);
        qUnoptimized.setWhereClause((GraphPatternGroup)outerJoin);
        qUnoptimized.setProjection(projection);
        System.out.println(qUnoptimized);
        ASTSetValueExpressionsOptimizer valueExpRewriter = new ASTSetValueExpressionsOptimizer();
        AST2BOpContext contextValueExpRewriter = new AST2BOpContext(new ASTContainer(qUnoptimized), this.store);
        IBindingSet[] bsetsValueExpRewriter = new IBindingSet[]{};
        IQueryNode qIntermediate = valueExpRewriter.optimize(contextValueExpRewriter, new QueryNodeWithBindingSet((IQueryNode)qUnoptimized, bsetsValueExpRewriter)).getQueryNode();
        ASTAttachJoinFiltersOptimizer joinRewriter = new ASTAttachJoinFiltersOptimizer();
        AST2BOpContext contextJoinRewriter = new AST2BOpContext(new ASTContainer((QueryRoot)qIntermediate), this.store);
        IBindingSet[] bsetsJoinRewriter = new IBindingSet[]{};
        IQueryNode qOptimized = joinRewriter.optimize(contextJoinRewriter, new QueryNodeWithBindingSet(qIntermediate, bsetsJoinRewriter)).getQueryNode();
        TestASTAttachJoinFiltersOptimizer.assertEquals((Object)QueryType.SELECT, qOptimized.annotations().get("queryType"));
        JoinGroupNode topLevelJoin = (JoinGroupNode)qOptimized.annotations().get("graphPattern");
        List topLevelJoinChildren = topLevelJoin.getChildren();
        TestASTAttachJoinFiltersOptimizer.assertEquals((int)topLevelJoinChildren.size(), (int)1);
        SubqueryRoot innerSelect = (SubqueryRoot)topLevelJoinChildren.get(0);
        TestASTAttachJoinFiltersOptimizer.assertEquals((Object)QueryType.SELECT, innerSelect.annotations().get("queryType"));
        JoinGroupNode innerJoin2 = (JoinGroupNode)innerSelect.annotations().get("graphPattern");
        TestASTAttachJoinFiltersOptimizer.assertNotNull((Object)innerJoin2);
        List filters = (List)innerSelect.annotations().get("filters");
        TestASTAttachJoinFiltersOptimizer.assertEquals((int)filters.size(), (int)1);
    }
}

