/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.AbstractASTEvaluationTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.ASTDeferredIVResolution;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Collections;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.StatementPattern;

public class TestASTBatchResolveTermsOptimizer
extends AbstractASTEvaluationTestCase {
    public TestASTBatchResolveTermsOptimizer() {
    }

    public TestASTBatchResolveTermsOptimizer(String name) {
        super(name);
    }

    public void test_batchResolveTerms_01() throws MalformedQueryException {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI unknown1 = f.createURI("http://example/out");
        unknown1.setIV((IV)TermId.mockIV((VTE)VTE.URI));
        TestASTBatchResolveTermsOptimizer.assertFalse((boolean)unknown1.isRealIV());
        unknown1.getIV().setValue((BigdataValue)unknown1);
        BigdataURI known1 = f.createURI("http://example/out");
        this.store.addTerms(new BigdataValue[]{known1});
        TestASTBatchResolveTermsOptimizer.assertTrue((boolean)known1.isRealIV());
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("v"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        JoinGroupNode graphPattern = new JoinGroupNode();
        graphPattern.setContext((TermNode)new ConstantNode((IConstant)new Constant((Object)unknown1.getIV())));
        whereClause.addChild((IGroupMemberNode)graphPattern);
        JoinGroupNode innerGroup = new JoinGroupNode();
        graphPattern.addChild((IGroupMemberNode)innerGroup);
        innerGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("v"), (TermNode)new ConstantNode((IConstant)new Constant((Object)unknown1.getIV())), StatementPattern.Scope.NAMED_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        expected.setProperty("prefixDecls", Collections.emptyMap());
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("p"));
        projection2.addProjectionVar(new VarNode("v"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        expected.setProperty("prefixDecls", Collections.emptyMap());
        JoinGroupNode graphPattern2 = new JoinGroupNode();
        graphPattern2.setContext((TermNode)new ConstantNode((IConstant)new Constant((Object)known1.getIV())));
        whereClause2.addChild((IGroupMemberNode)graphPattern2);
        JoinGroupNode innerGroup2 = new JoinGroupNode();
        graphPattern2.addChild((IGroupMemberNode)innerGroup2);
        innerGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("v"), (TermNode)new ConstantNode((IConstant)new Constant((Object)known1.getIV())), StatementPattern.Scope.NAMED_CONTEXTS));
        ASTContainer astContainer = new ASTContainer(given);
        ASTDeferredIVResolution.resolveQuery((AbstractTripleStore)this.store, (ASTContainer)astContainer);
        QueryRoot actual = astContainer.getOriginalAST();
        TestASTBatchResolveTermsOptimizer.assertSameAST((IQueryNode)expected, (IQueryNode)actual);
    }

    public void test_batchResolveTerms_02() throws MalformedQueryException {
        BigdataValueFactory f = this.store.getValueFactory();
        BigdataURI unknown1 = f.createURI("http://example/out");
        unknown1.setIV((IV)TermId.mockIV((VTE)VTE.URI));
        TestASTBatchResolveTermsOptimizer.assertFalse((boolean)unknown1.isRealIV());
        unknown1.getIV().setValue((BigdataValue)unknown1);
        BigdataURI known1 = f.createURI("http://example/out");
        this.store.addTerms(new BigdataValue[]{known1});
        TestASTBatchResolveTermsOptimizer.assertTrue((boolean)known1.isRealIV());
        IBindingSet[] bsets = new IBindingSet[]{new ListBindingSet()};
        QueryRoot given = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection = new ProjectionNode();
        given.setProjection(projection);
        projection.addProjectionVar(new VarNode("s"));
        projection.addProjectionVar(new VarNode("p"));
        projection.addProjectionVar(new VarNode("v"));
        JoinGroupNode whereClause = new JoinGroupNode();
        given.setWhereClause((GraphPatternGroup)whereClause);
        JoinGroupNode graphPattern = new JoinGroupNode();
        graphPattern.setContext((TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"x"), (Object)unknown1.getIV())));
        whereClause.addChild((IGroupMemberNode)graphPattern);
        JoinGroupNode innerGroup = new JoinGroupNode();
        graphPattern.addChild((IGroupMemberNode)innerGroup);
        innerGroup.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("v"), (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"x"), (Object)unknown1.getIV())), StatementPattern.Scope.NAMED_CONTEXTS));
        QueryRoot expected = new QueryRoot(QueryType.SELECT);
        ProjectionNode projection2 = new ProjectionNode();
        expected.setProjection(projection2);
        expected.setProperty("prefixDecls", Collections.emptyMap());
        projection2.addProjectionVar(new VarNode("s"));
        projection2.addProjectionVar(new VarNode("p"));
        projection2.addProjectionVar(new VarNode("v"));
        JoinGroupNode whereClause2 = new JoinGroupNode();
        expected.setWhereClause((GraphPatternGroup)whereClause2);
        JoinGroupNode graphPattern2 = new JoinGroupNode();
        graphPattern2.setContext((TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"x"), (Object)known1.getIV())));
        whereClause2.addChild((IGroupMemberNode)graphPattern2);
        JoinGroupNode innerGroup2 = new JoinGroupNode();
        graphPattern2.addChild((IGroupMemberNode)innerGroup2);
        innerGroup2.addChild((IGroupMemberNode)new StatementPatternNode((TermNode)new VarNode("s"), (TermNode)new VarNode("p"), (TermNode)new VarNode("v"), (TermNode)new ConstantNode((IConstant)new Constant((IVariable)Var.var((String)"x"), (Object)known1.getIV())), StatementPattern.Scope.NAMED_CONTEXTS));
        ASTContainer astContainer = new ASTContainer(given);
        AST2BOpContext context = new AST2BOpContext(astContainer, this.store);
        ASTDeferredIVResolution.resolveQuery((AbstractTripleStore)this.store, (ASTContainer)astContainer);
        QueryRoot actual = astContainer.getOriginalAST();
        TestASTBatchResolveTermsOptimizer.assertSameAST((IQueryNode)expected, (IQueryNode)actual);
    }
}

